/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.io.Serializable;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

public class DBObjectActionsContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        DBObjectNode dBObjectNode = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
        if (dBObjectNode != null) {
            Serializable serializable;
            DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(dBObjectNode);
            DBEditorFactory dBEditorFactory2 = DBEditorFactoryRegistry.getEditFactory(dBObjectNode);
            String string = DBObjectNodeUtil.normalizeType(dBObjectNode);
            if (string != null) {
                serializable = Metadata.getInstance().getObjectClass(string);
                boolean bl = serializable != null && SystemObject.class.isAssignableFrom((Class<?>)serializable);
            } else {
                boolean bl = false;
            }
            if (dBEditorFactory2 != null && this.shouldAddProperties(context)) {
                serializable = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getPropertiesAction());
                contextMenu.add((Component)serializable, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
            if (dBObjectNode instanceof DBObjectPlSqlNode) {
                if (("PACKAGE".equals(string) || "TYPE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE BODY".equals(string)) && PlSqlFeatures.isSupportedSyncSpecAndBody()) {
                    serializable = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getSynchronizeSpecAndBody());
                    contextMenu.add((Component)serializable, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                }
                if (context.getView() instanceof CodeEditor) {
                    if (PlSqlFeatures.isSupportedQuickDocumentation()) {
                        serializable = contextMenu.createMenuItem((ToggleAction)IdeAction.find((String)"AbstractDocPopupController.SHOW_DOC_POPUP_CMD"));
                        contextMenu.add((Component)serializable, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                    }
                    if (PlSqlFeatures.isSupportedTestQuery()) {
                        serializable = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getTestQueryAction());
                        contextMenu.add((Component)serializable, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                    }
                }
            }
        }
    }

    private boolean shouldAddProperties(Context context) {
        return context.getView() instanceof ExplorerWindow && DBObjectNodeUtil.isOnlineNode(context.getNode());
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

