/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumb;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;

final class PlSqlBreadcrumbsModel
implements BreadcrumbsModel {
    private final List<BreadcrumbsModelListener> m_listeners = new LinkedList<BreadcrumbsModelListener>();
    private final ArrayList<Breadcrumb> m_crumbs = new ArrayList();

    PlSqlBreadcrumbsModel() {
    }

    public int getBreadcrumbCount() {
        return this.m_crumbs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breadcrumb getBreadcrumb(int n) {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            if (n < this.getBreadcrumbCount()) {
                return this.m_crumbs.get(n);
            }
            return null;
        }
    }

    public void addBreadcrumbsModelListener(BreadcrumbsModelListener breadcrumbsModelListener) {
        if (!this.m_listeners.contains(breadcrumbsModelListener)) {
            this.m_listeners.add(breadcrumbsModelListener);
        }
    }

    public void removeBreadcrumbsModelListener(BreadcrumbsModelListener breadcrumbsModelListener) {
        if (this.m_listeners.contains(breadcrumbsModelListener)) {
            this.m_listeners.remove(breadcrumbsModelListener);
        }
    }

    public boolean hasChildren(Breadcrumb breadcrumb) {
        return ((PlSqlBreadcrumb)breadcrumb).canHavePopupItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(PlSqlCodeFragment plSqlCodeFragment, PlSqlParser plSqlParser) throws CancelledException {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            this.m_crumbs.clear();
            try {
                while (plSqlCodeFragment != null) {
                    String[] stringArray = this.getText(plSqlCodeFragment, plSqlParser);
                    if (stringArray[0] != null) {
                        String string;
                        String string2 = stringArray[0];
                        String string3 = stringArray[2];
                        String string4 = string = this.m_crumbs.size() < 3 ? stringArray[1] : "";
                        if (string != null && string.length() > 40) {
                            string = "";
                        }
                        PlSqlBreadcrumb plSqlBreadcrumb = new PlSqlBreadcrumb(string2, string, plSqlCodeFragment.getStartOffset(), plSqlCodeFragment, string3);
                        this.m_crumbs.add(0, plSqlBreadcrumb);
                    }
                    plSqlCodeFragment = (PlSqlCodeFragment)plSqlCodeFragment.getParent();
                }
                return true;
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                this.m_crumbs.clear();
            }
        }
        return false;
    }

    private String[] getText(PlSqlCodeFragment plSqlCodeFragment, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(plSqlCodeFragment.getStartOffset().intValue());
        String[] stringArray = new String[3];
        if (plSqlCodeFragment instanceof PlSqlStatement) {
            if (plSqlCodeFragment instanceof SchemaObject) {
                stringArray[0] = plSqlCodeFragment.getName();
                plSqlToken = plSqlParser.getNameToken();
            } else if (plSqlCodeFragment instanceof PlSqlSubProgram) {
                while (!(plSqlToken.getStart() >= plSqlCodeFragment.getEndOffset() || plSqlToken.matches("PROCEDURE") || plSqlToken.matches("FUNCTION") || plSqlToken.matches("CURSOR"))) {
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                }
                if (plSqlToken.matches("PROCEDURE") || plSqlToken.matches("FUNCTION") || plSqlToken.matches("CURSOR")) {
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                }
                stringArray[0] = plSqlToken.getSource(true);
            } else {
                PlSqlStatement.Type type = ((PlSqlStatement)plSqlCodeFragment).getStatementType();
                if (type != null) {
                    String string = null;
                    switch (type) {
                        case IF: 
                        case ELSIF: {
                            string = "THEN";
                            break;
                        }
                        case FOR_LOOP: 
                        case WHILE_LOOP: {
                            string = "LOOP";
                            break;
                        }
                    }
                    if (string != null) {
                        PlSqlToken plSqlToken2;
                        PlSqlToken plSqlToken3;
                        stringArray[0] = plSqlToken.getSource().toLowerCase();
                        PlSqlToken plSqlToken4 = plSqlToken3 = (PlSqlToken)plSqlToken.getNextCodeToken();
                        while (!plSqlToken4.matches(string) && (plSqlToken2 = (PlSqlToken)plSqlToken4.getNextCodeToken()) != null && !plSqlToken2.isEndMarker()) {
                            plSqlToken4 = plSqlToken2;
                        }
                        stringArray[1] = " " + plSqlToken3.getSource(true, (Token)plSqlToken4).toLowerCase();
                        stringArray[2] = plSqlToken.getSource(false, (Token)plSqlToken4);
                    }
                } else {
                    PlSqlToken plSqlToken5 = plSqlParser.getTokenAtOffset(plSqlCodeFragment.getEndOffset().intValue());
                    stringArray[0] = plSqlToken.getSource(true).toLowerCase();
                    stringArray[1] = null;
                    stringArray[2] = plSqlToken.getSource(false, (Token)plSqlToken5);
                }
            }
        }
        return stringArray;
    }

    public void dispose() {
        this.m_crumbs.clear();
    }

    void fireBreadcrumbsUpdated() {
        for (BreadcrumbsModelListener breadcrumbsModelListener : this.m_listeners) {
            breadcrumbsModelListener.breadcrumbsUpdated();
        }
    }
}

