/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.ide.ceditor.BreadcrumbsPlugin;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.config.Preferences;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.PeekHelper;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumb;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumbsModel;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.PopupHandler;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;

public final class PlSqlBreadcrumbsPlugin
extends BreadcrumbsPlugin
implements CaretListener {
    private PlSqlBreadcrumbsListener m_listener;
    private PlSqlBreadcrumbsModel m_breadcrumbsModel;
    private PopupHandler m_popupHandler;
    private DBRequestProcessor m_reqProc;

    public void install(BasicEditorPane basicEditorPane) {
        Preferences preferences = Preferences.getPreferences();
        if (DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs() && PlSqlFeatures.isSupportedBreadcrumbs() && PlSqlFeatures.getTextNode(basicEditorPane) != null) {
            super.install(basicEditorPane);
            basicEditorPane.addCaretListener((CaretListener)this);
            this.m_breadcrumbsModel = new PlSqlBreadcrumbsModel();
            this.breadcrumbs.setModel((BreadcrumbsModel)this.m_breadcrumbsModel);
            this.m_listener = new PlSqlBreadcrumbsListener();
            this.breadcrumbs.addBreadcrumbsListener((BreadcrumbsListener)this.m_listener);
            this.m_popupHandler = new PopupHandler();
            this.m_popupHandler.attach(this.breadcrumbs, (PopupProvider)new PlSqlPopupProvider());
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        DBRequestProcessor dBRequestProcessor;
        PlSqlBreadcrumbsModel plSqlBreadcrumbsModel;
        PlSqlBreadcrumbsListener plSqlBreadcrumbsListener;
        PopupHandler popupHandler = this.m_popupHandler;
        if (popupHandler != null) {
            popupHandler.detatch();
            this.m_popupHandler = null;
        }
        if ((plSqlBreadcrumbsListener = this.m_listener) != null) {
            this.breadcrumbs.removeBreadcrumbsListener((BreadcrumbsListener)plSqlBreadcrumbsListener);
            this.m_listener = null;
        }
        if ((plSqlBreadcrumbsModel = this.m_breadcrumbsModel) != null) {
            plSqlBreadcrumbsModel.dispose();
            this.breadcrumbs.setModel(null);
            this.m_breadcrumbsModel = null;
        }
        if ((dBRequestProcessor = this.m_reqProc) != null) {
            dBRequestProcessor.cancel(this.getRequestProcessorKey());
            this.m_reqProc = null;
        }
        basicEditorPane.removeCaretListener((CaretListener)this);
        super.deinstall(basicEditorPane);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        BaseDBObjectTextNode baseDBObjectTextNode = this.getTextNode();
        if (this.m_reqProc == null) {
            this.m_reqProc = DBRequestProcessorFactory.getProcessor(baseDBObjectTextNode);
        }
        String string = this.getRequestProcessorKey();
        DBRequestProcessor dBRequestProcessor = this.m_reqProc;
        dBRequestProcessor.getClass();
        this.m_reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, baseDBObjectTextNode.getProvider(), UIBundle.format("PLSQL_BREADCRUMBS_TASK", baseDBObjectTextNode.getShortLabel())){
            {
                DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor;
                dBRequestProcessor2.getClass();
                super(dBObjectProvider, string);
            }

            @Override
            protected void doWork() throws DBException {
                PlSqlBreadcrumbsPlugin.this.updateBreadCrumbs();
            }
        }, 1500);
    }

    private BaseDBObjectTextNode getTextNode() {
        return PlSqlFeatures.getTextNode(this.editor);
    }

    private String getRequestProcessorKey() {
        return this.getClass().getSimpleName();
    }

    private void updateBreadCrumbs() throws CancelledException {
        PlSqlCodeFragment plSqlCodeFragment;
        PlSqlParser plSqlParser;
        BaseDBObjectTextNode baseDBObjectTextNode;
        PlSqlSourceObject plSqlSourceObject;
        PlSqlBreadcrumbsModel plSqlBreadcrumbsModel = this.m_breadcrumbsModel;
        if (plSqlBreadcrumbsModel != null && (plSqlSourceObject = (PlSqlSourceObject)(baseDBObjectTextNode = this.getTextNode()).getDBObjectFromBuffer()) != null && (plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)this.getTextNode().getProvider())) != null && plSqlParser.getRoot() != null && this.editor != null && plSqlBreadcrumbsModel != null && plSqlBreadcrumbsModel.update(plSqlCodeFragment = (PlSqlCodeFragment)plSqlSourceObject.getDeclarationAtOffset(this.editor.getCaretPosition()), plSqlParser)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlSqlBreadcrumbsModel plSqlBreadcrumbsModel = PlSqlBreadcrumbsPlugin.this.m_breadcrumbsModel;
                    if (plSqlBreadcrumbsModel != null) {
                        plSqlBreadcrumbsModel.fireBreadcrumbsUpdated();
                    }
                }
            });
        }
    }

    private class PlSqlBreadcrumbsListener
    implements BreadcrumbsListener<Integer> {
        private CodePeek m_peek;

        private PlSqlBreadcrumbsListener() {
        }

        public void breadcrumbClicked(Breadcrumb<Integer> breadcrumb) {
            if (breadcrumb != null) {
                PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)breadcrumb.getUserObject()).intValue());
                PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
            }
        }

        public void breadcrumbContextClicked(Breadcrumb<Integer> breadcrumb, Point point) {
        }

        public void showBreadcrumbPeek(Breadcrumb breadcrumb, Rectangle rectangle) {
            String string;
            if (breadcrumb == null) {
                return;
            }
            if (this.m_peek != null) {
                this.m_peek.hidePeek();
            }
            if ((string = ((PlSqlBreadcrumb)breadcrumb).getPeekText()) == null) {
                return;
            }
            this.m_peek = PeekHelper.createCodePeek((JComponent)PlSqlBreadcrumbsPlugin.this.breadcrumbs, (String)PlSqlBreadcrumbsPlugin.this.getTextNode().getURL().toExternalForm(), (String)string, null, (Rectangle)rectangle);
            this.m_peek.getGhostPointingPalette().setShowRectangle(false);
            this.m_peek.showPeek();
        }

        public void hideBreadcrumbPeek() {
            if (this.m_peek != null) {
                this.m_peek.hidePeek();
            }
        }

        public void separatorClicked(Breadcrumb breadcrumb, Rectangle rectangle) {
        }
    }

    private class PlSqlPopupProvider
    implements PopupProvider<Integer> {
        private PlSqlPopupProvider() {
        }

        public List<PopupItem<Integer>> getPopupItems(Breadcrumb breadcrumb) {
            List<PopupItem<Integer>> list = ((PlSqlBreadcrumb)breadcrumb).getPopupItems();
            return list;
        }

        public void itemSelected(PopupItem<Integer> popupItem) {
            PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)popupItem.getUserObject()).intValue());
            PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
        }
    }
}

