/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.AsynchronousComboComponentWrapper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class DataTypeUsageEditableWrapper
extends AsynchronousComboComponentWrapper<JComboBox<String>> {
    private final Map<String, DataTypeUsage> m_cache = new ConcurrentHashMap<String, DataTypeUsage>();
    private final Map<String, String> m_defaultUsageStrings = new HashMap<String, String>();

    public DataTypeUsageEditableWrapper() {
        super(new JComboBox());
        JComboBox jComboBox = (JComboBox)this.getActiveComponent();
        jComboBox.setEditable(true);
        jComboBox.setEditor(new BasicComboBoxEditor(){

            @Override
            public void setItem(Object object) {
                String string = "";
                if (object instanceof String) {
                    string = (String)object;
                    String string2 = (String)DataTypeUsageEditableWrapper.this.m_defaultUsageStrings.get(string);
                    if (string2 != null) {
                        string = string2;
                    }
                }
                if (ModelUtil.areDifferent((Object)this.editor.getText(), (Object)string)) {
                    this.editor.setText(string);
                }
            }

            @Override
            public Object getItem() {
                return super.getItem();
            }
        });
    }

    @Override
    protected void resourceComponent(DBUIResourceHelper dBUIResourceHelper) {
        super.resourceComponent(dBUIResourceHelper);
        dBUIResourceHelper.setName(((JComboBox)this.getActiveComponent()).getEditor().getEditorComponent(), this.getPropertyName() + "-editor");
    }

    @Override
    protected void initialiseComponent() {
        JComboBox jComboBox = (JComboBox)this.getActiveComponent();
        if (this.getComponentContext().isInTable()) {
            jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        DataType[] dataTypeArray = this.getProvider().listSupportedDataTypes();
        Arrays.sort(dataTypeArray, DBUtil.getNameComparator());
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
        for (DataType dataType : dataTypeArray) {
            String string;
            String string2 = dataType.getName();
            nonNullableComboBoxModel.addElement((Object)string2);
            DataTypeUsage dataTypeUsage = dataType.createDefaultUsage();
            this.m_cache.put(string2, dataTypeUsage);
            if (dataTypeUsage.getAttributeValues().isEmpty() || !ModelUtil.areDifferent((Object)(string = dataType.getDDL(dataTypeUsage)), (Object)string2)) continue;
            this.m_defaultUsageStrings.put(string2, string);
            this.m_cache.put(string, dataTypeUsage);
        }
        jComboBox.setModel(nonNullableComboBoxModel);
    }

    public DataTypeUsage getPropertyValue() {
        String string = (String)((JComboBox)this.getActiveComponent()).getEditor().getItem();
        DataTypeUsage dataTypeUsage = this.m_cache.get(string);
        if (dataTypeUsage == null) {
            dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.getProvider(), (Schema)DBUtil.getSchema((DBObject)this.getUpdatedObject()), (String)string);
            if (dataTypeUsage != null) {
                this.m_cache.put(string, (DataTypeUsage)dataTypeUsage.copyTo(null));
            }
        } else {
            dataTypeUsage = (DataTypeUsage)dataTypeUsage.copyTo(null);
        }
        return dataTypeUsage;
    }

    @Override
    protected void setPropertyValueImpl(Object object) {
        JComboBox jComboBox = (JComboBox)this.getActiveComponent();
        String string = "";
        if (object instanceof DataTypeUsage) {
            string = DataTypeHelper.getDDL((DataTypeUsage)((DataTypeUsage)object), (DBObjectProvider)this.getProvider());
        }
        jComboBox.setSelectedItem(string);
    }
}

