/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.components.AsynchronousComboComponentWrapper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;

public class IndexObjectComponentWrapper
extends AsynchronousComboComponentWrapper<CustomCombo> {
    public IndexObjectComponentWrapper() {
        super(new CustomCombo());
        CustomCombo customCombo = (CustomCombo)this.getActiveComponent();
        customCombo.setParent(this);
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        if (DBUtil.findParentOfType((DBObject)this.getUpdatedObject(), Index.class) != null) {
            JComboBox jComboBox = (JComboBox)this.getActiveComponent();
            jComboBox.setEditable(true);
        }
    }

    @Override
    public Object getPropertyValue() {
        JComboBox jComboBox = (JComboBox)this.getActiveComponent();
        Object object = jComboBox.isEditable() ? jComboBox.getEditor().getItem() : jComboBox.getSelectedItem();
        return object;
    }

    @Override
    protected void setPropertyValueImpl(Object object) {
        CustomCombo customCombo = (CustomCombo)this.getActiveComponent();
        customCombo.reset();
        customCombo.setSelectedItem(object);
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        ((CustomCombo)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndexObjectComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void setActiveImpl(boolean bl) {
        super.setActiveImpl(bl);
        if (!bl) {
            ((CustomCombo)this.getActiveComponent()).cancel();
        }
    }

    static class CustomCombo
    extends AbstractLazyCombo {
        private ComponentWrapper m_parent = null;

        CustomCombo() {
        }

        @Override
        public void setName(String string) {
            super.setName(string + "-combo");
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().setName(string);
            }
        }

        private void setParent(ComponentWrapper componentWrapper) {
            this.m_parent = componentWrapper;
        }

        @Override
        protected List getModelEntries() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.m_parent != null) {
                ComponentContext componentContext = this.m_parent.getComponentContext();
                DBEditorConfig dBEditorConfig = componentContext.getEditorConfig();
                DBObjectProvider dBObjectProvider = componentContext.getProvider();
                SystemObject systemObject = dBEditorConfig.getUpdatedObject();
                Relation relation = (Relation)DBUtil.findParentOfType((DBObject)systemObject, Table.class);
                if (relation != null) {
                    for (Column column : relation.getColumns()) {
                        arrayList.add(dBObjectProvider.getExternalName(column.getName(), "COLUMN"));
                    }
                }
            }
            return arrayList;
        }
    }
}

