/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SubTypeComponentWrapper
extends EnumPropertyComponentWrapper {
    private Map<String, Object> m_cachedProperties;

    public SubTypeComponentWrapper() {
        this.addVetoListener(propertyChangeEvent -> this.vetoPropertyChange(propertyChangeEvent));
        this.addListener(propertyChangeEvent -> this.processPropertyChange(propertyChangeEvent));
    }

    private void vetoPropertyChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Object object;
        Object object2;
        if (this.isActive() && ModelUtil.areDifferent((Object)(object2 = propertyChangeEvent.getOldValue()), (Object)(object = propertyChangeEvent.getNewValue())) && this.vetoPropertyChange(object2, object)) {
            throw new PropertyVetoException(null, propertyChangeEvent);
        }
    }

    protected boolean vetoPropertyChange(Object object, Object object2) {
        boolean bl = false;
        DBObject dBObject = this.getUpdatedObject();
        if (dBObject instanceof SystemObject) {
            SystemObject systemObject = (SystemObject)dBObject;
            try {
                SystemObject systemObject2 = (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject);
                this.getPropertyHelper().setPropertyValueOrFail((Object)systemObject2, this.getPropertyName(), object2);
                Map<String, Object> map = this.getInvalidProperties(systemObject2);
                if (map != null && !map.isEmpty()) {
                    bl = !MessageDialog.confirm((Component)DBMessageDialog.getDialogParent(), (Object)this.getConfirmationMessage(object2, map), (String)UIBundle.get("DBOBJECT_PROP_CONFIRM_TITLE"), null, (boolean)true);
                }
            }
            catch (MissingPropertyException missingPropertyException) {
                this.getLogger().warning(missingPropertyException.getMessage());
            }
        }
        return bl;
    }

    private void processPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isActive()) {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if (ModelUtil.areDifferent((Object)object2, (Object)object)) {
                if (this.shouldEnsurePanels()) {
                    try {
                        PanelLibrary.ensurePanels(this.getComponentContext().getDataContext(), traversableContext -> this.clearInvalidProperties());
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog(this.getComponent());
                        this.resetPropertyValue(object2);
                    }
                } else {
                    this.clearInvalidProperties();
                }
            }
        }
    }

    private void clearInvalidProperties() {
        Object object;
        SystemObject systemObject = (SystemObject)this.getUpdatedObject();
        SystemObject systemObject2 = (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject);
        Map<String, Object> map = this.getInvalidProperties(systemObject2);
        for (Map.Entry<String, Object> propertyHelper : map.entrySet()) {
            object = propertyHelper.getKey();
            Iterator<Map.Entry<String, Object>> iterator = propertyHelper.getValue();
            this.clearInvalidProperty(systemObject, (String)object, iterator);
            if (this.getComponentContext().isInFlatEditor() || !this.shouldCacheInvalidProperty((String)object)) continue;
            if (this.m_cachedProperties == null) {
                this.m_cachedProperties = new HashMap<String, Object>();
            }
            this.m_cachedProperties.put((String)object, iterator);
        }
        if (this.m_cachedProperties != null && !this.m_cachedProperties.isEmpty()) {
            PropertyManager propertyManager = this.getProvider().getPropertyManager();
            PropertyHelper propertyHelper = this.getPropertyHelper();
            object = new HashMap();
            for (Map.Entry<String, Object> entry : this.m_cachedProperties.entrySet()) {
                String string = entry.getKey();
                Object object2 = entry.getValue();
                if (propertyManager.canCreateProperty(systemObject2, string)) {
                    propertyHelper.setPropertyValue((Object)systemObject, string, object2);
                    continue;
                }
                object.put(string, object2);
            }
            this.m_cachedProperties = object;
        }
    }

    private String getConfirmationMessage(Object object, Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(PropertyDisplayRegistry.getDisplayName(string, this.getProvider(), this.getUpdatedObject()));
        }
        String string = UIBundle.format("DBOBJECT_PROP_CONFIRM", this.getPropertyDisplayName(), PropertyDisplayRegistry.getPropValueDisplay(this.getPropertyName(), object), stringBuilder);
        return string;
    }

    protected boolean shouldCacheInvalidProperty(String string) {
        return false;
    }

    protected boolean shouldRecurseToChildProperties(String string) {
        return false;
    }

    protected boolean shouldTestProperty(String string) {
        return !string.equals("Timestamp") && !string.equals("TemplateObject");
    }

    protected boolean shouldEnsurePanels() {
        return false;
    }

    protected Map<String, Object> getInvalidProperties(SystemObject systemObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.findInvalidProperties(systemObject, (DBObject)systemObject, hashMap, null);
        return hashMap;
    }

    private void findInvalidProperties(SystemObject systemObject, DBObject dBObject, Map<String, Object> map, String string) {
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        Map map2 = dBObject.getProperties();
        for (Map.Entry entry : map2.entrySet()) {
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            if (!this.shouldTestProperty(string2) || v == null) continue;
            String string3 = string == null ? string2 : Property.createPath((String[])new String[]{string, string2});
            boolean bl = propertyManager.canCreateProperty(systemObject, string3);
            if (!bl) {
                map.put(string3, v);
                continue;
            }
            if (!(v instanceof DBObject) || !this.shouldRecurseToChildProperties(string3)) continue;
            this.findInvalidProperties(systemObject, (DBObject)v, map, string3);
        }
    }

    protected void clearInvalidProperty(SystemObject systemObject, String string, Object object) {
        this.getPropertyHelper().setPropertyValue((Object)systemObject, string, null);
    }

    protected boolean applyCachedProperty(SystemObject systemObject, String string, Object object) {
        boolean bl = false;
        if (this.getProvider().getPropertyManager().canCreateProperty(systemObject, string)) {
            this.getPropertyHelper().setPropertyValue((Object)systemObject, string, object);
            bl = true;
        }
        return bl;
    }
}

