/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.insight.completion.DBCompletionSupportFactory;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ideimpl.db.components.AsynchronousDocumentComponentWrapper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.PopupButton;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.util.ModelUtil;

public abstract class TextPropertyComponentWrapper<T extends JTextComponent>
extends AsynchronousDocumentComponentWrapper<T> {
    private boolean m_internalise;

    protected TextPropertyComponentWrapper(T t) {
        super(t);
    }

    @Override
    public Object getPropertyValue() {
        String string = ((JTextComponent)this.getActiveComponent()).getText();
        if (string != null) {
            if (this.m_internalise) {
                string = this.getProvider().getInternalName(string);
            }
            if (string.length() == 0) {
                string = null;
            }
        }
        return string;
    }

    @Override
    protected void writeFinished(boolean bl) {
        if (this.refreshAfterWrite() && bl) {
            this.refreshObject(this.getUpdatedObject());
        }
    }

    protected boolean refreshAfterWrite() {
        return this.m_internalise;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ((JTextComponent)this.getActiveComponent()).setEditable(bl);
    }

    @Override
    protected void setPropertyValueImpl(Object object) {
        JTextComponent jTextComponent = (JTextComponent)this.getActiveComponent();
        String string = jTextComponent.getText();
        String string2 = object instanceof String ? (this.m_internalise ? this.getProvider().getExternalName((String)object) : (String)object) : null;
        if (ModelUtil.areDifferent(string2, (Object)string)) {
            jTextComponent.setText(string2);
        }
    }

    @Override
    protected Document getDocument() {
        return ((JTextComponent)this.getActiveComponent()).getDocument();
    }

    private void setInternalise(boolean bl) {
        this.m_internalise = bl;
    }

    @Override
    protected void initialiseComponent() {
        String string = this.getUpdatedObject().getType();
        String string2 = this.getPropertyName();
        PropertyCriteria propertyCriteria = new PropertyCriteria();
        propertyCriteria.setDerived(Boolean.valueOf(true));
        propertyCriteria.addPredicate(propertyInfo -> string2.equals(propertyInfo.getDerivedSourceProperty()) && SQLFragment.class.isAssignableFrom(propertyInfo.getPropertyClass()));
        DBObject dBObject = this.getUpdatedObject();
        if (Metadata.getInstance().hasSupportedProperty(this.getUpdatedObject().getClass(), null, (Predicate)propertyCriteria)) {
            DBInsightContext dBInsightContext = new DBInsightContext();
            dBInsightContext.setProvider(this.getProvider());
            dBInsightContext.setContextObject(dBObject);
            Context context = (Context)this.getComponentContext().getDataContext().find(Context.class);
            DBCompletionSupportFactory.getCompletionSupport(dBInsightContext, context, (JTextComponent)this.getActiveComponent());
        }
        super.initialiseComponent();
    }

    public static TextPropertyComponentWrapper createTextWrapper(ComponentContext componentContext) {
        PropertyInfo propertyInfo = componentContext.getPropertyInfo();
        TextPropertyComponentWrapper textPropertyComponentWrapper = componentContext.isInTable() && propertyInfo.isTextMultiLine() ? TextPropertyComponentWrapper.createExtendedTextFieldWrapper() : (propertyInfo.isTextPassword() ? new PasswordTextWrapper() : (propertyInfo.isTextMultiLine() ? TextPropertyComponentWrapper.createMultiLineTextWrapper() : ("name".equals(componentContext.getPropertyName()) ? new NameWrapper() : new SingleLineTextWrapper())));
        super.setInternalise(propertyInfo.isTextInternalName());
        return textPropertyComponentWrapper;
    }

    static TextPropertyComponentWrapper<ExtendedTextField> createExtendedTextFieldWrapper() {
        return new ExtendedTextFieldWrapper();
    }

    private static TextPropertyComponentWrapper<JTextArea> createMultiLineTextWrapper() {
        return new MultiLineTextWrapper();
    }

    static TextPropertyComponentWrapper<JTextArea> createMultiLineSQLTextWrapper(PropertyInfo propertyInfo) {
        SQLFragmentExpressionBuilder.ExpressionType expressionType = SQLFragmentExpressionBuilder.ExpressionType.ITEM;
        if ("checkCondition".equals(propertyInfo.getPropertyName())) {
            expressionType = SQLFragmentExpressionBuilder.ExpressionType.CONDITION;
        }
        return new MultiLineSQLTextWrapper(expressionType);
    }

    private static class MultiLineTextWrapper
    extends TextPropertyComponentWrapper<JTextArea> {
        public MultiLineTextWrapper() {
            super(new JTextArea());
        }

        @Override
        public Component getCellEditorComponent() {
            JTextArea jTextArea = (JTextArea)this.getActiveComponent();
            jTextArea.setRows(4);
            jTextArea.setColumns(20);
            PopupButton popupButton = new PopupButton((JComponent)new JScrollPane(jTextArea));
            return popupButton;
        }

        @Override
        protected void setPropertyValueImpl(Object object) {
            super.setPropertyValueImpl(object);
            ((JTextArea)this.getActiveComponent()).setCaretPosition(0);
        }

        @Override
        protected Component createComponentForLayout() {
            JTextArea jTextArea = (JTextArea)this.getActiveComponent();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            if (this.getComponentContext().isInFlatEditor()) {
                jScrollPane = new ResizeComponent((JComponent)jScrollPane);
            }
            jScrollPane.setPreferredSize(new Dimension(300, 100));
            return jScrollPane;
        }
    }

    private static class PasswordTextWrapper
    extends SingleLineTextWrapper<JPasswordField> {
        public PasswordTextWrapper() {
            super(new JPasswordField());
        }
    }

    private static class ExtendedTextFieldWrapper
    extends SingleLineTextWrapper<ExtendedTextField> {
        public ExtendedTextFieldWrapper() {
            super(new ExtendedTextField());
        }

        @Override
        protected void initialiseComponent() {
            super.initialiseComponent();
            ((ExtendedTextField)this.getActiveComponent()).setAllowBreaks(true);
        }
    }

    private static class NameWrapper<T extends JTextField>
    extends SingleLineTextWrapper<T> {
        public NameWrapper() {
            this(new JTextField());
        }

        protected NameWrapper(T t) {
            super(t);
            this.addVetoChangeListener();
        }

        protected void addVetoChangeListener() {
            this.addVetoListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = ((JTextField)this.getActiveComponent()).getText();
                    try {
                        String string2 = this.getUpdatedObject().getType();
                        this.getProvider().validateName(string2, string);
                    }
                    catch (InvalidNameException invalidNameException) {
                        throw new PropertyVetoException(invalidNameException.getMessage(), propertyChangeEvent);
                    }
                }
            });
        }

        @Override
        protected void initialiseComponent() {
            super.initialiseComponent();
            ((JTextField)this.getActiveComponent()).setColumns(1);
        }

        @Override
        protected boolean refreshAfterWrite() {
            return true;
        }
    }

    public static class SingleLineTextWrapper<T extends JTextField>
    extends TextPropertyComponentWrapper<T> {
        public SingleLineTextWrapper() {
            this(new JTextField());
        }

        protected SingleLineTextWrapper(T t) {
            super(t);
        }

        @Override
        protected void initialiseComponentListener() {
            super.initialiseComponentListener();
            if (this.getComponentContext().isInFlatEditor() && !this.getComponentContext().isInTable()) {
                ((JTextField)this.getActiveComponent()).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.fireChangeEvent();
                    }
                });
            }
        }
    }

    private static class MultiLineSQLTextWrapper
    extends MultiLineTextWrapper {
        private final SQLFragmentExpressionBuilder.ExpressionType m_expressionType;

        public MultiLineSQLTextWrapper(SQLFragmentExpressionBuilder.ExpressionType expressionType) {
            this.m_expressionType = expressionType;
        }

        @Override
        protected void setPropertyValueImpl(Object object) {
            ((JTextArea)this.getActiveComponent()).setText(object instanceof SQLFragment ? ((SQLFragment)object).getSQLText() : null);
        }

        @Override
        public Object getPropertyValue() {
            String string = ((JTextArea)this.getActiveComponent()).getText().trim();
            Relation relation = (Relation)DBUtil.findParentOfType((DBObject)this.getUpdatedObject(), Relation.class);
            SQLFragment sQLFragment = SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)this.getProvider(), (Relation)relation, (SQLFragmentExpressionBuilder.ExpressionType)this.m_expressionType, (String)string);
            return sQLFragment;
        }

        @Override
        public Component getCellEditorComponent() {
            JTextArea jTextArea = (JTextArea)this.getActiveComponent();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setRows(3);
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
            return jScrollPane;
        }
    }
}

