/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension;

import java.awt.HeadlessException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ImageIconCache;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

public abstract class AbstractExtensionHook {
    protected static final String TEXT_KEY = "#text";
    protected static final String NAMESPACE = "http://xmlns.oracle.com/ide/extension/db";
    private static Map<String, AbstractExtensionHook> s_hooks = new TreeMap<String, AbstractExtensionHook>();
    private HashStructureHookListener m_listener;
    private HashStructure m_currentHash;
    private HashStructureHook m_hook;
    private ElementName m_elementName;
    private final Map<String, HashProcessor> m_processors = new HashMap<String, HashProcessor>();

    private synchronized HashStructureHook getHook() {
        if (this.m_hook == null) {
            this.m_hook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(this.m_elementName);
            if (this.m_hook == null) {
                throw new IllegalArgumentException("Cannot find hook " + this.m_elementName.getLocalName());
            }
            this.initialize();
        }
        return this.m_hook;
    }

    final void setElementName(ElementName elementName) {
        this.m_elementName = elementName;
    }

    private void cacheProcessor(Class clazz, HashProcessor hashProcessor) {
        this.m_processors.put(clazz.getName(), hashProcessor);
    }

    private List<HashThunk> getProcessedList(Class clazz) {
        HashProcessorList hashProcessorList = null;
        HashProcessor hashProcessor = this.m_processors.get(clazz.getName());
        if (hashProcessor instanceof HashProcessorList) {
            hashProcessorList = (HashProcessorList)hashProcessor;
        }
        return hashProcessorList;
    }

    protected final <T> List<T> getList(Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<HashThunk> list = this.getProcessedList(clazz);
        if (list != null) {
            for (HashThunk hashThunk : list) {
                try {
                    Object object = hashThunk.get();
                    if (object == null) continue;
                    arrayList.add(object);
                }
                catch (ClassCastException classCastException) {
                    this.logClassCastError(hashThunk.m_hash, hashThunk.m_clzName, clazz.getName());
                }
            }
        }
        return arrayList;
    }

    protected final synchronized void checkListenerInit() {
        if (this.m_listener == null) {
            this.m_listener = new HashStructureHookListener(){

                public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
                    AbstractExtensionHook.this.incomingHashStructure(hashStructureHookEvent.getCombinedHashStructure());
                }

                public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
                    AbstractExtensionHook.this.incomingHashStructure(hashStructureHookEvent.getNewElementHashStructure());
                }
            };
            this.getHook().addHashStructureHookListener(this.m_listener);
        }
    }

    protected void initialize() {
    }

    private synchronized void incomingHashStructure(HashStructure hashStructure) {
        this.processHashStructure(hashStructure);
        for (HashProcessor hashProcessor : this.m_processors.values()) {
            hashProcessor.process(hashStructure);
        }
    }

    protected void processHashStructure(HashStructure hashStructure) {
    }

    private final HashStructure getSingleChild(HashStructure hashStructure, String string) {
        HashStructure hashStructure2 = null;
        List list = hashStructure.getAsList(string);
        if (list != null && list.size() > 0) {
            hashStructure2 = (HashStructure)list.get(0);
        }
        return hashStructure2;
    }

    protected final void fullyLoadExtension(HashStructure hashStructure, String string) {
        ExtensionRegistry extensionRegistry;
        Extension extension;
        String string2 = HashStructureHook.getExtensionId((HashStructure)hashStructure);
        if (string2 != null && (extension = (extensionRegistry = ExtensionRegistry.getExtensionRegistry()).findExtension(string2)) != null) {
            extensionRegistry.fullyLoadExtension(extension, string);
        }
    }

    protected final <T> MetaClass<T> getSingleChildMeta(HashStructure hashStructure, String string, Class<T> clazz) {
        MetaClass metaClass = null;
        HashStructure hashStructure2 = this.getSingleChild(hashStructure, string);
        if (hashStructure2 != null) {
            metaClass = this.getMetaClass(hashStructure2);
        }
        return metaClass;
    }

    protected final MetaClass getMetaClass(HashStructure hashStructure) {
        LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure);
        return lazyClassAdapter.getMetaClass(TEXT_KEY);
    }

    protected final Step loadStep(HashStructure hashStructure) {
        Step step = null;
        String string = this.getText(hashStructure, "title");
        Class<Traversable> clazz = this.loadClass(hashStructure, "panel-class", Traversable.class);
        if (clazz != null) {
            String string2 = this.getText(hashStructure, "help-id", false);
            String string3 = this.getText(hashStructure, "step-label", false);
            step = new Step(string, clazz, string2);
            if (ModelUtil.hasLength((String)string3)) {
                step.setStepLabel(string3);
            }
        }
        return step;
    }

    protected final Navigable loadNavigable(HashStructure hashStructure) {
        DBNavigable dBNavigable = null;
        String string = this.getText(hashStructure, "title");
        Class<Traversable> clazz = this.loadClass(hashStructure, "panel-class", Traversable.class);
        if (clazz != null) {
            List<String> list = this.getChildTextList(hashStructure, "panel-properties", "property");
            if (list.size() > 0) {
                dBNavigable = new DBNavigable(string, clazz);
                dBNavigable.setProperties(list);
            } else {
                dBNavigable = new Navigable(string, clazz);
            }
            String string2 = this.getText(hashStructure, "help-id", false);
            if (ModelUtil.hasLength((String)string2)) {
                dBNavigable.setHelpID(string2);
            }
        }
        return dBNavigable;
    }

    protected final List<Navigable> loadNavigables(List<HashStructure> list) {
        ArrayList<Navigable> arrayList = new ArrayList<Navigable>();
        for (HashStructure hashStructure : list) {
            Navigable navigable = this.loadNavigable(hashStructure);
            if (navigable == null) continue;
            arrayList.add(navigable);
        }
        return arrayList;
    }

    protected boolean isAssignableFrom(String string, Class clazz) {
        boolean bl = false;
        if (ModelUtil.hasLength((String)string)) {
            block0: for (Class clazz2 = clazz; clazz2 != null && !bl; clazz2 = clazz2.getSuperclass()) {
                if (string.equals(clazz2.getName())) {
                    bl = true;
                    break;
                }
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    if (!string.equals(clazz3.getName())) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        return bl;
    }

    protected <T> Class<? extends T> loadAPIClass(HashStructure hashStructure, Class<T> clazz) {
        Class<Object> clazz2 = null;
        String string = HashStructureHook.getText((HashStructure)hashStructure);
        try {
            clazz2 = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz2 = this.loadClass(hashStructure, clazz);
        }
        return clazz2;
    }

    public final <T> Class<? extends T> loadAPIClass(HashStructure hashStructure, String string, Class<T> clazz) {
        Class<T> clazz2 = null;
        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
        if (hashStructure2 != null) {
            clazz2 = this.loadAPIClass(hashStructure2, clazz);
        }
        return clazz2;
    }

    public final <T> Class<? extends T> loadClass(HashStructure hashStructure, Class<T> clazz) {
        Class clazz2 = null;
        String string = hashStructure.getStructName();
        MetaClass metaClass = this.getMetaClass(hashStructure);
        if (metaClass != null) {
            try {
                clazz2 = metaClass.toClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logClassCastError(hashStructure, HashStructureHook.getText((HashStructure)hashStructure), clazz.getName());
            }
            catch (Throwable throwable) {
                this.logError(hashStructure, UIBundle.format("EXTENSION_CLASS_ERR", HashStructureHook.getText((HashStructure)hashStructure), throwable.getMessage()));
            }
        }
        return clazz2;
    }

    public final <T> Class<? extends T> loadClass(HashStructure hashStructure, String string, Class<T> clazz) {
        Class<T> clazz2 = null;
        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
        if (hashStructure2 != null) {
            clazz2 = this.loadClass(hashStructure2, clazz);
        }
        return clazz2;
    }

    public final <T> Thunk<T> createInstanceThunk(HashStructure hashStructure, Class<T> clazz) {
        return new HashThunk<T>(hashStructure, clazz);
    }

    public final <T> Thunk<Class<? extends T>> createClassThunk(HashStructure hashStructure, Class<T> clazz) {
        return new HashClassThunk<T>(hashStructure, clazz);
    }

    public final <T> Thunk<Class<? extends T>> createClassThunk(HashStructure hashStructure, String string, Class<T> clazz) {
        Thunk<Class<T>> thunk = null;
        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
        if (hashStructure2 == null) {
            this.logMissingElemError(hashStructure, string);
        } else {
            thunk = this.createClassThunk(hashStructure2, clazz);
        }
        return thunk;
    }

    public final <T> T instantiateClass(HashStructure hashStructure, Class<T> clazz) {
        return this.instantiateClass(null, hashStructure, clazz, null, null);
    }

    public final <T> T instantiateClass(HashStructure hashStructure, Class<T> clazz, Class<?>[] classArray, Object[] objectArray) {
        return this.instantiateClass(null, hashStructure, clazz, classArray, objectArray);
    }

    private final <T> T instantiateClass(List<Thunk> list, HashStructure hashStructure, Class<T> clazz, Class<?>[] classArray, Object[] objectArray) {
        T t = null;
        Class<T> clazz2 = this.loadClass(hashStructure, clazz);
        if (clazz2 != null && !this.contains(list, clazz2)) {
            String string = hashStructure.getStructName();
            try {
                if (objectArray == null || objectArray.length == 0) {
                    t = clazz2.newInstance();
                } else {
                    Constructor<T> constructor = clazz2.getConstructor(classArray);
                    if (constructor == null) {
                        this.logError(hashStructure, UIBundle.format("EXTENSION_CONSTR_SIG", clazz2.getName(), classArray));
                    } else {
                        t = constructor.newInstance(objectArray);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                this.logClassCastError(hashStructure, clazz2.getName(), clazz.getName());
            }
            catch (HeadlessException headlessException) {
                throw headlessException;
            }
            catch (Throwable throwable) {
                String string2 = UIBundle.format("EXTENSION_CLASS_ERR", clazz2.getName(), throwable.getMessage());
                DBLog.logStackTrace((String)string2, (Throwable)throwable);
                this.logError(hashStructure, string2);
            }
        }
        return t;
    }

    private boolean contains(List<Thunk> list, Class clazz) {
        boolean bl = false;
        if (list != null) {
            for (Thunk thunk : list) {
                if (!thunk.getClass().equals(clazz)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected final void logError(HashStructure hashStructure, String string) {
        this.logMessage(hashStructure, Level.SEVERE, string);
    }

    protected final void logWarning(HashStructure hashStructure, String string) {
        this.logMessage(hashStructure, Level.WARNING, string);
    }

    protected final void logMessage(HashStructure hashStructure, Level level, String string) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        extensionRegistry.getManifestLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, this.m_elementName.getLocalName() + ": " + string, extensionRegistry.findExtension(HashStructureHook.getExtensionId((HashStructure)hashStructure)), 0));
    }

    protected final void logClassCastError(HashStructure hashStructure, String string, String string2) {
        this.logError(hashStructure, UIBundle.format("EXTENSION_CLASS_CAST", string, string2));
    }

    protected final void logMissingElemError(HashStructure hashStructure, String string) {
        this.logMissingElemError(hashStructure, null, string);
    }

    protected final void logMissingElemError(HashStructure hashStructure, String string, String string2) {
        this.logMissingElemsError(hashStructure, string, string2);
    }

    protected final void logMissingElemsError(HashStructure hashStructure, String string, String ... stringArray) {
        if (string == null) {
            String string2 = hashStructure.getStructName();
            try {
                String[] stringArray2;
                if (Integer.valueOf(string2) != null && (stringArray2 = (string2 = hashStructure.getFullName()).split("/")).length > 1) {
                    string2 = stringArray2[stringArray2.length - 2];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string = string2;
        }
        this.logError(hashStructure, UIBundle.format("EXTENSION_ELEM_MISSING", stringArray, string));
    }

    protected final List<String> getChildTextList(HashStructure hashStructure, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HashStructure hashStructure2 : this.getChildList(hashStructure, string, string2)) {
            arrayList.add(HashStructureHook.getText((HashStructure)hashStructure2));
        }
        return arrayList;
    }

    protected final List<HashStructure> getChildList(HashStructure hashStructure, String string, String string2) {
        ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
        List list = hashStructure.getAsList(string);
        if (list != null) {
            for (HashStructure hashStructure2 : list) {
                List list2 = hashStructure2.getAsList(string2);
                if (list2 == null) continue;
                arrayList.addAll(list2);
            }
        }
        return arrayList;
    }

    protected final List<? extends Thunk> createChildList(String string, String string2, Class clazz) {
        HashProcessorList hashProcessorList = new HashProcessorList(string, string2, clazz);
        this.cacheProcessor(clazz, hashProcessorList);
        return hashProcessorList;
    }

    protected final Map<String, Thunk> createChildMap(String string, String string2, String string3, String string4, Class clazz) {
        HashProcessorMap hashProcessorMap = new HashProcessorMap(string, string2, string3, string4, clazz);
        this.cacheProcessor(clazz, hashProcessorMap);
        return hashProcessorMap;
    }

    private final void populateObjectMap(Map<String, Thunk> map, HashStructure hashStructure, String string, String string2, String string3, String string4, Class clazz) {
        for (HashStructure hashStructure2 : this.getChildList(hashStructure, string, string2)) {
            String string5 = hashStructure2.getString(string3 + "/" + TEXT_KEY);
            if (ModelUtil.hasLength((String)string5)) {
                if (map.containsKey(string5)) {
                    this.logError(hashStructure2, UIBundle.format("EXTENSION_DUP_KEY", string2, string3, string5));
                    continue;
                }
                HashStructure hashStructure3 = hashStructure2.getHashStructure(string4);
                if (hashStructure3 == null) {
                    this.logError(hashStructure2, UIBundle.format("EXTENSION_ELEM_MISSING", string2, string4));
                    continue;
                }
                HashThunk hashThunk = new HashThunk(hashStructure3, clazz);
                map.put(string5, hashThunk);
                continue;
            }
            this.logError(hashStructure2, UIBundle.format("EXTENSION_ELEM_MISSING", string2, string3));
        }
    }

    private final void populateObjectList(List<HashThunk> list, HashStructure hashStructure, String string, String string2, Class clazz) {
        for (HashStructure hashStructure2 : this.getChildList(hashStructure, string, string2)) {
            String string3 = HashStructureHook.getText((HashStructure)hashStructure2);
            if (!ModelUtil.hasLength((String)string3)) continue;
            boolean bl = false;
            for (HashThunk hashThunk : list) {
                if (!string3.equals(hashThunk.m_clzName)) continue;
                bl = true;
            }
            if (bl) continue;
            list.add(0, new HashThunk(hashStructure2, clazz));
        }
    }

    protected final String getText(HashStructure hashStructure, String string) {
        return this.getText(hashStructure, string, true);
    }

    protected final String getText(HashStructure hashStructure, String string, boolean bl) {
        HashStructure hashStructure2 = hashStructure.getHashStructure(string);
        String string2 = null;
        if (hashStructure2 != null) {
            string2 = HashStructureHook.getText((HashStructure)hashStructure2);
        } else if (bl) {
            this.logMissingElemError(hashStructure, string);
        }
        return string2;
    }

    protected final Icon getIcon(HashStructure hashStructure) {
        return this.getIcon(hashStructure, "icon", true);
    }

    protected final Icon getIcon(HashStructure hashStructure, String string, boolean bl) {
        ImageIcon imageIcon = null;
        String string2 = this.getText(hashStructure, string, bl);
        if (ModelUtil.hasLength((String)string2)) {
            try {
                URL uRL = URLFactory.newURL((String)string2);
                imageIcon = ImageIconCache.get((URL)uRL);
            }
            catch (Exception exception) {
                this.logError(hashStructure, UIBundle.format("EXTENSION_ICON_LOADING_ERROR", exception.getMessage()));
            }
        }
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractExtensionHook> T findHook(ElementName elementName, Class<T> clazz) {
        if (ModelUtil.areDifferent((Object)NAMESPACE, (Object)elementName.getNamespaceURI())) {
            throw new IllegalArgumentException("Can only be used for database hooks.");
        }
        AbstractExtensionHook abstractExtensionHook = null;
        Map<String, AbstractExtensionHook> map = s_hooks;
        synchronized (map) {
            String string = elementName.getLocalName();
            abstractExtensionHook = s_hooks.get(string);
            if (abstractExtensionHook == null && Ide.isRunning()) {
                try {
                    abstractExtensionHook = (AbstractExtensionHook)clazz.newInstance();
                    abstractExtensionHook.setElementName(elementName);
                    s_hooks.put(string, abstractExtensionHook);
                }
                catch (Throwable throwable) {
                    DBLog.getLogger(clazz).log(Level.SEVERE, "Couldn't get hook " + string + " from the extension registry.", throwable);
                }
            }
        }
        return (T)abstractExtensionHook;
    }

    private class HashProcessorList
    extends AbstractList<HashThunk>
    implements HashProcessor {
        private final List<HashThunk> m_list = new ArrayList<HashThunk>();
        private final String m_listName;
        private final String m_name;
        private final Class m_clz;

        HashProcessorList(String string, String string2, Class clazz) {
            this.m_listName = string;
            this.m_name = string2;
            this.m_clz = clazz;
        }

        @Override
        public void process(HashStructure hashStructure) {
            AbstractExtensionHook.this.populateObjectList(this.m_list, hashStructure, this.m_listName, this.m_name, this.m_clz);
        }

        @Override
        public HashThunk get(int n) {
            AbstractExtensionHook.this.checkListenerInit();
            return this.m_list.get(n);
        }

        @Override
        public int size() {
            AbstractExtensionHook.this.checkListenerInit();
            return this.m_list.size();
        }
    }

    private class HashProcessorMap
    extends AbstractMap<String, Thunk>
    implements HashProcessor {
        private final Map<String, Thunk> m_map = new HashMap<String, Thunk>();
        private final String m_listName;
        private final String m_listElemName;
        private final String m_idElemName;
        private final String m_clzElemName;
        private final Class m_clz;

        HashProcessorMap(String string, String string2, String string3, String string4, Class clazz) {
            this.m_listName = string;
            this.m_listElemName = string2;
            this.m_idElemName = string3;
            this.m_clzElemName = string4;
            this.m_clz = clazz;
        }

        @Override
        public Set<Map.Entry<String, Thunk>> entrySet() {
            AbstractExtensionHook.this.checkListenerInit();
            return this.m_map.entrySet();
        }

        @Override
        public void process(HashStructure hashStructure) {
            AbstractExtensionHook.this.populateObjectMap(this.m_map, hashStructure, this.m_listName, this.m_listElemName, this.m_idElemName, this.m_clzElemName, this.m_clz);
        }
    }

    private static interface HashProcessor {
        public void process(HashStructure var1);
    }

    private class HashThunk<T>
    extends Thunk<T> {
        private HashStructure m_hash;
        private String m_clzName;
        private Class<T> m_clz;

        HashThunk(HashStructure hashStructure, Class<T> clazz) {
            this.m_hash = hashStructure;
            this.m_clzName = HashStructureHook.getText((HashStructure)hashStructure);
            this.m_clz = clazz;
        }

        protected T compute() {
            return AbstractExtensionHook.this.instantiateClass(this.m_hash, this.m_clz);
        }
    }

    private class HashClassThunk<T>
    extends Thunk<Class<? extends T>> {
        private HashStructure m_hash;
        private Class<T> m_clz;

        HashClassThunk(HashStructure hashStructure, Class<T> clazz) {
            this.m_hash = hashStructure;
            this.m_clz = clazz;
        }

        protected Class<? extends T> compute() {
            return AbstractExtensionHook.this.loadClass(this.m_hash, this.m_clz);
        }
    }
}

