/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive;

import java.awt.Component;
import java.util.Collections;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.util.SchemaObjectBuilder;
import oracle.ide.model.Element;
import oracle.ideimpl.db.hive.resource.HiveUIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class HiveExternalTableController
implements Controller {
    private static final String COMMAND = "oracle.ide.db.hive.NewOracleExternalTable";

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (this.isCommand(ideAction)) {
            DBObject dBObject;
            bl = true;
            DBObjectNode dBObjectNode = HiveExternalTableController.getHiveTableNode(context);
            if (dBObjectNode != null && (dBObject = dBObjectNode.getDBObject()) instanceof Table) {
                DBObjectProvider dBObjectProvider = dBObjectNode.getProvider();
                DBObjectProviderPicker.PickerConfiguration pickerConfiguration = new DBObjectProviderPicker.PickerConfiguration();
                pickerConfiguration.setProviderTypes(dBObjectProvider.getProviderType());
                pickerConfiguration.setContext(context);
                pickerConfiguration.setDatabaseTypes("Oracle Database");
                pickerConfiguration.setPickerValidator(new DBObjectProviderPicker.PickerValidator(){

                    @Override
                    public void validateProvider(DBObjectProvider dBObjectProvider) throws DBException {
                        DatabaseDescriptor databaseDescriptor;
                        boolean bl = false;
                        if (dBObjectProvider != null && (databaseDescriptor = dBObjectProvider.getDescriptor()).getDatabaseType().equals("Oracle Database") && databaseDescriptor.getDatabaseVersion() >= 1210) {
                            bl = true;
                        }
                        if (!bl) {
                            throw new DBException(null, HiveUIBundle.get("EXTTAB_ORA_TOO_OLD"));
                        }
                    }
                });
                DBObjectProvider dBObjectProvider2 = DBObjectProviderPicker.chooseProvider(pickerConfiguration, (Component)Ide.getMainWindow(), DBTypeDisplayRegistry.getDialogTitle("TABLE", false, false), HiveUIBundle.get("EXTTAB_CONN_TEXT"), null);
                if (dBObjectProvider2 != null) {
                    Table table;
                    try {
                        table = this.createOracleTable((Table)dBObject, dBObjectProvider, dBObjectProvider2);
                    }
                    catch (CancelledException cancelledException) {
                        table = null;
                    }
                    catch (DBException dBException) {
                        DBExceptionDialog.showErrorDialog((Component)Ide.getMainWindow(), HiveUIBundle.get("EXTTAB_CONN_ERR_TITLE"), dBException);
                        table = null;
                    }
                    if (table != null) {
                        DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig(dBObjectProvider2, (DBObject)table);
                        dBEditorConfig.setChildObject((DBObject)table.getColumns()[0]);
                        DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(dBEditorConfig);
                        if (dBEditorFactory != null) {
                            dBEditorFactory.launchDialog(dBEditorConfig);
                        }
                    }
                }
            }
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (this.isCommand(ideAction)) {
            bl = true;
            ideAction.setEnabled(HiveExternalTableController.getHiveTableNode(context) != null);
        }
        return bl;
    }

    private boolean isCommand(IdeAction ideAction) {
        IdeAction ideAction2 = HiveExternalTableController.getAction();
        return ideAction2 != null && ideAction.getCommandId() == ideAction2.getCommandId();
    }

    private Table createOracleTable(Table table, DBObjectProvider dBObjectProvider, DBObjectProvider dBObjectProvider2) throws DBException {
        SchemaObjectBuilder schemaObjectBuilder = new SchemaObjectBuilder(true);
        schemaObjectBuilder.setProperties("TABLE", "columns");
        schemaObjectBuilder.ensureObjectBuiltEx(new DBObject[]{table});
        String string = table.getName();
        Schema schema = dBObjectProvider2.getDefaultSchema();
        Table table2 = new Table();
        table2.setSchema(schema);
        table2.setName(dBObjectProvider2.getUniqueName("TABLE", (DBObject)schema, this.convertName(string, "TABLE", dBObjectProvider, dBObjectProvider2)));
        table2.setProperty("TableType", (Object)Table.TableType.EXTERNAL);
        DBObjectFactory dBObjectFactory = dBObjectProvider2.getObjectFactory();
        OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)dBObjectFactory.newObject(OracleExternalTableProperties.class, (DBObject)table2);
        table2.setProperty("OracleExternalTableProperties", (Object)oracleExternalTableProperties);
        oracleExternalTableProperties.setAccessDriverType("ORACLE_HIVE");
        BigDataAccessParameters bigDataAccessParameters = (BigDataAccessParameters)dBObjectFactory.newObject(BigDataAccessParameters.class, (DBObject)oracleExternalTableProperties);
        BigDataAccessParameter bigDataAccessParameter = (BigDataAccessParameter)dBObjectFactory.newObject(BigDataAccessParameter.class, (DBObject)bigDataAccessParameters);
        bigDataAccessParameter.setName("com.oracle.bigdata.tablename");
        bigDataAccessParameter.setParameterValue(DBUtil.getFullyQualifiedName((DBObject)table, (boolean)true));
        bigDataAccessParameters.setBigDataAccessParameters(new BigDataAccessParameter[]{bigDataAccessParameter});
        oracleExternalTableProperties.setAccessParameters(bigDataAccessParameters.getSQLText());
        oracleExternalTableProperties.setAccessParametersFragment((SQLFragment)bigDataAccessParameters);
        Column[] columnArray = table.getColumns();
        Column[] columnArray2 = new Column[columnArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = new Column();
            column.setName(this.convertName(columnArray[i].getName(), "COLUMN", dBObjectProvider, dBObjectProvider2));
            column.setDataTypeUsage(this.mapDTU(columnArray[i].getDataTypeUsage(), dBObjectProvider2));
            columnArray2[i] = column;
        }
        table2.setColumns(columnArray2);
        TemporaryObjectID.setID((DBObject)table2, (boolean)true);
        return table2;
    }

    private String convertName(String string, String string2, DBObjectProvider dBObjectProvider, DBObjectProvider dBObjectProvider2) {
        return dBObjectProvider2.getInternalName(dBObjectProvider.getExternalName(string, string2), string2);
    }

    private DataTypeUsage mapDTU(DataTypeUsage dataTypeUsage, DBObjectProvider dBObjectProvider) {
        String string = null;
        Map map = null;
        String string2 = DBUtil.getDBObjectName((DBObjectID)dataTypeUsage.getDataTypeID());
        if (ModelUtil.hasLength((String)string2)) {
            if ("DATE".equals(string2) || "TIMESTAMP".equals(string2)) {
                string = string2;
            } else if ("INT".equals(string2) || "SMALLINT".equals(string2) || "BIGINT".equals(string2) || "TINYINT".equals(string2) || "BOOLEAN".equals(string2) || "DECIMAL".equals(string2)) {
                string = "NUMBER";
            } else if ("BINARY".equals(string2)) {
                string = "RAW";
                map = Collections.singletonMap("size", 4000L);
            } else if ("FLOAT".equals(string2)) {
                string = "BINARY_FLOAT";
            } else if ("DOUBLE".equals(string2)) {
                string = "BINARY_DOUBLE";
            } else if ("VARCHAR".equals(string2)) {
                string = "VARCHAR2";
                map = dataTypeUsage.getAttributeValues();
            }
        }
        if (string == null) {
            string = "VARCHAR2";
            map = Collections.singletonMap("size", 4000L);
        }
        DataType dataType = dBObjectProvider.getDataType(string);
        return map == null ? dataType.createDefaultUsage() : dataType.createUsage(map);
    }

    static IdeAction getAction() {
        return IdeAction.find((String)COMMAND);
    }

    static DBObjectNode getHiveTableNode(Context context) {
        DBObjectProvider dBObjectProvider;
        String string;
        Element element;
        DBObjectNode dBObjectNode = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1 && (element = elementArray[0]) instanceof DBObjectNode && "TABLE".equals(string = DBObjectNodeUtil.normalizeType(((DBObjectNode)element).getObjectType())) && (dBObjectProvider = DBObjectNodeUtil.findProvider(element)) != null && "Hive".equals(dBObjectProvider.getDescriptor().getDatabaseType())) {
            dBObjectNode = (DBObjectNode)element;
        }
        return dBObjectNode;
    }
}

