/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBLog;
import oracle.javatools.ui.Header;

public class GeneralPanel
implements DBTraversable {
    private List<Traversable> m_travs = new ArrayList<Traversable>();
    private final JPanel m_panel;
    private final DBUILayoutHelper m_layout;
    private JScrollPane m_scrollPane;
    private boolean m_layoutDone;

    public GeneralPanel(Traversable traversable, List<Navigable> list) {
        if (traversable != null) {
            this.m_travs.add(traversable);
        }
        if (list != null) {
            for (Navigable navigable : list) {
                Traversable traversable2 = navigable.newTraversable(null);
                if (traversable2 == null) continue;
                this.m_travs.add(traversable2);
            }
        }
        this.m_panel = new JPanel();
        this.m_panel.setName("GeneralPanel");
        this.m_layout = new DBUILayoutHelper(this.m_panel, true);
        this.m_scrollPane = DBUILayoutHelper.createFlatScrollPane(this.m_panel);
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.m_travs != null) {
            for (Traversable traversable : this.m_travs) {
                try {
                    traversable.onEntry(traversableContext);
                }
                catch (Exception exception) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Error entering sub-panel", exception);
                }
            }
        }
        if (!this.m_layoutDone) {
            Traversable traversable;
            this.m_layoutDone = true;
            String string = ((DBEditorConfig)traversableContext.find(DBEditorConfig.class)).getObjectType();
            traversable = new Header();
            traversable.setLevel(Header.Level.PAGE);
            traversable.setText(DBTypeDisplayRegistry.getSingularDisplayName(string));
            traversable.setIcon(DBTypeDisplayRegistry.getNodeIcon(string));
            this.m_layout.add((Component)traversable, 2, 1, false, false);
            this.m_layout.nextRow();
            for (Traversable traversable2 : this.m_travs) {
                if (traversable2 instanceof ChildTableEditorPanel) {
                    this.m_layout.add(traversable2.getComponent(), 2, 1, true, true);
                } else {
                    this.m_layout.addChildren(traversable2.getComponent(), new Integer[0]);
                }
                this.m_layout.nextRowWithGap();
            }
            this.m_layout.pushUp();
            this.m_layout.layout();
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        TraversalException traversalException = null;
        if (this.m_travs != null) {
            for (Traversable traversable : this.m_travs) {
                try {
                    traversable.onExit(traversableContext);
                }
                catch (TraversalException traversalException2) {
                    traversalException = traversalException2;
                }
                catch (Exception exception) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Error exiting sub-panel", exception);
                }
            }
        }
        if (traversalException != null) {
            throw traversalException;
        }
    }

    public Component getComponent() {
        return this.m_scrollPane;
    }

    public String getHelpID() {
        return null;
    }

    @Override
    public Component getDefaultFocusComponent() {
        Component component = null;
        for (Traversable traversable : this.m_travs) {
            if (traversable instanceof DBTraversable && (component = ((DBTraversable)traversable).getDefaultFocusComponent()) != null) break;
        }
        return component;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        Traversable traversable;
        boolean bl = false;
        Iterator<Traversable> iterator = this.m_travs.iterator();
        while (!(!iterator.hasNext() || (traversable = iterator.next()) instanceof DBTraversable && (bl = ((DBTraversable)traversable).requestFocusForEditorConfig()))) {
        }
        return bl;
    }
}

