/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectDefineEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;

public class OracleInMemoryPropertiesPanel
extends ChildObjectDefineEditorPanel<OracleInMemoryProperties, DBObject> {
    public OracleInMemoryPropertiesPanel() {
        super("OracleInMemoryPropertiesPanel", null);
        this.setHelpID("f1_odbtainmemory_html");
    }

    @Override
    protected String getPropertyPath() {
        String string = "OracleInMemoryProperties";
        if (this.getUpdatedObject() instanceof Tablespace) {
            string = Property.createPath((String[])new String[]{"OracleTablespaceProperties", string});
        }
        return string;
    }

    @Override
    protected void initialiseChildComponents(DBUILayoutHelper dBUILayoutHelper) {
        DBObject dBObject = this.getComponentFactoryUpdatedObject();
        boolean bl = dBObject instanceof TablePartition;
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("inMemory");
        dBUILayoutHelper.add(componentWrapper);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.getOrCreateWrapper("inMemoryCompression"));
        if (bl) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(this.getOrCreateWrapper("inMemoryPriority"));
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.getOrCreateWrapper("inMemoryDistribute"));
        if (bl) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(this.getOrCreateWrapper("inMemoryDuplicate"));
        if (bl) {
            dBUILayoutHelper.pushUp();
        }
        componentWrapper.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OracleInMemoryPropertiesPanel.this.checkComponents();
            }
        });
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.checkComponents();
    }

    @Override
    protected String getDefineCheckBoxText() {
        DBObject dBObject = this.getComponentFactoryOriginalObject();
        String string = this.getProvider() instanceof Database && dBObject instanceof Table && Boolean.TRUE.equals(dBObject.getProperty("PARTITIONED TABLE")) ? UIBundle.get("INMEM_EDIT_PARTITIONED_TABLE") : super.getDefineCheckBoxText();
        return string;
    }

    @Override
    protected void enabledChildComponents(boolean bl) {
        super.enabledChildComponents(bl);
        if (bl) {
            this.checkComponents();
        }
    }

    private void checkComponents() {
        if (this.isEnabled() && this.getDefineCheckBox().isSelected()) {
            boolean bl = ((OracleInMemoryProperties)this.getChildObject()).isInMemory();
            this.setWrapperEnabled("inMemoryCompression", bl);
            this.setWrapperEnabled("inMemoryDuplicate", bl);
            this.setWrapperEnabled("inMemoryPriority", bl);
            this.setWrapperEnabled("inMemoryDistribute", bl);
        }
    }

    private void setWrapperEnabled(String string, boolean bl) {
        ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper(this.getComponentPath(string));
        if (componentWrapper != null) {
            componentWrapper.setEnabled(bl);
        }
    }

    @Override
    protected Class<OracleInMemoryProperties> getChildClass() {
        return OracleInMemoryProperties.class;
    }

    @Override
    protected Dimension getDialogInitialSize() {
        return new Dimension(400, 400);
    }
}

