/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.partition.PartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.util.ModelUtil;

class PartitionSetDetailsPanel
extends PartitionDetailsPanel {
    private final JCheckBox m_check = new JCheckBox();
    private final PropertyChangeListener m_pcl;

    PartitionSetDetailsPanel(ActionListener actionListener, PropertyChangeListener propertyChangeListener) {
        super(PartitionProperty.PARTITIONS);
        this.m_check.addActionListener(actionListener);
        this.m_pcl = propertyChangeListener;
    }

    @Override
    protected void initialiseChildComponents() {
        this.getComponentFactory().getResourceHelper().resButton(this.m_check, UIBundle.get("PART_SUBPART_TEMPLATE"), "SubPartitionTemplateCheck");
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add(this.m_check, 2, 1, true, false);
        dBUILayoutHelper.nextRowWithGap();
        this.initialiseChildComponentsImpl(dBUILayoutHelper);
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
        if (this.m_pcl != null) {
            ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper("name");
            componentWrapper.addListener(this.m_pcl);
            ComponentWrapper componentWrapper2 = this.getComponentFactory().findComponentWrapper("values");
            componentWrapper2.addListener(this.m_pcl);
        }
    }

    @Override
    protected void initialisePanel() {
        Integer n;
        super.initialisePanel();
        TablePartition tablePartition = (TablePartition)this.getChildObject();
        OracleTablePartitions.ObjectType objectType = tablePartition == null ? null : tablePartition.getObjectType();
        PropertyHelper propertyHelper = this.getPropertyHelper();
        Object t = this.getUpdatedObject();
        this.enableWrappers();
        Object[] objectArray = (TablePartition[])propertyHelper.getPropertyValue(t, PartitionProperty.SUBPARTITIONS_FOR_TABLE);
        boolean bl = ModelUtil.hasNonNullElement((Object[])objectArray);
        if (!bl) {
            n = (Integer)propertyHelper.getPropertyValue(t, PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY);
            bl = n != null;
        }
        n = (OracleTablePartitions)propertyHelper.getPropertyValue(t, PartitionProperty.SUBPARTITIONING_FOR_TABLE);
        boolean bl2 = tablePartition != null && objectType == OracleTablePartitions.ObjectType.PARTITIONSET && n != null;
        boolean bl3 = false;
        if (bl2 && bl) {
            OracleTablePartitions oracleTablePartitions = tablePartition.getPartitionLevelSubpartitions();
            TablePartition[] tablePartitionArray = oracleTablePartitions == null ? null : oracleTablePartitions.getPartitions();
            boolean bl4 = bl3 = oracleTablePartitions == null || tablePartitionArray == null || tablePartitionArray.length == 0;
            if (bl3 && oracleTablePartitions != null && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH && oracleTablePartitions.getHashQuantity() != null) {
                bl3 = false;
            }
        }
        this.m_check.setVisible(bl2);
        this.m_check.setEnabled(bl);
        this.m_check.setSelected(!bl3);
    }

    private TablePartition enableWrappers() {
        TablePartition tablePartition = (TablePartition)this.getChildObject();
        boolean bl = tablePartition == null || tablePartition.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE;
        this.enableWrapper("name", bl);
        this.enableValuesWrapper(bl);
        this.enableWrapper(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), bl);
        this.enableWrapper("OracleInMemoryProperties", bl);
        this.enableWrapper("segmentAttributes", bl);
        this.enableLobWrapper(bl);
        return tablePartition;
    }

    private void enableWrapper(String string, boolean bl) {
        ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper(string);
        if (componentWrapper != null) {
            componentWrapper.setEnabled(bl);
        }
    }

    @Override
    protected void refreshComponents() {
        TablePartition tablePartition = (TablePartition)this.getChildObject();
        String string = PartitionProperty.PARTITIONS;
        if (tablePartition != null && tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITIONSET_LEVEL_SUBPARTITION_TEMPLATE) {
            string = PartitionProperty.SUBPARTITIONS_FOR_TABLE;
        }
        this.getComponentFactory().setBasePath(string);
        super.refreshComponents();
    }
}

