/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.FunctionComboBox;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class ExpressionPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
KeyListener,
TreeSelectionListener,
FocusListener {
    public static final String EMPTY = "<" + UIBundle.get("EMPTY") + ">";
    private TreeNodeMaker m_nodeMaker = new TreeNodeMaker(false);
    private DBObjectProvider m_dboPro;
    private FragmentProvider m_fragPro;
    private SQLFragment m_current;
    private boolean m_ignoreList;
    private boolean m_entered;
    private JSplitPane m_expPanel;
    private JPanel m_templPanel;
    private DefaultMutableTreeNode m_top;
    private DefaultTreeModel m_templModel;
    private JTree m_templates;
    private FunctionComboBox m_functions;
    private JButton m_insertTemplate;
    private JButton m_insertFunction;
    private JLabel m_templateLabel;
    private JPanel m_listPanel;
    private DefaultListModel m_expressionsModel = new DefaultListModel();
    private JList m_expressions = new JList(this.m_expressionsModel);
    private final DBUIResourceHelper m_reshelp;
    private ListButtons m_listButtons;
    protected static final Dimension BUTTON_SIZE = new Dimension(28, 25);
    protected static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    public ExpressionPanel(FragmentProvider fragmentProvider) {
        this.m_fragPro = fragmentProvider;
        this.m_reshelp = new DBUIResourceHelper(fragmentProvider.getComponentNamePrefix() + ".ExpPanel");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridLayout(2, 1, 0, 5));
        this.createListPanel();
        this.add(this.m_listPanel);
        this.createExpressionPanel();
        this.add(this.m_expPanel);
    }

    private void createListPanel() {
        this.m_listPanel = new JPanel();
        this.m_listPanel.setLayout(new GridBagLayout());
        this.m_expressions.setSelectionMode(2);
        this.m_expressions.setCellRenderer(new DBObjectRenderer(false));
        this.m_expressions.addListSelectionListener(this);
        this.m_expressions.addKeyListener(this);
        this.m_reshelp.resLabel(new JLabel(), this.m_expressions, this.m_fragPro.getListTitle(), "Expressions");
        this.m_listButtons = new ListButtons(this.m_expressions, (ListButtons.Controller)new ExpressionsButtonHelper());
        this.m_listPanel.add((Component)this.m_listButtons.getComponent(), new GridBagConstraints(1, 2, 1, 4, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void createExpressionPanel() {
        this.m_templPanel = new JPanel();
        this.m_templPanel.setLayout(new GridBagLayout());
        this.m_expPanel = new JSplitPane(1, this.m_fragPro.getEditorUI(), this.m_templPanel);
        this.m_expPanel.setBorder(BorderFactory.createTitledBorder(this.m_fragPro.getEditorName()));
    }

    private void addTemplateBits() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.m_templateLabel = new JLabel();
        this.m_top = new DefaultMutableTreeNode("PICKER");
        this.m_templModel = new DefaultTreeModel(this.m_top);
        this.m_templates = new JTree(this.m_templModel);
        this.m_templates.setRootVisible(false);
        this.m_templates.setShowsRootHandles(true);
        this.m_templates.setEditable(false);
        this.m_templates.setExpandsSelectedPaths(true);
        this.m_templates.setCellRenderer(new DBObjectRenderer(true));
        this.m_templates.addMouseListener(this);
        this.m_templates.addTreeSelectionListener(this);
        this.m_templates.getSelectionModel().setSelectionMode(1);
        this.m_templates.setScrollsOnExpand(true);
        this.m_templates.addFocusListener(this);
        toolTipManager.registerComponent(this.m_templates);
        this.m_reshelp.resLabel(this.m_templateLabel, this.m_templates, this.m_fragPro.getTemplateTitle(), "Templates");
        this.m_templPanel.add((Component)this.m_templateLabel, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.m_insertTemplate = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
        DBObjectRenderer.setToolTipText(this.m_insertTemplate, UIBundle.get("EXP_ADD_COLUMN_TT"));
        this.m_insertTemplate.setMnemonic('c');
        toolTipManager.registerComponent(this.m_insertTemplate);
        this.setupButton(this.m_insertTemplate, this, null, EMPTY_INSETS, "InsertTemplate");
        this.m_templPanel.add((Component)this.m_insertTemplate, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_templPanel.add((Component)new JScrollPane(this.m_templates), new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private void addFunctionBits() {
        this.m_insertFunction = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
        DBObjectRenderer.setToolTipText(this.m_insertFunction, UIBundle.get("EXP_ADD_FUNC_TT"));
        this.m_insertFunction.setMnemonic('t');
        ToolTipManager.sharedInstance().registerComponent(this.m_insertFunction);
        this.setupButton(this.m_insertFunction, this, null, EMPTY_INSETS, "InsertFunction");
        this.m_templPanel.add((Component)this.m_insertFunction, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_functions = new FunctionComboBox();
        this.m_reshelp.setName(this.m_functions, "Functions");
        this.m_templPanel.add((Component)this.m_functions, new GridBagConstraints(3, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
    }

    protected void initExpression() {
        Object e = this.m_expressions.getSelectedValue();
        this.m_current = null;
        if (e instanceof SQLFragment) {
            this.m_current = (SQLFragment)e;
        }
        this.m_fragPro.edit(this.m_current);
    }

    public SQLFragment[] getExpressions() {
        int n = this.m_expressionsModel.getSize();
        SQLFragment[] sQLFragmentArray = new SQLFragment[n];
        for (int i = 0; i < n; ++i) {
            sQLFragmentArray[i] = (SQLFragment)this.m_expressionsModel.getElementAt(i);
        }
        return sQLFragmentArray;
    }

    public SQLFragment getCurrentExpression() {
        return this.m_current;
    }

    public void setCurrentExpression(SQLFragment sQLFragment) {
        int n = this.m_expressionsModel.indexOf(this.m_current);
        this.m_current = sQLFragment;
        this.m_expressionsModel.setElementAt(sQLFragment, n);
    }

    public void addFunction(Object object) {
        if (this.m_functions == null) {
            this.addFunctionBits();
        }
        this.m_functions.addItem(object);
    }

    public void addFunctions(List<BuiltInFunction> list) {
        if (this.m_functions == null) {
            this.addFunctionBits();
        }
        this.m_functions.removeAllItems();
        HashSet<String> hashSet = new HashSet<String>();
        for (BuiltInFunction object2 : list) {
            hashSet.add(object2.getSignature(false));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.m_functions.addItem(string);
        }
    }

    public void addTemplate(SQLFragment sQLFragment, boolean bl) {
        if (this.m_templates == null) {
            this.addTemplateBits();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.m_nodeMaker.createTreeNode(sQLFragment, bl);
        this.m_templModel.insertNodeInto(defaultMutableTreeNode, this.m_top, this.m_top.getChildCount());
    }

    public void clearTemplates() {
        if (this.m_templModel != null) {
            this.m_top.removeAllChildren();
            this.m_templModel.reload();
        }
    }

    public void setDBObjectProvider(DBObjectProvider dBObjectProvider) {
        this.m_dboPro = dBObjectProvider;
    }

    private void addToExpression(SQLFragment sQLFragment) {
        String string = sQLFragment.getSQLText();
        this.m_fragPro.addToExpression(string);
    }

    private void addToExpression(Relation relation) {
        this.m_fragPro.addToExpression(relation.getName());
    }

    void showInvalidExpressionDialog(TraversalException traversalException) {
        MessageDialog.error((Component)this, (Object)traversalException.getMessage(), (String)UIBundle.get("EXP_INVALID_EXPRESSION"), null);
    }

    public void entered(SQLFragment[] sQLFragmentArray, SQLFragment sQLFragment) {
        int n;
        this.m_expressionsModel.removeAllElements();
        for (n = 0; sQLFragmentArray != null && n < sQLFragmentArray.length; ++n) {
            this.m_expressionsModel.addElement(sQLFragmentArray[n]);
        }
        if (this.m_templModel != null) {
            this.m_templModel.reload();
        }
        if (this.m_expressionsModel.size() > 0) {
            n = this.m_expressionsModel.indexOf(sQLFragment);
            if (n < 0) {
                n = 0;
            }
            this.m_expressions.setSelectedIndex(n);
            this.initExpression();
        }
        this.m_listButtons.enableButtons();
        this.enableButtons();
        this.m_expPanel.setDividerLocation(250);
        this.m_entered = true;
    }

    public void exited() throws TraversalException {
        this.m_fragPro.commit();
        this.m_entered = false;
        this.m_current = null;
    }

    protected void enableButtons() {
        boolean bl;
        int[] nArray = this.m_expressions.getSelectedIndices();
        boolean bl2 = bl = nArray != null && nArray.length == 1;
        if (this.m_templates != null) {
            this.m_templateLabel.setEnabled(bl);
            this.m_templates.setEnabled(bl);
            this.m_insertTemplate.setEnabled(bl);
        }
        if (this.m_functions != null) {
            this.m_functions.setEnabled(bl);
            this.m_insertFunction.setEnabled(bl);
        }
    }

    protected void newExpression() {
        try {
            this.m_fragPro.commit();
            this.m_current = this.m_fragPro.newFragment();
            this.m_ignoreList = true;
            try {
                this.m_expressionsModel.addElement(this.m_current);
                this.m_expressions.setSelectedValue(this.m_current, true);
            }
            finally {
                this.m_ignoreList = false;
            }
        }
        catch (TraversalException traversalException) {
            this.showInvalidExpressionDialog(traversalException);
        }
        this.enableButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSelectedExpressions() {
        int n = this.m_expressions.getSelectedIndex();
        Object[] objectArray = this.m_expressions.getSelectedValues();
        if (objectArray != null && objectArray.length > 0) {
            this.m_ignoreList = true;
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != EMPTY && !this.m_fragPro.removeFragment((SQLFragment)objectArray[i])) continue;
                    this.m_expressionsModel.removeElement(objectArray[i]);
                    int n2 = this.m_expressionsModel.size() - 1;
                    this.m_expressions.setSelectedIndex(n > n2 ? n2 : n);
                }
            }
            finally {
                this.m_ignoreList = false;
            }
            this.initExpression();
            this.enableButtons();
        }
    }

    private void insertCurrentTemplate() {
        Object object;
        TreePath treePath;
        if (this.m_templates != null && (treePath = this.m_templates.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != null && ((DefaultMutableTreeNode)object).isLeaf()) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof SQLFragment) {
                this.addToExpression((SQLFragment)object2);
            } else if (object2 instanceof Relation) {
                String string = ((Relation)object2).getName();
                if (this.m_dboPro != null) {
                    string = this.m_dboPro.getExternalName(string);
                }
                this.m_fragPro.addToExpression(string);
            } else if (object2 instanceof Column) {
                Object object3;
                Object object4;
                FastStringBuffer fastStringBuffer = new FastStringBuffer();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent();
                Object object5 = object4 = defaultMutableTreeNode == null ? null : defaultMutableTreeNode.getUserObject();
                if (object4 != null && object4 instanceof FromObject) {
                    fastStringBuffer.append(((FromObject)object4).getName());
                    fastStringBuffer.append(".");
                } else {
                    object3 = ((Column)object2).getRelation();
                    if (object3 != null) {
                        String string = ((Relation)object2).getName();
                        if (this.m_dboPro != null) {
                            string = this.m_dboPro.getExternalName(string);
                        }
                        fastStringBuffer.append(string).append(".");
                    }
                }
                object3 = ((Column)object2).getName();
                if (this.m_dboPro != null) {
                    object3 = this.m_dboPro.getExternalName((String)object3);
                }
                fastStringBuffer.append((String)object3);
                this.m_fragPro.addToExpression(fastStringBuffer.toString());
            }
        }
    }

    private void insertCurrentFunction() {
        Object object = this.m_functions.getSelectedItem();
        String string = null;
        string = object instanceof SQLFragment ? ((SQLFragment)object).getSQLText() : object.toString();
        if (ModelUtil.hasLength((String)string)) {
            this.m_fragPro.addToExpression(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_insertFunction) {
            this.insertCurrentFunction();
        } else if (object == this.m_insertTemplate) {
            this.insertCurrentTemplate();
        }
    }

    public void hideTemplatePanel(boolean bl) {
        if (this.m_insertTemplate != null) {
            this.m_insertTemplate.setEnabled(!bl);
        }
        if (this.m_insertFunction != null) {
            this.m_insertFunction.setEnabled(!bl);
        }
        if (this.m_templates != null) {
            this.m_templates.setEnabled(!bl);
        }
        if (this.m_functions != null) {
            this.m_functions.setEnabled(!bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.m_entered && !this.m_ignoreList && listSelectionEvent.getSource() == this.m_expressions) {
            Object e = this.m_expressions.getSelectedValue();
            try {
                if (e != this.m_current && (e != EMPTY || this.m_current != null)) {
                    int n = this.m_expressionsModel.indexOf(this.m_current);
                    this.m_fragPro.commit();
                    this.initExpression();
                }
            }
            catch (TraversalException traversalException) {
                this.showInvalidExpressionDialog(traversalException);
                this.m_ignoreList = true;
                try {
                    this.m_expressions.setSelectedValue(this.m_current == null ? EMPTY : this.m_current, false);
                }
                finally {
                    this.m_ignoreList = false;
                }
            }
            this.enableButtons();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (mouseEvent.getClickCount() % 2 == 0 && object == this.m_templates && this.m_templates.isEnabled()) {
            this.insertCurrentTemplate();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.m_expressions) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 127: {
                    this.removeSelectedExpressions();
                    break;
                }
                case 155: {
                    this.newExpression();
                    break;
                }
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        this.m_templates.scrollPathToVisible(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.m_insertTemplate.setEnabled(defaultMutableTreeNode.isLeaf());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        int[] nArray;
        if (focusEvent.getComponent() == this.m_templates && (nArray = this.m_templates.getSelectionRows()) == null) {
            this.m_templates.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private void setupButton(JButton jButton, ActionListener actionListener, Dimension dimension, Insets insets, String string) {
        ExpressionPanel.setupButton(jButton, actionListener, dimension, insets);
        this.m_reshelp.setName(jButton, string);
    }

    protected static void setupButton(JButton jButton, ActionListener actionListener, Dimension dimension, Insets insets) {
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        if (dimension != null) {
            jButton.setMaximumSize(dimension);
            jButton.setMinimumSize(dimension);
            jButton.setPreferredSize(dimension);
        }
        if (insets != null) {
            jButton.setMargin(insets);
        }
    }

    private class ExpressionsButtonHelper
    extends ListButtons.Controller {
        private ExpressionsButtonHelper() {
        }

        @Override
        public void addToList() {
            ExpressionPanel.this.newExpression();
        }

        @Override
        public void removeFromList() {
            ExpressionPanel.this.removeSelectedExpressions();
        }

        @Override
        public boolean canAdd() {
            return true;
        }

        @Override
        public boolean canRemove() {
            boolean bl = false;
            int[] nArray = ExpressionPanel.this.m_expressions.getSelectedIndices();
            if (nArray != null && nArray.length > 0) {
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean canRemove(Object object) {
            return this.canRemove();
        }

        @Override
        public String getBaseName() {
            return ExpressionPanel.this.m_reshelp.getPanelName();
        }

        @Override
        public String getListLabel() {
            return ExpressionPanel.this.m_fragPro.getListTitle();
        }

        @Override
        public boolean useResizeComponent() {
            return false;
        }

        @Override
        public void objectMovedDown(Object object) {
            int n;
            SQLFragment sQLFragment = (SQLFragment)ExpressionPanel.this.m_expressions.getSelectedValue();
            int n2 = ExpressionPanel.this.m_expressions.getSelectedIndex();
            if (n2 <= (n = ExpressionPanel.this.m_expressionsModel.getSize()) - 1) {
                ExpressionPanel.this.m_fragPro.moveFragment(sQLFragment, n2);
            }
        }

        @Override
        public void objectMovedUp(Object object) {
            SQLFragment sQLFragment = (SQLFragment)ExpressionPanel.this.m_expressions.getSelectedValue();
            int n = ExpressionPanel.this.m_expressions.getSelectedIndex();
            if (n >= 0) {
                ExpressionPanel.this.m_fragPro.moveFragment(sQLFragment, n);
            }
        }
    }

    public static interface FragmentProvider {
        public SQLFragment newFragment();

        public boolean removeFragment(SQLFragment var1);

        public void moveFragment(SQLFragment var1, int var2);

        public JPanel getEditorUI();

        public void commit() throws TraversalException;

        public void edit(SQLFragment var1);

        public void addToExpression(String var1);

        public String getEditorName();

        public String getListTitle();

        public String getTemplateTitle();

        public String getComponentNamePrefix();
    }
}

