/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import oracle.dss.gauge.BaseText;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.javatools.annotations.Concealed;

public class BaseLabel
extends BaseText {
    protected int m_defaultPosition = GaugeDefaultValues.getMetricLabelPosition();
    protected String m_positionKey = "MetricLabelPosition";
    @Concealed
    protected static final String lp_none = "LP_NONE";
    @Concealed
    protected static final String lp_belowgauge = "LP_BELOW_GAUGE";
    @Concealed
    protected static final String lp_abovegauge = "LP_ABOVE_GAUGE";
    @Concealed
    protected static final String lp_insidegauge = "LP_INSIDE_GAUGE";
    @Concealed
    protected static final String lp_insidegauge_left = "LP_INSIDE_GAUGE_LEFT";
    @Concealed
    protected static final String lp_insidegauge_right = "LP_INSIDE_GAUGE_RIGHT";
    @Concealed
    protected static final String lp_withbottomlabel = "LP_WITH_BOTTOMLABEL";
    @Concealed
    protected static final String a_none = "none";
    @Concealed
    protected static final String a_belowGauge = "belowGauge";
    @Concealed
    protected static final String a_aboveGauge = "aboveGauge";
    @Concealed
    protected static final String a_insideGauge = "insideGauge";
    @Concealed
    protected static final String a_insideGaugeLeft = "insideGaugeLeft";
    @Concealed
    protected static final String a_insideGaugeRight = "insideGaugeRight";
    @Concealed
    protected static final String a_withBottomLabel = "withBottomLabel";

    public BaseLabel(CommonGauge gauge, int compType) {
        super(gauge, compType);
    }

    public int getPosition() {
        Object obj = this.m_commonGauge.getAttribute(this.m_positionKey);
        if (obj == null) {
            return this.m_defaultPosition;
        }
        return (Integer)obj;
    }

    public void setPosition(int position) {
        if (position < 0 || position > 6) {
            this.m_commonGauge.getErrorHandler().log("invalid position", this.getClass().getName(), "setPosition");
            return;
        }
        this.m_commonGauge.setAttribute(this.m_positionKey, new Integer(position));
    }

    @Concealed
    public static int convertLabelPositionToInt(String position) {
        int iPosition = 2;
        if (position.equals(lp_belowgauge) || position.equalsIgnoreCase(a_belowGauge)) {
            iPosition = 1;
        } else if (position.equals(lp_abovegauge) || position.equalsIgnoreCase(a_aboveGauge)) {
            iPosition = 3;
        } else if (position.equals(lp_insidegauge) || position.equalsIgnoreCase(a_insideGauge)) {
            iPosition = 4;
        } else if (position.equals(lp_insidegauge_left) || position.equalsIgnoreCase(a_insideGaugeLeft)) {
            iPosition = 5;
        } else if (position.equals(lp_insidegauge_right) || position.equalsIgnoreCase(a_insideGaugeRight)) {
            iPosition = 6;
        } else if (position.equals(lp_none) || position.equalsIgnoreCase(a_none)) {
            iPosition = 0;
        }
        return iPosition;
    }

    @Concealed
    public static String convertLabelPositionToString(int position) {
        String iPosition = lp_withbottomlabel;
        if (position == 1) {
            iPosition = lp_belowgauge;
        } else if (position == 3) {
            iPosition = lp_abovegauge;
        } else if (position == 4) {
            iPosition = lp_insidegauge;
        } else if (position == 0) {
            iPosition = lp_none;
        } else if (position == 5) {
            iPosition = lp_insidegauge_left;
        } else if (position == 6) {
            iPosition = lp_insidegauge_right;
        }
        return iPosition;
    }
}

