/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import oracle.dss.dataView.LocalDataSource;
import oracle.dss.dataView.ModelAdapter;
import oracle.dss.gauge.Gauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeModel;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.TypeNotSupportedException;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GaugeModelAdapter
extends ModelAdapter
implements GaugeModel {
    private static final long serialVersionUID = 1L;
    protected Gauge m_gaugeView;
    private static final String m_method_setsupporteddatalayerflags = "setSupportedDataLayerFlags ()";

    public GaugeModelAdapter(Gauge gaugeView) {
        this.m_gaugeView = gaugeView;
        this.initDefaults(new GaugeDefaultValues());
    }

    public GaugeModelAdapter(Gauge gaugeView, DataSource dataSource) {
        super.setDataSource(dataSource);
        this.m_gaugeView = gaugeView;
        this.initDefaults(new GaugeDefaultValues());
    }

    protected void initDefaults(GaugeDefaultValues gdv) {
        super.initDefaults(gdv);
    }

    @Override
    public void setDataSource(DataSource ds) {
        if (ds == null) {
            super.setDataSource(new LocalDataSource());
        } else {
            super.setDataSource(ds);
        }
        if (this.dataDirectorFactory != null) {
            this.setDataDirector((DataDirector)this.dataDirectorFactory.createCubeDataDirector());
        }
    }

    @Override
    protected void setSupportedDataLayerFlags() {
        DataMap dataMap = this.getDataDirector().getSupportedDataMap();
        MetadataMap metaMap = this.getDataDirector().getSupportedMetadataMap();
        LayerMetadataMap layerMap = this.getDataDirector().getSupportedLayerMetadataMap();
        boolean typeSupported = false;
        if (dataMap == null) {
            this.m_gaugeView.getErrorHandler().trace("Current DataSource has a null DataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (metaMap == null) {
            this.m_gaugeView.getErrorHandler().trace("Current DataSource has a null MetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (layerMap == null) {
            this.m_gaugeView.getErrorHandler().trace("Current DataSource has a null LayerMetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (!(typeSupported = dataMap != null ? dataMap.contains((Object)"dataValue") : false)) {
            this.m_gaugeView.getErrorHandler().error((Throwable)new TypeNotSupportedException("DataMap", "DATA_UNFORMATTED"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.m_gaugeView.setDataUnformattedSupported(true);
        typeSupported = metaMap != null ? metaMap.contains((Object)"label") : false;
        if (!typeSupported) {
            this.m_gaugeView.getErrorHandler().error((Throwable)new TypeNotSupportedException("MetadataMap", "METADATA_LONGLABEL"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.m_gaugeView.setMetadataLongLabelSupported(true);
        if (metaMap != null) {
            typeSupported = metaMap.contains((Object)"drillState");
        }
        this.m_gaugeView.setMetadataDrillSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"mediumName") : false;
        this.m_gaugeView.setMetadataMediumLabelSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"shortName") : false;
        this.m_gaugeView.setMetadataShortLabelSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"viewStyle") : false;
        this.m_gaugeView.setMetadataViewStyleSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"date") : false;
        this.m_gaugeView.setMetadataDateSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"drillParentDate") : false;
        this.m_gaugeView.setMetadataDrillParentDateSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"drillParentDateSpan") : false;
        this.m_gaugeView.setMetadataDrillParentDateSpanSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"dateSpan") : false;
        this.m_gaugeView.setMetadataDateSpanSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"value") : false;
        this.m_gaugeView.setMetadataValueSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimShortName") : false;
        this.m_gaugeView.setLayerMetaShortLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimMediumName") : false;
        this.m_gaugeView.setLayerMetaMediumLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"layerLabel") : false;
        this.m_gaugeView.setLayerMetaLongLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"layerName") : false;
        this.m_gaugeView.setLayerMetaNameSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"viewStyle") : false;
        this.m_gaugeView.setLayerMetaViewStyleSupported(typeSupported);
    }

    @Override
    @Concealed
    public DataMap getDataMap() {
        return new DataMap("dataValue");
    }

    @Override
    @Concealed
    public MetadataMap getMetadataMap(int edge) {
        String[] types = new String[]{"label", "mediumName", "shortName", "value"};
        return new MetadataMap(types);
    }

    @Override
    @Concealed
    public LayerMetadataMap getLayerMetadataMap(int edge) {
        String[] types = new String[]{"layerLabel", "dimMediumName", "dimShortName", "layerName"};
        return new LayerMetadataMap(types);
    }

    @Override
    public Gauge getGaugeView() {
        return this.m_gaugeView;
    }
}

