/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Font;
import java.util.HashMap;
import oracle.dss.dataView.DataviewFont;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphFont;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public abstract class BaseText
extends BaseGraphComponent
implements DataviewFontAttribute,
FontAttribute {
    @Concealed
    protected GraphFont m_font;

    @Concealed
    public BaseText(CommonGraph graph) {
        super(graph);
    }

    public GraphFont getGraphFont() {
        if (this.m_font == null) {
            this.m_font = new GraphFont(this.m_commonGraph, this.m_identObj);
        } else {
            this.m_font.setObjectId(this.m_identObj);
        }
        return this.m_font;
    }

    @Override
    public DataviewFont getDataviewFont() {
        return this.getGraphFont();
    }

    @Override
    public void setFont(Font f) {
        this.getGraphFont();
        this.m_font.setFont(f);
    }

    @Override
    public Font getFont() {
        this.getGraphFont();
        return this.m_font.getFont();
    }

    public boolean isFontSizeAbsolute() {
        return this.m_pfj.getFontSizeAbsolute(this.m_identObj);
    }

    public void setFontSizeAbsolute(boolean yesNo) {
        this.m_pfj.setFontSizeAbsolute(this.m_identObj, yesNo);
    }

    @Concealed
    protected void resetStyle() {
        this.m_pfj.setFontSizeAbsolute(this.m_identObj, true);
        if (this.m_font != null) {
            this.m_font.resetStyle();
        }
    }

    @Concealed
    protected GraphFont _getGraphFont() {
        return this.m_font;
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        ObjectNode graphFont;
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getFontSizeAbsoluteObj(this.m_identObj);
        if (val != null) {
            node.addProperty("fontSizeAbsolute", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        if ((graphFont = this.getGraphFont().getStyleXML(allProperties)) != null) {
            node.addProperty(graphFont);
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        ObjectNode graphFont;
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("fontSizeAbsolute");
        if (pNode != null) {
            this.setFontSizeAbsolute(pNode.getValueAsBoolean());
        }
        if ((graphFont = node.getPropertyValueAsObjectNode("GraphFont", true)) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put("GraphFont", map);
                this.getGraphFont().setStyleXML(graphFont, map);
            } else {
                this.getGraphFont().setStyleXML(graphFont);
            }
        }
    }

    @Override
    @Concealed
    public void setNonstyleXML(ObjectNode node) {
        super.setNonstyleXML(node);
        ObjectNode graphFont = node.getPropertyValueAsObjectNode("GraphFont", true);
        if (graphFont != null) {
            this.getGraphFont().setNonstyleXML(graphFont);
        }
    }

    @Concealed
    protected String truncateText(String txt, String[] tokenArray) {
        if (txt.length() <= 1024) {
            return txt;
        }
        int index = 0;
        String maxStr = txt.substring(0, 1024);
        if (tokenArray != null) {
            int lastTokenIndex = -1;
            int tokenLength = 0;
            for (int i = 0; i < tokenArray.length; ++i) {
                String tokenStr = tokenArray[i];
                index = maxStr.lastIndexOf(tokenStr);
                if (index <= lastTokenIndex) continue;
                lastTokenIndex = index;
                tokenLength = tokenStr.length();
            }
            if (lastTokenIndex == -1) {
                if (txt.charAt(1024) != ' ' && (index = maxStr.lastIndexOf(32)) != -1) {
                    maxStr = maxStr.substring(0, index);
                }
            } else if (txt.charAt(1024) != ' ') {
                index = maxStr.lastIndexOf(32);
                maxStr = index != -1 ? (index > lastTokenIndex ? maxStr.substring(0, index) : maxStr.substring(0, lastTokenIndex + tokenLength)) : maxStr.substring(0, lastTokenIndex + tokenLength);
            }
        } else if (txt.charAt(1024) != ' ' && (index = maxStr.lastIndexOf(32)) != -1) {
            maxStr = maxStr.substring(0, index);
        }
        return maxStr;
    }
}

