/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.sql.Date;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dss.dataView.DVTResources;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.javatools.annotations.Concealed;

@Concealed
public class SampleDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    protected double[][] defaultData1 = new double[][]{{42.0, 34.0}, {55.0, 30.0}, {36.0, 50.0}, {22.0, 46.0}, {25.0, 18.0}};
    protected double[][] highLowCloseData = new double[][]{{75.0, 45.0, 55.0, 80.0, 60.0, 68.0, 58.0, 38.0, 48.0, 65.0, 50.0, 55.0, 25.0, 10.0, 18.0}};
    protected double[][] highLowCloseVolumeData = new double[][]{{65.0, 45.0, 40.0, 15000.0, 70.0, 50.0, 53.0, 14000.0, 63.0, 35.0, 45.0, 13000.0, 75.0, 53.0, 60.0, 16000.0, 25.0, 10.0, 15.0, 17000.0}};
    protected double[][] openHiLoCloseData = new double[][]{{47.0, 65.0, 43.0, 51.0, 65.0, 80.0, 55.0, 60.0, 45.0, 45.0, 30.0, 34.0, 75.0, 77.0, 45.0, 71.0, 85.0, 85.0, 65.0, 76.0}};
    protected double[][] openHiLoCloseVolumeData = new double[][]{{37.0, 55.0, 33.0, 53.0, 13000.0, 55.0, 77.0, 45.0, 75.0, 14000.0, 25.0, 50.0, 23.0, 45.0, 15000.0, 65.0, 87.0, 55.0, 85.0, 11000.0, 45.0, 75.0, 43.0, 66.0, 10000.0}};
    protected double[][] openCloseData = new double[][]{{52.0, 70.0, 60.0, 80.0, 65.0, 85.0, 55.0, 70.0, 58.0, 70.0}};
    protected double[][] openCloseVolumeData = new double[][]{{32.0, 60.0, 13000.0, 40.0, 60.0, 11000.0, 45.0, 65.0, 14000.0, 35.0, 55.0, 15000.0, 38.0, 58.0, 9000.0}};
    protected double[][] bubbleData = new double[][]{{15.0, 25.0, 5.0, 25.0, 30.0, 12.0, 25.0, 45.0, 12.0}, {15.0, 15.0, 8.0, 20.0, 35.0, 14.0, 40.0, 55.0, 35.0}, {10.0, 10.0, 8.0, 18.0, 55.0, 10.0, 40.0, 50.0, 18.0}, {8.0, 20.0, 6.0, 11.0, 30.0, 8.0, 30.0, 40.0, 15.0}};
    protected double[][] scatterPolarData = new double[][]{{15.0, 15.0, 25.0, 43.0, 25.0, 25.0}, {25.0, 15.0, 55.0, 45.0, 57.0, 47.0}, {17.0, 36.0, 32.0, 52.0, 26.0, 28.0}, {38.0, 22.0, 43.0, 43.0, 58.0, 36.0}};
    protected double[][] paretoData = new double[][]{{55.0, 43.0, 32.0, 21.0, 9.0}};
    protected double[][] threedSurfaceData = new double[][]{{42.0, 50.0, 38.0, 46.0, 55.0, 35.0, 32.0, 45.0}, {26.0, 34.0, 22.0, 30.0, 38.0, 40.0, 25.0, 30.0}, {10.0, 18.0, 6.0, 14.0, 18.0, 9.0, 19.0, 20.0}};
    protected double[][] threedAreaRibbonData = new double[][]{{42.0, 50.0, 38.0, 46.0, 55.0, 40.0}, {26.0, 34.0, 22.0, 30.0, 40.0, 28.0}, {10.0, 18.0, 6.0, 14.0, 20.0, 13.0}};
    protected double[][] lineData = new double[][]{{74.0, 62.0, 70.0, 76.0, 66.0}, {50.0, 38.0, 46.0, 54.0, 42.0}, {34.0, 22.0, 30.0, 32.0, 26.0}, {18.0, 6.0, 14.0, 22.0, 10.0}, {3.0, 2.0, 3.0, 3.0, 2.0}};
    protected double[][] areaData = new double[][]{{74.0, 42.0, 70.0, 46.0}, {50.0, 58.0, 46.0, 54.0}, {34.0, 22.0, 30.0, 32.0}, {18.0, 6.0, 14.0, 22.0}};
    protected double[][] funnelData = new double[][]{{7100.0, 2700.0, 760.0, 500.0, 400.0}, {10000.0, 5000.0, 2000.0, 1000.0, 500.0}};
    protected double[][] defaultData2 = new double[][]{{42.0, 50.0, 38.0, 46.0}, {26.0, 34.0, 22.0, 30.0}, {10.0, 18.0, 6.0, 14.0}};
    protected double[][] defaultAreaDualYData = new double[][]{{42.0, 10.0, 38.0, 46.0}, {26.0, 34.0, 22.0, 30.0}, {22.0, 30.0, 18.0, 26.0}};
    protected double[][] sparkchartData = new double[][]{{32.0, 54.0, 15.0, 10.0, 33.0, 17.0, 26.0, 16.0, 40.0, 63.0, 72.0, 56.0, 50.0, 20.0, 59.0}};
    protected double[][] sparkchartFloatingBarData = new double[][]{{3.0, 13.0, 12.0, 10.0, 4.0, 13.0, 11.0, 2.0, 9.0, 14.0, 10.0, 9.0, 11.0, 3.0, 13.0, 20.0}, {32.0, 54.0, 15.0, 10.0, 33.0, 17.0, 26.0, 16.0, 40.0, 63.0, 72.0, 56.0, 50.0, 20.0, 59.0}};
    protected double[][] FiveValueBoxPlotData = new double[][]{{10.0, 18.0, 45.0, 55.0, 75.0, 25.0, 50.0, 55.0, 60.0, 80.0, 38.0, 48.0, 58.0, 65.0, 68.0, 10.0, 25.0, 50.0, 75.0, 80.0, 20.0, 38.0, 45.0, 55.0, 60.0, 68.0}};
    protected double[][] SevenValueBoxPlotData = new double[][]{{10.0, 18.0, 25.0, 50.0, 55.0, 75.0, 80.0, 20.0, 38.0, 45.0, 55.0, 58.0, 60.0, 68.0, 10.0, 15.0, 25.0, 40.0, 45.0, 60.0, 87.0, 20.0, 27.0, 32.0, 37.0, 45.0, 50.0, 60.0, 24.0, 38.0, 45.0, 55.0, 60.0, 68.0, 84.0}};
    protected DataDirectorListener listener;
    protected int rowCount;
    protected int columnCount;
    protected int pageCount;
    protected int currentPage;
    private Object[][] cellData;
    protected String[] rowLabels;
    protected Object[] columnLabels;
    protected String[] pageLabels;
    private Locale loc = null;
    protected ResourceBundle rBundle = null;
    protected ResourceBundle rBundle1 = null;
    protected DVTResources m_dvtResources = null;
    protected CommonGraph m_graph = null;
    protected int m_graphType = -1;
    protected int m_timeAxisType = -1;
    protected double[][] defaultDataCommon;
    protected String[] strGroupArray = new String[35];
    protected String[] strSeriesArray = new String[5];
    private String baseEdgeDim = null;
    private String baseDim = null;
    private String basePageMem = null;
    private String strPage = null;
    private boolean localeChanged = false;

    public SampleDataSource(CommonGraph graph) {
        this.updateResourceBundle(graph.getLocale());
        this.m_dvtResources = graph.getDVTResources();
        this.m_graph = graph;
        this.strPage = this.rBundle1.getString("Page");
        this.baseEdgeDim = this.rBundle1.getString("LDSEdgeDim");
        this.baseDim = this.rBundle1.getString("LDSDim");
        this.basePageMem = this.rBundle1.getString("LDSPageMem");
        this.pageCount = 2;
        this.currentPage = 0;
        this.pageLabels = new String[this.pageCount];
        for (int page = 0; page < this.pageCount; ++page) {
            Integer Num = new Integer(page + 1);
            this.pageLabels[page] = this.strPage + " " + Num.toString();
        }
        this.setSampleDataSource();
    }

    public void setLocale(Locale loc) {
        this.loc = loc;
        this.updateResourceBundle(loc);
        this.localeChanged = true;
        this.setSampleDataSource();
    }

    public Locale getLocale() {
        return this.loc;
    }

    public DataDirector createDataDirector() {
        return this;
    }

    protected void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle", loc);
            this.rBundle1 = ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", loc);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle");
            this.rBundle1 = ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
        }
    }

    protected String getIntlString(String key) {
        String strTemp;
        if (this.m_dvtResources != null && this.m_dvtResources.getResourceString(key) != null) {
            return this.m_dvtResources.getResourceString(key);
        }
        if (this.rBundle == null) {
            return key;
        }
        try {
            strTemp = this.rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.m_graph.getErrorHandler().log("missing resource \"" + key + "\" in " + this.rBundle.getClass().getName(), ((Object)((Object)this)).getClass().getName(), "getIntlString(String key)");
            return key;
        }
        return strTemp;
    }

    public void populateCellData(int columnCount, int rowCount, double[][] data) {
        int tat = this.m_graph.getTimeAxisType();
        if ((tat == 3 || tat == 6) && this.m_graph.getPFJ().isMixedFreqTimeAxisGraphTypeNoLog(this.m_graph.getGraphType())) {
            this.populateMixedFreqCellData(columnCount, rowCount, data);
            return;
        }
        this.cellData = new Object[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                this.cellData[row][col] = new Double(data[row][col]);
            }
        }
    }

    public void populateMixedFreqCellData(int columnCount, int rowCount, double[][] data) {
        this.cellData = new Object[rowCount][columnCount];
        long now = Date.valueOf("2007-08-12").getTime();
        for (int row = 0; row < rowCount; ++row) {
            long start = now;
            for (int col = 0; col < columnCount; ++col) {
                this.cellData[row][col] = col % 2 == 0 ? new java.util.Date(start) : new Double(data[row][col]);
                start += 86400000L;
            }
        }
    }

    protected void populateRowLabels(int rowCount) {
        this.rowLabels = new String[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.rowLabels[row] = this.strSeriesArray[row];
        }
    }

    protected void populateColumnLabels(int columnCount) {
        int tat = this.m_graph.getTimeAxisType();
        if ((tat == 2 || tat == 5) && this.m_graph.getPFJ().isIrregularTimeAxisGraphTypeNoLog(this.m_graph.getGraphType())) {
            this.populateIrregularColumnLabels(columnCount);
            return;
        }
        this.columnLabels = new String[columnCount];
        for (int col = 0; col < columnCount; ++col) {
            this.columnLabels[col] = this.strGroupArray[col];
        }
    }

    protected void populateIrregularColumnLabels(int columnCount) {
        this.columnLabels = new java.util.Date[columnCount];
        long now = Date.valueOf("2007-08-12").getTime();
        for (int col = 0; col < columnCount; ++col) {
            this.columnLabels[col] = new java.util.Date(now);
            now += 86400000L;
        }
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener l) {
        this.listener = l;
        this.listener.viewDataAvailable(new DataAvailableEvent((Object)this, (DataAccess)this));
    }

    public void removeDataDirectorListener(DataDirectorListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }

    public boolean changeEdgeCurrentSlice(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        if (slice == 1) {
            this.currentPage = 1;
            this.listener.viewDataChanged(new DataChangedEvent((Object)this, (DataAccess)this, true, true, true, true));
        } else if (slice == 0) {
            this.currentPage = 0;
            this.listener.viewDataChanged(new DataChangedEvent((Object)this, (DataAccess)this, true, false, false, true));
        }
        return true;
    }

    public boolean changeEdgeCurrentHPos(int edge, int[] hPos, int maxLayerSpecified) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        try {
            return this.changeEdgeCurrentSlice(edge, hPos[maxLayerSpecified]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        this.setSampleDataSource();
        switch (edge) {
            case 0: {
                return this.columnCount;
            }
            case 1: {
                return this.rowCount;
            }
            case 2: {
                return this.pageCount;
            }
        }
        return 0;
    }

    public int getEdgeCount() {
        return 3;
    }

    public Object getValue(int aRow, int aColumn, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        if (aRow < 0 || aRow >= this.rowCount) {
            throw new RowOutOfRangeException((long)aRow, (long)this.rowCount);
        }
        if (aColumn < 0 || aColumn >= this.columnCount) {
            throw new ColumnOutOfRangeException((long)aColumn, (long)this.columnCount);
        }
        if (type.equals("dataRatio")) {
            return new Integer(0);
        }
        if (type.equals("dataGroupSort")) {
            return new Integer(0);
        }
        if (type.equals("dataViewFormat") || type.equals("dataViewStyle") || type.equals("dataFormattedValue") || type.equals("dataAnnotation")) {
            return null;
        }
        Object value = null;
        value = this.currentPage == 1 ? new Double((Double)this.cellData[aRow][aColumn] + 10.0) : this.cellData[aRow][aColumn];
        return value;
    }

    public boolean setValue(Object aValue, int aRow, int aColumn, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        if (aRow < 0 || aRow >= this.rowCount) {
            throw new RowOutOfRangeException((long)aRow, (long)this.rowCount);
        }
        if (aColumn < 0 || aColumn >= this.columnCount) {
            throw new ColumnOutOfRangeException((long)aColumn, (long)this.columnCount);
        }
        Object oldValue = this.getValue(aRow, aColumn, type);
        Object newValue = aValue;
        try {
            newValue = oldValue.getClass().getMethod("valueOf", String.class).invoke(null, aValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cellData[aRow][aColumn] = newValue;
        return true;
    }

    public Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        switch (edge) {
            case 0: {
                if (slice < 0 || slice >= this.columnCount) {
                    throw new SliceOutOfRangeException(slice, this.columnCount);
                }
                return this.columnLabels[slice];
            }
            case 1: {
                if (slice < 0 || slice >= this.rowCount) {
                    throw new SliceOutOfRangeException(slice, this.rowCount);
                }
                return this.rowLabels[slice];
            }
            case 2: {
                if (slice < 0 || slice >= this.pageCount) {
                    throw new SliceOutOfRangeException(slice, this.pageCount);
                }
                return this.pageLabels[slice];
            }
        }
        return null;
    }

    public int getEdgeCurrentSlice(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge == 2) {
            return this.currentPage;
        }
        return 0;
    }

    public void setCurrentPage(long aPage) {
        if (aPage < 0L || aPage >= (long)this.pageCount) {
            return;
        }
        this.currentPage = (int)aPage;
    }

    public int getLayerCount(int edge) throws EdgeOutOfRangeException {
        return 1;
    }

    public int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (type.equals("dimCanPivot")) {
            return new Integer(1);
        }
        if (type.equals("viewStyle")) {
            return null;
        }
        String columnLayerString = this.getIntlString("af_dvt_graph.GROUP");
        String rowLayerString = this.getIntlString("af_dvt_graph.SERIES");
        if (edge == 0) {
            return columnLayerString;
        }
        if (edge == 1) {
            return rowLayerString;
        }
        return null;
    }

    public Object getMemberMetadata(int edge, int dimension, int dimvalue, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("indent") || type.equals("relIndent")) {
            return new Integer(0);
        }
        if (type.equals("value") || type.equals("displayName") || type.equals("label") || type.equals("mediumName") || type.equals("shortName")) {
            Object obj = null;
            switch (edge) {
                case 0: {
                    obj = this.columnLabels[dimvalue];
                    break;
                }
                case 1: {
                    obj = this.rowLabels[dimvalue];
                    break;
                }
                case 2: {
                    obj = this.pageLabels[dimvalue];
                }
            }
            return obj;
        }
        return null;
    }

    public int getMemberExtent(int edge, int layer, int slice) {
        return 1;
    }

    public int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return slice;
    }

    public void setOutline(boolean outline) throws DataDirectorException {
        this.listener.viewDataChanged(new DataChangedEvent((Object)this, (DataAccess)this, true, true, true, true));
    }

    public boolean isOutline() {
        return false;
    }

    public int getMemberSiblingCount(int edge, int[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 2;
    }

    public Object getMemberMetadata(int edge, int[] hPos, int memberLayer, int hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (memberLayer == 0 || hPos == null) {
            return MessageFormat.format(this.basePageMem, String.valueOf(hIndex + 1));
        }
        return hPos[0] + " # " + hIndex;
    }

    public int[] getEdgeCurrentHPos(int edge) throws EdgeOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getMemberHPos(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getNextHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge == 2 && this.currentPage == 0) {
            return new int[]{1};
        }
        return null;
    }

    public int[] getPrevHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge == 2 && this.currentPage == 1) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getFirstHPos(int edge) throws EdgeOutOfRangeException {
        if (edge == 2) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getLastHPos(int edge) throws EdgeOutOfRangeException {
        if (edge == 2) {
            return new int[]{1};
        }
        return null;
    }

    public DataMap getDataMap() {
        return new DataMap();
    }

    public DataMap getSupportedDataMap() {
        String[] supported = new String[]{"dataValue", "dataFormattedValue", "dataRatio", "dataViewFormat", "dataViewStyle", "dataGroupSort", "dataAnnotation", "value"};
        return new DataMap(supported);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] supported = new String[]{"label", "mediumName", "shortName", "drillState", "viewStyle", "value", "indent", "relIndent", "date"};
        return new MetadataMap(supported);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] supported = new String[]{"layerLabel", "dimMediumName", "dimShortName", "layerName", "dimCanPivot", "viewStyle"};
        return new LayerMetadataMap(supported);
    }

    public QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        String layerName = this.getLayerMetadata(edge, layer, "layerLabel").toString();
        return new QDR(null, layerName, (String)null);
    }

    public QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return this.constructSliceQDR(edge, slice);
    }

    protected QDR constructSliceQDR(int edge, int slice) {
        String layerName = null;
        String memberName = null;
        String result = "";
        int layerCount = 0;
        try {
            layerCount = this.getLayerCount(edge);
        }
        catch (DataException dataException) {
            // empty catch block
        }
        for (int layer = 0; layer < layerCount; ++layer) {
            try {
                layerName = this.getLayerMetadata(edge, layer, "layerLabel").toString();
            }
            catch (DataException de) {
                layerName = "";
            }
            try {
                memberName = this.getMemberMetadata(edge, layer, slice, "label").toString();
            }
            catch (DataException de) {
                memberName = "";
            }
            result = result + ";" + layerName.toString() + ":" + memberName.toString();
        }
        QDR qdr = new QDR(null, result);
        return qdr;
    }

    public void setSampleDataSource() {
        if (this.m_graphType != this.m_graph.getGraphType() || this.m_timeAxisType != this.m_graph.getTimeAxisType()) {
            this.m_graphType = this.m_graph.getGraphType();
            this.m_timeAxisType = this.m_graph.getTimeAxisType();
        } else if (!this.localeChanged) {
            return;
        }
        if (this.m_graph.getFormFactor() == GraphConstants.FormFactor.SPARKCHART) {
            switch (this.m_graphType) {
                case 95: {
                    this.rowCount = 2;
                    this.columnCount = 15;
                    this.defaultDataCommon = this.sparkchartFloatingBarData;
                    break;
                }
                default: {
                    this.rowCount = 1;
                    this.columnCount = 15;
                    this.defaultDataCommon = this.sparkchartData;
                }
            }
            this.initGroupAndSeriesArrays();
        } else {
            switch (this.m_graphType) {
                case 76: {
                    this.initGroups5_3();
                    this.rowCount = 1;
                    this.columnCount = 15;
                    this.defaultDataCommon = this.highLowCloseData;
                    break;
                }
                case 88: {
                    this.initGroups5_4();
                    this.rowCount = 1;
                    this.columnCount = 20;
                    this.defaultDataCommon = this.highLowCloseVolumeData;
                    break;
                }
                case 72: {
                    this.initGroups5_2();
                    this.rowCount = 1;
                    this.columnCount = 10;
                    this.defaultDataCommon = this.openCloseData;
                    break;
                }
                case 84: {
                    this.initGroups5_3();
                    this.rowCount = 1;
                    this.columnCount = 15;
                    this.defaultDataCommon = this.openCloseVolumeData;
                    break;
                }
                case 70: 
                case 79: {
                    this.initGroups5_4();
                    this.rowCount = 1;
                    this.columnCount = 20;
                    this.defaultDataCommon = this.openHiLoCloseData;
                    break;
                }
                case 71: 
                case 83: {
                    this.initGroups5_5();
                    this.rowCount = 1;
                    this.columnCount = 25;
                    this.defaultDataCommon = this.openHiLoCloseVolumeData;
                    break;
                }
                case 101: {
                    this.initGroups5_5();
                    this.rowCount = 1;
                    this.columnCount = 25;
                    this.defaultDataCommon = this.FiveValueBoxPlotData;
                    break;
                }
                case 102: {
                    this.initGroups5_7();
                    this.rowCount = 1;
                    this.columnCount = 35;
                    this.defaultDataCommon = this.SevenValueBoxPlotData;
                    break;
                }
                case 89: 
                case 90: 
                case 91: 
                case 92: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 4;
                    this.columnCount = 9;
                    this.defaultDataCommon = this.bubbleData;
                    break;
                }
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 4;
                    this.columnCount = 6;
                    this.defaultDataCommon = this.scatterPolarData;
                    break;
                }
                case 21: 
                case 22: 
                case 28: 
                case 29: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 2;
                    this.columnCount = 4;
                    this.defaultDataCommon = this.defaultData2;
                    break;
                }
                case 33: 
                case 34: 
                case 38: 
                case 39: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 3;
                    this.columnCount = 4;
                    this.defaultDataCommon = this.defaultAreaDualYData;
                    break;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 54: 
                case 67: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 5;
                    this.columnCount = 5;
                    this.defaultDataCommon = this.lineData;
                    break;
                }
                case 31: 
                case 32: 
                case 35: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 4;
                    this.columnCount = 4;
                    this.defaultDataCommon = this.areaData;
                    break;
                }
                case 45: 
                case 46: 
                case 52: 
                case 53: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 2;
                    this.columnCount = 4;
                    this.defaultDataCommon = this.lineData;
                    break;
                }
                case 96: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 1;
                    this.columnCount = 5;
                    this.defaultDataCommon = this.paretoData;
                    break;
                }
                case 12: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 3;
                    this.columnCount = 5;
                    this.defaultDataCommon = this.threedSurfaceData;
                    break;
                }
                case 6: 
                case 7: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 3;
                    this.columnCount = 4;
                    this.defaultDataCommon = this.threedAreaRibbonData;
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 97: 
                case 98: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 5;
                    this.columnCount = 2;
                    this.defaultDataCommon = this.defaultData1;
                    break;
                }
                case 100: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 2;
                    this.columnCount = 5;
                    this.defaultDataCommon = this.funnelData;
                    break;
                }
                default: {
                    this.initGroupAndSeriesArrays();
                    this.rowCount = 3;
                    this.columnCount = 4;
                    this.defaultDataCommon = this.defaultData2;
                }
            }
        }
        int tat = this.m_graph.getTimeAxisType();
        if ((tat == 3 || tat == 6) && this.m_graph.getPFJ().isMixedFreqTimeAxisGraphTypeNoLog(this.m_graph.getGraphType())) {
            this.rowCount = 4;
            this.columnCount = 6;
            this.defaultDataCommon = this.scatterPolarData;
        }
        this.populateCellData(this.columnCount, this.rowCount, this.defaultDataCommon);
        this.populateRowLabels(this.rowCount);
        this.populateColumnLabels(this.columnCount);
        if (this.localeChanged) {
            this.localeChanged = false;
            this.listener.viewDataChanged(new DataChangedEvent((Object)this, (DataAccess)this, true, true, true, true));
        } else if (this.m_graph.getDataSource() == this) {
            this.m_graph.saveDrillState();
        }
    }

    protected void initGroups5_2() {
        String a = this.getIntlString("af_dvt_graph.LABEL_GROUP_A");
        String b = this.getIntlString("af_dvt_graph.LABEL_GROUP_B");
        String c = this.getIntlString("af_dvt_graph.LABEL_GROUP_C");
        String d = this.getIntlString("af_dvt_graph.LABEL_GROUP_D");
        String e = this.getIntlString("af_dvt_graph.LABEL_GROUP_E");
        this.strGroupArray[0] = a;
        this.strGroupArray[1] = a;
        this.strGroupArray[2] = b;
        this.strGroupArray[3] = b;
        this.strGroupArray[4] = c;
        this.strGroupArray[5] = c;
        this.strGroupArray[6] = d;
        this.strGroupArray[7] = d;
        this.strGroupArray[8] = e;
        this.strGroupArray[9] = e;
        this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.LABEL_SERIES_1");
    }

    protected void initGroups5_3() {
        String a = this.getIntlString("af_dvt_graph.LABEL_GROUP_A");
        String b = this.getIntlString("af_dvt_graph.LABEL_GROUP_B");
        String c = this.getIntlString("af_dvt_graph.LABEL_GROUP_C");
        String d = this.getIntlString("af_dvt_graph.LABEL_GROUP_D");
        String e = this.getIntlString("af_dvt_graph.LABEL_GROUP_E");
        this.strGroupArray[0] = a;
        this.strGroupArray[1] = a;
        this.strGroupArray[2] = a;
        this.strGroupArray[3] = b;
        this.strGroupArray[4] = b;
        this.strGroupArray[5] = b;
        this.strGroupArray[6] = c;
        this.strGroupArray[7] = c;
        this.strGroupArray[8] = c;
        this.strGroupArray[9] = d;
        this.strGroupArray[10] = d;
        this.strGroupArray[11] = d;
        this.strGroupArray[12] = e;
        this.strGroupArray[13] = e;
        this.strGroupArray[14] = e;
        this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.LABEL_SERIES_1");
    }

    protected void initGroups5_4() {
        String a = this.getIntlString("af_dvt_graph.LABEL_GROUP_A");
        String b = this.getIntlString("af_dvt_graph.LABEL_GROUP_B");
        String c = this.getIntlString("af_dvt_graph.LABEL_GROUP_C");
        String d = this.getIntlString("af_dvt_graph.LABEL_GROUP_D");
        String e = this.getIntlString("af_dvt_graph.LABEL_GROUP_E");
        this.strGroupArray[0] = a;
        this.strGroupArray[1] = a;
        this.strGroupArray[2] = a;
        this.strGroupArray[3] = a;
        this.strGroupArray[4] = b;
        this.strGroupArray[5] = b;
        this.strGroupArray[6] = b;
        this.strGroupArray[7] = b;
        this.strGroupArray[8] = c;
        this.strGroupArray[9] = c;
        this.strGroupArray[10] = c;
        this.strGroupArray[11] = c;
        this.strGroupArray[12] = d;
        this.strGroupArray[13] = d;
        this.strGroupArray[14] = d;
        this.strGroupArray[15] = d;
        this.strGroupArray[16] = e;
        this.strGroupArray[17] = e;
        this.strGroupArray[18] = e;
        this.strGroupArray[19] = e;
        this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.LABEL_SERIES_1");
    }

    protected void initGroups5_5() {
        String a = this.getIntlString("af_dvt_graph.LABEL_GROUP_A");
        String b = this.getIntlString("af_dvt_graph.LABEL_GROUP_B");
        String c = this.getIntlString("af_dvt_graph.LABEL_GROUP_C");
        String d = this.getIntlString("af_dvt_graph.LABEL_GROUP_D");
        String e = this.getIntlString("af_dvt_graph.LABEL_GROUP_E");
        this.strGroupArray[0] = a;
        this.strGroupArray[1] = a;
        this.strGroupArray[2] = a;
        this.strGroupArray[3] = a;
        this.strGroupArray[4] = a;
        this.strGroupArray[5] = b;
        this.strGroupArray[6] = b;
        this.strGroupArray[7] = b;
        this.strGroupArray[8] = b;
        this.strGroupArray[9] = b;
        this.strGroupArray[10] = c;
        this.strGroupArray[11] = c;
        this.strGroupArray[12] = c;
        this.strGroupArray[13] = c;
        this.strGroupArray[14] = c;
        this.strGroupArray[15] = d;
        this.strGroupArray[16] = d;
        this.strGroupArray[17] = d;
        this.strGroupArray[18] = d;
        this.strGroupArray[19] = d;
        this.strGroupArray[20] = e;
        this.strGroupArray[21] = e;
        this.strGroupArray[22] = e;
        this.strGroupArray[23] = e;
        this.strGroupArray[24] = e;
        this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.LABEL_SERIES_1");
    }

    protected void initGroups5_7() {
        String a = this.getIntlString("af_dvt_graph.LABEL_GROUP_A");
        String b = this.getIntlString("af_dvt_graph.LABEL_GROUP_B");
        String c = this.getIntlString("af_dvt_graph.LABEL_GROUP_C");
        String d = this.getIntlString("af_dvt_graph.LABEL_GROUP_D");
        String e = this.getIntlString("af_dvt_graph.LABEL_GROUP_E");
        this.strGroupArray[0] = a;
        this.strGroupArray[1] = a;
        this.strGroupArray[2] = a;
        this.strGroupArray[3] = a;
        this.strGroupArray[4] = a;
        this.strGroupArray[5] = a;
        this.strGroupArray[6] = a;
        this.strGroupArray[7] = b;
        this.strGroupArray[8] = b;
        this.strGroupArray[9] = b;
        this.strGroupArray[10] = b;
        this.strGroupArray[11] = b;
        this.strGroupArray[12] = b;
        this.strGroupArray[13] = b;
        this.strGroupArray[14] = c;
        this.strGroupArray[15] = c;
        this.strGroupArray[16] = c;
        this.strGroupArray[17] = c;
        this.strGroupArray[18] = c;
        this.strGroupArray[19] = c;
        this.strGroupArray[20] = c;
        this.strGroupArray[21] = d;
        this.strGroupArray[22] = d;
        this.strGroupArray[23] = d;
        this.strGroupArray[24] = d;
        this.strGroupArray[25] = d;
        this.strGroupArray[26] = d;
        this.strGroupArray[27] = d;
        this.strGroupArray[28] = e;
        this.strGroupArray[29] = e;
        this.strGroupArray[30] = e;
        this.strGroupArray[31] = e;
        this.strGroupArray[32] = e;
        this.strGroupArray[33] = e;
        this.strGroupArray[34] = e;
        this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.LABEL_SERIES_1");
    }

    protected void initGroupAndSeriesArrays() {
        String a = this.getIntlString("af_dvt_graph.LABEL_GROUP_A");
        String b = this.getIntlString("af_dvt_graph.LABEL_GROUP_B");
        String c = this.getIntlString("af_dvt_graph.LABEL_GROUP_C");
        String d = this.getIntlString("af_dvt_graph.LABEL_GROUP_D");
        String e = this.getIntlString("af_dvt_graph.LABEL_GROUP_E");
        String aa = this.getIntlString("af_dvt_graph.LABEL_GROUP_AA");
        String bb = this.getIntlString("af_dvt_graph.LABEL_GROUP_BB");
        String cc = this.getIntlString("af_dvt_graph.LABEL_GROUP_CC");
        String dd = this.getIntlString("af_dvt_graph.LABEL_GROUP_DD");
        String ee = this.getIntlString("af_dvt_graph.LABEL_GROUP_EE");
        this.strGroupArray[0] = a;
        this.strGroupArray[1] = b;
        this.strGroupArray[2] = c;
        this.strGroupArray[3] = d;
        this.strGroupArray[4] = e;
        this.strGroupArray[5] = aa;
        this.strGroupArray[6] = bb;
        this.strGroupArray[7] = cc;
        this.strGroupArray[8] = dd;
        this.strGroupArray[9] = ee;
        this.strGroupArray[10] = a;
        this.strGroupArray[11] = b;
        this.strGroupArray[12] = c;
        this.strGroupArray[13] = d;
        this.strGroupArray[14] = e;
        this.strGroupArray[15] = aa;
        this.strGroupArray[16] = bb;
        this.strGroupArray[17] = cc;
        this.strGroupArray[18] = dd;
        this.strGroupArray[19] = ee;
        this.strGroupArray[20] = a;
        this.strGroupArray[21] = b;
        this.strGroupArray[22] = c;
        this.strGroupArray[23] = d;
        this.strGroupArray[24] = e;
        if (this.m_graph.getFormFactor() == GraphConstants.FormFactor.SPARKCHART) {
            if (this.m_graphType == 95) {
                this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.SPARK_FLOAT_VALUE");
                this.strSeriesArray[1] = this.getIntlString("af_dvt_graph.SPARK_VALUE");
            } else {
                this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.SPARK_VALUE");
                this.strSeriesArray[1] = this.getIntlString("af_dvt_graph.LABEL_SERIES_2");
            }
        } else {
            this.strSeriesArray[0] = this.getIntlString("af_dvt_graph.LABEL_SERIES_1");
            this.strSeriesArray[1] = this.getIntlString("af_dvt_graph.LABEL_SERIES_2");
        }
        this.strSeriesArray[2] = this.getIntlString("af_dvt_graph.LABEL_SERIES_3");
        this.strSeriesArray[3] = this.getIntlString("af_dvt_graph.LABEL_SERIES_4");
        this.strSeriesArray[4] = this.getIntlString("af_dvt_graph.LABEL_SERIES_5");
    }
}

