/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.javatools.annotations.Concealed;

public class X1Axis
extends BaseDataAxis {
    @Concealed
    public X1Axis(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getX1Axis();
        this.m_identObj2 = this.m_pfj.getX1AxisLine();
        this.m_majorGridIdentObj = this.m_pfj.getX1MajorGrid();
        this.m_minorGridIdentObj = this.m_pfj.getX1MinorGrid();
        this.m_labelIdentObj = this.m_pfj.getX1Label();
        this.m_id = 41;
    }

    @Override
    public void setMajorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else {
            this.m_pfj.setX1MajorGridStep(value);
        }
    }

    @Override
    public double getMajorTickStep() {
        if (this.isMajorTickStepAutomatic() && !this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getX1MajorGridStep();
    }

    @Override
    public void setMinorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid minor tick step", this.getClass().getName(), "setMinorTickStep (double value)");
        } else {
            this.m_pfj.setX1MinorGridStep(value);
        }
    }

    @Override
    public double getMinorTickStep() {
        if (this.getMinorTickStepType() != GraphConstants.MinorGridStepType.AUTO && !this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getX1MinorGridStep();
    }

    @Override
    @Concealed
    public double getAutoMajorTickStep() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getX1MajorGridStepAutoValue();
    }

    @Override
    public boolean isAxisAutoScaledFromZero() {
        return this.m_pfj.getX1MustIncludeZero();
    }

    @Override
    public void setAxisAutoScaledFromZero(boolean yesNo) {
        this.m_pfj.setX1MustIncludeZero(yesNo);
    }

    @Override
    public boolean isAxisMaxAutoScaled() {
        return this.m_pfj.getX1ScaleMaxAuto();
    }

    @Override
    public void setAxisMaxAutoScaled(boolean yesNo) {
        this.m_pfj.setX1ScaleMaxAuto(yesNo);
    }

    @Override
    public boolean isAxisMinAutoScaled() {
        return this.m_pfj.getX1ScaleMinAuto();
    }

    @Override
    public void setAxisMinAutoScaled(boolean yesNo) {
        this.m_pfj.setX1ScaleMinAuto(yesNo);
    }

    @Override
    public double getAxisMaxAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getX1ScaleMaxAutoValue();
    }

    @Override
    public double getAxisMaxValue() {
        return this.m_pfj.getX1ScaleMax();
    }

    @Override
    public void setAxisMaxValue(double value) {
        this.m_pfj.setX1ScaleMax(value);
    }

    @Override
    public double getAxisMinAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getX1ScaleMinAutoValue();
    }

    @Override
    public double getAxisMinValue() {
        return this.m_pfj.getX1ScaleMin();
    }

    @Override
    public void setAxisMinValue(double value) {
        this.m_pfj.setX1ScaleMin(value);
    }

    @Override
    public double getAxisZoomMaxValue() {
        Double val = this.m_pfj.getX1ScaleZoomMax();
        if (val != null) {
            return val;
        }
        return 0.0;
    }

    @Override
    public void setAxisZoomMaxValue(double value) {
        this.m_pfj.setX1ScaleZoomMax(value);
    }

    @Override
    public double getAxisZoomMinValue() {
        Double val = this.m_pfj.getX1ScaleZoomMin();
        if (val != null) {
            return val;
        }
        return 0.0;
    }

    @Override
    public void setAxisZoomMinValue(double value) {
        this.m_pfj.setX1ScaleZoomMin(value);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_pfj.setX1AxisLineDisplay(visible);
        this.m_pfj.setX1LabelDisplay(visible);
        this.m_pfj.setX1MajorGridDisplay(visible);
        this.m_pfj.setX1MinorGridDisplay(visible);
    }

    @Override
    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getX1MajorGridStepAuto();
    }

    @Override
    public void setMajorTickStepAutomatic(boolean yesNo) {
        this.m_pfj.setX1MajorGridStepAuto(yesNo);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "X1Axis";
    }
}

