/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.FunnelLabelContainer;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class FunnelStageLabelContainer {
    protected Perspective m_perspective;
    protected Access m_access;
    protected JChart_2D_Funnel m_chart;
    protected boolean m_lastStageOnly;
    protected double[] m_targetValues;
    protected int m_nTotalGroups;
    protected int m_nTotalSeries;
    protected static final double FONT_GAP = 0.33;
    private TextStyleObj m_textStyles;
    private Vector m_stageLabels;
    private Vector m_truncatedStageLabels;
    private double m_StageLabelMaxWidth;
    private FontMetrics m_stageLabelFM;
    private VC m_vc;
    private double m_stageLabelGap;
    private int[] m_stageLabelWidths;
    private int m_maxStageLabelWidth = -1;

    public FunnelStageLabelContainer(Perspective m_perspective, JChart_2D_Funnel m_chart) {
        this.m_perspective = m_perspective;
        this.m_access = m_chart.m_Access;
        this.m_chart = m_chart;
        this.calc_init();
    }

    public void calc_init() {
        this.m_stageLabels = new Vector();
        this.m_truncatedStageLabels = new Vector();
        this.m_StageLabelMaxWidth = 0.0;
        this.m_nTotalGroups = this.m_access.getNumTotalGroups();
        this.m_vc = this.m_perspective.getVC();
        this.createTextStyle();
        this.m_stageLabelGap = this.calcStageLabelGap();
        this._getStageLabels();
        this._calcWidthOfStages();
        this.m_maxStageLabelWidth = this._calcMaxSliceLabelWidth();
    }

    public Vector getLabels() {
        return this.m_stageLabels;
    }

    public Vector getTruncatedLabels() {
        return this.m_truncatedStageLabels;
    }

    public TextStyleObj getTextStyleObject() {
        return this.m_textStyles;
    }

    public int[] getStageWidths() {
        return this.m_stageLabelWidths;
    }

    public double getStageLabelGap() {
        return this.m_stageLabelGap;
    }

    public int getMaxStageLabelWidth() {
        return this.m_maxStageLabelWidth;
    }

    public FontMetrics getFontMetrics() {
        return this.m_stageLabelFM;
    }

    public TextStyleObj getTextStyle() {
        return this.m_textStyles;
    }

    public int[] getLabelWidthArray() {
        return this.m_stageLabelWidths;
    }

    public int getFontHeight() {
        return TextStyleObj.getFontHeight(this.m_stageLabelFM, this.m_perspective.getFontMetricsResolver());
    }

    public int getFirstStageLabelWidth() {
        return this.m_stageLabelWidths[0];
    }

    public int getLastStageLabelWidth() {
        return this.m_stageLabelWidths[this.m_stageLabelWidths.length - 1];
    }

    protected void createTextStyle() {
        IdentObj id = this.m_perspective.getO1Label();
        int rotation = this.m_perspective.getTextRotation(id);
        int just = 1;
        if (rotation == 0) {
            just = 0;
        } else if (rotation == 90) {
            just = 3;
        }
        rotation = this.m_perspective.getTextRotation(id);
        this.m_textStyles = new TextStyleObj(this.m_perspective.m_fontCache, this.m_perspective.getFontName(id), this.m_perspective.getFontStyle(id), this.m_perspective.getFontSizeAbsolute(id), this.m_perspective.getFontSize(id), this.m_perspective.getFontSizeVC(id), rotation, 2, just, false, false, this.m_perspective.getTextWrap(id), this.m_perspective.getLocale());
    }

    private FontMetrics _getFontMetrics() {
        if (this.m_stageLabelFM == null) {
            Graphics graphics = this.m_perspective.getGraphicsContext();
            Font font = this.m_textStyles.getFont(this.m_vc);
            this.m_stageLabelFM = graphics.getFontMetrics(font);
            return this.m_stageLabelFM;
        }
        return this.m_stageLabelFM;
    }

    private void _getStageLabels() {
        GroupsEnumerator gEnum = this.m_chart.getResetGroupsEnumerator();
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            this._getStageLabel(g);
        }
    }

    private void _getStageLabel(int g) {
        String str = this.m_perspective.getGroupLabel(g);
        this.m_stageLabels.addElement(str);
        this.m_truncatedStageLabels.addElement(str);
    }

    private double calcStageLabelGap() {
        return (double)TextStyleObj.getFontHeight(this._getFontMetrics(), this.m_perspective.getFontMetricsResolver()) * 0.33;
    }

    private void _calcWidthOfStages() {
        this.m_stageLabelWidths = new int[this.m_nTotalGroups];
        String label = null;
        Enumeration enumerator = this.m_stageLabels.elements();
        int i = 0;
        while (enumerator.hasMoreElements()) {
            label = (String)enumerator.nextElement();
            this.m_stageLabelWidths[i] = FunnelLabelContainer.getWidth(this.m_stageLabelFM, label, this.m_perspective.getFontMetricsResolver());
            ++i;
        }
    }

    private int _calcMaxSliceLabelWidth() {
        return FunnelLabelContainer.getMaxWidth(this.m_stageLabelFM, this.m_stageLabels, this.m_perspective.getFontMetricsResolver());
    }
}

