/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.presutil.GradientStopObj;
import oracle.dss.presutil.SVGWriter;
import oracle.dss.util.ErrorHandler;

public class GraphSVGWriter
extends SVGWriter {
    protected static final String STROKE_DASHARRAY_DOTTED = "2";
    private static final String GRADIENT_ID_BASE = "grad";
    private static final String PATTERN_ID_BASE = "pat";
    protected Perspective m_pfj = null;
    private int m_gradientCount = 0;
    private int m_patternCount = 0;
    private boolean m_bPointerEventsForTransparentComponents = false;
    private boolean m_bDataZoomScriptWritten = false;
    private boolean m_bDataScrollbarScriptWritten = false;
    private boolean m_bTimeSelectorScriptWritten = false;
    protected static final String DATA_ZOOM_X = "x";
    protected static final String DATA_ZOOM_Y = "y";
    protected static final String DATA_ZOOM_WIDTH = "width";
    protected static final String DATA_ZOOM_HEIGHT = "height";
    protected static final String DATA_SCROLL_AXIS = "axis";
    protected static final String DATA_SCROLL_START = "start";
    protected static final String DATA_SCROLL_SPAN = "span";
    protected static final String DATA_SCROLL_COUNT = "count";
    protected static final int DATA_ZOOM_BUTTONS_INT_SPACE = 2;
    protected static final int DATA_ZOOM_BUTTONS_EXT_SPACE = 4;
    protected static final String TIME_AXIS_X = "x";
    protected static final String SRC_ID = "srcID";
    protected static final String NODE_ID = "nodeID";
    protected static final String TIME_SELECTOR_START_DATE = "timeSelStartDate";
    protected static final String TIME_SELECTOR_END_DATE = "timeSelEndDate";
    protected static final String ID_PARAM_SEPARATOR = ";";
    protected static final String ID_PARAM_VAL_SEPARATOR = "=";
    protected static final String ID_PARAM_GROUP = ";g=";
    protected static final String ID_PARAM_SERIES = ";s=";
    protected static final String ID_PARAM_MISC = ";m=";
    protected static final String ID_PARAM_EDGE = ";e=";
    protected static final String ID_PARAM_AXIS = ";a=";
    protected static final String ID_PARAM_VAL_COL = "col";
    protected static final String ID_PARAM_VAL_ROW = "row";

    public GraphSVGWriter(Perspective p, OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.init(p);
    }

    public GraphSVGWriter(Perspective p, OutputStream os, ErrorHandler eh) {
        super(os, eh);
        this.init(p);
    }

    public GraphSVGWriter(Perspective p, Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
        this.init(p);
    }

    public GraphSVGWriter(Perspective p, Writer writer, ErrorHandler eh) {
        super(writer, eh);
        this.init(p);
    }

    protected void init(Perspective p) {
        this.m_pfj = p;
        this.m_gradientCount = 0;
        this.m_patternCount = 0;
    }

    public void init(DetObj detObj) {
    }

    public void writeElement(IdentObj id, BlackBoxIF bb, Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, TextStyleObj textStyle, VC vc) throws IOException, Exception {
        if (!bb.getTransparentFillColor()) {
            Color dropShadowColor = this.m_pfj.getShadowColor(id);
            Dimension dropShadowOffset = null;
            if (this.m_pfj.getShadowDisplay(id) && !bb.getTransparentFillColor()) {
                dropShadowOffset = new Dimension(this.m_pfj.getVC().virtToDestWidth(this.m_pfj.getShadowXOffset(id) * 50), this.m_pfj.getVC().virtToDestHeight(this.m_pfj.getShadowYOffset(id) * 50));
            }
            this.fillColorText(id, bb, g, szText, rBounds, rInnerBounds, dropShadowColor, dropShadowOffset, textStyle, vc, 1);
        }
    }

    protected void fillColorText(IdentObj id, BlackBoxIF bb, Graphics g, String szText, Rectangle rBounds, Rectangle rInnerBounds, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, int nBackgroundFillType) throws IOException, Exception {
        Color fillColor = bb.getFillColor();
        if (textStyle.getRotationAngle() == 0) {
            this.drawStyledText(id, textStyle, fillColor, g, szText, rInnerBounds, dropShadowColor, dropShadowOffset, vc);
        } else {
            this.fillColorTextRotated(id, fillColor, g, szText, rInnerBounds, dropShadowColor, dropShadowOffset, textStyle, vc, nBackgroundFillType);
        }
    }

    protected void fillColorTextRotated(IdentObj id, Color textColor, Graphics g, String szText, Rectangle rectBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, int nBackgroundFillType) throws IOException, Exception {
        if (rectBoundsDC.width <= 0 || rectBoundsDC.height <= 0) {
            if (this.m_eh != null) {
                this.m_eh.log("invalid rectBoundsDC", this.getClass().getName(), "protected void fillColorTextRotated");
            }
            return;
        }
        Rectangle rTextDC = new Rectangle(0, 0, rectBoundsDC.height, rectBoundsDC.width);
        Rectangle rBoundsDC = new Rectangle(rectBoundsDC.x, rectBoundsDC.y, rectBoundsDC.width, rectBoundsDC.height);
        if (textStyle != null && textStyle.getWordWrap()) {
            Dimension dimTextDC = textStyle.preDraw(g, szText, rTextDC, vc, dropShadowOffset, this.m_pfj.getFontMetricsResolver());
            rTextDC.width = Math.max(rTextDC.width, dimTextDC.width);
            rTextDC.height = Math.max(rTextDC.height, dimTextDC.height);
        }
        if (rTextDC.width <= 1 || rTextDC.height <= 1) {
            if (this.m_eh != null) {
                this.m_eh.log("text bounds too small to draw", this.getClass().getName(), "protected void fillColorTextRotated");
            }
            return;
        }
        if (textStyle.getRotationAngle() == 270 || textStyle.getRotationAngle() == 90) {
            rBoundsDC.height = rTextDC.width;
            rBoundsDC.width = rTextDC.height;
        }
        int oldw = rBoundsDC.width;
        int oldh = rBoundsDC.height;
        if (textStyle.getRotationAngle() == 270 || textStyle.getRotationAngle() == 90) {
            int width = rBoundsDC.width;
            rBoundsDC.width = rBoundsDC.height;
            rBoundsDC.height = width;
            rBoundsDC.y = rBoundsDC.y + oldh / 2 - oldw / 2;
            rBoundsDC.x = rBoundsDC.x - oldh / 2 + oldw / 2;
        }
        int angle = 0;
        int cx = 0;
        int cy = 0;
        if (textStyle.getRotationAngle() == 270) {
            angle = 90;
            cx = rBoundsDC.x + rBoundsDC.width / 2;
            cy = rBoundsDC.y + rBoundsDC.height / 2;
        } else if (textStyle.getRotationAngle() == 90) {
            angle = 270;
            cx = rBoundsDC.x + rBoundsDC.width / 2;
            cy = rBoundsDC.y + rBoundsDC.height / 2;
        } else {
            int rotationAngle = textStyle.getRotationAngle();
            angle = 360 - rotationAngle;
            cx = rBoundsDC.x + rBoundsDC.width / 2;
            cy = rBoundsDC.y + rBoundsDC.height / 2;
        }
        String rotation = null;
        if (angle != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("rotate(");
            sb.append(angle);
            sb.append(',');
            sb.append(cx);
            sb.append(',');
            sb.append(cy);
            sb.append(')');
            rotation = sb.toString();
        }
        this.drawStyledText(id, textStyle, textColor, rotation, g, szText, rBoundsDC, dropShadowColor, dropShadowOffset, vc);
    }

    protected void drawStyledText(IdentObj id, TextStyleObj textStyleObj, Color textColor, Graphics gx, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc) throws IOException, Exception {
        this.drawStyledText(id, textStyleObj, textColor, null, gx, strText, rBoundsDC, dropShadowColor, dropShadowOffset, vc);
    }

    protected void drawStyledText(IdentObj id, TextStyleObj textStyleObj, Color textColor, String transform, Graphics gx, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc) throws IOException, Exception {
        int nFontSizeDC = textStyleObj.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(textStyleObj.getFontStyle());
        Font font = textStyleObj.getFont(textStyleObj.getFontName(), nStyle, nFontSizeDC);
        FontMetrics fm = gx.getFontMetrics(font);
        Vector<String> strLines = new Vector<String>();
        int nNumLines = 1;
        if (textStyleObj.getWordWrap()) {
            nNumLines = textStyleObj.extractLinesWordWrap(strText, strLines, rBoundsDC.width, fm, this.m_pfj.getFontMetricsResolver());
        } else {
            strLines.addElement(strText);
        }
        Dimension dimThisLineDC = new Dimension(0, 0);
        Rectangle rTextBoundsDC = new Rectangle(rBoundsDC.x, rBoundsDC.y, rBoundsDC.width, rBoundsDC.height);
        Dimension dimMaxDC = new Dimension(rTextBoundsDC.width, rTextBoundsDC.height);
        for (int nLine = 0; nLine < nNumLines; ++nLine) {
            String strThisLine = (String)strLines.elementAt(nLine);
            dimThisLineDC = textStyleObj.getTextSizeDC(gx, strThisLine, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, false, this.m_pfj.getFontMetricsResolver());
            Point ptTextDC = textStyleObj.alignTextInBox(nLine, nNumLines, fm, rTextBoundsDC, dimThisLineDC, this.m_pfj);
            if (dropShadowOffset != null) {
                Point ptDropShadow = new Point(ptTextDC.x + dropShadowOffset.width, ptTextDC.y + dropShadowOffset.height);
                Color color = gx.getColor();
                if (this.startTextElement(ptDropShadow.x, ptDropShadow.y)) {
                    this.writeFontAttributes(font);
                    this.writeAttribute("fill", dropShadowColor);
                    if (transform != null) {
                        this.writeAttribute("transform", transform);
                    }
                    if ((textStyleObj.getFontStyle() & 4) != 0) {
                        this.writeAttribute("text-decoration", "underline");
                    }
                    this.writeText(strThisLine, font);
                    this.endElement();
                } else if (this.m_eh != null) {
                    this.m_eh.log("could not start text element dropshadow", this.getClass().getName(), "protected void drawStyledText");
                }
            }
            if (textStyleObj.isDisplayDrillIcon()) {
                Image image = null;
                image = nFontSizeDC < 18 ? TextStyleObj.SMALL_DRILL_IMAGE : TextStyleObj.LARGE_DRILL_IMAGE;
                int imageSize = image.getWidth(null);
                if (nFontSizeDC < 18) {
                    this.writeSmallDrillUpArrow(rTextBoundsDC.x, rTextBoundsDC.y + (rTextBoundsDC.height - imageSize) / 2);
                } else {
                    this.writeLargeDrillUpArrow(rTextBoundsDC.x, rTextBoundsDC.y + (rTextBoundsDC.height - imageSize) / 2);
                }
                ptTextDC.x += imageSize + 2;
                dimThisLineDC.width -= imageSize + 2;
            }
            if (this.startTextElement(ptTextDC.x, ptTextDC.y)) {
                this.writeFontAttributes(font);
                this.writeAttribute("fill", textColor);
                if (transform != null) {
                    this.writeAttribute("transform", transform);
                }
                if ((textStyleObj.getFontStyle() & 4) != 0) {
                    this.writeAttribute("text-decoration", "underline");
                }
                this.writeText(strThisLine, font);
                this.endElement();
                continue;
            }
            if (this.m_eh == null) continue;
            this.m_eh.log("could not start text element", this.getClass().getName(), "protected void drawStyledText");
        }
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point2D a, Point2D b) throws IOException, Exception {
        boolean ret = false;
        if (!bb.getTransparentBorderColor() && (ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY()))) {
            this.writeAttribute("stroke", bb.getBorderColor());
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point2D a, Point2D b, int nThick, int style, boolean isMarker) throws IOException, Exception {
        boolean ret = false;
        double dashLen = 10.0;
        double dashOffset = 0.0;
        double miterLimit = 1.0;
        double[] dashArray = null;
        if (style != 0) {
            if (style == 1) {
                if (isMarker) {
                    dashArray = new double[]{4.0, 2.0, 4.0};
                    dashLen = 2.0;
                    nThick = 2;
                } else {
                    dashArray = new double[]{dashLen, dashLen / 2.0};
                }
                miterLimit = dashLen;
            } else if (style == 2) {
                if (isMarker) {
                    nThick = 2;
                }
                if (nThick <= 1) {
                    nThick = 2;
                }
                dashArray = new double[]{nThick};
            } else if (style == 3) {
                if (isMarker) {
                    dashArray = new double[]{3.0, 1.0, 2.0, 1.0, 3.0};
                    nThick = 2;
                } else {
                    dashArray = new double[]{dashLen, dashLen / 2.0, nThick, dashLen / 2.0};
                }
            }
        }
        if (!bb.getTransparentBorderColor()) {
            ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY());
            if (ret) {
                this.writeAttribute("stroke", bb.getBorderColor());
            }
        } else if (!bb.getTransparentFillColor() && (ret = a instanceof Point && b instanceof Point ? this.startLineElement(((Point)a).x, ((Point)a).y, ((Point)b).x, ((Point)b).y) : this.startLineElement(a.getX(), a.getY(), b.getX(), b.getY()))) {
            this.writeAttribute("stroke", bb.getFillColor());
        }
        if (ret) {
            if (nThick != 1) {
                this.writeAttribute("stroke-width", nThick);
            }
            if (dashArray != null) {
                this.writeAttribute("fill", "none");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < dashArray.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(dashArray[i]);
                }
                this.writeAttribute("stroke-dasharray", sb.toString());
            }
            if (dashOffset != 0.0) {
                this.writeAttribute("stroke-dashoffset", dashOffset);
            }
            if (miterLimit != 4.0) {
                this.writeAttribute("stroke-miterlimit", miterLimit);
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point[] points) throws IOException, Exception {
        boolean ret = false;
        if (!bb.getTransparentBorderColor() && (ret = this.startPolylineElement(points))) {
            this.writeAttribute("stroke", bb.getBorderColor());
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Point[] points, int nThick, int style, boolean isMarker, boolean shadow) throws IOException, Exception {
        Color c;
        boolean ret = false;
        double dashLen = 10.0;
        double dashOffset = 0.0;
        double miterLimit = 1.0;
        double[] dashArray = null;
        if (style != 0) {
            if (style == 1) {
                if (isMarker) {
                    dashArray = new double[]{4.0, 2.0, 4.0};
                    dashLen = 2.0;
                    nThick = 2;
                } else {
                    dashArray = new double[]{dashLen, dashLen / 2.0};
                }
                miterLimit = dashLen;
            } else if (style == 2) {
                if (isMarker) {
                    nThick = 2;
                }
                if (nThick <= 1) {
                    nThick = 2;
                }
                dashArray = new double[]{nThick};
            } else if (style == 3) {
                if (isMarker) {
                    dashArray = new double[]{3.0, 1.0, 2.0, 1.0, 3.0};
                    nThick = 2;
                } else {
                    dashArray = new double[]{dashLen, dashLen / 2.0, nThick, dashLen / 2.0};
                }
            }
        }
        if (!bb.getTransparentBorderColor()) {
            ret = this.startPolylineElement(points);
            if (ret) {
                c = shadow ? GraphSVGWriter.getBrighter(bb.getBorderColor()) : bb.getBorderColor();
                this.writeAttribute("stroke", c);
            }
        } else if (!bb.getTransparentFillColor() && (ret = this.startPolylineElement(points))) {
            c = shadow ? GraphSVGWriter.getBrighter(bb.getFillColor()) : bb.getFillColor();
            this.writeAttribute("stroke", c);
        }
        if (ret) {
            if (nThick != 1) {
                this.writeAttribute("stroke-width", nThick);
            }
            if (dashArray != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < dashArray.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(dashArray[i]);
                }
                this.writeAttribute("stroke-dasharray", sb.toString());
            }
            if (dashOffset != 0.0) {
                this.writeAttribute("stroke-dashoffset", dashOffset);
            }
            if (miterLimit != 4.0) {
                this.writeAttribute("stroke-miterlimit", miterLimit);
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle rect, int type) throws IOException, Exception {
        boolean ret = false;
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (type == 2) {
            x1 = rect.x;
            y1 = rect.y + rect.height;
            x2 = rect.x + rect.width;
            y2 = y1;
        } else if (type == 1) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = x1 + rect.width;
            y2 = y1;
        } else if (type == 3) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = rect.x;
            y2 = rect.y + rect.height;
        } else if (type == 4) {
            x1 = rect.x + rect.width;
            y1 = rect.y;
            x2 = x1;
            y2 = rect.y + rect.height;
        }
        if (!bb.getTransparentBorderColor()) {
            ret = this.startLineElement(x1, y1, x2, y2);
            if (ret) {
                this.writeAttribute("stroke", bb.getBorderColor());
            }
        } else if (!bb.getTransparentFillColor() && (ret = this.startLineElement(x1, y1, x2, y2))) {
            this.writeAttribute("stroke", bb.getFillColor());
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r) throws IOException, Exception {
        return this.startElement(id, bb, r, false, false);
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill) throws IOException, Exception {
        return this.startElement(id, bb, r, bOval, bNoFill, false);
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill, boolean bDotted) throws IOException, Exception {
        boolean ret = false;
        if (bb.getDropShadowOffset() != null) {
            Rectangle rDropShadow = new Rectangle(r.x + bb.getDropShadowOffset().width, r.y + bb.getDropShadowOffset().height, r.width, r.height);
            if (bOval) {
                if (this.startCircleOrEllipseElement(rDropShadow)) {
                    this.writeAttribute("fill", bb.getDropShadowColor());
                    this.endElement();
                }
            } else if (this.startRectElement(rDropShadow)) {
                this.writeAttribute("fill", bb.getDropShadowColor());
                this.endElement();
            }
        }
        if (bOval) {
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            String fillAttr = null;
            if (!bTransparentFill) {
                fillAttr = this.calcFillAttribute(id, bb, r);
            }
            if (ret = this.startCircleOrEllipseElement(r)) {
                if (!bTransparentBorder) {
                    this.writeAttribute("stroke", bb.getBorderColor());
                }
                if (!bTransparentFill) {
                    this.writeAttribute("fill", fillAttr);
                    this.writeFillOpacityAttribute(bb);
                } else {
                    this.writeAttribute("fill", "none");
                }
                if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents()) {
                    this.writeAttribute("pointer-events", "visible");
                }
            }
        } else {
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            String fillAttr = null;
            if (!bTransparentFill) {
                fillAttr = this.calcFillAttribute(id, bb, r);
            }
            if (ret = this.startRectElement(r)) {
                if (!bTransparentFill) {
                    this.writeAttribute("fill", fillAttr);
                    this.writeFillOpacityAttribute(bb);
                } else {
                    this.writeAttribute("fill", "none");
                }
                if (!bTransparentBorder) {
                    this.writeAttribute("stroke", bb.getBorderColor());
                    if (bDotted) {
                        this.writeAttribute("stroke-dasharray", STROKE_DASHARRAY_DOTTED);
                    }
                }
                if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents()) {
                    this.writeAttribute("pointer-events", "visible");
                }
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Rectangle r, boolean bOval, boolean bNoFill, int nWidth) throws IOException, Exception {
        boolean ret = false;
        if (bOval) {
            boolean bTransparentFill = bb.getTransparentFillColor() || bNoFill;
            boolean bTransparentBorder = bb.getTransparentBorderColor();
            String fillAttr = null;
            if (!bTransparentFill) {
                fillAttr = this.calcFillAttribute(id, bb, r);
            }
            if (ret = this.startCircleOrEllipseElement(r)) {
                if (!bTransparentFill) {
                    this.writeAttribute("fill", fillAttr);
                    this.writeFillOpacityAttribute(bb);
                } else {
                    this.writeAttribute("fill", "none");
                }
                if (!bTransparentBorder) {
                    this.writeAttribute("stroke", bb.getBorderColor());
                    if (nWidth > 1) {
                        this.writeAttribute("stroke-width", nWidth);
                    }
                }
                if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents()) {
                    this.writeAttribute("pointer-events", "visible");
                }
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Polygon p) throws IOException, Exception {
        boolean ret = false;
        if (bb.getDropShadowOffset() != null) {
            Polygon pDropShadow = new Polygon();
            for (int i = 0; i < p.npoints; ++i) {
                pDropShadow.addPoint(p.xpoints[i] + bb.getDropShadowOffset().width, p.ypoints[i] + bb.getDropShadowOffset().height);
            }
            if (this.startPolygonElement(pDropShadow)) {
                this.writeAttribute("fill", bb.getDropShadowColor());
                this.endElement();
            }
        }
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        String fillAttr = null;
        if (!bTransparentFill) {
            fillAttr = this.calcFillAttribute(id, bb, p.getBounds());
        }
        if (ret = this.startPolygonElement(p)) {
            if (!bTransparentFill) {
                this.writeAttribute("fill", fillAttr);
                this.writeFillOpacityAttribute(bb);
            } else {
                this.writeAttribute("fill", "none");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("stroke", bb.getBorderColor());
            }
            if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents() && id.getObjectID() != 357) {
                this.writeAttribute("pointer-events", "visible");
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, GeneralPath path) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        String fillAttr = null;
        if (!bTransparentFill) {
            fillAttr = this.calcFillAttribute(id, bb, path.getBounds());
        }
        if (ret = this.startPathElement(path)) {
            if (!bTransparentFill) {
                this.writeAttribute("fill", fillAttr);
                this.writeFillOpacityAttribute(bb);
            } else {
                this.writeAttribute("fill", "none");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("stroke", bb.getBorderColor());
            }
            if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents()) {
                this.writeAttribute("pointer-events", "visible");
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, Area area) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        String fillAttr = null;
        if (!bTransparentFill) {
            fillAttr = this.calcFillAttribute(id, bb, area.getBounds());
        }
        if (ret = this.startPathElement(area)) {
            if (!bTransparentFill) {
                this.writeAttribute("fill", fillAttr);
                this.writeFillOpacityAttribute(bb);
            } else {
                this.writeAttribute("fill", "none");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("stroke", bb.getBorderColor());
            }
            if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents()) {
                this.writeAttribute("pointer-events", "visible");
            }
        }
        return ret;
    }

    public boolean startElement(IdentObj id, BlackBoxIF bb, RectangularShape shape) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        String fillAttr = null;
        if (!bTransparentFill) {
            fillAttr = this.calcFillAttribute(id, bb, shape.getBounds2D().getBounds());
        }
        if (ret = this.startPathElement(shape)) {
            if (!bTransparentFill) {
                this.writeAttribute("fill", fillAttr);
                this.writeFillOpacityAttribute(bb);
            } else {
                this.writeAttribute("fill", "none");
            }
            if (!bTransparentBorder) {
                this.writeAttribute("stroke", bb.getBorderColor());
            }
            if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents()) {
                this.writeAttribute("pointer-events", "visible");
            }
        }
        return ret;
    }

    private boolean startElement(IdentObj id, BlackBoxIF bb, Arc2D arc, Area fillArea) throws IOException, Exception {
        boolean ret = false;
        boolean bTransparentFill = bb.getTransparentFillColor();
        boolean bTransparentBorder = bb.getTransparentBorderColor();
        String fillAttr = null;
        if (!bTransparentFill) {
            if (arc != null) {
                fillAttr = this.calcFillAttribute(id, bb, arc.getBounds2D().getBounds());
            } else if (fillArea != null) {
                fillAttr = this.calcFillAttribute(id, bb, fillArea.getBounds());
            }
        }
        if (arc != null) {
            ret = this.startPathElement(arc);
        } else if (fillArea != null) {
            ret = this.startPathElement(fillArea);
        }
        if (ret) {
            if (fillArea != null) {
                if (!bTransparentFill) {
                    this.writeAttribute("fill", fillAttr);
                    this.writeFillOpacityAttribute(bb);
                } else {
                    this.writeAttribute("fill", "none");
                }
            }
            if (arc != null) {
                if (!bTransparentBorder) {
                    this.writeAttribute("stroke", bb.getBorderColor());
                    this.writeAttribute("fill", "none");
                }
                if ((bTransparentFill || bTransparentBorder) && this.isPointerEventsForTransparentComponents()) {
                    this.writeAttribute("pointer-events", "visible");
                }
            }
        }
        return ret;
    }

    public void writeSmallDrillUpArrow(int x, int y) throws IOException, Exception {
        this.startElement("g");
        if (x != 0 && y != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("translate(");
            sb.append(x);
            sb.append(',');
            sb.append(y);
            sb.append(')');
            this.writeAttribute("transform", sb.toString());
        }
        this.startElement("polygon");
        this.writeAttribute("points", "0,3 3,0 6,3");
        this.writeAttribute("fill", "#0000ce");
        this.endElement();
        this.startElement("polyline");
        this.writeAttribute("points", "3,3 3,7 6,7");
        this.writeAttribute("stroke", "#0000ce");
        this.writeAttribute("fill", "none");
        this.endElement();
        this.endElement();
    }

    public void writeLargeDrillUpArrow(int x, int y) throws IOException, Exception {
        this.startElement("polygon");
        this.writeAttribute("points", "3,5 7,1 11,5 8,5 8,11 12,11 12,13 6,13 6,5");
        this.writeAttribute("fill", "#0000ce");
        if (x != 0 && y != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("translate(");
            sb.append(x);
            sb.append(',');
            sb.append(y);
            sb.append(')');
            this.writeAttribute("transform", sb.toString());
        }
        this.endElement();
    }

    public String getDrillJS(DetObj detObj) {
        return null;
    }

    public String getLink(DetObj detObj) {
        return this.m_pfj.getLink(detObj);
    }

    public String getDrillTooltip(DetObj detObj) {
        return null;
    }

    public String getTimeAxisEventClickJS() {
        return "bi_timeAxisClick(evt, \"" + this.getBeanName() + "\", \"" + this.getSvgRootId() + "\")";
    }

    public String getLineSelectPointClickJS() {
        return "bi_lineSelectPoint(evt, \"" + this.getBeanName() + "\")";
    }

    public void writeTimeAxisEventScript() throws IOException, Exception {
        this.writeCommonScript();
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_time_axis_event");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_timeAxisClick(evt, srcID, nodeID)");
        this.println("{");
        this.println("  var svgRoot = document.getElementById(nodeID);");
        this.println("  var topSvgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  var point = bi_getUserPoint(svgRoot, bi_getClientX(evt, topSvgRoot), bi_getClientY(evt, topSvgRoot));");
        this.println("  var x = point.x;");
        String js = this.getTimeAxisEventSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("  " + js);
        }
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    public void writeLineSelectPointScript() throws IOException, Exception {
        this.writeCommonScript();
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_line_select_point");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_lineSelectPoint(evt, srcID)");
        this.println("{");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var point = bi_getUserPoint(evt.target, bi_getClientX(evt, svgRoot), bi_getClientY(evt, svgRoot));");
        this.println("    var x  = point.x;");
        this.println("    var y  = point.y;");
        String js = this.getLineSelectPointSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("  " + js);
        }
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    public List getReferenceObjects(IdentObj id) {
        ArrayList<String> list = new ArrayList<String>();
        int graphID = this.m_pfj.getReferenceObjectGraphID(id.getObjectID());
        if (graphID == -1) {
            return null;
        }
        if (this.m_pfj.m_referenceObjects != null) {
            for (int i = 0; i < this.m_pfj.m_referenceObjects.size(); ++i) {
                int series;
                IdentObj ro = (IdentObj)this.m_pfj.m_referenceObjects.get(i);
                if (this.m_pfj.getReferenceAssociation(ro) != graphID || graphID == 31 && (series = this.m_pfj.getReferenceSeries(ro).intValue()) != id.getSeriesID()) continue;
                list.add(this.getReferenceObjectId(ro.getMiscID()));
            }
            if (list.size() > 0) {
                return list;
            }
        }
        return null;
    }

    public String getReferenceObjectId(int index) {
        return this.getBeanName() + "_referenceObj_" + index;
    }

    protected String getSvgRootId() {
        return this.getBeanName() + "_svgRoot";
    }

    protected String getBISVGGraphObjName() {
        return "top." + this.getSimpleBeanName() + "_svg";
    }

    protected String getBITimeSelectorObjName() {
        return "top." + this.getFilteredBeanName() + "_timeSelObj";
    }

    public void writeDataZoomScript() throws IOException, Exception {
        if (this.m_bDataZoomScriptWritten) {
            return;
        }
        this.writeCommonScript();
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_data_zoom");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("var BI_SVG_MODE_DEFAULT = 0;");
        this.println("var BI_SVG_MODE_ZOOM = 1;");
        this.println("var bi_SVGMode = BI_SVG_MODE_DEFAULT;");
        this.println("var BI_ZOOM_RECT_PAD = 3;");
        this.println("var BI_ZD_B = 0;");
        this.println("var BI_ZD_H = 1;");
        this.println("var BI_ZD_V = 2;");
        this.println("function bi_setMode(mode, svgGraph)");
        this.println("{");
        this.println("  bi_SVGMode = mode;");
        this.println("  var zoomPane = document.getElementById(svgGraph.graphID + \"_biZoomPane\");");
        this.println("  if (mode == BI_SVG_MODE_DEFAULT)");
        this.println("  {");
        this.println("    if (zoomPane != null)");
        this.println("      zoomPane.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("  }");
        this.println("  else if (mode == BI_SVG_MODE_ZOOM)");
        this.println("  {");
        this.println("    if (zoomPane == null)");
        this.println("      zoomPane = bi_createZoomPane(svgGraph);");
        this.println("    zoomPane.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("  }");
        this.println("}");
        this.println("function bi_getMode()");
        this.println("{");
        this.println("  return bi_SVGMode;");
        this.println("}");
        this.println("function bi_createZoomPane(svgGraph)");
        this.println("{");
        this.println("  var svgRoot = document.getElementById(svgGraph.svgRootID);");
        this.println("  var zoomPane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  zoomPane.setAttributeNS(null, \"id\", svgGraph.graphID + \"_biZoomPane\");");
        this.println("  var x = 0;");
        this.println("  var y = 0;");
        this.println("  zoomPane.setAttributeNS(null, \"x\", x);");
        this.println("  zoomPane.setAttributeNS(null, \"y\", y);");
        this.println("  zoomPane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  zoomPane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  zoomPane.setAttributeNS(null, \"onmousedown\", \"bi_zoomMouseDown(evt, \" + svgGraph.objName + \")\");");
        this.println("  zoomPane.setAttributeNS(null, \"onmouseup\", \"bi_zoomMouseUp(evt, \" + svgGraph.objName + \")\");");
        this.println("  zoomPane.setAttributeNS(null, \"onmousemove\", \"bi_zoomMouseMove(evt, \" + svgGraph.objName + \")\");");
        this.println("  zoomPane.setAttributeNS(null, \"onmouseout\", \"bi_zoomMouseOut(evt)\");");
        this.println("  zoomPane.setAttributeNS(null, \"onclick\", \"bi_zoomClick(evt, \" + svgGraph.objName + \")\");");
        this.println("  var width = svgRoot.getAttributeNS(null, \"width\");");
        this.println("  var height = svgRoot.getAttributeNS(null, \"height\");");
        this.println("  zoomPane.setAttributeNS(null, \"width\", width);");
        this.println("  zoomPane.setAttributeNS(null, \"height\", height);");
        this.println("  svgRoot.appendChild(zoomPane);");
        this.println("  return zoomPane;");
        this.println("}");
        this.println("function bi_showZoomRect(pnode, evt, svgGraph)");
        this.println("{");
        this.println("  var zoomRect = document.getElementById(svgGraph.graphID + \"_biZoomRect\");");
        this.println("  if (zoomRect != null)");
        this.println("  {");
        this.println("    var x = 0;");
        this.println("    var y = 0;");
        this.println("    var svgRoot = bi_findTopSVGRoot(zoomRect);");
        this.println("    var point = bi_getUserPoint(zoomRect, bi_getClientX(evt, svgRoot), bi_getClientY(evt, svgRoot));");
        this.println("    if (svgGraph.zoomDir == BI_ZD_V)");
        this.println("      x = bi_getMinZoomRectX(svgGraph);");
        this.println("    else");
        this.println("      x = bi_constrainZoomRectX(point.x, svgGraph);");
        this.println("    if (svgGraph.zoomDir == BI_ZD_H)");
        this.println("      y = bi_getMinZoomRectY(svgGraph);");
        this.println("    else");
        this.println("      y = bi_constrainZoomRectY(point.y, svgGraph);");
        this.println("    zoomRect.setAttributeNS(null, \"x\", x);");
        this.println("    zoomRect.setAttributeNS(null, \"y\", y);");
        this.println("    zoomRect.setAttributeNS(null, \"width\", 0);");
        this.println("    zoomRect.setAttributeNS(null, \"height\", 0);");
        this.println("    zoomRect.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("  }");
        this.println("  else");
        this.println("    zoomRect = bi_createZoomRect(pnode, evt, svgGraph);");
        this.println("}");
        this.println("function bi_getMinZoomRectX(svgGraph)");
        this.println("{");
        this.println("  return (svgGraph.plotAreaRect[0] - BI_ZOOM_RECT_PAD);");
        this.println("}");
        this.println("function bi_getMinZoomRectY(svgGraph)");
        this.println("{");
        this.println("  return (svgGraph.plotAreaRect[1] - BI_ZOOM_RECT_PAD);");
        this.println("}");
        this.println("function bi_getMaxZoomRectX(svgGraph)");
        this.println("{");
        this.println("  return (svgGraph.plotAreaRect[0] + svgGraph.plotAreaRect[2] + BI_ZOOM_RECT_PAD);");
        this.println("}");
        this.println("function bi_getMaxZoomRectY(svgGraph)");
        this.println("{");
        this.println("  return (svgGraph.plotAreaRect[1] + svgGraph.plotAreaRect[3] + BI_ZOOM_RECT_PAD);");
        this.println("}");
        this.println("function bi_constrainZoomRectX(x, svgGraph)");
        this.println("{");
        this.println("  var newX = x;");
        this.println("  if (x < svgGraph.plotAreaRect[0] - BI_ZOOM_RECT_PAD)");
        this.println("    newX = svgGraph.plotAreaRect[0] - BI_ZOOM_RECT_PAD;");
        this.println("  if (x > svgGraph.plotAreaRect[0] + svgGraph.plotAreaRect[2] + BI_ZOOM_RECT_PAD)");
        this.println("    newX = svgGraph.plotAreaRect[0] + svgGraph.plotAreaRect[2] + BI_ZOOM_RECT_PAD;");
        this.println("  return newX;");
        this.println("}");
        this.println("function bi_constrainZoomRectY(y, svgGraph)");
        this.println("{");
        this.println("  var newY = y;");
        this.println("  if (y < svgGraph.plotAreaRect[1] - BI_ZOOM_RECT_PAD)");
        this.println("    newY = svgGraph.plotAreaRect[1] - BI_ZOOM_RECT_PAD;");
        this.println("  if (y > svgGraph.plotAreaRect[1] + svgGraph.plotAreaRect[3] + BI_ZOOM_RECT_PAD)");
        this.println("    newY = svgGraph.plotAreaRect[1] + svgGraph.plotAreaRect[3] + BI_ZOOM_RECT_PAD;");
        this.println("  return newY;");
        this.println("}");
        this.println("function bi_createZoomRect(pnode, evt, svgGraph)");
        this.println("{");
        this.println("  var rectElem = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  rectElem.setAttributeNS(null, \"id\", svgGraph.graphID + \"_biZoomRect\");");
        this.println("  var x = 0;");
        this.println("  var y = 0;");
        this.println("  var svgRoot = bi_findTopSVGRoot(pnode);");
        this.println("  var point = bi_getUserPoint(pnode, bi_getClientX(evt, svgRoot), bi_getClientY(evt, svgRoot));");
        this.println("  if (svgGraph.zoomDir == BI_ZD_V)");
        this.println("    x = bi_getMinZoomRectX(svgGraph);");
        this.println("  else");
        this.println("    x = bi_constrainZoomRectX(point.x, svgGraph);");
        this.println("  if (svgGraph.zoomDir == BI_ZD_H)");
        this.println("    y = bi_getMinZoomRectY(svgGraph);");
        this.println("  else");
        this.println("    y = bi_constrainZoomRectY(point.y, svgGraph);");
        this.println("  rectElem.setAttributeNS(null, \"x\", x);");
        this.println("  rectElem.setAttributeNS(null, \"y\", y);");
        this.println("  rectElem.setAttributeNS(null, \"width\", 0);");
        this.println("  rectElem.setAttributeNS(null, \"height\", 0);");
        this.println("  rectElem.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  rectElem.setAttributeNS(null, \"stroke\", \"blue\");");
        this.println("  rectElem.setAttributeNS(null, \"stroke-dasharray\", \"1\");");
        this.println("  rectElem.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  pnode.appendChild(rectElem);");
        this.println("}");
        this.println("function bi_zoomMouseDown(evt, svgGraph)");
        this.println("{");
        this.println("  if (bi_SVGMode == BI_SVG_MODE_ZOOM)");
        this.println("  {");
        this.println("    bi_bMouseDown = true;");
        this.println("    var svgRoot = document.getElementById(svgGraph.svgRootID);");
        this.println("    var topSvgRoot = bi_findTopSVGRoot(svgRoot);");
        this.println("    var point = bi_getUserPoint(svgRoot, bi_getClientX(evt, topSvgRoot), bi_getClientY(evt, topSvgRoot));");
        this.println("    if (svgGraph.zoomDir == BI_ZD_V)");
        this.println("      bi_mouseDownX = bi_getMinZoomRectX(svgGraph);");
        this.println("    else");
        this.println("      bi_mouseDownX = bi_constrainZoomRectX(point.x, svgGraph);");
        this.println("    if (svgGraph.zoomDir == BI_ZD_H)");
        this.println("      bi_mouseDownY = bi_getMinZoomRectY(svgGraph);");
        this.println("    else");
        this.println("      bi_mouseDownY = bi_constrainZoomRectY(point.y, svgGraph);");
        this.println("    bi_showZoomRect(svgRoot, evt, svgGraph);");
        this.println("  }");
        this.println("}");
        this.println("function bi_zoomMouseOut(evt)");
        this.println("{");
        this.println("  bi_hideZoomCursor();");
        this.println("}");
        this.println("function bi_zoomMouseUp(evt, svgGraph)");
        this.println("{");
        this.println("  if (bi_SVGMode == BI_SVG_MODE_ZOOM)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    var zoomRect = document.getElementById(svgGraph.graphID + \"_biZoomRect\");");
        this.println("    if (zoomRect != null)");
        this.println("    {");
        this.println("      var x = zoomRect.getAttributeNS(null, \"x\");");
        this.println("      var y = zoomRect.getAttributeNS(null, \"y\");");
        this.println("      var width = zoomRect.getAttributeNS(null, \"width\");");
        this.println("      var height = zoomRect.getAttributeNS(null, \"height\");");
        this.println("      zoomRect.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("      if (width == 0 && height == 0)");
        this.println("        return;");
        this.println("      if (!evt.shiftKey)");
        this.println("      {");
        String js = this.getDataZoomInRectSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("        " + js);
        }
        this.println("      }");
        this.println("      else");
        this.println("      {");
        js = this.getDataZoomOutRectSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("        " + js);
        }
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_zoomClick(evt, svgGraph)");
        this.println("{");
        this.println("  if (bi_SVGMode == BI_SVG_MODE_ZOOM)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    var svgRoot = document.getElementById(svgGraph.svgRootID);");
        this.println("    var topSvgRoot = bi_findTopSVGRoot(svgRoot);");
        this.println("    var point = bi_getUserPoint(svgRoot, bi_getClientX(evt, topSvgRoot), bi_getClientY(evt, topSvgRoot));");
        this.println("    var x = point.x;");
        this.println("    var y = point.y;");
        this.println("    if (!evt.shiftKey)");
        this.println("    {");
        js = this.getDataZoomInClickSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("      " + js);
        }
        this.println("    }");
        this.println("    else");
        this.println("    {");
        js = this.getDataZoomOutClickSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("      " + js);
        }
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_zoomMouseMove(evt, svgGraph)");
        this.println("{");
        this.println("  if (bi_SVGMode == BI_SVG_MODE_ZOOM)");
        this.println("  {");
        this.println("    bi_updateZoomCursor(evt);");
        this.println("    if (bi_bMouseDown)");
        this.println("    {");
        this.println("      var zoomRect = document.getElementById(svgGraph.graphID + \"_biZoomRect\");");
        this.println("      if (zoomRect != null)");
        this.println("      {");
        this.println("        var svgRoot = document.getElementById(svgGraph.svgRootID);");
        this.println("        var topSvgRoot = bi_findTopSVGRoot(svgRoot);");
        this.println("        var point = bi_getUserPoint(zoomRect, bi_getClientX(evt, topSvgRoot), bi_getClientY(evt, topSvgRoot));");
        this.println("        var x = bi_constrainZoomRectX(point.x, svgGraph);");
        this.println("        var y = bi_constrainZoomRectY(point.y, svgGraph);");
        this.println("        if (svgGraph.zoomDir == BI_ZD_V)");
        this.println("        {");
        this.println("          x = bi_getMaxZoomRectX(svgGraph);");
        this.println("        }");
        this.println("        else");
        this.println("        {");
        this.println("          if (bi_mouseDownX <= svgGraph.plotAreaRect[0] && x <= svgGraph.plotAreaRect[0])");
        this.println("            x = bi_getMaxZoomRectX(svgGraph);");
        this.println("          if (bi_mouseDownX >= svgGraph.plotAreaRect[0] + svgGraph.plotAreaRect[2] && x >= svgGraph.plotAreaRect[0] + svgGraph.plotAreaRect[2])");
        this.println("            x = bi_getMinZoomRectX(svgGraph);");
        this.println("        }");
        this.println("        if (svgGraph.zoomDir == BI_ZD_H)");
        this.println("        {");
        this.println("          y = bi_getMaxZoomRectY(svgGraph);");
        this.println("        }");
        this.println("        else");
        this.println("        {");
        this.println("          if (bi_mouseDownY <= svgGraph.plotAreaRect[1] && y <= svgGraph.plotAreaRect[1])");
        this.println("            y = bi_getMaxZoomRectY(svgGraph);");
        this.println("          if (bi_mouseDownY >= svgGraph.plotAreaRect[1] + svgGraph.plotAreaRect[3] && y >= svgGraph.plotAreaRect[1] + svgGraph.plotAreaRect[3])");
        this.println("            y = bi_getMinZoomRectY(svgGraph);");
        this.println("        }");
        this.println("        if (x > bi_mouseDownX)");
        this.println("          zoomRect.setAttributeNS(null, \"width\", x - bi_mouseDownX);");
        this.println("        else");
        this.println("        {");
        this.println("          var width = bi_mouseDownX - x;");
        this.println("          zoomRect.setAttributeNS(null, \"x\", x);");
        this.println("          zoomRect.setAttributeNS(null, \"width\", width);");
        this.println("        }");
        this.println("        if (y > bi_mouseDownY)");
        this.println("          zoomRect.setAttributeNS(null, \"height\", y - bi_mouseDownY);");
        this.println("        else");
        this.println("        {");
        this.println("          var height = bi_mouseDownY - y;");
        this.println("          zoomRect.setAttributeNS(null, \"y\", y);");
        this.println("          zoomRect.setAttributeNS(null, \"height\", height);");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_createZoomInCursor(pnode)");
        this.println("{");
        this.println("  var groupElem = document.createElementNS(bi_svgNS, \"g\");");
        this.println("  groupElem.setAttributeNS(null, \"id\", \"biZoomInCursor\");");
        this.println("  groupElem.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  groupElem.setAttributeNS(null, \"fill\", \"white\");");
        this.println("  groupElem.setAttributeNS(null, \"stroke\", \"black\");");
        this.println("  bi_createZoomDirCursor(groupElem, \"in\");");
        this.println("  pnode.appendChild(groupElem);");
        this.println("  return groupElem;");
        this.println("}");
        this.println("function bi_createZoomOutCursor(pnode)");
        this.println("{");
        this.println("  var groupElem = document.createElementNS(bi_svgNS, \"g\");");
        this.println("  groupElem.setAttributeNS(null, \"id\", \"biZoomOutCursor\");");
        this.println("  groupElem.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  groupElem.setAttributeNS(null, \"fill\", \"white\");");
        this.println("  groupElem.setAttributeNS(null, \"stroke\", \"black\");");
        this.println("  bi_createZoomDirCursor(groupElem, \"out\");");
        this.println("  pnode.appendChild(groupElem);");
        this.println("  return groupElem;");
        this.println("}");
        this.println("function bi_updateZoomCursor(evt)");
        this.println("{");
        this.println("  if (bi_SVGMode == BI_SVG_MODE_ZOOM)");
        this.println("  {");
        this.println("    var usedCursor = null;");
        this.println("    var unusedCursor = null;");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    if (!evt.shiftKey)");
        this.println("    {");
        this.println("      usedCursor = document.getElementById(\"biZoomInCursor\");");
        this.println("      if (usedCursor == null)");
        this.println("        usedCursor = bi_createZoomInCursor(svgRoot);");
        this.println("      unusedCursor = document.getElementById(\"biZoomOutCursor\");");
        this.println("    }");
        this.println("    else");
        this.println("    {");
        this.println("      usedCursor = document.getElementById(\"biZoomOutCursor\");");
        this.println("      if (usedCursor == null)");
        this.println("        usedCursor = bi_createZoomOutCursor(svgRoot);");
        this.println("      unusedCursor = document.getElementById(\"biZoomInCursor\");");
        this.println("    }");
        this.println("    usedCursor.setAttributeNS(null, \"transform\", \"translate(\" + (bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target) + 13) + \", \" + (bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target) + 10) + \")\");");
        this.println("    usedCursor.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("    if (unusedCursor != null)");
        this.println("      unusedCursor.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("  }");
        this.println("}");
        this.println("function bi_createZoomDirCursor(pnode, dir)");
        this.println("{");
        this.println("  var circleElem = document.createElementNS(bi_svgNS, \"circle\");");
        this.println("  circleElem.setAttributeNS(null, \"cx\", 6);");
        this.println("  circleElem.setAttributeNS(null, \"cy\", 6);");
        this.println("  circleElem.setAttributeNS(null, \"r\", 6);");
        this.println("  pnode.appendChild(circleElem);");
        this.println("  var hLineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  hLineElem.setAttributeNS(null, \"x1\", 2);");
        this.println("  hLineElem.setAttributeNS(null, \"y1\", 6);");
        this.println("  hLineElem.setAttributeNS(null, \"x2\", 10);");
        this.println("  hLineElem.setAttributeNS(null, \"y2\", 6);");
        this.println("  pnode.appendChild(hLineElem);");
        this.println("  if (dir == \"in\")");
        this.println("  {");
        this.println("    var vLineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("    vLineElem.setAttributeNS(null, \"x1\", 6);");
        this.println("    vLineElem.setAttributeNS(null, \"y1\", 2);");
        this.println("    vLineElem.setAttributeNS(null, \"x2\", 6);");
        this.println("    vLineElem.setAttributeNS(null, \"y2\", 10);");
        this.println("    pnode.appendChild(vLineElem);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hideZoomCursor()");
        this.println("{");
        this.println("  if (bi_SVGMode == BI_SVG_MODE_ZOOM)");
        this.println("  {");
        this.println("    var zoomInGroup = document.getElementById(\"biZoomInCursor\");");
        this.println("    if (zoomInGroup != null)");
        this.println("      zoomInGroup.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("    var zoomOutGroup = document.getElementById(\"biZoomOutCursor\");");
        this.println("    if (zoomOutGroup != null)");
        this.println("      zoomOutGroup.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("  }");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bDataZoomScriptWritten = true;
    }

    @Override
    public String getBeanName() {
        if (this.m_id != null) {
            return this.m_id;
        }
        return "bigraph1";
    }

    protected String getDataZoomInRectSubmitJS() {
        return null;
    }

    protected String getDataZoomOutRectSubmitJS() {
        return null;
    }

    protected String getDataZoomInClickSubmitJS() {
        return null;
    }

    protected String getTimeAxisEventSubmitJS() {
        return null;
    }

    protected String getLineSelectPointSubmitJS() {
        return null;
    }

    protected String getDataZoomOutClickSubmitJS() {
        return null;
    }

    protected String getDataZoomInButtonSubmitJS(String axis) {
        return null;
    }

    protected String getDataZoomOutButtonSubmitJS(String axis) {
        return null;
    }

    public String getClickEventJS() {
        return null;
    }

    public boolean isOnClickPresent() {
        return false;
    }

    public boolean isOnMouseOverOutPresent() {
        return false;
    }

    public String getShapeAttributesAlt() {
        return null;
    }

    public String getShapeAttributesTitle() {
        return null;
    }

    public String getShapeAttributesHRef() {
        return null;
    }

    public String getShapeAttributesTarget() {
        return null;
    }

    public void writeShapeAttributes() throws IOException, Exception {
    }

    public void writeShapeAttributesScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_shape_attributes");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_onClick(evt, snglClick, dblClick)");
        this.println("{");
        this.println("  if ((evt.detail == 2) && (dblClick != null))");
        this.println("    eval(dblClick);");
        this.println("  else");
        this.println("  {");
        this.println("    if (snglClick != null)");
        this.println("      eval(snglClick);");
        this.println("  }");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    public void writeRolloverBehaviorScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_series_rollover_behavior");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("var RB_NONE=0;");
        this.println("var RB_HIGHLIGHT=1;");
        this.println("var RB_DIM=2;");
        this.println("var _RB_DELAY=50;");
        this.println("function bi_dimElement(elem)");
        this.println("{");
        this.println("  var elemId = elem.id+\";Dim\";");
        this.println("  var dimElem = document.getElementById(elemId);");
        this.println("  if (dimElem == null)");
        this.println("  {");
        this.println("    dimElem = document.createElementNS(bi_svgNS, \"animate\");");
        this.println("    dimElem.setAttributeNS(null, \"id\", elemId);");
        this.println("    dimElem.setAttributeNS(null, \"attributeName\", \"opacity\");");
        this.println("    dimElem.setAttributeNS(null, \"from\", \"1\");");
        this.println("    dimElem.setAttributeNS(null, \"to\", \"0.5\");");
        this.println("    dimElem.setAttributeNS(null, \"begin\", \"indefinite\");");
        this.println("    dimElem.setAttributeNS(null, \"end\", \"indefinite\");");
        this.println("    dimElem.setAttributeNS(null, \"dur\", \"0.25s\");");
        this.println("    dimElem.setAttributeNS(null, \"fill\", \"freeze\");");
        this.println("    dimElem.setAttributeNS(null, \"restart\", \"whenNotActive\");");
        this.println("    elem.appendChild(dimElem);");
        this.println("    setTimeout('document.getElementById(\"' + elemId + '\").beginElement()', _RB_DELAY);");
        this.println("  }");
        this.println("  else");
        this.println("    dimElem.beginElement();");
        this.println("}");
        this.println("function bi_undimElement(elem)");
        this.println("{");
        this.println("  var elemId = elem.id+\";Undim\";");
        this.println("  var undimElem = document.getElementById(elemId);");
        this.println("  if (undimElem == null)");
        this.println("  {");
        this.println("    undimElem = document.createElementNS(bi_svgNS, \"animate\");");
        this.println("    undimElem.setAttributeNS(null, \"id\", elemId);");
        this.println("    undimElem.setAttributeNS(null, \"attributeName\", \"opacity\");");
        this.println("    undimElem.setAttributeNS(null, \"from\", \"0.5\");");
        this.println("    undimElem.setAttributeNS(null, \"to\", \"1\");");
        this.println("    undimElem.setAttributeNS(null, \"begin\", \"indefinite\");");
        this.println("    undimElem.setAttributeNS(null, \"end\", \"indefinite\");");
        this.println("    undimElem.setAttributeNS(null, \"dur\", \"0.25s\");");
        this.println("    undimElem.setAttributeNS(null, \"fill\", \"freeze\");");
        this.println("    undimElem.setAttributeNS(null, \"restart\", \"whenNotActive\");");
        this.println("    elem.appendChild(undimElem);");
        this.println("    setTimeout('document.getElementById(\"' + elemId + '\").beginElement()', _RB_DELAY);");
        this.println("  }");
        this.println("  else");
        this.println("    undimElem.beginElement();");
        this.println("}");
        this.println("function bi_highlightElement(elem)");
        this.println("{");
        this.println("  var elemId = elem.id+\";Highlight\";");
        this.println("  var animElem = document.getElementById(elemId);");
        this.println("  if (animElem == null)");
        this.println("  {");
        this.println("    animElem = document.createElementNS(bi_svgNS, \"animate\");");
        this.println("    animElem.setAttributeNS(null, \"id\", elemId);");
        this.println("    animElem.setAttributeNS(null, \"attributeName\", \"stroke-width\");");
        this.println("    animElem.setAttributeNS(null, \"from\", \"1\");");
        this.println("    animElem.setAttributeNS(null, \"to\", \"3\");");
        this.println("    animElem.setAttributeNS(null, \"begin\", \"indefinite\");");
        this.println("    animElem.setAttributeNS(null, \"end\", \"indefinite\");");
        this.println("    animElem.setAttributeNS(null, \"dur\", \"0.25s\");");
        this.println("    animElem.setAttributeNS(null, \"fill\", \"freeze\");");
        this.println("    animElem.setAttributeNS(null, \"restart\", \"whenNotActive\");");
        this.println("    elem.appendChild(animElem);");
        this.println("    setTimeout('document.getElementById(\"' + elemId + '\").beginElement()', _RB_DELAY);");
        this.println("  }");
        this.println("  else");
        this.println("    animElem.beginElement();");
        this.println("}");
        this.println("function bi_unhighlightElement(elem)");
        this.println("{");
        this.println("  var elemId = elem.id+\";Unhighlight\";");
        this.println("  var animElem = document.getElementById(elemId);");
        this.println("  if (animElem == null)");
        this.println("  {");
        this.println("    animElem = document.createElementNS(bi_svgNS, \"animate\");");
        this.println("    animElem.setAttributeNS(null, \"id\", elemId);");
        this.println("    animElem.setAttributeNS(null, \"attributeName\", \"stroke-width\");");
        this.println("    animElem.setAttributeNS(null, \"from\", \"3\");");
        this.println("    animElem.setAttributeNS(null, \"to\", \"1\");");
        this.println("    animElem.setAttributeNS(null, \"begin\", \"indefinite\");");
        this.println("    animElem.setAttributeNS(null, \"end\", \"indefinite\");");
        this.println("    animElem.setAttributeNS(null, \"dur\", \"0.25s\");");
        this.println("    animElem.setAttributeNS(null, \"fill\", \"freeze\");");
        this.println("    animElem.setAttributeNS(null, \"restart\", \"whenNotActive\");");
        this.println("    elem.appendChild(animElem);");
        this.println("    setTimeout('document.getElementById(\"' + elemId + '\").beginElement()', _RB_DELAY);");
        this.println("  }");
        this.println("  else");
        this.println("    animElem.beginElement();");
        this.println("}");
        this.println("function bi_highlightGroup(groupId, series, rbMode)");
        this.println("{");
        this.println("  var elems = document.getElementById(groupId);");
        this.println("  bi_highlightGroupByNode(elems, series, rbMode);");
        this.println("}");
        this.println("function bi_highlightGroupByNode(elems, series, rbMode)");
        this.println("{");
        this.println("  if (elems != null)");
        this.println("  {");
        this.println("    var children = elems.childNodes;");
        this.println("    for (var i = 0; i <children.length; i++)");
        this.println("    {");
        this.println("      if (children.item(i).nodeType == 1 && ");
        this.println("          children.item(i).nodeName == \"g\")");
        this.println("      {");
        this.println("        // Cover children recursively");
        this.println("        if (children.item(i).hasChildNodes())");
        this.println("          bi_highlightGroupByNode(children.item(i), series, rbMode);");
        this.println("        var dmSeries = biGetTokenFromId(children.item(i), TOKEN_SERIES);");
        this.println("        if ((rbMode & RB_DIM) != 0 && dmSeries != null && dmSeries != series)");
        this.println("        {");
        this.println("          var undimElem = document.getElementById(children.item(i).id+\";Undim\");");
        this.println("          if (undimElem != null)");
        this.println("            undimElem.endElement();");
        this.println("          bi_dimElement(children.item(i));");
        this.println("        }");
        this.println("        if ((rbMode & RB_HIGHLIGHT) != 0 && dmSeries != null && dmSeries == series)");
        this.println("        {");
        this.println("          var unhighlightElem = document.getElementById(children.item(i).id+\";Unhighlight\");");
        this.println("          if (unhighlightElem != null)");
        this.println("            unhighlightElem.endElement();");
        this.println("          bi_highlightElement(children.item(i));");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_unhighlightGroup(groupId, series, rbMode)");
        this.println("{");
        this.println("  var elems = document.getElementById(groupId);");
        this.println("  bi_unhighlightGroupByNode(elems, series, rbMode);");
        this.println("}");
        this.println("function bi_unhighlightGroupByNode(elems, series, rbMode)");
        this.println("{");
        this.println("  if (elems != null)");
        this.println("  {");
        this.println("    var children = elems.childNodes;");
        this.println("    for (var i = 0; i <children.length; i++)");
        this.println("    {");
        this.println("      if (children.item(i).nodeType == 1 && ");
        this.println("          children.item(i).nodeName == \"g\")");
        this.println("      {");
        this.println("        // Cover children recursively");
        this.println("        if (children.item(i).hasChildNodes())");
        this.println("          bi_unhighlightGroupByNode(children.item(i), series, rbMode);");
        this.println("        var dmSeries = biGetTokenFromId(children.item(i), TOKEN_SERIES);");
        this.println("        if ((rbMode & RB_DIM) != 0 && dmSeries != null && dmSeries != series)");
        this.println("        {");
        this.println("          var dimElem = document.getElementById(children.item(i).id+\";Dim\");");
        this.println("          if (dimElem != null)");
        this.println("            dimElem.endElement();");
        this.println("          bi_undimElement(children.item(i));");
        this.println("        }");
        this.println("        if ((rbMode & RB_HIGHLIGHT) != 0 && dmSeries != null && dmSeries == series)");
        this.println("        {");
        this.println("          var highlightElem = document.getElementById(children.item(i).id+\";Highlight\");");
        this.println("          if (highlightElem != null)");
        this.println("            highlightElem.endElement();");
        this.println("          bi_unhighlightElement(children.item(i));");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_rollover(evt, begin, baseId)");
        this.println("{");
        this.println("  // Get group in which this element belongs");
        this.println("  //  and that has metadata in its ID");
        this.println("  var gNode = evt.target;");
        this.println("  var currSeries = null;");
        this.println("  while (currSeries == null)");
        this.println("  {");
        this.println("    currSeries = biGetTokenFromId(gNode, TOKEN_SERIES);");
        this.println("    if (currSeries != null)");
        this.println("      break;");
        this.println("    gNode = gNode.parentNode;");
        this.println("  }");
        this.println("  var rbMode = biGetMetadataAttribute(baseId, \"seriesRolloverBehavior\");");
        this.println("  var root = bi_findSVGRoot(gNode);");
        this.println("  var rootId = root.getAttributeNS(null, \"id\");");
        this.println("  if (begin)");
        this.println("    bi_highlightGroup(rootId, currSeries, rbMode);");
        this.println("  else bi_unhighlightGroup(rootId, currSeries, rbMode);");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    public void writeMetadataScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_metadata");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("var TOKEN_DELIMITER = \";\";");
        this.println("var NODE_METADATA = \"metadata\";");
        this.println("var NODE_GRAPH = \"Graph\";");
        this.println("var NODE_GAUGE = \"Gauge\";");
        this.println("var TOKEN_SERIES = \"s\";");
        this.println("var TOKEN_GROUP = \"g\";");
        this.println("function biGetMetadataNode(baseId)");
        this.println("{");
        this.println("  return document.getElementById(baseId + '_metadata');");
        this.println("}");
        this.println("function biGetMetadataAttribute(baseId, attrName)");
        this.println("{");
        this.println("  var mNode = biGetMetadataNode(baseId);");
        this.println("  var children = mNode.childNodes;");
        this.println("  var imgViewNode;");
        this.println("  for (var i = 0; i < children.length; i++)");
        this.println("  {");
        this.println("    imgViewNode = children.item(i);");
        this.println("    if (imgViewNode.nodeType == 1 && (imgViewNode.nodeName == NODE_GRAPH || imgViewNode.nodeName == NODE_GAUGE))");
        this.println("      break;");
        this.println("  }");
        this.println("  return imgViewNode.getAttributeNS(null, attrName);");
        this.println("}");
        this.println("function biGetTokenFromId(elem, name)");
        this.println("{");
        this.println("  var token;");
        this.println("  var id = elem.getAttributeNS(null, \"id\");");
        this.println("  var valueLoc = id.indexOf(name+\"=\");");
        this.println("  if (valueLoc > 0)");
        this.println("  {");
        this.println("    valueLoc = valueLoc + name.length + 1;");
        this.println("    var next = id.indexOf(TOKEN_DELIMITER, valueLoc);");
        this.println("    if (next == -1)");
        this.println("      next = id.length;");
        this.println("    token = id.substring(valueLoc, next);");
        this.println("    return token;");
        this.println("  }");
        this.println("  return null;");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    protected void setPointerEventsForTransparentComponents(boolean b) {
        this.m_bPointerEventsForTransparentComponents = b;
    }

    protected boolean isPointerEventsForTransparentComponents() {
        return this.m_bPointerEventsForTransparentComponents;
    }

    public boolean isDataScrollingSupported() {
        return false;
    }

    protected String getDataScrollSubmitJS() {
        return null;
    }

    protected void writeDataScrollbar(int axis, boolean bScrollbarVisible, boolean bZoomButtonsVisible) throws IOException, Exception {
        String jsID = null;
        String zoomAxisID = null;
        Axis2DObj axisObj = null;
        double autoMinVal = 0.0;
        double autoMaxVal = 0.0;
        boolean bAutoMin = false;
        boolean bAutoMax = false;
        int axisSide = 0;
        JChart_2D_Standard ch = (JChart_2D_Standard)this.m_pfj.getGraphObject();
        switch (axis) {
            case 2004: {
                jsID = this.getFilteredBeanName() + "_bi_y1Scr";
                zoomAxisID = "Y1";
                axisObj = (Axis2DObj)ch.m_Y1Axis;
                bAutoMin = this.m_pfj.getY1ScaleMinAuto();
                bAutoMax = this.m_pfj.getY1ScaleMaxAuto();
                autoMinVal = this.m_pfj.getY1ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getY1ScaleMaxAutoValue();
                axisSide = this.m_pfj.getY1AxisSide();
                break;
            }
            case 2005: {
                jsID = this.getFilteredBeanName() + "_bi_y2Scr";
                zoomAxisID = "Y2";
                axisObj = (Axis2DObj)ch.m_Y2Axis;
                bAutoMin = this.m_pfj.getY2ScaleMinAuto();
                bAutoMax = this.m_pfj.getY2ScaleMaxAuto();
                autoMinVal = this.m_pfj.getY2ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getY2ScaleMaxAutoValue();
                axisSide = this.m_pfj.getY2AxisSide();
                break;
            }
            case 2003: {
                jsID = this.getFilteredBeanName() + "_bi_x1Scr";
                zoomAxisID = "X1";
                axisObj = (Axis2DObj)ch.m_X1Axis;
                if (this.m_pfj.isContinuousTimeAxis()) {
                    axisObj = (Axis2DObj)ch.m_O1Axis;
                }
                bAutoMin = this.m_pfj.getX1ScaleMinAuto();
                bAutoMax = this.m_pfj.getX1ScaleMaxAuto();
                if (this.m_pfj.isContinuousTimeAxis()) {
                    bAutoMin = false;
                    bAutoMax = false;
                }
                autoMinVal = this.m_pfj.getX1ScaleMinAutoValue();
                autoMaxVal = this.m_pfj.getX1ScaleMaxAutoValue();
                break;
            }
            case 2001: {
                jsID = this.getFilteredBeanName() + "_bi_o1Scr";
                zoomAxisID = "O1";
                axisObj = (Axis2DObj)ch.m_O1Axis;
            }
        }
        boolean bHoriz = !axisObj.isVertical();
        Point[] axisBody = axisObj.getAxisBody();
        int axisLength = 0;
        axisLength = bHoriz ? Math.abs(axisBody[1].x - axisBody[0].x) : Math.abs(axisBody[1].y - axisBody[0].y);
        double pctThumbSize = 0.0;
        double pctThumbOffset = 0.0;
        int totalRange = 0;
        int visibleRange = 0;
        int startVal = 0;
        String[] labels = null;
        if (axis == 2001) {
            totalRange = this.m_pfj.getNumTotalGroups();
            visibleRange = this.m_pfj.getNumGroups();
            startVal = this.m_pfj.getEffectiveGroupOffset();
            pctThumbSize = (double)visibleRange / (double)totalRange;
            pctThumbOffset = (double)startVal / (double)totalRange;
            labels = new String[totalRange];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = this.m_pfj.isTimeAxis() ? this.m_pfj.getUnnestedGroupLabel(i) : this.m_pfj.getGroupLabel(i);
            }
        } else {
            if (axisObj.getAutoMinMaxArray() != null) {
                if (!bAutoMin) {
                    autoMinVal = axisObj.getAutoMinMaxArray()[0];
                }
                if (!bAutoMax) {
                    autoMaxVal = axisObj.getAutoMinMaxArray()[1];
                }
            }
            double autoMin = axisObj.getValueCoordForZoom(autoMinVal);
            double autoMax = axisObj.getValueCoordForZoom(autoMaxVal);
            double min = axisObj.getMinCoord();
            double max = axisObj.getMaxCoord();
            if (bHoriz) {
                totalRange = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(autoMax - autoMin)));
                visibleRange = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(max - min)));
                startVal = Math.abs(this.m_pfj.getVC().virtToDestWidth((int)(min - autoMin)));
            } else {
                totalRange = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(autoMax - autoMin)));
                visibleRange = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(max - min)));
                startVal = Math.abs(this.m_pfj.getVC().virtToDestHeight((int)(min - autoMin)));
            }
            pctThumbSize = (double)visibleRange / (double)totalRange;
            pctThumbOffset = (double)startVal / (double)totalRange;
            if (totalRange > axisLength) {
                totalRange = axisLength;
                visibleRange = (int)(pctThumbSize * (double)totalRange);
                startVal = (int)(pctThumbOffset * (double)totalRange);
            }
            labels = axisObj.getLabels(totalRange, autoMinVal, autoMaxVal);
        }
        if (bScrollbarVisible) {
            this.writeDataScrollbarScript();
        }
        int x = axisBody[0].x;
        int y = axisBody[0].y;
        if (bHoriz) {
            int width = axisLength;
            int height = 12;
            if (axisSide != 1) {
                y -= height;
            }
            if (bZoomButtonsVisible) {
                int dataZoomButtonsWidth = this._getHorizontalDataZoomButtonsWidth();
                width = width - 4 - dataZoomButtonsWidth;
            }
            if (bScrollbarVisible) {
                String group_id = this.getSimpleBeanName() + ID_PARAM_SEPARATOR + "Scrollbar" + ID_PARAM_AXIS + zoomAxisID;
                this.writeHorizontalScrollbar(x, y, width, height, pctThumbSize, pctThumbOffset, jsID, totalRange, startVal, visibleRange, labels, this.createDataScrollSubmitJS("'" + zoomAxisID + "'", "'" + this.getBeanName() + "'") + ID_PARAM_SEPARATOR, true, false, group_id, this.getFilteredBeanName());
            }
            if (bZoomButtonsVisible) {
                this.writeHorizontalDataZoomButtons(x + width + 4, y, zoomAxisID);
            }
        } else {
            int width = 12;
            int height = axisLength;
            if (axisSide == 1) {
                x -= width;
            }
            int oldY = y -= height;
            if (bZoomButtonsVisible) {
                int dataZoomButtonsHeight = this._getVerticalDataZoomButtonsHeight();
                height = height - 4 - dataZoomButtonsHeight;
                y = y + 4 + dataZoomButtonsHeight;
            }
            if (bScrollbarVisible) {
                boolean bReverseDir = axis == 2004 || axis == 2005 || axis == 2003;
                String group_id = this.getSimpleBeanName() + ID_PARAM_SEPARATOR + "Scrollbar" + ID_PARAM_AXIS + zoomAxisID;
                this.writeVerticalScrollbar(x, y, width, height, pctThumbSize, pctThumbOffset, jsID, totalRange, startVal, visibleRange, labels, this.createDataScrollSubmitJS("'" + zoomAxisID + "'", "'" + this.getBeanName() + "'") + ID_PARAM_SEPARATOR, true, bReverseDir, group_id, this.getFilteredBeanName());
            }
            if (bZoomButtonsVisible) {
                this.writeVerticalDataZoomButtons(x, oldY, zoomAxisID);
            }
        }
    }

    public void writeDataScrollbarScript() throws IOException, Exception {
        if (this.m_bDataScrollbarScriptWritten) {
            return;
        }
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_data_scrollbar");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function " + this.createDataScrollSubmitJS("axisID", SRC_ID));
        this.println("{");
        this.println("  var axis = axisID;");
        this.println("  var start = scrObj.index;");
        this.println("  var span = scrObj.span;");
        this.println("  var count = scrObj.count;");
        String js = this.getDataScrollSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("  " + js);
        }
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bDataScrollbarScriptWritten = true;
    }

    protected void writeHorizontalDataZoomButtons(int x, int y, String axis) throws IOException, Exception {
        int d = 12;
        this.writeDataZoomOutButton(x, y, d, axis);
        this.writeDataZoomInButton(x + d + 2, y, d, axis);
    }

    protected void writeVerticalDataZoomButtons(int x, int y, String axis) throws IOException, Exception {
        int d = 12;
        this.writeDataZoomInButton(x, y, d, axis);
        this.writeDataZoomOutButton(x, y + d + 2, d, axis);
    }

    private int _getHorizontalDataZoomButtonsWidth() {
        int d = 12;
        return 2 * d + 2;
    }

    private int _getVerticalDataZoomButtonsHeight() {
        int d = 12;
        return 2 * d + 2;
    }

    protected void writeDataZoomInButton(int x, int y, int d, String axis) throws IOException, Exception {
        this.startElement("g");
        this.writeAttribute("id", this.getSimpleBeanName() + ID_PARAM_SEPARATOR + "ZoomInButton" + ID_PARAM_AXIS + axis);
        int r = d / 2;
        int cx = x + r;
        int cy = y + r;
        this.startCircleElement(cx, cy, r);
        this.writeAttribute("fill", "lightgray");
        this.writeAttribute("stroke", Color.black);
        String js = this.getDataZoomInButtonSubmitJS(axis);
        if (js != null && js.length() > 0) {
            this.writeAttribute("onclick", js);
        }
        this.endElement();
        this.startLineElement(x + 1, cy, x + d - 1, cy);
        this.writeAttribute("stroke", Color.black);
        this.writeAttribute("pointer-events", "none");
        this.endElement();
        this.startLineElement(cx, y + 1, cx, y + d - 1);
        this.writeAttribute("stroke", Color.black);
        this.writeAttribute("pointer-events", "none");
        this.endElement();
        this.endElement();
    }

    protected void writeDataZoomOutButton(int x, int y, int d, String axis) throws IOException, Exception {
        this.startElement("g");
        this.writeAttribute("id", this.getSimpleBeanName() + ID_PARAM_SEPARATOR + "ZoomOutButton" + ID_PARAM_AXIS + axis);
        int r = d / 2;
        int cx = x + r;
        int cy = y + r;
        this.startCircleElement(cx, cy, r);
        this.writeAttribute("fill", "lightgray");
        this.writeAttribute("stroke", Color.black);
        String js = this.getDataZoomOutButtonSubmitJS(axis);
        if (js != null && js.length() > 0) {
            this.writeAttribute("onclick", js);
        }
        this.endElement();
        this.startLineElement(x + 1, cy, x + d - 1, cy);
        this.writeAttribute("stroke", Color.black);
        this.writeAttribute("pointer-events", "none");
        this.endElement();
        this.endElement();
    }

    public String getTimeSelectorGroupId() {
        return this.getFilteredBeanName() + "_timeSelGroup";
    }

    public String getTimeSelectorRectId() {
        return this.getFilteredBeanName() + "_timeSelRect";
    }

    public String getTimeSelectorOnMouseOverJS() {
        return null;
    }

    public String getTimeSelectorOnMouseOutJS() {
        return null;
    }

    public String getTimeSelectorOnMouseDownJS() {
        return null;
    }

    public String getTimeSelectorOnMouseMoveJS() {
        return null;
    }

    protected String getTimeSelectorSubmitJS() {
        return null;
    }

    protected void writeReferenceObjectDisplayScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_refObj");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_refObj_show_mOver()");
        this.println("{");
        this.println("  var items = bi_refObj_show_mOver.arguments.length");
        this.println("  for (i = 1; i<items; i++)");
        this.println("  {");
        this.println("       var rect = document.getElementById(bi_refObj_show_mOver.arguments[i]);");
        this.println("       rect.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("  }");
        this.println("}");
        this.println("function bi_refObj_hide_mOut()");
        this.println("{");
        this.println("  var items = bi_refObj_hide_mOut.arguments.length");
        this.println("  for (i = 1; i<items; i++)");
        this.println("  {");
        this.println("       var rect = document.getElementById(bi_refObj_hide_mOut.arguments[i]);");
        this.println("       rect.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("  }");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    protected void writeTimeSelectorScript(Rectangle timeSelectorRect, int minX, int maxX, double pixelMsRatio, long minTime, long maxTime, String translatedStart, String translatedEnd) throws IOException, Exception {
        if (this.m_bTimeSelectorScriptWritten) {
            return;
        }
        this.writeCommonScript();
        this.writeTooltipsScript();
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_time_selector");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        String biTimeSelectorObjName = this.getBITimeSelectorObjName();
        StringBuilder sb = new StringBuilder();
        sb.append(biTimeSelectorObjName);
        sb.append(" = new BITimeSelector(");
        sb.append("\"");
        sb.append(biTimeSelectorObjName);
        sb.append("\", \"");
        sb.append(this.getFilteredBeanName());
        sb.append("\", \"");
        sb.append(this.getBeanName());
        sb.append("\", ");
        sb.append(minX);
        sb.append(", ");
        sb.append(maxX);
        sb.append(", ");
        sb.append(timeSelectorRect.x);
        sb.append(", ");
        sb.append(timeSelectorRect.x + timeSelectorRect.width);
        sb.append(", ");
        sb.append(minTime);
        sb.append(", ");
        sb.append(maxTime);
        sb.append(", ");
        sb.append(pixelMsRatio);
        sb.append(", \"");
        sb.append(translatedStart);
        sb.append("\", \"");
        sb.append(translatedEnd);
        sb.append("\", \"bi_submitTimeSelectorEvent(");
        sb.append(biTimeSelectorObjName);
        sb.append(", '");
        sb.append(this.getBeanName());
        sb.append("');\");");
        this.println(sb.toString());
        this.println("function BITimeSelector(objName, base_id, graphClientID, minCoord, maxCoord, currMin, currMax, minTime, maxTime, pixelMsRatio, translatedStart, translatedEnd, submitJS)");
        this.println("{");
        this.println("  this.objName = objName;");
        this.println("  this.base_id = base_id;");
        this.println("  this.graphClientID = graphClientID;");
        this.println("  this.minCoord = minCoord;");
        this.println("  this.maxCoord = maxCoord;");
        this.println("  this.currMin = currMin;");
        this.println("  this.currMax = currMax;");
        this.println("  this.minTime = minTime;");
        this.println("  this.maxTime = maxTime;");
        this.println("  this.pixelMsRatio = pixelMsRatio;");
        this.println("  this.translatedStart = translatedStart;");
        this.println("  this.translatedEnd = translatedEnd;");
        this.println("  this.submitJS = submitJS;");
        this.println("}");
        this.println("function bi_addTimeSelectorListener(listener, timeSelObj)");
        this.println("{");
        this.println("  if (!timeSelObj.listeners)");
        this.println("    timeSelObj.listeners = new Array(listener);");
        this.println("  timeSelObj.listeners.push(listener);");
        this.println("}");
        this.println("function bi_removeTimeSelectorListener(listener, timeSelObj)");
        this.println("{");
        this.println("  if (listener && timeSelObj.listeners)");
        this.println("  {");
        this.println("    var tmp = new Array();");
        this.println("    var newI = 0;");
        this.println("    for (var i = 0; i < timeSelObj.listeners.length; i=i+1)");
        this.println("    {");
        this.println("      if (timeSelObj.listeners[i] != listener)");
        this.println("      {");
        this.println("        tmp[newI] = timeSelObj.listeners[i];");
        this.println("        newI = newI + 1;");
        this.println("      }");
        this.println("    }");
        this.println("    timeSelObj.listeners = tmp;");
        this.println("  }");
        this.println("}");
        this.println("function bi_fireTimeSelectorEvent(timeSelObj)");
        this.println("{");
        this.println("  if (timeSelObj.listeners && timeSelObj.listeners.length > 0)");
        this.println("  {");
        this.println("    var src = timeSelObj.graphClientID;");
        this.println("    var startTime = bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj);");
        this.println("    var endTime = bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj);");
        this.println("    for (var i = timeSelObj.listeners.length - 1; i >= 0; i=i-1)");
        this.println("      eval(timeSelObj.listeners[i]);");
        this.println("  }");
        this.println("}");
        this.println("function bi_submitTimeSelectorEvent(timeSelObj, srcID)");
        this.println("{");
        this.println("  var timeSelStartDate = bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj);");
        this.println("  var timeSelEndDate = bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj);");
        String js = this.getTimeSelectorSubmitJS();
        if (js != null && js.length() > 0) {
            this.println("  " + js);
        }
        this.println("}");
        this.println("function bi_mapTimeSelCoordToTime(coord, timeSelObj)");
        this.println("{");
        this.println("  var time = null;");
        this.println("  if (coord <= timeSelObj.minCoord)");
        this.println("    time = timeSelObj.minTime;");
        this.println("  else");
        this.println("  {");
        this.println("    if (coord >= timeSelObj.maxCoord)");
        this.println("      time = timeSelObj.maxTime;");
        this.println("    else");
        this.println("      time = timeSelObj.minTime + timeSelObj.pixelMsRatio * (coord - timeSelObj.minCoord);");
        this.println("  }");
        this.println("  return time;");
        this.println("}");
        this.println("function bi_formatDate(time)");
        this.println("{");
        this.println("  var date = new Date(time);");
        this.println("  return date.toLocaleString();");
        this.println("}");
        this.println("function bi_timeSel_validate_th_coord(coord, timeSelObj)");
        this.println("{");
        this.println("  var min = timeSelObj.minCoord;");
        this.println("  var max = timeSelObj.maxCoord - (timeSelObj.currMax - timeSelObj.currMin);");
        this.println("  var newCoord = coord;");
        this.println("  if (newCoord < min)");
        this.println("    newCoord = min;");
        this.println("  if (newCoord > max)");
        this.println("    newCoord = max;");
        this.println("  return newCoord;");
        this.println("}");
        this.println("function bi_timeSel_validate_th_minEdge(coord, timeSelObj)");
        this.println("{");
        this.println("  var min = timeSelObj.minCoord;");
        this.println("  var max = timeSelObj.currMax;");
        this.println("  var newCoord = coord;");
        this.println("  if (newCoord < min)");
        this.println("    newCoord = min;");
        this.println("  if (newCoord > max)");
        this.println("    newCoord = max;");
        this.println("  return newCoord;");
        this.println("}");
        this.println("function bi_timeSel_validate_th_maxEdge(coord, timeSelObj)");
        this.println("{");
        this.println("  var min = timeSelObj.currMin;");
        this.println("  var max = timeSelObj.maxCoord;");
        this.println("  var newCoord = coord;");
        this.println("  if (newCoord < min)");
        this.println("    newCoord = min;");
        this.println("  if (newCoord > max)");
        this.println("    newCoord = max;");
        this.println("  return newCoord;");
        this.println("}");
        this.println("function bi_timeSel_th_mOver(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_timeSel_showGrippies(evt, timeSelObj);");
        this.println("  var rect = document.getElementById(timeSelObj.base_id + \"_timeSelRect\");");
        this.println("  rect.setAttributeNS(null, \"stroke-width\", \"2\");");
        this.println("  bi_showMoveCursor(evt);");
        this.println("}");
        this.println("function bi_timeSel_th_mOut(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_timeSel_hideGrippies(evt, timeSelObj);");
        this.println("  var rect = document.getElementById(timeSelObj.base_id + \"_timeSelRect\");");
        this.println("  rect.setAttributeNS(null, \"stroke-width\", \"1\");");
        this.println("  bi_hideMoveCursor();");
        this.println("}");
        this.println("function bi_timeSel_th_mDown(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownX = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("  bi_timeSel_createThPane(timeSelObj, evt.target)");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(timeSelObj.translatedStart + bi_formatDate(bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj)), timeSelObj.translatedEnd + bi_formatDate(bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj)));");
        this.println("  var beanName = timeSelObj.base_id;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  bi_fireTimeSelectorEvent(timeSelObj);");
        this.println("}");
        this.println("function bi_timeSel_th_mUp(evt, timeSelObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    eval(timeSelObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_timeSel_th_mMove(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_updateMoveCursor(evt);");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var x = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("    var offsetX = x - bi_mouseDownX;");
        this.println("    var thumbElem = document.getElementById(timeSelObj.base_id + \"_timeSelRect\");");
        this.println("    var currX = timeSelObj.currMin;");
        this.println("    var newX = bi_timeSel_validate_th_coord(currX + offsetX, timeSelObj);");
        this.println("    thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("    bi_timeSel_translateThResizeArrows(newX, timeSelObj);");
        this.println("    bi_mouseDownX = x;");
        this.println("    timeSelObj.currMin = newX;");
        this.println("    timeSelObj.currMax = bi_timeSel_validate_th_maxEdge(timeSelObj.currMax + (newX - currX), timeSelObj);");
        this.println("    var bAutoHide = false;");
        this.println("    var lines = new Array(timeSelObj.translatedStart + bi_formatDate(bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj)), timeSelObj.translatedEnd + bi_formatDate(bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj)));");
        this.println("    var beanName = timeSelObj.base_id;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("    bi_fireTimeSelectorEvent(timeSelObj);");
        this.println("  }");
        this.println("}");
        this.println("function bi_timeSel_translateThResizeArrows(newX, timeSelObj)");
        this.println("{");
        this.println("  var lthaElem = document.getElementById(timeSelObj.base_id + \"_leftGrippy\");");
        this.println("  var rthaElem = document.getElementById(timeSelObj.base_id + \"_rightGrippy\");");
        this.println("  var sLTranslate = lthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var sRTranslate = rthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var currWidth = timeSelObj.currMax - timeSelObj.currMin;");
        this.println("  var offsetMinX = newX - timeSelObj.currMin;");
        this.println("  var offsetMaxX = newX - timeSelObj.currMin;");
        this.println("  var xMinTranslate = bi_timeSel_parseTranslateX(sLTranslate);");
        this.println("  if (xMinTranslate != null)");
        this.println("    offsetMinX = offsetMinX + xMinTranslate;");
        this.println("  sLTranslate = bi_timeSel_modifyTranslateX(sLTranslate, offsetMinX);");
        this.println("  var xMaxTranslate = bi_timeSel_parseTranslateX(sRTranslate);");
        this.println("  if (xMaxTranslate != null)");
        this.println("    offsetMaxX = offsetMaxX + xMaxTranslate;");
        this.println("  sRTranslate = bi_timeSel_modifyTranslateX(sRTranslate, offsetMaxX);");
        this.println("  lthaElem.setAttributeNS(null, \"transform\", sLTranslate);");
        this.println("  rthaElem.setAttributeNS(null, \"transform\", sRTranslate);");
        this.println("}");
        this.println("function bi_timeSel_translateLThResizeArrow(newX, timeSelObj)");
        this.println("{");
        this.println("  var lthaElem = document.getElementById(timeSelObj.base_id + \"_leftGrippy\");");
        this.println("  var sTranslate = lthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetX = newX - timeSelObj.currMin;");
        this.println("  var xTranslate = bi_timeSel_parseTranslateX(sTranslate);");
        this.println("  if (xTranslate != null)");
        this.println("    offsetX = offsetX + xTranslate;");
        this.println("  sTranslate = bi_timeSel_modifyTranslateX(sTranslate, offsetX);");
        this.println("  lthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_timeSel_translateRThResizeArrow(newX, timeSelObj)");
        this.println("{");
        this.println("  var rthaElem = document.getElementById(timeSelObj.base_id + \"_rightGrippy\");");
        this.println("  var sTranslate = rthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetX = newX - timeSelObj.currMax;");
        this.println("  var xTranslate = bi_timeSel_parseTranslateX(sTranslate);");
        this.println("  if (xTranslate != null)");
        this.println("    offsetX = offsetX + xTranslate;");
        this.println("  sTranslate = bi_timeSel_modifyTranslateX(sTranslate, offsetX);");
        this.println("  rthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_timeSel_parseTranslateX(translate)");
        this.println("{");
        this.println("  if (translate != null)");
        this.println("  {");
        this.println("    var op = translate.indexOf('(');");
        this.println("    var comma = translate.indexOf(',');");
        this.println("    var cp = translate.indexOf(')');");
        this.println("    var xString = null;");
        this.println("    if (comma < 0)");
        this.println("      xString = translate.substring(op+1, cp);");
        this.println("    else");
        this.println("      xString = translate.substring(op+1, comma);");
        this.println("    return eval(xString);");
        this.println("  }");
        this.println("  return null;");
        this.println("}");
        this.println("function bi_timeSel_modifyTranslateX(translate, newXVal)");
        this.println("{");
        this.println("  if (translate != null)");
        this.println("  {");
        this.println("    var op = translate.indexOf('(');");
        this.println("    var comma = translate.indexOf(',');");
        this.println("    var cp = translate.indexOf(')');");
        this.println("    var tString = translate.substring(0, op+1) + newXVal;");
        this.println("    if (comma < 0)");
        this.println("      tString = tString + translate.substring(cp, translate.length);");
        this.println("    else");
        this.println("      tString = tString + translate.substring(comma, translate.length);");
        this.println("    return tString;");
        this.println("  }");
        this.println("  return null;");
        this.println("}");
        this.println("function bi_timeSel_ltha_mOver(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_timeSel_showGrippies(evt, timeSelObj);");
        this.println("  var rect = document.getElementById(timeSelObj.base_id + \"_leftGrippyRect\");");
        this.println("  rect.setAttributeNS(null, \"stroke-width\", \"2\");");
        this.println("  bi_showHResizeCursor(evt);");
        this.println("}");
        this.println("function bi_timeSel_ltha_mOut(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_timeSel_hideGrippies(evt, timeSelObj);");
        this.println("  var rect = document.getElementById(timeSelObj.base_id + \"_leftGrippyRect\");");
        this.println("  rect.setAttributeNS(null, \"stroke-width\", \"1\");");
        this.println("  bi_hideHResizeCursor();");
        this.println("}");
        this.println("function bi_timeSel_ltha_mDown(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownX = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("  bi_timeSel_createLThAPane(timeSelObj, evt.target)");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(timeSelObj.translatedStart + bi_formatDate(bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj)));");
        this.println("  var beanName = timeSelObj.base_id;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  bi_fireTimeSelectorEvent(timeSelObj);");
        this.println("}");
        this.println("function bi_timeSel_ltha_mUp(evt, timeSelObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    eval(timeSelObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_timeSel_ltha_mMove(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_updateHResizeCursor(evt);");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var x = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("    var offsetX = x - bi_mouseDownX;");
        this.println("    var thumbElem = document.getElementById(timeSelObj.base_id + \"_timeSelRect\");");
        this.println("    var currX = timeSelObj.currMin;");
        this.println("    var newX = bi_timeSel_validate_th_minEdge(currX + offsetX, timeSelObj);");
        this.println("    var newWidth = timeSelObj.currMax - newX;");
        this.println("    thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("    thumbElem.setAttributeNS(null, \"width\", newWidth);");
        this.println("    bi_timeSel_translateLThResizeArrow(newX, timeSelObj);");
        this.println("    bi_mouseDownX = x;");
        this.println("    timeSelObj.currMin = newX;");
        this.println("    var bAutoHide = false;");
        this.println("    var maxIndex = bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj);");
        this.println("    var minIndex = bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj);");
        this.println("    if (minIndex > maxIndex)");
        this.println("      minIndex = minIndex - 1;");
        this.println("    var lines = new Array(timeSelObj.translatedStart + bi_formatDate(minIndex));");
        this.println("    var beanName = timeSelObj.base_id;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("    bi_fireTimeSelectorEvent(timeSelObj);");
        this.println("  }");
        this.println("}");
        this.println("function bi_timeSel_rtha_mOver(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_timeSel_showGrippies(evt, timeSelObj);");
        this.println("  var rect = document.getElementById(timeSelObj.base_id + \"_rightGrippyRect\");");
        this.println("  rect.setAttributeNS(null, \"stroke-width\", \"2\");");
        this.println("  bi_showHResizeCursor(evt);");
        this.println("}");
        this.println("function bi_timeSel_rtha_mOut(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_timeSel_hideGrippies(evt, timeSelObj);");
        this.println("  var rect = document.getElementById(timeSelObj.base_id + \"_rightGrippyRect\");");
        this.println("  rect.setAttributeNS(null, \"stroke-width\", \"1\");");
        this.println("  bi_hideHResizeCursor();");
        this.println("}");
        this.println("function bi_timeSel_rtha_mDown(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownX = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("  bi_timeSel_createRThAPane(timeSelObj, evt.target)");
        this.println("  var bAutoHide = false;");
        this.println("  var maxIndex = bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj);");
        this.println("  var minIndex = bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj);");
        this.println("  if (maxIndex < minIndex)");
        this.println("    maxIndex = maxIndex + 1;");
        this.println("  var lines = new Array(timeSelObj.translatedEnd + bi_formatDate(maxIndex));");
        this.println("  var beanName = timeSelObj.base_id;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  bi_fireTimeSelectorEvent(timeSelObj);");
        this.println("}");
        this.println("function bi_timeSel_rtha_mUp(evt, timeSelObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    eval(timeSelObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_timeSel_rtha_mMove(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_updateHResizeCursor(evt);");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var x = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("    var offsetX = x - bi_mouseDownX;");
        this.println("    var thumbElem = document.getElementById(timeSelObj.base_id + \"_timeSelRect\");");
        this.println("    var currX = timeSelObj.currMax;");
        this.println("    var newX = bi_timeSel_validate_th_maxEdge(currX + offsetX, timeSelObj);");
        this.println("    var newWidth = newX - timeSelObj.currMin;");
        this.println("    thumbElem.setAttributeNS(null, \"width\", newWidth);");
        this.println("    bi_timeSel_translateRThResizeArrow(newX, timeSelObj);");
        this.println("    bi_mouseDownX = x;");
        this.println("    timeSelObj.currMax = newX;");
        this.println("    var bAutoHide = false;");
        this.println("    var maxIndex = bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj);");
        this.println("    var minIndex = bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj);");
        this.println("    if (maxIndex < minIndex)");
        this.println("      maxIndex = maxIndex + 1;");
        this.println("    var lines = new Array(timeSelObj.translatedEnd + bi_formatDate(maxIndex));");
        this.println("    var beanName = timeSelObj.base_id;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("    bi_fireTimeSelectorEvent(timeSelObj);");
        this.println("  }");
        this.println("}");
        this.println("function bi_timeSel_createLThAPane(timeSelObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseover\", \"bi_timeSel_ltha_mOver(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_timeSel_ltha_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_timeSel_ltha_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_timeSel_ltha_mMove(evt, \" + timeSelObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.println("function bi_timeSel_createRThAPane(timeSelObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseover\", \"bi_timeSel_rtha_mOver(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_timeSel_rtha_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_timeSel_rtha_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_timeSel_rtha_mMove(evt, \" + timeSelObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.println("function bi_timeSel_createThPane(timeSelObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseover\", \"bi_timeSel_thPane_mOver(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_timeSel_th_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_timeSel_th_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_timeSel_th_mMove(evt, \" + timeSelObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.println("function bi_timeSel_thPane_mOver(evt, timeSelObj)");
        this.println("{");
        this.println("  bi_timeSel_th_mOver(evt, timeSelObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(timeSelObj.translatedStart + bi_formatDate(bi_mapTimeSelCoordToTime(timeSelObj.currMin, timeSelObj)), timeSelObj.translatedEnd + bi_formatDate(bi_mapTimeSelCoordToTime(timeSelObj.currMax, timeSelObj)));");
        this.println("  var beanName = timeSelObj.base_id;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_timeSel_showGrippies(evt, timeSelObj)");
        this.println("{");
        this.println("  var leftGrippy = document.getElementById(timeSelObj.base_id + \"_leftGrippy\");");
        this.println("  var rightGrippy = document.getElementById(timeSelObj.base_id + \"_rightGrippy\");");
        this.println("  var timeSelGroup = document.getElementById(timeSelObj.base_id + \"_timeSelGroup\");");
        this.println("  if (!leftGrippy)");
        this.println("    leftGrippy = bi_timeSel_createGrippy(timeSelObj, timeSelGroup, \"left\");");
        this.println("  if (!rightGrippy)");
        this.println("    rightGrippy = bi_timeSel_createGrippy(timeSelObj, timeSelGroup, \"right\");");
        this.println("  if (leftGrippy)");
        this.println("    leftGrippy.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("  if (rightGrippy)");
        this.println("    rightGrippy.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("}");
        this.println("function bi_timeSel_hideGrippies(evt, timeSelObj)");
        this.println("{");
        this.println("  var leftGrippy = document.getElementById(timeSelObj.base_id + \"_leftGrippy\");");
        this.println("  var rightGrippy = document.getElementById(timeSelObj.base_id + \"_rightGrippy\");");
        this.println("  if (leftGrippy)");
        this.println("    leftGrippy.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("  if (rightGrippy)");
        this.println("    rightGrippy.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("}");
        this.println("function bi_timeSel_createGrippy(timeSelObj, pNode, side)");
        this.println("{");
        this.println("  var timeSelRect = document.getElementById(timeSelObj.base_id + \"_timeSelRect\");");
        this.println("  var fill = timeSelRect.getAttributeNS(null, \"fill\");");
        this.println("  var fillOpacity = timeSelRect.getAttributeNS(null, \"fill-opacity\");");
        this.println("  var stroke = timeSelRect.getAttributeNS(null, \"stroke\");");
        this.println("  var strokeOpacity = timeSelRect.getAttributeNS(null, \"stroke-opacity\");");
        this.println("  var y = timeSelRect.getAttributeNS(null, \"y\");");
        this.println("  var height = timeSelRect.getAttributeNS(null, \"height\");");
        this.println("  var yCenter = eval(y) + eval(height / 2);");
        this.println("  var xLeft = timeSelRect.getAttributeNS(null, \"x\");");
        this.println("  var width = timeSelRect.getAttributeNS(null, \"width\");");
        this.println("  var xRight = eval(xLeft) + eval(width);");
        this.println("  var group = document.createElementNS(bi_svgNS, \"g\");");
        this.println("  group.setAttributeNS(null, \"id\", timeSelObj.base_id + \"_\" + side + \"Grippy\");");
        this.println("  group.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("  if (fill)");
        this.println("    group.setAttributeNS(null, \"fill\", fill);");
        this.println("  if (fillOpacity)");
        this.println("    group.setAttributeNS(null, \"fill-opacity\", fillOpacity);");
        this.println("  if (stroke)");
        this.println("    group.setAttributeNS(null, \"stroke\", stroke);");
        this.println("  if (strokeOpacity)");
        this.println("    group.setAttributeNS(null, \"stroke-opacity\", strokeOpacity);");
        this.println("  var xOffset = xLeft;");
        this.println("  if (side == 'right')");
        this.println("    xOffset = xRight;");
        this.println("  group.setAttributeNS(null, \"transform\", \"translate(\" + xOffset + \", \" + yCenter + \")\");");
        this.println("  var rect = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  rect.setAttributeNS(null, \"id\", timeSelObj.base_id + \"_\" + side + \"GrippyRect\");");
        this.println("  rect.setAttributeNS(null, \"x\", \"-4\");");
        this.println("  rect.setAttributeNS(null, \"y\", \"-6\");");
        this.println("  rect.setAttributeNS(null, \"width\", \"8\");");
        this.println("  rect.setAttributeNS(null, \"height\", \"12\");");
        this.println("  rect.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  if (side == 'left')");
        this.println("  {");
        this.println("    rect.setAttributeNS(null, \"onmouseover\", \"bi_timeSel_ltha_mOver(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmouseout\", \"bi_timeSel_ltha_mOut(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmousedown\", \"bi_timeSel_ltha_mDown(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmouseup\", \"bi_timeSel_ltha_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmousemove\", \"bi_timeSel_ltha_mMove(evt, \" + timeSelObj.objName + \")\");");
        this.println("  }");
        this.println("  else");
        this.println("  {");
        this.println("    rect.setAttributeNS(null, \"onmouseover\", \"bi_timeSel_rtha_mOver(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmouseout\", \"bi_timeSel_rtha_mOut(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmousedown\", \"bi_timeSel_rtha_mDown(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmouseup\", \"bi_timeSel_rtha_mUp(evt, \" + timeSelObj.objName + \")\");");
        this.println("    rect.setAttributeNS(null, \"onmousemove\", \"bi_timeSel_rtha_mMove(evt, \" + timeSelObj.objName + \")\");");
        this.println("  }");
        this.println("  var leftline = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  leftline.setAttributeNS(null, \"x1\", \"-1\");");
        this.println("  leftline.setAttributeNS(null, \"y1\", \"-3\");");
        this.println("  leftline.setAttributeNS(null, \"x2\", \"-1\");");
        this.println("  leftline.setAttributeNS(null, \"y2\", \"3\");");
        this.println("  leftline.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  var rightline = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  rightline.setAttributeNS(null, \"x1\", \"1\");");
        this.println("  rightline.setAttributeNS(null, \"y1\", \"-3\");");
        this.println("  rightline.setAttributeNS(null, \"x2\", \"1\");");
        this.println("  rightline.setAttributeNS(null, \"y2\", \"3\");");
        this.println("  rightline.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  group.appendChild(rect);");
        this.println("  group.appendChild(leftline);");
        this.println("  group.appendChild(rightline);");
        this.println("  pNode.appendChild(group);");
        this.println("  return group;");
        this.println("}");
        this.println("function bi_showMoveCursor(evt)");
        this.println("{");
        this.println("  var cursorGroup = document.getElementById(\"biMoveCursor\");");
        this.println("  if (cursorGroup == null)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    cursorGroup = bi_createMoveCursor(svgRoot);");
        this.println("  }");
        this.println("  bi_updateMoveCursor(evt);");
        this.println("  cursorGroup.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("}");
        this.println("function bi_showHResizeCursor(evt)");
        this.println("{");
        this.println("  var cursorGroup = document.getElementById(\"biHResizeCursor\");");
        this.println("  if (cursorGroup == null)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    cursorGroup = bi_createHResizeCursor(svgRoot);");
        this.println("  }");
        this.println("  bi_updateHResizeCursor(evt);");
        this.println("  cursorGroup.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("}");
        this.println("function bi_hideMoveCursor()");
        this.println("{");
        this.println("  var cursorGroup = document.getElementById(\"biMoveCursor\");");
        this.println("  if (cursorGroup != null)");
        this.println("    cursorGroup.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("}");
        this.println("function bi_hideHResizeCursor()");
        this.println("{");
        this.println("  var cursorGroup = document.getElementById(\"biHResizeCursor\");");
        this.println("  if (cursorGroup != null)");
        this.println("    cursorGroup.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("}");
        this.println("function bi_createMoveCursor(pnode)");
        this.println("{");
        this.println("  var groupElem = document.createElementNS(bi_svgNS, \"g\");");
        this.println("  groupElem.setAttributeNS(null, \"id\", \"biMoveCursor\");");
        this.println("  groupElem.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  groupElem.setAttributeNS(null, \"fill\", \"white\");");
        this.println("  groupElem.setAttributeNS(null, \"stroke\", \"black\");");
        this.println("  bi_createCursor(groupElem, \"move\");");
        this.println("  pnode.appendChild(groupElem);");
        this.println("  return groupElem;");
        this.println("}");
        this.println("function bi_createHResizeCursor(pnode)");
        this.println("{");
        this.println("  var groupElem = document.createElementNS(bi_svgNS, \"g\");");
        this.println("  groupElem.setAttributeNS(null, \"id\", \"biHResizeCursor\");");
        this.println("  groupElem.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  groupElem.setAttributeNS(null, \"fill\", \"white\");");
        this.println("  groupElem.setAttributeNS(null, \"stroke\", \"black\");");
        this.println("  bi_createCursor(groupElem, \"hresize\");");
        this.println("  pnode.appendChild(groupElem);");
        this.println("  return groupElem;");
        this.println("}");
        this.println("function bi_updateMoveCursor(evt)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  var cursor = document.getElementById(\"biMoveCursor\");");
        this.println("  if (cursor)");
        this.println("    cursor.setAttributeNS(null, \"transform\", \"translate(\" + (bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target) + 13) + \", \" + (bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target) + 10) + \")\");");
        this.println("}");
        this.println("function bi_updateHResizeCursor(evt)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  var cursor = document.getElementById(\"biHResizeCursor\");");
        this.println("  if (cursor)");
        this.println("    cursor.setAttributeNS(null, \"transform\", \"translate(\" + (bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target) + 13) + \", \" + (bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target) + 10) + \")\");");
        this.println("}");
        this.println("function bi_createCursor(pnode, type)");
        this.println("{");
        this.println("  var hLineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  hLineElem.setAttributeNS(null, \"x1\", 0);");
        this.println("  hLineElem.setAttributeNS(null, \"y1\", 6);");
        this.println("  hLineElem.setAttributeNS(null, \"x2\", 12);");
        this.println("  hLineElem.setAttributeNS(null, \"y2\", 6);");
        this.println("  pnode.appendChild(hLineElem);");
        this.println("  var lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  lineElem.setAttributeNS(null, \"x1\", 0);");
        this.println("  lineElem.setAttributeNS(null, \"y1\", 6);");
        this.println("  lineElem.setAttributeNS(null, \"x2\", 2);");
        this.println("  lineElem.setAttributeNS(null, \"y2\", 4);");
        this.println("  pnode.appendChild(lineElem);");
        this.println("  lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  lineElem.setAttributeNS(null, \"x1\", 0);");
        this.println("  lineElem.setAttributeNS(null, \"y1\", 6);");
        this.println("  lineElem.setAttributeNS(null, \"x2\", 2);");
        this.println("  lineElem.setAttributeNS(null, \"y2\", 8);");
        this.println("  pnode.appendChild(lineElem);");
        this.println("  var lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  lineElem.setAttributeNS(null, \"x1\", 12);");
        this.println("  lineElem.setAttributeNS(null, \"y1\", 6);");
        this.println("  lineElem.setAttributeNS(null, \"x2\", 10);");
        this.println("  lineElem.setAttributeNS(null, \"y2\", 4);");
        this.println("  pnode.appendChild(lineElem);");
        this.println("  var lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("  lineElem.setAttributeNS(null, \"x1\", 12);");
        this.println("  lineElem.setAttributeNS(null, \"y1\", 6);");
        this.println("  lineElem.setAttributeNS(null, \"x2\", 10);");
        this.println("  lineElem.setAttributeNS(null, \"y2\", 8);");
        this.println("  pnode.appendChild(lineElem);");
        this.println("  if (type == \"move\")");
        this.println("  {");
        this.println("    var vLineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("    vLineElem.setAttributeNS(null, \"x1\", 6);");
        this.println("    vLineElem.setAttributeNS(null, \"y1\", 0);");
        this.println("    vLineElem.setAttributeNS(null, \"x2\", 6);");
        this.println("    vLineElem.setAttributeNS(null, \"y2\", 12);");
        this.println("    pnode.appendChild(vLineElem);");
        this.println("    lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("    lineElem.setAttributeNS(null, \"x1\", 6);");
        this.println("    lineElem.setAttributeNS(null, \"y1\", 0);");
        this.println("    lineElem.setAttributeNS(null, \"x2\", 4);");
        this.println("    lineElem.setAttributeNS(null, \"y2\", 2);");
        this.println("    pnode.appendChild(lineElem);");
        this.println("    lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("    lineElem.setAttributeNS(null, \"x1\", 6);");
        this.println("    lineElem.setAttributeNS(null, \"y1\", 0);");
        this.println("    lineElem.setAttributeNS(null, \"x2\", 8);");
        this.println("    lineElem.setAttributeNS(null, \"y2\", 2);");
        this.println("    pnode.appendChild(lineElem);");
        this.println("    lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("    lineElem.setAttributeNS(null, \"x1\", 6);");
        this.println("    lineElem.setAttributeNS(null, \"y1\", 12);");
        this.println("    lineElem.setAttributeNS(null, \"x2\", 4);");
        this.println("    lineElem.setAttributeNS(null, \"y2\", 10);");
        this.println("    pnode.appendChild(lineElem);");
        this.println("    lineElem = document.createElementNS(bi_svgNS, \"line\");");
        this.println("    lineElem.setAttributeNS(null, \"x1\", 6);");
        this.println("    lineElem.setAttributeNS(null, \"y1\", 12);");
        this.println("    lineElem.setAttributeNS(null, \"x2\", 8);");
        this.println("    lineElem.setAttributeNS(null, \"y2\", 10);");
        this.println("    pnode.appendChild(lineElem);");
        this.println("  }");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bTimeSelectorScriptWritten = true;
    }

    protected void writeBISVGGraphObjectScript(boolean bZoomHoriz, boolean bZoomVert) throws IOException, Exception {
        if (!this.m_bDataZoomScriptWritten && !this.m_bTimeSelectorScriptWritten) {
            return;
        }
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_svg_graph_object");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        String sZoomDir = null;
        if (bZoomHoriz && bZoomVert) {
            sZoomDir = "BI_ZD_B";
        } else if (bZoomHoriz && !bZoomVert) {
            sZoomDir = "BI_ZD_H";
        } else if (!bZoomHoriz && bZoomVert) {
            sZoomDir = "BI_ZD_V";
        }
        String biSVGGraphObjName = this.getBISVGGraphObjName();
        Rectangle plotAreaRect = this.m_pfj.getVC().virtToDest(this.m_pfj.getFrameRect(false));
        String sPlotAreaRect = "new Array(" + plotAreaRect.x + ", " + plotAreaRect.y + ", " + plotAreaRect.width + ", " + plotAreaRect.height + ")";
        String biTimeSelObjName = null;
        if (this.m_bTimeSelectorScriptWritten) {
            biTimeSelObjName = this.getBITimeSelectorObjName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(biSVGGraphObjName);
        sb.append(" = new BISVGGraph(\"");
        sb.append(this.getFilteredBeanName());
        sb.append("\", \"");
        sb.append(this.getBeanName());
        sb.append("\", \"");
        sb.append(biSVGGraphObjName);
        sb.append("\", ");
        sb.append(sZoomDir);
        sb.append(", \"");
        sb.append(this.getSvgRootId());
        sb.append("\", ");
        sb.append(sPlotAreaRect);
        sb.append(", ");
        sb.append(bZoomHoriz || bZoomVert);
        sb.append(", \"");
        sb.append(biTimeSelObjName);
        sb.append("\");");
        this.println(sb.toString());
        this.println("function BISVGGraph(graphID, graphClientID, objName, zoomDir, svgRootID, plotAreaRect, bZoomable, timeSelObjName)");
        this.println("{");
        this.println("  this.graphID = graphID;");
        this.println("  this.graphClientID = graphClientID;");
        this.println("  this.objName = objName;");
        this.println("  this.svgRootID = svgRootID;");
        this.println("  this.plotAreaRect = plotAreaRect;");
        this.println("  if (bZoomable)");
        this.println("  {");
        this.println("    this.zoomDir = zoomDir;");
        this.println("    this.setMode = new Function(\"mode\", \"return bi_setMode(mode, this);\");");
        this.println("    this.BI_SVG_MODE_DEFAULT = BI_SVG_MODE_DEFAULT;");
        this.println("    this.BI_SVG_MODE_ZOOM = BI_SVG_MODE_ZOOM;");
        this.println("  }");
        this.println("  if (timeSelObjName)");
        this.println("  {");
        this.println("    this.timeSelObjName = timeSelObjName;");
        this.println("    this.addTimeSelectorListener = new Function(\"listener\", \"return bi_addTimeSelectorListener(listener, eval(this.timeSelObjName));\");");
        this.println("    this.removeTimeSelectorListener = new Function(\"listener\", \"return bi_removeTimeSelectorListener(listener, eval(this.timeSelObjName));\");");
        this.println("  }");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    protected void writeFillOpacityAttribute(BlackBoxIF bb) throws IOException, Exception {
        Color color = bb.getFillColor();
        int fillType = bb.getFillType();
        if (fillType == 1 && color != null) {
            this.writeOpacityAttribute(color, "fill-opacity");
        }
    }

    protected void writeOpacityAttribute(Color color, String attr) throws IOException, Exception {
        int alpha = color.getAlpha();
        if (alpha < 255) {
            double opacity = (double)alpha / 255.0;
            if (opacity < 0.0) {
                opacity = 0.0;
            } else if (opacity > 1.0) {
                opacity = 1.0;
            }
            this.writeAttribute(attr, opacity);
        }
    }

    protected String calcFillAttribute(IdentObj id, BlackBoxIF bb, Rectangle bounds) throws IOException, Exception {
        String fillAttr = null;
        switch (bb.getFillType()) {
            case 1: {
                fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
                break;
            }
            case 2: {
                FillGradientObj gradient;
                String gradientName = null;
                Rectangle gradBounds = bounds;
                FillObj fill = bb.getFillObj();
                if (fill instanceof FillGradientObj && (gradient = (FillGradientObj)fill).getBoundingBox() != null) {
                    gradBounds = gradient.getBoundingBox().getBounds();
                }
                if ((gradientName = this.writeGradientElement(bb, gradBounds)) != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("url(#");
                    sb.append(gradientName);
                    sb.append(')');
                    fillAttr = sb.toString();
                    break;
                }
                if (this.m_eh != null) {
                    this.m_eh.log("gradient name null", this.getClass().getName(), "protected String calcFillAttribute");
                }
                fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
                break;
            }
            case 3: {
                String szURL = this.m_pfj.getTexture(bb.getIdentObj());
                Image img = this.m_pfj.getTexture(szURL);
                int imgHeight = img.getHeight(null);
                int imgWidth = img.getWidth(null);
                if (img != null) {
                    int nDisplayMode = this.m_pfj.getTextureDisplayMode(bb.getIdentObj());
                    int nFlipMode = this.m_pfj.getTextureFlipMode(bb.getIdentObj());
                    if (nDisplayMode == 0) {
                        String patternName = this.writePatternElement(bounds, szURL, imgWidth, imgHeight, nFlipMode);
                        if (patternName != null) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("url(#");
                            sb.append(patternName);
                            sb.append(')');
                            fillAttr = sb.toString();
                            break;
                        }
                        if (this.m_eh != null) {
                            this.m_eh.log("pattern name null", this.getClass().getName(), "protected String calcFillAttribute");
                        }
                        fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
                        break;
                    }
                    if (nDisplayMode == 1) {
                        this.writeImageElement(bounds.x, bounds.y, bounds.width, bounds.height, szURL);
                        fillAttr = "none";
                        break;
                    }
                    if (this.m_eh != null) {
                        this.m_eh.log("unknown display mode", this.getClass().getName(), "protected String calcFillAttribute");
                    }
                    fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
                    break;
                }
                if (this.m_eh != null) {
                    this.m_eh.log("texture image null", this.getClass().getName(), "protected String calcFillAttribute");
                }
                fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
                break;
            }
            case 4: {
                int imgWidth = 8;
                int imgHeight = 8;
                int pattern = this.m_pfj.getFillPattern(bb.getIdentObj());
                if (pattern >= 6) {
                    imgWidth = 16;
                    imgHeight = 16;
                }
                if (pattern > -1) {
                    Color patternColor = null;
                    GraphStyle gs = bb.getGraphStyle(id.getSeriesID(), id.getGroupID());
                    patternColor = gs != null && gs.getFillColor() != null ? gs.getFillColor() : this.m_pfj.getFillColor(bb.getIdentObj());
                    boolean nDisplayMode = false;
                    int nFlipMode = 0;
                    if (!nDisplayMode) {
                        String patternName = this.writePatternElement(bounds, pattern, imgWidth, imgHeight, nFlipMode, patternColor);
                        if (patternName != null) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("url(#");
                            sb.append(patternName);
                            sb.append(')');
                            fillAttr = sb.toString();
                            break;
                        }
                        if (this.m_eh != null) {
                            this.m_eh.log("pattern name null", this.getClass().getName(), "protected String calcFillAttribute");
                        }
                        fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
                        break;
                    }
                    if (this.m_eh != null) {
                        this.m_eh.log("unknown display mode", this.getClass().getName(), "protected String calcFillAttribute");
                    }
                    fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
                    break;
                }
                if (this.m_eh != null) {
                    this.m_eh.log("texture image null", this.getClass().getName(), "protected String calcFillAttribute");
                }
                fillAttr = GraphSVGWriter.colorToHex(bb.getFillColor());
            }
        }
        return fillAttr;
    }

    protected String writePatternElement(Rectangle bounds, String szURL, int imgWidth, int imgHeight, int nFlipMode) throws IOException, Exception {
        String elemID = this.getNextPatternID();
        this.startElement("defs");
        this.startElement("pattern");
        this.writeAttribute("id", elemID);
        this.writeAttribute(DATA_ZOOM_WIDTH, imgWidth);
        this.writeAttribute(DATA_ZOOM_HEIGHT, imgHeight);
        this.writeAttribute("patternUnits", "userSpaceOnUse");
        if (this.startImageElement(imgWidth, imgHeight, szURL)) {
            this.endElement();
        } else if (this.m_eh != null) {
            this.m_eh.log("could not start image element", this.getClass().getName(), "protected String writePatternElement");
        }
        this.endElement();
        this.endElement();
        return elemID;
    }

    protected String writePatternElement(Rectangle bounds, int pattern, int imgWidth, int imgHeight, int nFlipMode, Color color) throws IOException, Exception {
        String elemID = this.getNextPatternID();
        this.startElement("defs");
        this.startElement("pattern");
        this.writeAttribute("id", elemID);
        this.writeAttribute(DATA_ZOOM_WIDTH, imgWidth);
        this.writeAttribute(DATA_ZOOM_HEIGHT, imgHeight);
        this.writeAttribute("patternUnits", "userSpaceOnUse");
        int halfWidth = imgWidth / 2;
        int halfHeight = imgHeight / 2;
        this.startRectElement(0, 0, imgWidth, imgHeight);
        this.writeAttribute("fill", Color.white);
        this.endElement();
        switch (pattern) {
            case 0: {
                this.startLineElement(halfWidth, 0, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.endElement();
                this.startLineElement(0, halfHeight, halfWidth, imgHeight);
                this.writeAttribute("stroke", color);
                this.endElement();
                break;
            }
            case 1: 
            case 7: {
                this.startRectElement(0, 0, halfWidth, halfHeight);
                this.writeAttribute("fill", color);
                this.endElement();
                this.startRectElement(halfWidth, halfHeight, halfWidth, halfHeight);
                this.writeAttribute("fill", color);
                this.endElement();
                break;
            }
            case 2: {
                this.startLineElement(0, halfHeight, halfWidth, 0);
                this.writeAttribute("stroke", color);
                this.endElement();
                this.startLineElement(halfWidth, imgHeight, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.endElement();
                break;
            }
            case 3: 
            case 9: {
                int[] xcoords = new int[]{0, imgWidth, imgWidth};
                int[] ycoords = new int[]{imgHeight, 0, imgHeight};
                this.startPolygonElement(xcoords, ycoords, xcoords.length);
                this.writeAttribute("fill", color);
                this.endElement();
                break;
            }
            case 4: {
                this.startLineElement(halfWidth, 0, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.endElement();
                this.startLineElement(0, halfHeight, halfWidth, imgHeight);
                this.writeAttribute("stroke", color);
                this.endElement();
                this.startLineElement(0, halfHeight, halfWidth, 0);
                this.writeAttribute("stroke", color);
                this.endElement();
                this.startLineElement(halfWidth, imgHeight, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.endElement();
                break;
            }
            case 5: 
            case 11: {
                int[] xcoords = new int[]{halfWidth, imgWidth, halfWidth, 0};
                int[] ycoords = new int[]{0, halfHeight, imgHeight, halfHeight};
                this.startPolygonElement(xcoords, ycoords, xcoords.length);
                this.writeAttribute("fill", color);
                this.endElement();
                break;
            }
            case 6: {
                this.startLineElement(halfWidth, 0, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.writeAttribute("stroke-linecap", "square");
                this.endElement();
                this.startLineElement(0, halfHeight, halfWidth, imgHeight);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.writeAttribute("stroke-linecap", "square");
                this.endElement();
                break;
            }
            case 8: {
                this.startLineElement(0, halfHeight, halfWidth, 0);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.writeAttribute("stroke-linecap", "square");
                this.endElement();
                this.startLineElement(halfWidth, imgHeight, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.writeAttribute("stroke-linecap", "square");
                this.endElement();
                break;
            }
            default: {
                this.startLineElement(halfWidth, 0, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.endElement();
                this.startLineElement(0, halfHeight, halfWidth, imgHeight);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.endElement();
                this.startLineElement(0, halfHeight, halfWidth, 0);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.endElement();
                this.startLineElement(halfWidth, imgHeight, imgWidth, halfHeight);
                this.writeAttribute("stroke", color);
                this.writeAttribute("stroke-width", 3);
                this.endElement();
            }
        }
        this.endElement();
        this.endElement();
        return elemID;
    }

    protected String writeGradientElement(BlackBoxIF bb, Rectangle bounds) throws IOException, Exception {
        String elemID = this.getNextGradientID();
        this.startElement("defs");
        int direction = 0;
        FillObj fillObj = bb.getFillObj();
        direction = fillObj != null && fillObj instanceof FillGradientObj ? ((FillGradientObj)fillObj).getDirection() : this.m_pfj.getGradientDirection(bb.getIdentObj());
        switch (direction) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.writeLinearGradientElement(bb, bounds, elemID, direction);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.writeRadialGradientElement(bb, bounds, elemID, direction);
                break;
            }
            case 14: {
                if (this.m_eh == null) break;
                this.m_eh.log("rectangular gradient not supported", this.getClass().getName(), "protected String writeGradientElement");
            }
        }
        this.endElement();
        return elemID;
    }

    protected void writeLinearGradientElement(BlackBoxIF bb, Rectangle bounds, String elemID, int direction) throws IOException, Exception {
        this.startElement("linearGradient");
        this.writeAttribute("id", elemID);
        this.writeAttribute("gradientUnits", "userSpaceOnUse");
        switch (direction) {
            case 1: {
                this.writeAttribute("x1", bounds.x);
                this.writeAttribute("y1", bounds.y);
                this.writeAttribute("x2", bounds.x + bounds.width);
                this.writeAttribute("y2", bounds.y);
                break;
            }
            case 2: {
                this.writeAttribute("x1", bounds.x + bounds.width);
                this.writeAttribute("y1", bounds.y);
                this.writeAttribute("x2", bounds.x);
                this.writeAttribute("y2", bounds.y);
                break;
            }
            case 3: {
                this.writeAttribute("x1", bounds.x);
                this.writeAttribute("y1", bounds.y);
                this.writeAttribute("x2", bounds.x);
                this.writeAttribute("y2", bounds.y + bounds.height);
                break;
            }
            case 4: {
                this.writeAttribute("x1", bounds.x);
                this.writeAttribute("y1", bounds.y + bounds.height);
                this.writeAttribute("x2", bounds.x);
                this.writeAttribute("y2", bounds.y);
                break;
            }
            case 5: {
                this.writeAttribute("x1", bounds.x + bounds.width);
                this.writeAttribute("y1", bounds.y);
                this.writeAttribute("x2", bounds.x);
                this.writeAttribute("y2", bounds.y + bounds.height);
                break;
            }
            case 6: {
                this.writeAttribute("x1", bounds.x + bounds.width);
                this.writeAttribute("y1", bounds.y + bounds.height);
                this.writeAttribute("x2", bounds.x);
                this.writeAttribute("y2", bounds.y);
                break;
            }
            case 7: {
                this.writeAttribute("x1", bounds.x);
                this.writeAttribute("y1", bounds.y);
                this.writeAttribute("x2", bounds.x + bounds.width);
                this.writeAttribute("y2", bounds.y + bounds.height);
                break;
            }
            case 8: {
                this.writeAttribute("x1", bounds.x);
                this.writeAttribute("y1", bounds.y + bounds.height);
                this.writeAttribute("x2", bounds.x + bounds.width);
                this.writeAttribute("y2", bounds.y);
            }
        }
        this.writeGradientStopElements(bb);
        this.endElement();
    }

    protected void writeRadialGradientElement(BlackBoxIF bb, Rectangle bounds, String elemID, int direction) throws IOException, Exception {
        this.startElement("radialGradient");
        this.writeAttribute("id", elemID);
        switch (direction) {
            case 9: {
                this.writeAttribute("r", "75%");
                break;
            }
            case 10: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "0%");
                this.writeAttribute("cy", "0%");
                break;
            }
            case 11: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "100%");
                this.writeAttribute("cy", "0%");
                break;
            }
            case 12: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "0%");
                this.writeAttribute("cy", "100%");
                break;
            }
            case 13: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "100%");
                this.writeAttribute("cy", "100%");
            }
        }
        this.writeGradientStopElements(bb);
        this.endElement();
    }

    protected void writeGradientStopElements(BlackBoxIF bb) throws IOException, Exception {
        IdentObj id = bb.getIdentObj();
        int pinCount = 0;
        FillObj fillObj = bb.getFillObj();
        List<GradientStopObj> pins = null;
        if (fillObj != null && fillObj instanceof FillGradientObj) {
            pins = ((FillGradientObj)fillObj).getStopList();
            pinCount = pins.size();
        } else {
            pinCount = this.m_pfj.getGradientNumPins(id);
        }
        for (int pin = 0; pin < pinCount; ++pin) {
            this.startElement("stop");
            GradientStopObj colorPinObj = null;
            if (pins != null) {
                colorPinObj = pins.get(pin);
            }
            double offset = 0.5;
            offset = colorPinObj == null ? this.m_pfj.getGradientPinPosition(id, pin) : colorPinObj.getPosition();
            this.writeAttribute("offset", offset);
            Color color = null;
            color = colorPinObj == null ? this.m_pfj.getGradientPinRightColor(id, pin) : colorPinObj.getColor();
            this.writeAttribute("stop-color", color);
            if (color != null) {
                this.writeOpacityAttribute(color, "stop-opacity");
            }
            this.endElement();
        }
    }

    protected String getNextGradientID() {
        return this.getFilteredBeanName() + "_" + GRADIENT_ID_BASE + this.m_gradientCount++;
    }

    protected String getNextPatternID() {
        return this.getFilteredBeanName() + "_" + PATTERN_ID_BASE + this.m_patternCount++;
    }

    protected String createDataScrollSubmitJS(String axis, String srcID) {
        return "bi_submitDataScrollEvent(scrObj, " + axis + ", " + srcID + ")";
    }

    public String createElementId(IdentObj identObj) {
        int id = ObjClassID.stripExceptionalOffset(identObj.getObjectID());
        int group = identObj.getGroupID();
        int series = identObj.getSeriesID();
        int misc = identObj.getMiscID();
        StringBuilder sb = new StringBuilder();
        String name = null;
        String axis = null;
        switch (id) {
            case 1: {
                sb.append("ChartBackground");
                break;
            }
            case 301: {
                sb.append("PieBarConnectLines");
                break;
            }
            case 317: {
                if (name == null) {
                    name = "LineRiserSide";
                }
            }
            case 258: {
                if (name == null) {
                    name = "LineRiser";
                }
            }
            case 318: {
                if (name == null) {
                    name = "LineRiserTop";
                }
                sb.append(name);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 259: {
                sb.append("LineMarker");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 277: {
                if (name == null) {
                    name = "BarRiser";
                }
            }
            case 312: {
                if (name == null) {
                    name = "BarRiserSide";
                }
            }
            case 313: {
                if (name == null) {
                    name = "BarRiserBottom";
                }
            }
            case 331: {
                if (name == null) {
                    name = "PieBarRiser";
                }
            }
            case 334: {
                if (name == null) {
                    name = "PieBarRiserSide";
                }
            }
            case 335: {
                if (name == null) {
                    name = "PieBarRiserTop";
                }
                sb.append(name);
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 310: {
                sb.append("StockVolumeRiser");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 303: {
                if (name == null) {
                    name = "StockRiser";
                }
            }
            case 306: {
                if (name == null) {
                    name = "StockLowerRiser";
                }
            }
            case 307: {
                if (name == null) {
                    name = "StockCloseTick";
                }
            }
            case 308: {
                if (name == null) {
                    name = "StockOpenTick";
                }
            }
            case 319: {
                if (name == null) {
                    name = "StockRisingRiser";
                }
            }
            case 320: {
                if (name == null) {
                    name = "StockFallingRiser";
                }
            }
            case 321: {
                if (name == null) {
                    name = "StockHighLine";
                }
            }
            case 322: {
                if (name == null) {
                    name = "StockLowLine";
                }
                sb.append(name);
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 474: {
                sb.append("ParetoLineMarker");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 473: {
                if (name == null) {
                    name = "ParetoLineRiser";
                }
            }
            case 475: {
                if (name == null) {
                    name = "ParetoLineRiserTop";
                }
            }
            case 476: {
                if (name == null) {
                    name = "ParetoLineRiserSide";
                }
                sb.append(name);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 315: {
                if (name == null) {
                    name = "AreaRiserSide";
                }
            }
            case 256: {
                if (name == null) {
                    name = "AreaRiser";
                }
            }
            case 314: {
                if (name == null) {
                    name = "AreaRiserTop";
                }
            }
            case 316: {
                if (name == null) {
                    name = "AreaRiserBottom";
                }
                sb.append(name);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 606: {
                sb.append("CubeRiserFace");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                if (this.m_pfj.getGraphType() == 12) break;
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 41: {
                sb.append("CurveFitLineRiser");
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 12: {
                sb.append("LegendArea");
                break;
            }
            case 13: {
                sb.append("LegendMarker");
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 14: {
                if (this.m_pfj.getGraphType() != 12) {
                    sb.append("LegendText");
                    sb.append(ID_PARAM_SERIES);
                    sb.append(series);
                    sb.append(ID_PARAM_EDGE);
                    sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                    break;
                }
                sb.append("LegendText");
                break;
            }
            case 18: {
                if (this.m_pfj.getGraphType() != 12) break;
                sb.append("SpectralLegendMarker");
                break;
            }
            case 260: {
                sb.append("DataText");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 294: {
                sb.append("PieFeelerLine");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 296: {
                sb.append("DataText");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_COL : ID_PARAM_VAL_ROW);
                break;
            }
            case 297: {
                sb.append("DataText");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_COL : ID_PARAM_VAL_ROW);
                break;
            }
            case 2: {
                if (name == null) {
                    name = "Frame";
                }
                sb.append(name);
                if (misc < 0) break;
                sb.append(ID_PARAM_MISC);
                sb.append(misc);
                break;
            }
            case 15: {
                if (name == null) {
                    name = "FrameSide";
                }
            }
            case 16: {
                if (name == null) {
                    name = "FrameBottom";
                }
                sb.append(name);
                break;
            }
            case 302: {
                sb.append("PieFrame");
                break;
            }
            case 328: {
                if (name == null) {
                    name = "QuadrantLine";
                }
            }
            case 329: {
                if (name == null) {
                    name = "ScatterQuadrantLine";
                }
                sb.append(name);
                break;
            }
            case 298: {
                if (name == null) {
                    name = "Slice";
                }
            }
            case 299: {
                if (name == null) {
                    name = "SliceCrust";
                }
            }
            case 300: {
                if (name == null) {
                    name = "SliceRing";
                }
                sb.append(name);
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 332: {
                if (name == null) {
                    name = "PieBarSlice";
                }
            }
            case 333: {
                if (name == null) {
                    name = "PieBarSliecCrust";
                }
                sb.append(name);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 295: {
                sb.append("PieSliceLabel");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 17: {
                sb.append("FrameSeparator");
                break;
            }
            case 269: {
                sb.append("O1AxisLine");
                break;
            }
            case 279: {
                sb.append("X1AxisLine");
                break;
            }
            case 271: {
                sb.append("O1MajorGrid");
                break;
            }
            case 281: {
                sb.append("X1MajorGrid");
                break;
            }
            case 614: {
                if (name == null) {
                    name = "CubeFloorGridX";
                }
            }
            case 618: {
                if (name == null) {
                    name = "CubeRightWallGridX";
                }
                sb.append(name);
                break;
            }
            case 270: {
                sb.append("O1Label");
                sb.append(ID_PARAM_GROUP);
                sb.append(group);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_COL : ID_PARAM_VAL_ROW);
                if (misc <= 0) break;
                sb.append(ID_PARAM_MISC);
                sb.append(misc);
                break;
            }
            case 280: {
                sb.append("X1Label");
                break;
            }
            case 8: {
                sb.append("O1Title");
                break;
            }
            case 10: {
                sb.append("X1Title");
                break;
            }
            case 283: {
                sb.append("Y1AxisLine");
                break;
            }
            case 285: {
                sb.append("Y1MajorGrid");
                break;
            }
            case 616: {
                if (name == null) {
                    name = "CubeLeftWallGridY";
                }
            }
            case 619: {
                if (name == null) {
                    name = "CubeRightWallGridY";
                }
                sb.append(name);
                break;
            }
            case 284: {
                sb.append("Y1Label");
                break;
            }
            case 6: {
                sb.append("Y1Title");
                break;
            }
            case 292: {
                sb.append("Y1ZeroLine");
                break;
            }
            case 287: {
                sb.append("Y2AxisLine");
                break;
            }
            case 289: {
                sb.append("Y2MajorGrid");
                break;
            }
            case 288: {
                sb.append("Y2Label");
                break;
            }
            case 7: {
                sb.append("Y2Title");
                break;
            }
            case 293: {
                sb.append("Y2ZeroLine");
                break;
            }
            case 608: {
                sb.append("CubeRiserGridY");
                break;
            }
            case 615: {
                if (name == null) {
                    name = "CubeFloorGridZ";
                }
            }
            case 617: {
                if (name == null) {
                    name = "CubeLeftWallGridZ";
                }
                sb.append(name);
                break;
            }
            case 274: {
                sb.append("O2Label");
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 9: {
                sb.append("O2Title");
                break;
            }
            case 603: {
                sb.append("CubeFloor");
                break;
            }
            case 604: {
                sb.append("CubeLeftWall");
                break;
            }
            case 605: {
                sb.append("CubeRightWall");
                break;
            }
            case 3: {
                sb.append("Footnote");
                break;
            }
            case 4: {
                sb.append("Subtitle");
                break;
            }
            case 5: {
                sb.append("Title");
                break;
            }
            case 357: {
                int location = this.m_pfj.getReferenceObjectLocation(identObj);
                if (location == 0) {
                    sb.append("ReferenceObjectFront");
                    break;
                }
                sb.append("ReferenceObjectBack");
                break;
            }
            case 358: {
                switch (group) {
                    case 279: {
                        if (axis != null) break;
                        axis = "X1";
                        break;
                    }
                    case 283: {
                        if (axis != null) break;
                        axis = "Y1";
                        break;
                    }
                    case 287: {
                        if (axis != null) break;
                        axis = "Y2";
                    }
                }
                sb.append("ReferenceLine");
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_AXIS);
                sb.append(axis);
                break;
            }
            case 511: {
                sb.append("SelectPointMarker");
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                break;
            }
            case 503: {
                switch (group) {
                    case 279: {
                        if (axis != null) break;
                        axis = "X1";
                        break;
                    }
                    case 283: {
                        if (axis != null) break;
                        axis = "Y1";
                        break;
                    }
                    case 287: {
                        if (axis != null) break;
                        axis = "Y2";
                    }
                }
                sb.append("ReferenceLineLegendText");
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_AXIS);
                sb.append(axis);
                break;
            }
            case 504: {
                switch (group) {
                    case 279: {
                        if (axis != null) break;
                        axis = "X1";
                        break;
                    }
                    case 283: {
                        if (axis != null) break;
                        axis = "Y1";
                        break;
                    }
                    case 287: {
                        if (axis != null) break;
                        axis = "Y2";
                    }
                }
                sb.append("ReferenceLegendMarker");
                sb.append(ID_PARAM_SERIES);
                sb.append(series);
                sb.append(ID_PARAM_AXIS);
                sb.append(axis);
                break;
            }
            case 232: {
                sb.append("O1DrillLabel");
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_COL : ID_PARAM_VAL_ROW);
                break;
            }
            case 233: {
                sb.append("O2DrillLabel");
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 235: {
                sb.append("DrillText");
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 234: {
                sb.append("DrillMarker");
                sb.append(ID_PARAM_EDGE);
                sb.append(this.m_pfj.getSeriesAreRows() ? ID_PARAM_VAL_ROW : ID_PARAM_VAL_COL);
                break;
            }
            case 513: {
                sb.append("TimeSelector");
                break;
            }
            case 359: {
                sb.append("SeriesObjects");
                break;
            }
        }
        if (sb.length() > 0) {
            sb.insert(0, this.getSimpleBeanName() + ID_PARAM_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    protected String constructId(String id) {
        if (id == null || id.length() < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFilteredBeanName());
        sb.append("_");
        sb.append(id);
        return sb.toString();
    }
}

