/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.ThresholdOutOfRangeException;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.Threshold;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.JChart_2D_BLA;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.sparkChart.CommonSparkChart;
import oracle.dss.sparkChart.SparkItem;
import oracle.javatools.annotations.Concealed;

@Concealed
public class SparkchartUtils {
    public static LocalXMLDataSource convertCollectionModelToDataModel(CommonGraph spark, List<SparkItem> list, CommonSparkChart.Type subType) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<Number> values = new ArrayList<Number>();
        ArrayList<Number> floatValues = new ArrayList<Number>();
        ArrayList<Date> timeValues = new ArrayList<Date>();
        for (SparkItem dataItem : list) {
            values.add(dataItem.getValue());
            floatValues.add(dataItem.getFloatValue());
            timeValues.add(dataItem.getDate());
        }
        int numValues = values.size();
        Object[] columnLabels = new Object[numValues];
        Object[] rowLabels = new Object[]{spark.getIntlString("af_dvt_graph.SPARK_VALUE")};
        if (subType == CommonSparkChart.Type.FLOATING_BAR) {
            for (Object e : floatValues) {
                if (e == null) continue;
                rowLabels = new Object[]{spark.getIntlString("af_dvt_graph.SPARK_FLOAT_VALUE"), spark.getIntlString("af_dvt_graph.SPARK_VALUE")};
                break;
            }
        }
        boolean bDateLabels = false;
        for (Date date : timeValues) {
            if (date == null) continue;
            bDateLabels = true;
            spark.setTimeAxisType(2);
            break;
        }
        Object[][] objectArray = new Object[numValues][rowLabels.length];
        for (int i = 0; i < numValues; ++i) {
            columnLabels[i] = bDateLabels ? timeValues.get(i) : "Column " + i;
            if (rowLabels.length > 1) {
                objectArray[i][0] = floatValues.get(i);
                objectArray[i][1] = values.get(i);
                continue;
            }
            objectArray[i][0] = values.get(i);
        }
        return new LocalXMLDataSource(columnLabels, rowLabels, objectArray);
    }

    protected static void applySparkchartProperties(Perspective pfj) {
        CommonGraph cg = pfj.getCommonGraph();
        boolean noXML = pfj.isNoXMLMode();
        pfj.setNoXMLMode(true);
        int graphType = pfj.getGraphType();
        switch (graphType) {
            case 17: 
            case 31: 
            case 41: 
            case 95: {
                break;
            }
            default: {
                pfj.setNoXMLMode(noXML);
                return;
            }
        }
        cg.setAutoLayout(0);
        int virtHorizGap = pfj.getVC().destToVirtWidth(2);
        int virtVertGap = pfj.getVC().destToVirtHeight(SparkchartUtils.getVertGap(graphType, pfj));
        Rectangle plotAreaRect = new Rectangle(-16000 + virtHorizGap, -16000 + virtVertGap, 32000 - 2 * virtHorizGap, 32000 - 2 * virtVertGap);
        pfj.setRect(pfj.getFrame(), plotAreaRect);
        if (graphType == 95) {
            cg.setDisplaySeries(2);
        } else {
            cg.setDisplaySeries(1);
        }
        cg.getSeries().setDefaultLineWidth(1);
        cg.getLegendArea().setVisible(false);
        cg.getO1Axis().setVisible(false);
        cg.getX1Axis().setVisible(false);
        cg.getY1Axis().setVisible(false);
        cg.getY2Axis().setVisible(false);
        cg.getO1MajorTick().setTickStyle(6);
        cg.getX1MajorTick().setTickStyle(6);
        cg.getY1MajorTick().setTickStyle(6);
        cg.getY2MajorTick().setTickStyle(6);
        cg.setCustomLayout(0);
        cg.setVisualEffects(0);
        cg.setSeriesEffect(0);
        Vector ruleBundle = SparkchartUtils.getThresholdsAsRuleBundle(pfj);
        if (!ruleBundle.isEmpty()) {
            cg.getGraphStyleManager().setBundles(cg, ruleBundle);
        }
        cg.getGraphBackground().getSFX().setFillType(1);
        if (pfj.getFillColor(pfj.getChartBackground(), false) == null) {
            pfj.setFillColor(pfj.getChartBackground(), Attr.DEFAULT_SPARKCHART_BACKGROUND_COLOR);
        }
        if (pfj.getFromLook2(IdentObj.GLOBAL, Attr.DefaultColor) == null) {
            cg.getSeries().setDefaultColor(Attr.DEFAULT_SPARKCHART_COLOR);
        }
        if (SparkchartUtils.isDrawingHighLowMarkers(pfj)) {
            SparkchartUtils.calculateHighLowMarkers(pfj);
        }
        if ((graphType == 41 || graphType == 31) && SparkchartUtils.isDrawingMarkers(pfj)) {
            pfj.setMarkerDisplay(true);
            cg.getSeries().setDefaultMarkerColor(new Color(0xFFFFFF, true));
        }
        pfj.setNoXMLMode(noXML);
    }

    private static Vector getThresholdsAsRuleBundle(Perspective pfj) {
        Integer thresholdCountObj = (Integer)pfj.getFromLook2(IdentObj.GLOBAL, Attr.ThresholdCount);
        if (thresholdCountObj != null) {
            RuleBundle bundle = new RuleBundle();
            Threshold threshold = pfj.getCommonGraph().getThreshold();
            int numThresholds = thresholdCountObj;
            for (int i = numThresholds - 1; i >= 0; --i) {
                try {
                    double maxValue = i == numThresholds - 1 ? Double.MAX_VALUE : threshold.getMaxValue(i);
                    Color color = threshold.getColor(i);
                    DiscriminatorRule dr = new DiscriminatorRule();
                    dr.setDiscriminator((Discriminator)new NumberValueDiscriminator(maxValue, 1));
                    GraphStyle gs = new GraphStyle();
                    gs.setFillColor(color);
                    dr.setFixedMergeable((Mergeable)gs);
                    bundle.addRule((Rule)dr);
                    continue;
                }
                catch (ThresholdOutOfRangeException thresholdOutOfRangeException) {
                    // empty catch block
                }
            }
            Vector<RuleBundle> styleVector = new Vector<RuleBundle>();
            styleVector.addElement(bundle);
            return styleVector;
        }
        return new Vector();
    }

    private static void calculateHighLowMarkers(Perspective pfj) {
        if (!(pfj.getGraphObject() instanceof JChart_2D_BLA)) {
            return;
        }
        JChart_2D_BLA chart = (JChart_2D_BLA)pfj.getGraphObject();
        int series = 0;
        if (pfj.getGraphType() == 95) {
            series = 1;
        }
        int numGroups = pfj.getNumTotalGroups();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int minGroup = -1;
        int maxGroup = -1;
        for (int group = 0; group < numGroups; ++group) {
            double y;
            try {
                Point2D value = chart.getDataValuesXY(series, group);
                if (value == null) continue;
                y = value.getY();
            }
            catch (AssertionException e) {
                continue;
            }
            if (y < min) {
                min = y;
                minGroup = group;
            }
            if (!(y > max)) continue;
            max = y;
            maxGroup = group;
        }
        chart.setMinValueGroupIndex(minGroup);
        chart.setMaxValueGroupIndex(maxGroup);
    }

    private static boolean isDrawingHighLowMarkers(Perspective pfj) {
        EnumSet<GraphConstants.Markers> enumSet = pfj.getDefaultMarkers();
        if (enumSet.contains((Object)GraphConstants.Markers.HIGH) || enumSet.contains((Object)GraphConstants.Markers.LOW)) {
            return true;
        }
        return enumSet.contains((Object)GraphConstants.Markers.AUTO) && (pfj.getDefaultMarkerColor(GraphConstants.Markers.HIGH, false) != null || pfj.getDefaultMarkerColor(GraphConstants.Markers.LOW, false) != null);
    }

    protected static boolean isDrawingMarkers(Perspective pfj) {
        EnumSet<GraphConstants.Markers> enumSet = pfj.getDefaultMarkers();
        if (enumSet.contains((Object)GraphConstants.Markers.HIGH) || enumSet.contains((Object)GraphConstants.Markers.LOW) || enumSet.contains((Object)GraphConstants.Markers.FIRST) || enumSet.contains((Object)GraphConstants.Markers.LAST)) {
            return true;
        }
        return enumSet.contains((Object)GraphConstants.Markers.AUTO) && (pfj.getDefaultMarkerColor(GraphConstants.Markers.HIGH, false) != null || pfj.getDefaultMarkerColor(GraphConstants.Markers.LOW, false) != null || pfj.getDefaultMarkerColor(GraphConstants.Markers.FIRST, false) != null || pfj.getDefaultMarkerColor(GraphConstants.Markers.LAST, false) != null);
    }

    private static int getVertGap(int graphType, Perspective pfj) {
        if (graphType != 41 && graphType != 31) {
            return 0;
        }
        int markerSizeFactor = pfj.getMarkerSizeDefault();
        int markerWidth = pfj.getVC().virtToDestWidth(MarkerTemplate.MARKER_SQUARE.width * markerSizeFactor / 100);
        int markerHeight = pfj.getVC().virtToDestHeight(MarkerTemplate.MARKER_SQUARE.height * markerSizeFactor / 100);
        int markerSize = Math.max(markerWidth, markerHeight);
        int gap = Math.max(markerSize / 3, 1);
        return gap;
    }
}

