/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.FillGradientObj;

public class BorderObj
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int DOTTED_SIZE = 2;
    private Color m_color;
    private FillGradientObj m_GradientObj;

    public BorderObj() {
        this.m_color = Color.WHITE;
    }

    public BorderObj(Color c) {
        this.m_color = c;
    }

    public BorderObj(BorderObj b) {
        this.copy(b);
    }

    public void copy(BorderObj b) {
        this.m_color = b.m_color;
    }

    public Color getColor() {
        return this.m_color;
    }

    public FillGradientObj getGradient() {
        return this.m_GradientObj;
    }

    public void paint(Graphics g, Point a, Point b) {
        g.setColor(this.m_color);
        g.drawLine(a.x, a.y, b.x, b.y);
    }

    public void paint(Graphics g, Point2D a, Point2D b) {
        g.setColor(this.m_color);
        Line2D.Double line = new Line2D.Double(a, b);
        ((Graphics2D)g).draw(line);
    }

    public void paint(Graphics g, Perspective pfj, Polygon p) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setColor(this.m_color);
        g2.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void paint(Graphics g, Perspective pfj, Area area) {
        g.setColor(this.m_color);
        Graphics2D g2 = (Graphics2D)g;
        if (Perspective.compareVersions(Perspective.m_JavaVersion, "1.4.0") == -1 || pfj.getPrimitiveAntialiasing()) {
            g2.draw(area);
        } else {
            g2.setStroke(new BasicStroke(1.01f));
            g2.draw(area);
            g2.setStroke(new BasicStroke(1.0f));
        }
    }

    public void paint(Graphics g, Perspective pfj, RectangularShape shape) {
        g.setColor(this.m_color);
        Graphics2D g2 = (Graphics2D)g;
        if (Perspective.compareVersions(Perspective.m_JavaVersion, "1.4.0") == -1 || pfj.getPrimitiveAntialiasing()) {
            g2.draw(shape);
        } else {
            g2.setStroke(new BasicStroke(1.01f));
            g2.draw(shape);
            g2.setStroke(new BasicStroke(1.0f));
        }
    }

    public void paint(Graphics g, Perspective pfj, RectangularShape shape, float borderWidth) {
        g.setColor(this.m_color);
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(borderWidth));
        g2.draw(shape);
        g2.setStroke(oldStroke);
    }

    public void paint(Graphics g, Perspective pfj, GeneralPath path) {
        g.setColor(this.m_color);
        Graphics2D g2 = (Graphics2D)g;
        g2.draw(path);
    }

    public void paint(Graphics g, Polygon p) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setColor(this.m_color);
        g2.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void paint(Graphics g, Rectangle r) {
        g.setColor(this.m_color);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    public void paint(Graphics g, Rectangle r, boolean bDotted) {
        int nY;
        int nX;
        g.setColor(this.m_color);
        int nXRight = r.x + r.width - 2;
        for (nX = r.x; nX <= nXRight; nX += 4) {
            g.drawLine(nX, r.y, nX + 2, r.y);
        }
        for (nX = r.x; nX <= nXRight; nX += 4) {
            g.drawLine(nX, r.y + r.height, nX + 2, r.y + r.height);
        }
        int nYBot = r.y + r.height - 2;
        for (nY = r.y; nY <= nYBot; nY += 4) {
            g.drawLine(r.x, nY, r.x, nY + 2);
        }
        nYBot = r.y + r.height - 2;
        for (nY = r.y; nY <= nYBot; nY += 4) {
            g.drawLine(r.x + r.width, nY, r.x + r.width, nY + 2);
        }
        g.drawLine(r.x, r.y, r.x + 1, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + 1);
        g.drawLine(r.x, r.y + r.height - 1, r.x, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + 1, r.y + r.height);
        g.drawLine(r.x + r.width - 1, r.y + r.height, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width, r.y + r.height - 1, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width, r.y);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + 1);
    }

    public void paintOval(Graphics g, Rectangle r) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.m_color);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void setGradient(FillGradientObj gradient) {
        this.m_GradientObj = gradient;
    }

    public void paint(Graphics g, Point a, Point b, int nThickness) {
        g.setColor(this.m_color);
        g.drawLine(a.x, a.y, b.x, b.y);
        g.fillRect(a.x, a.y, b.x - b.y, nThickness);
    }

    public void paintOval(Graphics g, Rectangle r, int nThickness, int nUnitWidth) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.m_color);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

