/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared;

import java.util.List;
import oracle.dss.legend.shared.LegendSettings;
import oracle.dss.legend.shared.visit.LegendVisitContext;
import oracle.dss.legend.shared.visit.LegendVisitor;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.Stroke;

public abstract class LegendItem {
    public static final int ITEM_GAP = 2;
    public static final int DBL_ITEM_GAP = 4;
    public static final int SECTION_GAP = 6;
    public static final int DBL_SECTION_GAP = 12;
    public static final int DIFF_GAP = 4;
    public static final int SECTION_INDENT = 7;
    protected LegendSettings m_settings;
    protected Fill m_fill;
    protected Stroke m_border;
    protected int m_itemGap = 2;
    protected int m_sectionGap = 6;
    protected String m_id = "";
    protected int m_x;
    protected int m_y;
    protected int m_width;
    protected int m_height;

    public void accept(LegendVisitor visitor, LegendVisitContext context) {
        visitor.visitAll(this, context);
        this.internalAccept(visitor, context);
    }

    protected abstract void internalAccept(LegendVisitor var1, LegendVisitContext var2);

    public void setSettings(LegendSettings context) {
        this.m_settings = context;
    }

    public abstract Fill getDefaultFill();

    public abstract Stroke getDefaultBorder();

    public Fill getInstanceFill() {
        Fill instanceFill = this.m_fill;
        if (instanceFill == null) {
            instanceFill = this.getDefaultFill();
        }
        return instanceFill;
    }

    public Stroke getInstanceBorder() {
        Stroke instanceBorder = this.m_border;
        if (instanceBorder == null) {
            instanceBorder = this.getDefaultBorder();
        }
        return instanceBorder;
    }

    public abstract void calc();

    public abstract void calcFinal();

    public abstract List<DrawableObject> render();

    public void setPosition(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public void setBorder(Stroke border) {
        this.m_border = border;
    }

    public void setFill(Fill fill) {
        this.m_fill = fill;
    }

    public void setId(String m_id) {
        this.m_id = m_id;
    }

    public String getId() {
        return this.m_id;
    }
}

