/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class Stroke {
    private Color m_color;
    private float m_width;
    private String m_style;
    private Map m_properties;
    private int m_cap;
    private int m_join;
    private float m_miterLimit;
    private float[] m_dash;
    private float m_dashPhase;
    public static final float DEFAULT_WIDTH = 1.0f;
    public static final int DEFAULT_CAP = 2;
    public static final float DEFAULT_MITERLIMIT = 10.0f;
    public static final int DEFAULT_JOIN = 0;
    public static final float DEFAULT_DASHPHASE = 0.0f;

    public Stroke() {
        this.m_color = null;
        this.m_style = null;
        this.m_properties = new HashMap();
        this.initDefaults();
    }

    public Stroke(HashMap map) {
        this.m_properties = map;
        this.initDefaults();
    }

    public Stroke(java.awt.Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.m_cap = basicStroke.getEndCap();
            this.m_miterLimit = basicStroke.getMiterLimit();
            this.m_join = basicStroke.getLineJoin();
            this.m_dash = basicStroke.getDashArray();
            this.m_dashPhase = basicStroke.getDashPhase();
            this.m_width = basicStroke.getLineWidth();
        }
    }

    private void initDefaults() {
        this.m_width = 1.0f;
        this.m_cap = 2;
        this.m_miterLimit = 10.0f;
        this.m_join = 0;
        this.m_dash = null;
        this.m_dashPhase = 0.0f;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color c) {
        this.m_color = c;
    }

    public float getWidth() {
        return this.m_width;
    }

    public void setWidth(float w) {
        this.m_width = w;
    }

    public String getStyle() {
        return this.m_style;
    }

    public void setStyle(String style) {
        this.m_style = style;
    }

    public Map getProperties() {
        return this.m_properties;
    }

    public int getCap() {
        return this.m_cap;
    }

    public int getJoin() {
        return this.m_join;
    }

    public float getMiterLimit() {
        return this.m_miterLimit;
    }

    public float[] getDash() {
        return this.m_dash;
    }

    public float getDashPhase() {
        return this.m_dashPhase;
    }
}

