/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.filenav.FilesRootFolder;
import oracle.dbtools.raptor.filenav.NavRoot;
import oracle.dbtools.raptor.filenav.RecentFilesFolder;
import oracle.dbtools.raptor.utils.URLChooserShortcuts;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.explorer.TNode;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;

public class ProjectRootFilter
extends BaseRaptorFilter {
    private List<Element> m_children;

    protected Object getKey(Object object) {
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }

    public void closeChildren() {
        this.m_children = null;
    }

    public Iterator getChildren() {
        if (this.m_children == null) {
            this.m_children = this.loadChildren();
        }
        return this.m_children.iterator();
    }

    private List<Element> loadChildren() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        TNode tNode = this.getOwner();
        Element element = tNode.getData();
        if (element instanceof NavRoot) {
            NavRoot navRoot = (NavRoot)element;
            arrayList.add((Element)new RecentFilesFolder());
            ContentSet contentSet = navRoot.getFilesContent();
            arrayList.add((Element)new FilesRootFolder(contentSet));
        }
        return arrayList;
    }

    public Comparator getComparator() {
        return null;
    }

    static boolean isRoot(URL uRL) {
        Collection collection = URLChooserShortcuts.getInstance().getStandardDocumentLocationShortcuts();
        for (URLChooserShortcut uRLChooserShortcut : collection) {
            if (!URLFileSystem.equals((URL)uRLChooserShortcut.url(), (URL)uRL)) continue;
            return true;
        }
        return false;
    }
}

