/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ObjectOperationDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class DeleteImageCopyAction
extends ObjectOperationDialog {
    private String pKey = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        String string = this.getObjectName();
        if (Connections.getInstance().lock(connection)) {
            object = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("FNAME", string);
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getPKey"), hashMap);
                if (object != null) {
                    while (object.next()) {
                        this.pKey = object.getString("PKEY");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        object = super.createControls(connection);
        object.add(new SeperatorActionControl());
        object.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return object;
    }

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("IC_DELETE_TITLE");
    }

    protected String getObjectLabel() {
        return DbaNavigatorResources.getString("BACKUP_SET_LABEL");
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE NOPROMPT DATAFILECOPY ");
        stringBuffer.append(this.pKey);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }
}

