/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.FileNameConvertControl;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbStorageControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class PlugPdbsAction
extends ActionDialog {
    private static final String PDB_NAME = "PdbName";
    private static final String AS_CLONE = "AsClone";
    private static final String FILE_NAME = "FileName";
    private static final String SOURCE_CONVERT = "SourceConvert";
    private static final String FILE_CONVERT = "FileConvert";
    private static final String PDB_ACTION = "PdbAction";
    private static final String PDB_STORAGE = "PdbStorage";
    private static final String HELP_ID = "f1_dba_plug_pdb_html";

    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("PLUG_PDB_TITLE");
    }

    protected List<ActionControl> createControls(final Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), "NEW_PDB");
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(AS_CLONE, "AS CLONE", false);
        FilePathActionControl filePathActionControl = new FilePathActionControl(FILE_NAME, DbaNavigatorResources.getString("XML_FILE"), "PDB.XML", 0);
        final FileNameConvertControl fileNameConvertControl = new FileNameConvertControl(SOURCE_CONVERT, DbaNavigatorResources.getString("SOURCE_FILE_NAME_CONVERT_LABEL"), connection, true, textBoxActionControl.getValue().get());
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(PDB_ACTION, DbaNavigatorResources.getString("PDB_ACTION"), new String[]{"NOCOPY", "COPY", "MOVE"}, "NOCOPY");
        final FileNameConvertControl fileNameConvertControl2 = new FileNameConvertControl(FILE_CONVERT, DbaNavigatorResources.getString("FILE_NAME_CONVERT_LABEL"), connection, true, textBoxActionControl.getValue().get());
        fileNameConvertControl2.setEditable(false);
        PdbStorageControl pdbStorageControl = new PdbStorageControl(PDB_STORAGE, DbaNavigatorResources.getString("STORAGE_LABEL"));
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (((ActionControl.Value)propertyChangeEvent.getNewValue()).get().equals("NOCOPY")) {
                    fileNameConvertControl2.setEditable(false);
                } else {
                    fileNameConvertControl2.setEditable(true);
                }
            }
        });
        textBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl, fileNameConvertControl2){
            final /* synthetic */ ActionControl val$pdbName;
            final /* synthetic */ FileNameConvertControl val$fileNameConvert;
            {
                this.val$pdbName = actionControl;
                this.val$fileNameConvert = fileNameConvertControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                fileNameConvertControl.resetSourcePdbName(connection, "PDB$SEED", this.val$pdbName.getValue().get());
                this.val$fileNameConvert.resetSourcePdbName(connection, "PDB$SEED", this.val$pdbName.getValue().get());
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)filePathActionControl);
        arrayList.add((ActionControl)fileNameConvertControl);
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)fileNameConvertControl2);
        arrayList.add((ActionControl)pdbStorageControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        stringBuffer.append("CREATE PLUGGABLE DATABASE \"");
        stringBuffer.append(values.get(PDB_NAME));
        stringBuffer.append('\"');
        if (values.get(AS_CLONE).equals("true")) {
            stringBuffer.append(" AS CLONE");
        }
        stringBuffer.append(" USING '");
        stringBuffer.append(values.get(FILE_NAME));
        stringBuffer.append("'");
        stringBuffer.append(FileNameConvertControl.getFileNameConvertClause(SOURCE_CONVERT, (ActionValuesLookup)values, true, false, string));
        stringBuffer.append('\n' + string + "  ");
        stringBuffer.append(values.get(PDB_ACTION));
        if (!values.get(PDB_ACTION).equals("NOCOPY")) {
            stringBuffer.append(FileNameConvertControl.getFileNameConvertClause(FILE_CONVERT, (ActionValuesLookup)values, false, false, string));
        }
        stringBuffer.append(PdbStorageControl.getStorageClause(PDB_STORAGE, (ActionValuesLookup)values, string));
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

