/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.rollbacksegments;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class ShrinkAction
extends ActionDialog {
    private static final String SEGMENT_NAME = "FileName";
    private static final String OPTIMAL = "Optimal";
    private static final String SEGMENT_SIZE = "SegmentSize";

    protected String getTitle() {
        return DbaNavigatorResources.getString("SHRINK_ROLLBACK_SEGMENT_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        String string = this.getObjectName();
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(SEGMENT_NAME, DbaNavigatorResources.getString("SEGMENT_NAME_LABEL"), string);
        final BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(OPTIMAL, DbaNavigatorResources.getString("SEGMENT_OPTIMAL_LABEL"), true);
        FileSizeActionControl fileSizeActionControl = new FileSizeActionControl(SEGMENT_SIZE, DbaNavigatorResources.getString("SEGMENT_SIZE_LABEL"), 102400L);
        textBoxActionControl.setEditable(false);
        fileSizeActionControl.enableUI(false);
        booleanCheckBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)fileSizeActionControl){
            final /* synthetic */ ActionControl val$segmentSizeCtl;
            {
                this.val$segmentSizeCtl = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = !Boolean.parseBoolean(booleanCheckBoxActionControl.getValue().get());
                this.val$segmentSizeCtl.enableUI(bl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)fileSizeActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER ROLLBACK SEGMENT \"");
        stringBuffer.append(this.getObjectName());
        stringBuffer.append("\"\nSHRINK");
        if (!Boolean.parseBoolean(values.get(OPTIMAL))) {
            stringBuffer.append(" TO ");
            stringBuffer.append(values.get(SEGMENT_SIZE, "SizeClause"));
        }
        return stringBuffer.toString();
    }
}

