/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespacesets;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.AbstractTablespaceSetAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class DeleteTablespaceSetAction
extends AbstractTablespaceSetAction {
    private static final String SET_NAME = "SetName";
    private static final String INCLUDE_CONTENTS = "IncludeContents";
    private static final String INCLUDE_DATAFILES = "IncludeDataFiles";
    private static final String CASCADE_CONSTRAINTS = "CascadeConstraints";

    protected String getTitle() {
        return DbaNavigatorResources.getString("DELETE_TABLESPACE_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.loadShardedDDLStatus(connection);
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(SET_NAME, DbaNavigatorResources.getString("TABLESPACE_SET_NAME_LABEL"), this.getObjectName());
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(INCLUDE_CONTENTS, DbaNavigatorResources.getString("INCLUDE_CONTENTS_LABEL"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(INCLUDE_DATAFILES, DbaNavigatorResources.getString("INCLUDE_DATAFILES_LABEL"), false);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl3 = new BooleanCheckBoxActionControl(CASCADE_CONSTRAINTS, DbaNavigatorResources.getString("CASCADE_CONSTRAINTS_LABEL"), false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)booleanCheckBoxActionControl3);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPreSql(stringBuilder);
        stringBuilder.append("DROP TABLESPACE SET \"");
        stringBuilder.append(values.get(SET_NAME));
        stringBuilder.append("\"");
        boolean bl = Boolean.parseBoolean(values.get(INCLUDE_CONTENTS));
        boolean bl2 = Boolean.parseBoolean(values.get(INCLUDE_DATAFILES));
        boolean bl3 = Boolean.parseBoolean(values.get(CASCADE_CONSTRAINTS));
        if (bl || bl2) {
            stringBuilder.append("\n  INCLUDING CONTENTS");
            if (bl2) {
                stringBuilder.append(" AND DATAFILES");
            } else {
                stringBuilder.append(" KEEP DATAFILES");
            }
        }
        if (bl3) {
            stringBuilder.append("\n  CASCADE CONSTRAINTS");
        }
        this.appendPostSql(stringBuilder);
        return stringBuilder.toString();
    }
}

