/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.dba.navigator.displays.performancereport.RowSelectionPanel;
import oracle.dbtools.raptor.ui.Utils;

public class DbInstancePanel
extends JPanel {
    private final Connection conn;
    private final PropertyChangeSupport changeSupport;
    private final String defaultDbId;
    private final boolean globalOption;
    private RowSelectionPanel instanceSelectionPanel;
    private RowSelectionPanel dbIdSelectionPanel;

    public DbInstancePanel(Connection connection, boolean bl, boolean bl2, String string, boolean bl3) {
        this.conn = connection;
        this.defaultDbId = string;
        this.globalOption = bl3;
        this.setLayout(new GridBagLayout());
        this.changeSupport = new PropertyChangeSupport(this);
        int n = 0;
        if (bl) {
            this.add((Component)this.createInstancePanel(bl3), new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (bl2) {
            this.add((Component)this.createDbIdPanel(string), new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String instanceNumber() {
        return this.instanceSelectionPanel != null ? this.instanceSelectionPanel.getSelectedItemId() : "1";
    }

    public boolean hasMultipleInstanceNumbers() {
        return this.globalOption && this.instanceNumber().contains(",");
    }

    public String dbId() {
        return this.dbIdSelectionPanel != null ? this.dbIdSelectionPanel.getSelectedItemId() : this.defaultDbId;
    }

    private JPanel createInstancePanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.instanceSelectionPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getInstances"), null, new String[]{DisplayArb.getString("PERF_INSTANCE_NUMBER"), DisplayArb.getString("PERF_INSTANCE_NAME"), DisplayArb.getString("PERF_HOST")}, 6, bl);
        this.instanceSelectionPanel.setSelectedItemId("1");
        this.instanceSelectionPanel.addPropertyChangeListener(propertyChangeEvent -> this.onInstanceNumberChanged((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue()));
        jPanel.add((Component)new JLabel(DisplayArb.getString("PERF_INSTANCE_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.instanceSelectionPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return jPanel;
    }

    private JPanel createDbIdPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.dbIdSelectionPanel = new RowSelectionPanel(this.conn, Utils.getQuery(this.getClass(), (Connection)this.conn, (String)"getDBIDs"), null, new String[]{DisplayArb.getString("PERF_DB_ID"), DisplayArb.getString("PERF_DB_NAME"), DisplayArb.getString("PERF_HOST")}, 6);
        this.dbIdSelectionPanel.addPropertyChangeListener(propertyChangeEvent -> this.onDbIdChanged((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue()));
        this.dbIdSelectionPanel.setSelectedItemId(string);
        jPanel.add((Component)new JLabel(DisplayArb.getString("PERF_DB_ID_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.dbIdSelectionPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return jPanel;
    }

    private void onInstanceNumberChanged(String string, String string2) {
        String[] stringArray;
        for (String string3 : stringArray = string2.split(",")) {
            try {
                Integer.parseInt(string3.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.instanceSelectionPanel.setSelectedItemId(string);
                return;
            }
        }
        this.changeSupport.firePropertyChange(null, null, null);
    }

    private void onDbIdChanged(String string, String string2) {
        try {
            Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.dbIdSelectionPanel.setSelectedItemId(string);
            return;
        }
        this.changeSupport.firePropertyChange(null, null, null);
    }
}

