/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.dba.navigator.net.DBAURLFormatHelper;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.TraversalExportException;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizMain;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizScheduleOptions;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerRunner;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.log.LogPage;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.controls.ProgressPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class DpWizCommon {
    public static final String sysdateTimeString = "hh24_mi_ss";
    private static final Logger LOGGER = Logger.getLogger(DpWizCommon.class.getName());

    public static String getDWCSCanned(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            string = "    dbms_datapump.set_parameter(h1, 'TRACE', 167144-96) ; \n    dbms_datapump.set_parameter (h1, 'PARTITION_OPTIONS', 'MERGE'); \n    dbms_datapump.metadata_transform(h1, 'SEGMENT_ATTRIBUTES', 0); \n    dbms_datapump.metadata_transform(h1, 'DWCS_CVT_IOTS', 1); \n    dbms_datapump.metadata_transform(h1, 'DWCS_CVT_CONSTRAINTS', 1); \n    dbms_datapump.metadata_filter(h1, 'EXCLUDE_PATH_EXPR',         'IN (''INDEX'',''INDEXTYPE'', ''MATERIALIZED_VIEW'',''MATERIALIZED_VIEW_LOG'',         ''MATERIALIZED_ZONEMAP'', ''CLUSTER'', ''CLUSTERING'')'); \n";
        } else if (bl2) {
            string = "    dbms_datapump.set_parameter(h1, 'TRACE', 167144-96) ; \n    dbms_datapump.metadata_transform(h1, 'DWCS_CVT_IOTS', 1); \n    dbms_datapump.metadata_transform(h1, 'DWCS_CVT_CONSTRAINTS', 1); \n    dbms_datapump.metadata_filter(h1, 'EXCLUDE_PATH_EXPR',         'IN ( ''CLUSTER'', ''CLUSTERING'', ''DB_LINK'' )'); \n";
        }
        return string;
    }

    public static String getToUpperMaybe(String string) {
        if (string == null) {
            return " UPPER('') ";
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return " '" + string.substring(1, string.lastIndexOf("\"")).replace("'", "''") + "' ";
        }
        return " UPPER('" + string.replace("'", "''") + "') ";
    }

    public static String getNoToUpper(String string) {
        if (string == null) {
            return " '' ";
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return " '" + string.substring(1, string.lastIndexOf("\"")).replace("'", "''") + "' ";
        }
        return " '" + string.replace("'", "''") + "' ";
    }

    public static boolean compareStringList(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            arrayList2.add(stringArray2[n]);
        }
        return arrayList.removeAll(arrayList2);
    }

    public static Object getOrInitializeList(ExtractListModel extractListModel, String string, Object object) {
        if (extractListModel.getPropertyValue(string) == null) {
            extractListModel.setProperty(string, object);
        }
        return extractListModel.getPropertyValue(string);
    }

    public static String[] getDirectories(TraversableContext traversableContext) {
        ExtractListModel extractListModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        return (String[])DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_DIRECTORIES", new String[0]);
    }

    public static String doProgressBar(DefaultTraversablePanel defaultTraversablePanel, ProgressBarRunnable progressBarRunnable, String string) throws TraversalException {
        ProgressBar progressBar = new ProgressBar((Component)defaultTraversablePanel, string, (Runnable)progressBarRunnable, true);
        progressBarRunnable.setProgressBar(progressBar);
        progressBarRunnable.run();
        if (progressBarRunnable.getTraversalException() != null) {
            throw progressBarRunnable.getTraversalException();
        }
        return progressBarRunnable.getRetVal();
    }

    public static String doProgressBarLive(DefaultTraversablePanel defaultTraversablePanel, ProgressBarRunnableLive progressBarRunnableLive, String string) throws TraversalException {
        ProgressBar progressBar = new ProgressBar((Component)defaultTraversablePanel, string, (Runnable)progressBarRunnableLive, true);
        progressBarRunnableLive.setProgressBar(progressBar);
        progressBar.setCancelable(false);
        progressBar.start(string, DpWizardArb.getString("PROCESSING"), 0, 0);
        progressBar.waitUntilDone();
        if (progressBarRunnableLive.getTraversalException() != null) {
            throw progressBarRunnableLive.getTraversalException();
        }
        if (progressBar.hasUserCancelled()) {
            throw new TraversalException(DpWizardArb.getString("USER_HAS_CANCELLED"), DpWizardArb.getString("CANCELLED"));
        }
        return progressBarRunnableLive.getRetVal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupConnection(ExtractListModel extractListModel, boolean bl) throws TraversalException {
        String string = (String)extractListModel.getPropertyValue("KEY_CNAME");
        try {
            Connections.getInstance().getConnection(string);
        }
        catch (Exception exception) {
            Throwable throwable;
            Exception exception2;
            while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                exception2 = (Exception)throwable;
            }
            throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", exception2.getLocalizedMessage()), DpWizardArb.getString("IMP_EXCEPTION_OCCURRED"));
        }
        if (Connections.getInstance().lock(string)) {
            try {
                Object object8;
                Object object22;
                Object object3;
                Object object42;
                Object object52;
                extractListModel.setProperty("ISEXPOT", (Object)bl);
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", dBException.getLocalizedMessage()), DpWizardArb.getString("IMP_EXCEPTION_OCCURRED"));
                }
                List list = DBUtil.getInstance((String)string).executeReturnList("select username from user_role_privs where (GRANTED_ROLE = 'DBA' OR GRANTED_ROLE = 'IMP_FULL_DATABASE' OR GRANTED_ROLE = 'EXP_FULL_DATABASE' OR GRANTED_ROLE = 'PDB_DBA') AND USERNAME = USER", null);
                Boolean bl2 = Boolean.FALSE;
                for (Object object52 : list) {
                    bl2 = Boolean.TRUE;
                }
                if (bl2.equals(Boolean.FALSE)) {
                    throw new TraversalException(DpWizardArb.getString("EXP_DBA_REQUIRED"), DpWizardArb.getString("EXP_PRIV_ERROR"));
                }
                ArrayList<String> arrayList = new ArrayList();
                object52 = "";
                DBUtil dBUtil = DBUtil.getInstance((String)string);
                List list2 = null;
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    Logger.getLogger("DpWizCommon").log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                object52 = "select * from (select 1 num,  'DIRECTORY:'||DIRECTORY_NAME name from all_directories union select 2 num, 'CREDENTIAL:'||credential_name name from all_credentials union select 2 num, 'CREDENTIAL:'||'NULL' name from dual) order by num, name";
                list2 = dBUtil.executeReturnList((String)object52, null);
                if (dBUtil.getLastException() != null) {
                    object52 = "select * from (select 1 num,  'DIRECTORY:'||DIRECTORY_NAME name from all_directories union select 2 num, 'CREDENTIAL:'||'NULL' name from dual) order by num, name";
                    arrayList = new ArrayList<String>();
                    list2 = dBUtil.executeReturnList((String)object52, null);
                }
                for (Object object42 : list2) {
                    arrayList.add((String)object42.get("NAME"));
                }
                Object[] objectArray = arrayList.toArray(new String[list2.size()]);
                Arrays.sort(objectArray);
                extractListModel.setProperty("DP_EXP_DIRECTORIES", (Object)objectArray);
                if (objectArray.length == 0) {
                    throw new TraversalException(DpWizardArb.getString("EXP_NO_DIRECTORIES"), DpWizardArb.getString("EXP_PRIV_ERROR"));
                }
                object42 = null;
                ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
                object52 = "SELECT owner, directory_name, directory_path from all_directories";
                object42 = dBUtil.executeReturnList((String)object52, null);
                Object object6 = object42.iterator();
                while (object6.hasNext()) {
                    object3 = (Map)object6.next();
                    arrayList2.add(new String[]{(String)object3.get("OWNER"), (String)object3.get("DIRECTORY_NAME"), (String)object3.get("DIRECTORY_PATH")});
                }
                extractListModel.setProperty("DP_EXP_DIRECTORIES_PATH", arrayList2);
                try {
                    connection = Connections.getInstance().getConnection(string);
                    extractListModel.setProperty("IMP_DWCS_OPTS_ENABLED", (Object)DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)connection), (String)"dwcs"));
                    extractListModel.setProperty("IMP_DP_OPTS_ENABLED", (Object)DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)connection), (String)"atp"));
                }
                catch (Exception exception) {
                    throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", exception.getLocalizedMessage()), DpWizardArb.getString("IMP_EXCEPTION_OCCURRED"));
                }
                extractListModel.setProperty("EXP_SYSDATE_STRING", (Object)DBUtil.getInstance((String)string).executeOracleReturnOneCol("select to_char(sysdate,'hh24_mi_ss') thesysdate from dual", new HashMap()));
                object6 = null;
                object3 = null;
                Timestamp timestamp = null;
                try {
                    object6 = connection.prepareStatement("select current_timestamp from dual");
                    object3 = object6.executeQuery();
                    object3.next();
                    timestamp = object3.getTimestamp(1);
                }
                catch (SQLException sQLException2) {
                    Logger.getLogger("DpWizCommon").log(Level.WARNING, sQLException2.getStackTrace()[0].toString(), sQLException2);
                }
                finally {
                    if (object3 != null) {
                        try {
                            object3.close();
                        }
                        catch (SQLException sQLException3) {}
                    }
                    if (object6 != null) {
                        try {
                            object6.close();
                        }
                        catch (SQLException sQLException4) {}
                    }
                }
                if (timestamp == null) {
                    extractListModel.setProperty("DP_EXP_SYSDATE", (Object)new Date());
                } else {
                    extractListModel.setProperty("DP_EXP_SYSDATE", (Object)new Date(timestamp.getTime()));
                }
                ArrayList<String> arrayList3 = new ArrayList<String>();
                Statement statement = null;
                object3 = null;
                if (bl) {
                    try {
                        statement = connection.createStatement();
                        object3 = statement.executeQuery("select name from sys.ku_noexp_tab where obj_type='SCHEMA'");
                        while (object3.next()) {
                            arrayList3.add(object3.getString(1));
                        }
                    }
                    catch (SQLException sQLException5) {
                    }
                    finally {
                        if (object3 != null) {
                            try {
                                object3.close();
                            }
                            catch (SQLException sQLException6) {}
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException7) {}
                        }
                    }
                }
                extractListModel.setProperty("DP_EXP_NO_EXPORT_LIST", arrayList3);
                Boolean bl3 = Boolean.FALSE;
                List list3 = DBUtil.getInstance((String)string).executeReturnList("select USER NAME from dual where USER = 'SYS'", null);
                for (Object object22 : list3) {
                    bl3 = Boolean.TRUE;
                }
                extractListModel.setProperty("DP_EXP_IS_SYS", (Object)bl3);
                object52 = null;
                object52 = bl ? "select username from user_role_privs where ( GRANTED_ROLE = 'DBA' OR GRANTED_ROLE = 'EXP_FULL_DATABASE' OR GRANTED_ROLE = 'PDB_DBA' ) AND USERNAME = USER" : "select username from user_role_privs where ( GRANTED_ROLE = 'DBA' OR GRANTED_ROLE = 'IMP_FULL_DATABASE' OR GRANTED_ROLE = 'PDB_DBA' ) AND USERNAME = USER";
                list3 = DBUtil.getInstance((String)string).executeReturnList((String)object52, null);
                Object object7 = Boolean.FALSE;
                for (Object object8 : list3) {
                    object7 = Boolean.TRUE;
                }
                extractListModel.setProperty("DP_EXP_IS_PRIV", object7);
                if (bl) {
                    extractListModel.setProperty("DP_EXP_GEN_NAME", (Object)DBUtil.getInstance((String)string).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('EXP_SD_') from dual", new HashMap()));
                } else {
                    extractListModel.setProperty("DP_EXP_GEN_NAME", (Object)DBUtil.getInstance((String)string).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('IMP_SD_') from dual", new HashMap()));
                }
                object6 = null;
                object3 = null;
                object22 = "";
                try {
                    object6 = connection.prepareStatement("select to_char(current_scn,'99999999999999999999999999999999999999') from v$database");
                    object3 = object6.executeQuery();
                    object3.next();
                    object22 = object3.getString(1).replaceFirst("^\\s+", "");
                }
                catch (SQLException sQLException8) {
                    object22 = DpWizardArb.getString("EXP_NOT_PRIVILEGED");
                }
                finally {
                    if (object3 != null) {
                        try {
                            object3.close();
                        }
                        catch (SQLException sQLException9) {}
                    }
                    if (object6 != null) {
                        try {
                            object6.close();
                        }
                        catch (SQLException sQLException10) {}
                    }
                }
                extractListModel.setProperty("EXP_SCN_ON_ENTRY", object22);
                dBUtil = DBUtil.getInstance((String)string);
                extractListModel.setProperty("EXP_ALL_USERS", (Object)dBUtil.executeReturnList("select username from all_users order by username", null));
                extractListModel.setProperty("EXP_THIS_USER", (Object)dBUtil.executeReturnList("select user USERNAME from dual", null));
                extractListModel.setProperty("EXP_ALL_TABLESPACES", (Object)dBUtil.executeReturnList("select name from v$tablespace order by name", null));
                extractListModel.setProperty("EXP_NO_TABLESPACES", (Object)dBUtil.executeReturnList("select 'name' NAME from dual where 1=2", null));
                object8 = Boolean.TRUE;
                Statement statement2 = null;
                try {
                    statement2 = connection.createStatement();
                    statement2.execute("begin\nnull;\nEXCEPTION WHEN UTL_FILE.invalid_operation then null;\nend;");
                    statement2.close();
                }
                catch (SQLException sQLException11) {
                    if (statement2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (SQLException sQLException12) {
                            // empty catch block
                        }
                    }
                    object8 = Boolean.FALSE;
                }
                extractListModel.setProperty("EXP_UTL_FILE", object8);
                extractListModel.setProperty("EXP_VERSION", (Object)RaptorVersionTracker.getDbVersion((Connection)connection));
            }
            finally {
                Connections.getInstance().unlock(string);
            }
        }
    }

    public static String utilDateToString(ExtractListModel extractListModel, OraTIMESTAMPTZ oraTIMESTAMPTZ) {
        String string = "";
        try {
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat("YYYY-MM-DD hh24:mi:ss TZR", OraLocaleInfo.getInstance((Locale)Locale.US));
            string = oraTIMESTAMPTZFormat.format(oraTIMESTAMPTZ.getDatum());
        }
        catch (Exception exception) {
            Logger.getLogger("DpExpWizSummary").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public static String scheduleCommon(ExtractListModel extractListModel, String string, String string2, String string3) throws TraversalException {
        String string4;
        ExtractListModel extractListModel2 = extractListModel;
        String string5 = string2;
        String string6 = string3;
        String string7 = string;
        if (Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_RBIMMEDIATE", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
            return string7 + string6;
        }
        String string8 = null;
        string8 = Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_RBINDEFINATE", Boolean.TRUE).equals(Boolean.TRUE)) == false && !((Integer)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_MONTHLY_YEARLY", new Integer(1))).equals(new Integer(1)) ? "                        end_date => TO_TIMESTAMP_TZ('" + DpWizCommon.utilDateToString(extractListModel2, (OraTIMESTAMPTZ)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_REPEAT_UNTIL", DpExpWizScheduleOptions.getSysTIMESTAMPTZ(extractListModel2))) + "','YYYY-MM-DD hh24:mi:ss TZR'),\n" : "";
        String string9 = "";
        Integer n = (Integer)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_MONTHLY_YEARLY", new Integer(1));
        String string10 = "";
        if (n == 2) {
            string4 = (String)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_FREQUENCY", new String(""));
            Integer n2 = (Integer)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_FREQCOMBO", new Integer(0));
            string10 = "";
            if (n2 == 0) {
                string10 = "MINUTELY";
            } else if (n2 == 1) {
                string10 = "HOURLY";
            } else if (n2 == 2) {
                string10 = "DAILY";
            } else if (n2 == 3) {
                string10 = "WEEKLY";
            }
            if (!string4.equals("")) {
                string9 = "                        repeat_interval => 'FREQ=" + string10 + "; INTERVAL=" + string4 + "',\n";
            }
        } else if (n == 3) {
            string10 = "MONTHLY";
            string9 = "                        repeat_interval => 'FREQ=" + string10 + "',\n";
        } else if (n == 4) {
            string10 = "YEARLY";
            string9 = "                        repeat_interval => 'FREQ=" + string10 + "',\n";
        }
        string4 = (String)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_JNAME", "");
        string4 = string4.equals("") ? "DBMS_SCHEDULER.GENERATE_JOB_NAME()" : "'SCH_" + string4.replace("'", "''") + "'";
        string7 = "BEGIN \n    SYS.DBMS_SCHEDULER.CREATE_JOB (                        job_name => USER||'.'||" + string4 + ",\n                        job_type => 'PLSQL_BLOCK',\n                        job_action => '" + DpWizCommon.tryToReduce((string + string5).replace("'", "''")) + "',\n                        number_of_arguments => 0,\n                        start_date => TO_TIMESTAMP_TZ('" + DpWizCommon.utilDateToString(extractListModel2, (OraTIMESTAMPTZ)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_CALFROM", DpExpWizScheduleOptions.getSysTIMESTAMPTZ(extractListModel2))) + "','YYYY-MM-DD hh24:mi:ss TZR'),\n" + string9 + string8 + "                        job_class => 'DEFAULT_JOB_CLASS',\n                        enabled => true,\n                        auto_drop => true,\n                        comments => '" + ((String)DpWizCommon.getOrInitializeList(extractListModel2, "DP_EXP_JDESCRIPTION", "")).replace("'", "''") + "');\nEND;\n/\n";
        return string7;
    }

    public static String tryToReduce(String string) throws TraversalException {
        String string2 = string.replaceAll("[\\r \\t]*\\n[\\r\\n \\t]*", "\n").replaceAll("\\r", "");
        if (string2.length() > 4000) {
            throw new TraversalException(DpWizardArb.getString("EXP_JOB_OVER_4000_TEXT"), DpWizardArb.getString("EXP_JOB_OVER_4000"));
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onExitRun(ExtractListModel extractListModel, String string, boolean bl) throws TraversalException {
        Connection connection = null;
        try {
            if (!(bl && Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE).equals(Boolean.TRUE)).booleanValue() && Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_OUT_8", Boolean.FALSE).equals(Boolean.TRUE)).booleanValue() || bl && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_CHECK_DO_IMPORT_ONLY", Boolean.FALSE)).booleanValue())) {
                String string2;
                String string3;
                CharSequence charSequence;
                Object object;
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
                ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                scriptRunnerContext.setScanOn(false);
                WrapListenBufferOutputStream wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, null);
                wrapListenBufferOutputStream.setRemoveForcePrint(true);
                scriptRunnerContext.setOutputStreamWrapper((BufferedOutputStream)wrapListenBufferOutputStream);
                scriptRunnerContext.consumerRuning(true);
                scriptRunnerContext.setEscape(false);
                scriptRunnerContext.setSqlError(4);
                scriptRunnerContext.consumerRuning(true);
                OutputRedirectorToStringBuffer outputRedirectorToStringBuffer = new OutputRedirectorToStringBuffer(pipedInputStream, new StringBuffer(), null);
                outputRedirectorToStringBuffer.start();
                ScriptExecutor scriptExecutor = null;
                connection = null;
                Connection connection2 = null;
                try {
                    connection2 = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("KEY_CNAME"));
                }
                catch (DBException dBException) {
                    throw new TraversalException(DpWizardArb.getString("EXP_NO_CONNECTION"));
                }
                Connection connection3 = connection2;
                String string4 = (String)extractListModel.getPropertyValue("KEY_CNAME");
                if (bl && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE)).booleanValue()) {
                    connection = Connections.getInstance().cloneConnection(string4);
                    scriptExecutor = new ScriptExecutor(string, connection);
                } else {
                    scriptExecutor = new ScriptExecutor(string, connection3);
                }
                ScriptExecutor scriptExecutor2 = scriptExecutor;
                scriptExecutor2.setOut((BufferedOutputStream)wrapListenBufferOutputStream);
                scriptExecutor2.setScriptRunnerContext(scriptRunnerContext);
                scriptExecutor2.setStmt(string);
                boolean bl2 = false;
                bl2 = bl && (Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE) != false ? Connections.getInstance().lock(connection) : Connections.getInstance().lock(connection3);
                boolean bl3 = bl && Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE).equals(Boolean.TRUE)) != false && Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_OUT_8", Boolean.FALSE).equals(Boolean.TRUE)) != false;
                boolean bl4 = false;
                if (bl2) {
                    try {
                        if (!(bl3 || bl && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_CHECK_DO_IMPORT_ONLY", Boolean.FALSE)).booleanValue())) {
                            scriptExecutor2.run();
                            if (Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_RBIMMEDIATE", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
                                Object object2;
                                object = connection3;
                                charSequence = (String)((Map)((List)extractListModel.getPropertyValue("EXP_THIS_USER")).get(0)).get("USERNAME");
                                string3 = (String)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_FULLJNAME_USED", "");
                                String string5 = (String)extractListModel.getPropertyValue("KEY_CNAME");
                                if (!bl && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE)).equals(Boolean.TRUE) && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_CHECK_DO_IMPORT", Boolean.FALSE)).equals(Boolean.TRUE)) {
                                    string3 = (String)extractListModel.getPropertyValue("EXP_FULL_JOB_NAME_USED_AUTOIMPORT");
                                    object2 = DBUtil.getInstance((Connection)object).executeReturnList("select user USERNAME from dual", null);
                                    if (object2 == null || object2.size() == 0) {
                                        throw new Exception("NO USER");
                                    }
                                    if (object2.size() > 0) {
                                        string2 = ((Map)object2.get(0)).get("USERNAME");
                                        if (string2 instanceof String) {
                                            charSequence = string2;
                                        } else {
                                            throw new Exception("NO USER");
                                        }
                                    }
                                }
                                object2 = charSequence;
                                string2 = string3;
                                final String string6 = string5;
                                SwingUtilities.invokeLater(new Runnable((String)object2, string2, bl){
                                    final /* synthetic */ String val$user;
                                    final /* synthetic */ String val$fullJobName;
                                    final /* synthetic */ boolean val$isExport;
                                    {
                                        this.val$user = string2;
                                        this.val$fullJobName = string3;
                                        this.val$isExport = bl;
                                    }

                                    @Override
                                    public void run() {
                                        DpWizCommon.launchDataPumpNode(string6, this.val$user, this.val$fullJobName, this.val$isExport);
                                    }
                                });
                            }
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(DpWizCommon.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        if (bl && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE)).booleanValue()) {
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {
                                Connections.getInstance().unlock(connection);
                                throw new TraversalException((Object)exception);
                            }
                            Connections.getInstance().unlock(connection);
                        } else {
                            Connections.getInstance().unlock(connection3);
                        }
                    }
                }
                try {
                    if (wrapListenBufferOutputStream != null) {
                        wrapListenBufferOutputStream.flush();
                        wrapListenBufferOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                outputRedirectorToStringBuffer.join();
                object = new StringBuffer();
                object = outputRedirectorToStringBuffer.getStringBuffer();
                charSequence = object;
                if (scriptRunnerContext.getExited() || charSequence != null && ((StringBuffer)charSequence).indexOf("REMOVE TO START TRACE TEXT") != -1) {
                    string3 = "Error";
                    if (charSequence != null) {
                        string3 = ((StringBuffer)charSequence).toString();
                    }
                    int n = string3.lastIndexOf("REMOVE FINAL TRACE TEXT\r");
                    int n2 = string3.lastIndexOf("REMOVE FINAL TRACE TEXT\n");
                    if (n2 > n) {
                        n = n2;
                    }
                    if (n != -1 && n > 2) {
                        string3 = string3.substring(0, n);
                    }
                    n = string3.lastIndexOf("REMOVE TO START TRACE TEXT\r");
                    n2 = string3.lastIndexOf("REMOVE TO START TRACE TEXT\n");
                    if (n2 > n) {
                        n = n2;
                    }
                    if (n != -1 && !string3.endsWith("REMOVE TO START TRACE TEXT")) {
                        string3 = string3.substring(n + "REMOVE TO START TRACE TEXT".length());
                    }
                    if (string3.length() > 620) {
                        string3 = "...\n" + string3.substring(string3.length() - 619);
                    }
                    string2 = null;
                    string2 = bl ? DBUtil.getInstance((Connection)connection3).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('EXP_SD_') from dual", new HashMap()) : DBUtil.getInstance((Connection)connection3).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('IMP_SD_') from dual", new HashMap());
                    extractListModel.setProperty("DP_EXP_JNAME", (Object)string2);
                    throw new TraversalException(string3, DpWizardArb.getString("EXP_ERROR_SUMIT"));
                }
                if (bl && Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE).equals(Boolean.TRUE)).booleanValue() && !((StringBuffer)charSequence).toString().contains("WAIT_FOR_JOB_RETURN:COMPLETED") && !bl3) {
                    throw new TraversalException(((StringBuffer)charSequence).toString(), DpWizardArb.getString("EXP_ERROR_WAIT"));
                }
            }
            if (bl) {
                DpWizCommon.startOSSTask(extractListModel);
            }
        }
        catch (Exception exception) {
            if (exception instanceof TraversalException) {
                throw (TraversalException)exception;
            }
            Logger.getLogger(DpWizCommon.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static String stripDir(String string, boolean bl) {
        if (!bl) {
            return string;
        }
        if (string.equals("NULL") || string.equals("CREDENTIAL:NULL")) {
            return string;
        }
        return string.substring(string.indexOf(":") + 1).replaceAll("\"", "");
    }

    public static ArrayList<String> tofilepath(String string, String string2) {
        ArrayList<String> arrayList;
        block14: {
            arrayList = new ArrayList<String>();
            if (!string2.contains("%u") && !string2.contains("%U")) {
                try {
                    File file = FileSystems.getDefault().getPath(string, string2).toFile();
                    if (!file.exists()) break block14;
                    try {
                        arrayList.add(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINE, iOException.getMessage(), iOException);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.FINE, exception.getMessage(), exception);
                }
            } else {
                int n = 1;
                while (true) {
                    block15: {
                        try {
                            String string3 = "" + n;
                            if (n < 10) {
                                string3 = "0" + n;
                            }
                            String string4 = string2.replaceAll("%U", string3).replaceAll("%u", string3);
                            File file = null;
                            try {
                                file = FileSystems.getDefault().getPath(string, string4).toFile();
                                if (!file.exists()) break;
                                try {
                                    arrayList.add(file.getCanonicalPath());
                                    break block15;
                                }
                                catch (IOException iOException) {
                                    LOGGER.log(Level.FINE, iOException.getMessage(), iOException);
                                }
                            }
                            catch (Exception exception) {
                                LOGGER.log(Level.FINE, exception.getMessage(), exception);
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.log(Level.FINE, exception.getMessage(), exception);
                        }
                        break;
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static ArrayList<String> getFullPath(String[] stringArray, ArrayList<String[]> arrayList, String string) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = stringArray[0];
        for (String[] stringArray2 : arrayList) {
            if (!stringArray2[1].equals(string2)) continue;
            String string3 = stringArray2[2];
            if (string != null && !string.equals("")) {
                string3 = string;
            }
            for (String string4 : DpWizCommon.tofilepath(string3, stringArray[1])) {
                arrayList2.add(string4);
            }
        }
        return arrayList2;
    }

    public static void getFileNames(FileSet fileSet, ExtractListModel extractListModel) {
        ArrayList arrayList = (ArrayList)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_DIRECTORIES_PATH", new ArrayList());
        ArrayList arrayList2 = (ArrayList)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_OUTDIRFILESIZE", new ArrayList());
        for (String[] stringArray : arrayList2) {
            stringArray = DpWizCommon.injectSysdate(extractListModel, stringArray);
            String string = "";
            if (Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_OPT_DIR_SELECTED", Boolean.FALSE).equals(Boolean.TRUE)).booleanValue()) {
                string = (String)DpWizCommon.getOrInitializeList(extractListModel, "EXP_OUT_7", "");
            }
            for (String string2 : DpWizCommon.getFullPath(stringArray, arrayList, string)) {
                fileSet.add(string2);
            }
        }
    }

    private static String[] injectSysdate(ExtractListModel extractListModel, String[] stringArray) {
        String string = DpWizCommon.superSysdate(extractListModel, stringArray[1], true);
        return new String[]{stringArray[0], string, stringArray[2]};
    }

    public static void startOSSTask(ExtractListModel extractListModel) throws TraversalException {
        if (((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE)).booleanValue()) {
            DpWizCommon.startOSSTask_OSSBMC(extractListModel);
        }
    }

    public static void fillFiles(String string, URL uRL, FileSet fileSet, boolean bl, ExtractListModel extractListModel) throws TraversalException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            for (Path path : fileSet.getPaths()) {
                File file = path.toFile();
                String string2 = path.toUri().getPath();
                int n = -1;
                int n2 = string2.lastIndexOf("/");
                int n3 = string2.lastIndexOf("\\");
                if (n2 > n) {
                    n = n2;
                }
                if (n3 > n) {
                    n = n3;
                }
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                string2 = URLEncoder.encode(string2, "UTF-8").replace("+", "%20");
                string2 = uRL.getPath() != null && uRL.getPath().contains("\\") ? '\\' + string2 : '/' + string2;
                String string3 = uRL.getPath();
                if (string3 != null) {
                    if (string3.endsWith("/")) {
                        string3 = string3.substring(0, string3.lastIndexOf("/"));
                    } else if (string3.endsWith("\\")) {
                        string3 = string3.substring(0, string3.lastIndexOf("\\"));
                    }
                }
                arrayList.add(new String[]{string, new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3 + string2).toString()});
            }
        }
        catch (Exception exception) {
            throw new TraversalExportException(exception.getMessage(), DpWizardArb.getString("EXP_EXPAND_FILES"), true);
        }
        if (arrayList.size() == 0) {
            throw new TraversalExportException(DpWizardArb.getString("EXP_NO_FILES_BIG"), DpWizardArb.getString("EXP_NO_FILES_TITLE"), true);
        }
        extractListModel.setProperty("EXP_TRANS_FILES", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doTransfer(Connection connection, String string, URL uRL, FileSet fileSet, boolean bl, ExtractListModel extractListModel) throws TraversalException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (Connections.getInstance().lock(connection)) {
            try {
                Connection connection2 = connection;
                String string2 = "Begin DBMS_CLOUD.put_object( credential_name => /*cred1*/?, \nobject_uri      => /*uri2*/?, \ncontents        => /*theBlob3*/?, \n";
                String string3 = string2 + "compression     => DBMS_CLOUD.COMPRESS_AUTO\n );end;";
                if (!bl) {
                    string3 = string2 + "compression     => NULL\n );end;";
                }
                BufferedInputStream bufferedInputStream = null;
                Object var11_12 = null;
                for (Path path : fileSet.getPaths()) {
                    Statement statement = null;
                    try {
                        File file = path.toFile();
                        String string4 = path.toUri().getPath();
                        int n = -1;
                        int n2 = string4.lastIndexOf("/");
                        int n3 = string4.lastIndexOf("\\");
                        if (n2 > n) {
                            n = n2;
                        }
                        if (n3 > n) {
                            n = n3;
                        }
                        if (n != -1) {
                            string4 = string4.substring(n + 1);
                        }
                        string4 = URLEncoder.encode(string4, "UTF-8").replace("+", "%20");
                        string4 = uRL.getPath() != null && uRL.getPath().contains("\\") ? '\\' + string4 : '/' + string4;
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        statement = connection2.prepareCall(string3);
                        statement.setString(1, string);
                        String string5 = uRL.getPath();
                        if (string5 != null) {
                            if (string5.endsWith("/")) {
                                string5 = string5.substring(0, string5.lastIndexOf("/"));
                            } else if (string5.endsWith("\\")) {
                                string5 = string5.substring(0, string5.lastIndexOf("\\"));
                            }
                        }
                        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string5 + string4);
                        arrayList.add(new String[]{string, uRL2.toString()});
                        statement.setString(2, uRL2.toString());
                        statement.setBlob(3, bufferedInputStream);
                        statement.executeUpdate();
                        arrayList.add(new String[]{string, uRL + string4});
                        connection2.commit();
                    }
                    finally {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Exception exception) {}
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                throw new TraversalExportException(exception.getMessage(), DpWizardArb.getString("EXP_FILE_TRANSFER"), true);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startOSSTask_OSSBMC(ExtractListModel extractListModel) throws TraversalException {
        block28: {
            boolean bl = (Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_CHECK_3", Boolean.FALSE);
            String string = (String)DpWizCommon.getOrInitializeList(extractListModel, "EXP_OUT_1", "");
            URL uRL = (URL)DpWizCommon.getOrInitializeList(extractListModel, "EXP_OUT_11", null);
            String string2 = (String)DpWizCommon.getOrInitializeList(extractListModel, "EXP_OUT_10", "");
            IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater = (IRaptorTaskProgressUpdater)DpWizCommon.getOrInitializeList(extractListModel, "DPTASKUPDATER", null);
            try {
                Location location = Location.getLocal();
                FileSet fileSet = new FileSet();
                DpWizCommon.getFileNames(fileSet, extractListModel);
                if (fileSet.getPaths().size() == 0) {
                    throw new TraversalExportException(DpWizardArb.getString("EXP_NO_FILES_EXPANDING"), DpWizardArb.getString("EXP_NO_FILES_TITLE"), true);
                }
                if (string == null || string.length() == 0) {
                    throw new TraversalExportException(DpWizardArb.getString("EXP_NO_CONNECTION_MESSAGE"), DpWizardArb.getString("EXP_NO_CONNECTION_TITLE"), true);
                }
                if (uRL == null || uRL.getHost() == null || uRL.getHost() == "localhost") {
                    throw new TraversalExportException(DpWizardArb.getString("EXP_NO_URL_MESSAGE"), DpWizardArb.getString("EXP_NO_URL_TITLE"), true);
                }
                if (string2 == null || string2.length() == 0) {
                    throw new TraversalExportException(DpWizardArb.getString("EXP_NO_CONNECTION_MESSAGE"), DpWizardArb.getString("EXP_NO_CONNECTION_TITLE"), true);
                }
                fileSet.setLocation(location);
                Connection connection = null;
                if (Connections.getInstance().lock(string)) {
                    try {
                        connection = Connections.getInstance().cloneConnection(string);
                    }
                    finally {
                        Connections.getInstance().unlock(string);
                    }
                }
                Connection connection2 = connection;
                if (!Connections.getInstance().lock(connection2)) break block28;
                try {
                    DpWizCommon.fillFiles(string2, uRL, fileSet, bl, extractListModel);
                    if (!((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_CHECK_DO_IMPORT_ONLY", Boolean.FALSE)).booleanValue()) {
                        if (iRaptorTaskProgressUpdater != null) {
                            iRaptorTaskProgressUpdater.checkCanProceed();
                        }
                        DpWizCommon.doTransfer(connection2, string2, uRL, fileSet, bl, extractListModel);
                    }
                    Connection connection3 = null;
                    String string3 = null;
                    Connection connection4 = null;
                    try {
                        connection4 = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("KEY_CNAME"));
                    }
                    catch (DBException dBException) {
                        throw new TraversalException(DpWizardArb.getString("EXP_NO_CONNECTION"));
                    }
                    Connection connection5 = connection4;
                    if (!((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE)).equals(Boolean.TRUE) || !((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "EXP_CHECK_DO_IMPORT", Boolean.FALSE)).equals(Boolean.TRUE)) break block28;
                    try {
                        connection3 = connection5;
                        string3 = (String)extractListModel.getPropertyValue("KEY_CNAME");
                        extractListModel.setProperty("KEY_CNAME", (Object)string);
                        try {
                            extractListModel.setProperty("DPTASKUPDATER", null);
                            if (iRaptorTaskProgressUpdater != null) {
                                iRaptorTaskProgressUpdater.checkCanProceed();
                            }
                            DpWizCommon.onExitRun(extractListModel, DpWizCommon.autoImport(extractListModel), false);
                        }
                        catch (TraversalException traversalException) {
                            final TraversalExportException traversalExportException = new TraversalExportException(DpWizardArb.format("IMP_FULL_IMPORT_FAILED_COLON", traversalException.getLocalizedMessage()), DpWizardArb.getString("IMP_FULL_IMPORT_FAILED"), true);
                            traversalExportException.setFullImport(true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)traversalExportException.getLocalizedMessage(), (String)traversalExportException.getTitle(), null);
                                }
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        extractListModel.setProperty("KEY_CNAME", string3);
                        throw throwable;
                    }
                    extractListModel.setProperty("KEY_CNAME", (Object)string3);
                }
                finally {
                    Connections.getInstance().unlock(connection2);
                    try {
                        connection2.close();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            }
            catch (Exception exception) {
                if (exception instanceof TraversalException) {
                    throw (TraversalException)((Object)exception);
                }
                LOGGER.severe(exception.getLocalizedMessage());
                if (exception instanceof ExecutionException && exception.getCause() != null && exception.getCause() instanceof CancellationException) break block28;
                throw new TraversalExportException(exception.getMessage(), DpWizardArb.getString("EXP_FILE_TRANSFER"), true);
            }
        }
    }

    public static void reinflateExport(final TraversalException traversalException, final ExtractListModel extractListModel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                extractListModel.setProperty("EXP_LAST_EXCEPTION", (Object)traversalException);
                DpExpWizMain.getInstance().launchWizard(extractListModel.getPropertyValue("DBOBJECT"), extractListModel);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String autoImport(ExtractListModel extractListModel) throws TraversalException {
        Object object;
        boolean bl;
        boolean bl2;
        String string;
        block8: {
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("KEY_CNAME"));
            }
            catch (DBException dBException) {
                throw new TraversalException((Object)dBException);
            }
            Connection connection2 = connection;
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection2);
            string = DpWizCommon.superSysdate(extractListModel, (String)DpWizCommon.getOrInitializeList(extractListModel, "EXP_FULL_JOB_NAME", ""), true);
            extractListModel.setProperty("EXP_FULL_JOB_NAME_USED_AUTOIMPORT", (Object)string);
            bl2 = false;
            bl = false;
            try {
                object = connection2;
                if (!Connections.getInstance().lock((Connection)object)) break block8;
                try {
                    bl2 = DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)object), (String)"dwcs");
                    bl = DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)object), (String)"atp");
                }
                finally {
                    Connections.getInstance().unlock((Connection)object);
                }
            }
            catch (Exception exception) {
                throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", exception.getLocalizedMessage()), DpWizardArb.getString("IMP_EXCEPTION_OCCURRED"));
            }
        }
        object = (String)DpWizCommon.getOrInitializeList(extractListModel, "EXP_FILE_VERSION", "COMPATIBLE");
        String string2 = "set scan off \nset serveroutput on \nset escape off \nwhenever sqlerror exit  \nDECLARE \n    s varchar2(1000);  \n    h1 number; \n    errorvarchar varchar2(100):= 'ERROR'; \n    tryGetStatus number := 0; \nbegin \n    h1 := dbms_datapump.open (operation => 'IMPORT', job_mode => 'FULL', job_name => '" + string + "', version => '" + (String)object + "');  \n    tryGetStatus := 1; \n" + DpWizCommon.getDWCSCanned(bl2, bl) + "    dbms_datapump.set_parallel(handle => h1, degree => 1);  \n    dbms_datapump.add_file(handle => h1, filename => " + DpWizCommon.superSysdate(extractListModel, ((String)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_LOGFILE", "EXPDAT.LOG")).replaceAll("(?i)EXP", "IMP").replaceAll("\"", "").replace("'", "''"), false) + ", directory => 'DATA_PUMP_DIR', filetype=>DBMS_DATAPUMP.KU$_FILE_TYPE_LOG_FILE);  \n    dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 1);  \n";
        ArrayList arrayList = (ArrayList)extractListModel.getPropertyValue("EXP_TRANS_FILES");
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray = (String[])arrayList.get(i);
            string2 = string2 + "    dbms_datapump.add_file(handle => h1, filename => '" + stringArray[1].replaceAll("'", "''") + "', directory => '" + stringArray[0].replaceAll("'", "''") + "', filetype => 5);\n";
        }
        string2 = string2 + "    dbms_datapump.set_parameter(handle => h1, name => 'INCLUDE_METADATA', value => 1);  \n    dbms_datapump.set_parameter(handle => h1, name => 'DATA_ACCESS_METHOD', value => 'AUTOMATIC');  \n    dbms_datapump.set_parameter(handle => h1, name => 'REUSE_DATAFILES', value => 0);  \n    dbms_datapump.set_parameter(handle => h1, name => 'SKIP_UNUSABLE_INDEXES', value => 0); \n    dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);  \n    dbms_datapump.detach(handle => h1);  \n    errorvarchar := 'NO_ERROR';  \n    tryGetStatus:=0;\nEXCEPTION\nWhen Others then \n    dbms_output.put_line('REMOVE TO START TRACE TEXT');\n    dbms_output.put_line(SQLERRM);\n    DECLARE\n        ind NUMBER;\n        percent_done NUMBER;\n        job_state VARCHAR2(30);\n        le ku$_LogEntry;\n        js ku$_JobStatus;\n        jd ku$_JobDesc;\n        sts ku$_Status;\n    BEGIN \n        /* on error try getstatus */\n        if ((errorvarchar = 'ERROR')AND(tryGetStatus=1)) then \n            dbms_datapump.get_status(h1,\n            dbms_datapump.ku$_status_job_error +\n            dbms_datapump.ku$_status_job_status +\n            dbms_datapump.ku$_status_wip,-1,job_state,sts);\n            js := sts.job_status;\n    /* If any work-in-progress (WIP) or Error messages were received for the job,\n     display them.*/\n            if (bitand(sts.mask,dbms_datapump.ku$_status_wip) != 0)\n            then\n                le := sts.wip;\n            else\n                if (bitand(sts.mask,dbms_datapump.ku$_status_job_error) != 0)\n                then\n                    le := sts.error;\n                else\n                    le := null;\n                end if;\n            end if;\n            if le is not null\n            then\n                ind := le.FIRST;\n                if ind is not null \n                then\n                    dbms_output.put_line('dbms_datapump.get_status('||h1||'...)');\n                end if;\n                while ind is not null loop\n                    dbms_output.put_line(le(ind).LogText);\n                    ind := le.NEXT(ind);\n                end loop;\n            end if;\n        END IF;\n    EXCEPTION \n    when others then null;\n    END;\n    BEGIN \n        IF ((errorvarchar = 'ERROR')AND(tryGetStatus=1)) THEN \n            DBMS_DATAPUMP.DETACH(h1);\n        END IF;\n    EXCEPTION \n    WHEN OTHERS THEN \n        NULL;\n    END;\n    dbms_output.put_line('REMOVE FINAL TRACE TEXT');\n     --Raise;\nEND;\n/\n";
        return string2;
    }

    public static String superSysdate(ExtractListModel extractListModel, String string, boolean bl) {
        if (!((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "DP_APPENDSYSDATEDUMPFILE", Boolean.TRUE)).equals(Boolean.TRUE)) {
            if (bl) {
                return string;
            }
            return '\'' + string + '\'';
        }
        String string2 = "to_char(sysdate,'hh24_mi_ss')";
        if (bl) {
            String string3 = string;
            string2 = (String)DpWizCommon.getOrInitializeList(extractListModel, "EXP_SYSDATE_STRING", "");
            int n = string.lastIndexOf(".");
            string3 = n == -1 || n == 0 || string.endsWith(".") ? "" + string + "-" + string2 : "" + string.substring(0, n) + "-" + string2 + "" + string.substring(n) + "";
            return string3;
        }
        if (Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE).equals(Boolean.TRUE)).booleanValue() || !Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE).equals(Boolean.TRUE)).booleanValue() && !Boolean.valueOf(DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_RBIMMEDIATE", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
            string2 = '\'' + (String)DpWizCommon.getOrInitializeList(extractListModel, "EXP_SYSDATE_STRING", "") + '\'';
        }
        String string4 = "'" + string + "'";
        if (((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "DP_APPENDSYSDATEDUMPFILE", Boolean.TRUE)).equals(Boolean.TRUE)) {
            int n = string.lastIndexOf(".");
            string4 = n == -1 || n == 0 || string.endsWith(".") ? "'" + string + "-'||" + string2 : "'" + string.substring(0, n) + "-'||" + string2 + "||'" + string.substring(n) + "'";
        }
        return string4;
    }

    public static void launchDataPumpNode(String string, String string2, String string3, boolean bl) {
        String string4 = string;
        String string5 = "DATAPUMP_IMPORT_JOBS";
        if (bl) {
            string5 = "DATAPUMP_EXPORT_JOBS";
        }
        if (string3.startsWith("'") && string3.endsWith("'") && string3.length() > 1) {
            string3 = string3.substring(1, string3.length() - 1).replace("''", "'");
        }
        URL uRL = DBAURLFormatHelper.getURL("sqldev.dbanav", string4, null, string2, string5);
        URL uRL2 = DBAURLFormatHelper.getURL(uRL, '\"' + string2 + "\".\"" + string3 + '\"');
        AsynchronousViewerRunner asynchronousViewerRunner = new AsynchronousViewerRunner(uRL2, true);
        asynchronousViewerRunner.show();
    }

    private static class OutputRedirectorToStringBuffer
    extends Thread {
        private Logger logger = Logger.getLogger(OutputRedirectorToStringBuffer.class.getName());
        private PipedInputStream _in;
        private StringBuffer _text;
        private String _line = "";
        private BufferedReader _reader;
        private final int DISPLAY_NUMBER_OF_LINES = 50;
        private StringBuffer _editor;
        private LogPage _logPage;
        private ProgressPanel _progress;
        private Exception stopRunning;
        private boolean doStop = false;
        public static final String OUTPUTREADER_ENCODING = "UTF-8";

        public OutputRedirectorToStringBuffer(PipedInputStream pipedInputStream, LogPage logPage) {
            this(pipedInputStream, null, null, logPage);
        }

        public OutputRedirectorToStringBuffer(PipedInputStream pipedInputStream, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            this(pipedInputStream, stringBuffer, stringBuffer2, null);
        }

        public OutputRedirectorToStringBuffer(PipedInputStream pipedInputStream, StringBuffer stringBuffer, StringBuffer stringBuffer2, LogPage logPage) {
            this._in = pipedInputStream;
            this._text = stringBuffer;
            this._editor = stringBuffer2;
            this._logPage = logPage;
            try {
                this._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, OUTPUTREADER_ENCODING));
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            try {
                while (this._line != null) {
                    for (int i = 0; i <= 50 && !bl; ++i) {
                        if (this.doStop) {
                            throw this.stopRunning;
                        }
                        this._line = this._reader.readLine();
                        if (this._line == null) break;
                        if (this._line.trim().equals("force_print")) {
                            this._line = "";
                            bl = true;
                        }
                        if (bl) continue;
                        stringBuffer.append(this._line + "\n");
                    }
                    if (this._text != null) {
                        this._text.append(stringBuffer.toString());
                    }
                    if (!(this._logPage == null || bl && stringBuffer.length() <= 0)) {
                        this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                    }
                    stringBuffer = null;
                    stringBuffer = new StringBuffer();
                    this.moveToLastRow();
                    bl = false;
                }
            }
            catch (Exception exception) {
                this.logger.info("Output Pipe finished");
            }
            finally {
                if (this._text != null) {
                    this._text.append(stringBuffer.toString());
                }
                if (this._logPage != null) {
                    this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                }
                this.moveToLastRow();
            }
        }

        public void moveToLastRow() {
        }

        public void setProgressPanel(ProgressPanel progressPanel) {
            this._progress = progressPanel;
        }

        public void setLogPage(LogPage logPage) {
            this._logPage = logPage;
        }

        public void stopRun() {
            this.doStop = true;
        }

        public StringBuffer getStringBuffer() {
            return this._text;
        }
    }

    public static abstract class ProgressBarRunnableLive
    extends ProgressBarRunnable {
        private ProgressBar _pb = null;

        @Override
        public abstract void run();

        @Override
        public void setProgressBar(ProgressBar progressBar) {
            this._pb = progressBar;
        }

        @Override
        public void setDoneStatus() {
            this._pb.setDoneStatus();
        }
    }

    public static abstract class ProgressBarRunnable
    implements Runnable {
        protected String _retVal = null;
        protected TraversalException _te = null;

        @Override
        public abstract void run();

        public void setProgressBar(ProgressBar progressBar) {
        }

        public void setDoneStatus() {
        }

        public String getRetVal() {
            return this._retVal;
        }

        public void setRetVal(String string) {
            this._retVal = string;
        }

        public void setTraversalException(TraversalException traversalException) {
            this._te = traversalException;
        }

        public TraversalException getTraversalException() {
            return this._te;
        }
    }
}

