/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.OutputDirectoriesUI;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class CopyFilesPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel _borderLabel = new JLabel(DpWizardArb.getString("EXP_OSS_TRANSFER_OPTIONS_STEP"));
    private JLabel _exportJName = new JLabel(DpWizardArb.getString("EXP_DP_EXP") + " " + DpWizardArb.getString("EXP_JOB_NAME"));
    private JTextField curDir = new JTextField(15);
    private JTextField jName = new JTextField(15);
    private JCheckBox _optDir = new JCheckBox(DpWizardArb.getString("EXP_DIRECTORY_PATH"));
    private ExtractListModel _listModel = null;
    private OutputDirectoriesUI _oUI = null;

    public CopyFilesPane(OutputDirectoriesUI outputDirectoriesUI) {
        this._oUI = outputDirectoriesUI;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void addLabelandText(JPanel jPanel, int n, JComponent jComponent, JComponent jComponent2, int n2, int n3) {
        jPanel.add((Component)jComponent, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)jComponent2, new GridBagConstraints(1, n, n2, 1, 0.0, 0.0, 18, n3, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this._optDir, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.curDir, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this._exportJName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.jName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._borderLabel, (Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)titledPane, "Center");
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 5, 3, 3), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 10.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._optDir.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CopyFilesPane.this.setOptDirEnabled(true);
                    CopyFilesPane.this.reset(true);
                } else {
                    CopyFilesPane.this.setOptDirEnabled(false);
                }
            }
        });
    }

    protected void setLocalEnabled(boolean bl) {
        this._optDir.setEnabled(bl);
        this.curDir.setEnabled(bl);
        this._exportJName.setEnabled(bl);
        this.jName.setEnabled(bl);
        if (bl && !this._optDir.isSelected()) {
            this.curDir.setEnabled(false);
        }
    }

    private void setOptDirEnabled(boolean bl) {
        this.curDir.setEnabled(bl);
    }

    private void reset(boolean bl) {
        if (bl) {
            this.curDir.setText(CopyFilesPane.dirToPath(this._oUI, this._listModel));
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        if (((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_OPT_DIR_SELECTED", Boolean.FALSE)).equals(Boolean.TRUE)) {
            this._optDir.setSelected(true);
            this.setOptDirEnabled(true);
        } else {
            this._optDir.setSelected(false);
            this.setOptDirEnabled(false);
        }
        this.curDir.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "EXP_OUT_7", CopyFilesPane.dirToPath(this._oUI, this._listModel)));
        this.jName.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_JNAME", ""));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._listModel.setProperty("DP_EXP_JNAME", (Object)this.jName.getText());
        Boolean bl = Boolean.FALSE;
        ExtractListModel extractListModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        if (traversableContext.getDirection() == 1 && DpWizCommon.superSysdate(extractListModel, this.jName.getText(), true).length() > 30) {
            throw new TraversalException(DpWizardArb.getString("EXP_JNAME_TOO_LONG_NOT_SCHEDULED"), DpWizardArb.getString("EXP_JNAME_TOO_LONG"));
        }
        bl = Boolean.FALSE;
        if (this._optDir.isSelected()) {
            bl = Boolean.TRUE;
        }
        extractListModel.setProperty("EXP_OPT_DIR_SELECTED", (Object)bl);
        extractListModel.setProperty("EXP_OUT_7", (Object)this.curDir.getText());
    }

    private static String dirToPath(OutputDirectoriesUI outputDirectoriesUI, ExtractListModel extractListModel) {
        String string = "";
        ArrayList<String[]> arrayList = outputDirectoriesUI.getSettings();
        if (arrayList != null && arrayList.size() > 0 && arrayList.get(0)[0] != null && !arrayList.get(0)[0].equals("")) {
            ArrayList arrayList2 = (ArrayList)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_DIRECTORIES_PATH", new ArrayList());
            for (String[] stringArray : arrayList2) {
                if (stringArray[0] == null || !stringArray[1].equals(arrayList.get(0)[0])) continue;
                string = stringArray[2];
                break;
            }
        }
        return string;
    }
}

