/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.util.Pair;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class DpExpWizOSSTransfer
extends DefaultTraversablePanel {
    private ExtractListModel _listModel = null;
    private static final long serialVersionUID = 1L;
    private JTextField _threadNumber = new JTextField(5);
    boolean _isShowGoToSummary = true;
    private JComboBox _connCombo;
    boolean _passwordclean = false;
    private JTextField _jName = new JTextField(20);
    char[] currentPassword;
    private JLabel _warnNeedCred = new JLabel(DpWizardArb.getString("EXP_PRECONFIGURED"));
    private JLabel _ADWCConn = new JLabel(DpWizardArb.getString("EXP_CONNECTION_IMPORT"));
    private JCheckBox _dumpExists = new JCheckBox(DpWizardArb.getString("EXP_DMP_EXISTS"));
    private JLabel _ADWCCred = new JLabel(DpWizardArb.getString("EXP_ADWC_CRED"));
    private JLabel _URLBucket = new JLabel(DpWizardArb.getString("EXP_BUCKET"));
    private JLabel _noDbmsCloud = new JLabel(DpWizardArb.getString("EXP_NO_DBMS_CLOUD"));
    private JLabel _jobName = new JLabel(DpWizardArb.getString("EXP_JOB_NAME"));
    private DBConnectionComboBox _ADWCConnCombo;
    private JTextField _optDirPathTF = new JTextField(20);
    private JTextField _jobNameTF = new JTextField(20);
    private JComboBox<String> _ADWCCredCombo = new JComboBox();
    private URLFileChooser.URLFileChooserPanel _dataChooser;
    private JCheckBox _cbDoImport = new JCheckBox(DpWizardArb.getString("FULL_IMPORT"));
    private JCheckBox _cbGoToSummary = new JCheckBox();
    private JPanel log = new JPanel();

    public DpExpWizOSSTransfer() {
        this.buildUI();
    }

    public void connectionChanged(ActionEvent actionEvent) {
        String string = this._ADWCConnCombo.getCurrentConnectionName();
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = (String)this._listModel.getPropertyValue("KEY_CNAME_FOLLOWING_IMPORT");
        if (string2 == null || !string2.equals(string)) {
            // empty if block
        }
        boolean bl = false;
        if (string2 == null || !string2.equals(string)) {
            bl = true;
        }
        this._listModel.setProperty("KEY_CNAME_FOLLOWING_IMPORT", (Object)string);
        if (!bl) {
            return;
        }
        this.connectionChangedUI();
    }

    private void initDataChooser() {
        this._dataChooser = URLFileChooser.createURLFileChooserPanel((int)0, null, null, (boolean)false, (boolean)false, (boolean)false);
        this._dataChooser.setEncoding("UTF-8");
        this._dataChooser.setEnabled(true);
        this._dataChooser.setCheckIfFileExists(false);
        this._dataChooser.setMaximumSize(new Dimension(200, 60));
        this._dataChooser.setPathContext(((Object)((Object)this)).getClass().getName() + ".dataChooser");
        this._URLBucket.setLabelFor((Component)this._dataChooser);
        this._dataChooser.clearChooseableURLFilters();
        this._dataChooser.setURLFilter(new URLFilter(){

            public boolean accept(URL uRL) {
                return true;
            }
        });
    }

    protected void setDataChooserURL(URL uRL) {
        this._dataChooser.setSelectedURL(uRL);
    }

    protected URL getDataChooserURL() {
        URL uRL = this._dataChooser.getSelectedURL();
        return uRL;
    }

    public void connectionChangedUI() {
        String string = (String)this._listModel.getPropertyValue("KEY_CNAME_FOLLOWING_IMPORT");
        this.getCredentialsOnTask(string);
    }

    public void getCredentialsOnTask(final String string) {
        DatabaseQueryTask<Pair<Boolean, ArrayList<String>>> databaseQueryTask = new DatabaseQueryTask<Pair<Boolean, ArrayList<String>>>(DpWizardArb.getString("EXP_POPULATE_CREDENTIALS"), IRaptorTaskRunMode.MODAL, false, true){

            public void canProceedTask() throws ExecutionException {
                this.checkCanProceed();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Pair<Boolean, ArrayList<String>> doWork() throws TaskException {
                Boolean bl;
                ArrayList<Object> arrayList;
                block8: {
                    arrayList = new ArrayList<Object>();
                    bl = false;
                    try {
                        Connection connection = Connections.getInstance().getConnection(string, true);
                        Object var4_5 = null;
                        if (!Connections.getInstance().lock(connection)) break block8;
                        try {
                            bl = DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)connection), (String)"dbms_cloud");
                            if (bl.booleanValue()) {
                                List list = DBUtil.getInstance((Connection)connection).executeReturnList(this.getQuery(), new HashMap());
                                for (Map map : list) {
                                    arrayList.add((String)map.get("CRED"));
                                }
                                String string2 = DBUtil.getInstance((Connection)connection).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('IMP_SD_F') from dual", new HashMap());
                                if (string2 == null || string2.equals("")) {
                                    throw new Exception("EXP_JOB_NAME");
                                }
                                arrayList.add(0, string2);
                            }
                        }
                        finally {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                    catch (Exception exception) {
                        throw new TaskException((Throwable)exception);
                    }
                }
                return new Pair((Object)bl, arrayList);
            }

            public boolean cancel() {
                return super.cancel();
            }

            public String getQuery() {
                return " select credential_name cred from all_credentials order by cred";
            }

            public String getConnectionName() {
                return string;
            }
        };
        RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter((DatabaseQueryTask)databaseQueryTask){
            final /* synthetic */ DatabaseQueryTask val$task;
            {
                this.val$task = databaseQueryTask;
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Serializable serializable;
                        Pair pair = new Pair((Object)Boolean.FALSE, new ArrayList());
                        TraversalException traversalException = null;
                        String string = null;
                        try {
                            pair = (Pair)val$task.getResult();
                        }
                        catch (InterruptedException interruptedException) {
                            string = DpWizardArb.getString("IMP_EXCEPTION_OCCURRED");
                            traversalException = new TraversalException(DpWizardArb.format("IMP_EXCEPTION", interruptedException.getLocalizedMessage()), string);
                        }
                        catch (ExecutionException executionException) {
                            string = DpWizardArb.getString("IMP_EXCEPTION_OCCURRED");
                            traversalException = new TraversalException(DpWizardArb.format("IMP_EXCEPTION", executionException.getLocalizedMessage()), string);
                        }
                        if (traversalException != null) {
                            traversalException.showMessageDialog((Component)((Object)DpExpWizOSSTransfer.this));
                            return;
                        }
                        DpExpWizOSSTransfer.this._ADWCCredCombo.removeAllItems();
                        if (((Boolean)pair.first()).equals(Boolean.TRUE) && pair.second() != null && ((ArrayList)pair.second()).size() > 0) {
                            Object object;
                            serializable = (ArrayList)pair.second();
                            DpExpWizOSSTransfer.this._jobNameTF.setText((String)((ArrayList)serializable).get(0));
                            ((ArrayList)serializable).remove(0);
                            Object object2 = ((ArrayList)serializable).iterator();
                            while (object2.hasNext()) {
                                object = (String)object2.next();
                                DpExpWizOSSTransfer.this._ADWCCredCombo.addItem(object);
                            }
                            object2 = (String)DpWizCommon.getOrInitializeList(DpExpWizOSSTransfer.this._listModel, "EXP_OUT_10", "");
                            if (object2 != null && !((String)object2).equals("") && ((ArrayList)serializable).contains(object2) && ((ArrayList)serializable).contains(object2)) {
                                DpExpWizOSSTransfer.this._ADWCCredCombo.setSelectedItem((String)DpWizCommon.getOrInitializeList(DpExpWizOSSTransfer.this._listModel, "EXP_OUT_10", ""));
                            }
                            if ((object = DpExpWizOSSTransfer.this._noDbmsCloud.getParent()) != null && object.equals(DpExpWizOSSTransfer.this.log)) {
                                DpExpWizOSSTransfer.this.log.remove(DpExpWizOSSTransfer.this._noDbmsCloud);
                                DpExpWizOSSTransfer.this.log.add((Component)DpExpWizOSSTransfer.this._ADWCCredCombo, LayoutControl.GBC.gbc((int)1, (int)9, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_CONTROL2BUTTON_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
                            }
                        } else {
                            serializable = DpExpWizOSSTransfer.this._ADWCCredCombo.getParent();
                            if (serializable != null && serializable.equals(DpExpWizOSSTransfer.this.log)) {
                                DpExpWizOSSTransfer.this.log.remove(DpExpWizOSSTransfer.this._ADWCCredCombo);
                                DpExpWizOSSTransfer.this.log.add((Component)DpExpWizOSSTransfer.this._noDbmsCloud, LayoutControl.GBC.gbc((int)1, (int)9, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_CONTROL2BUTTON_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
                            }
                        }
                        DpExpWizOSSTransfer.this.log.revalidate();
                        DpExpWizOSSTransfer.this.log.repaint();
                    }
                });
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = new TraversalException(DpWizardArb.getString("IMP_TASK_FAILED"), DpWizardArb.getString("IMP_TASK_FAILED"));
                        traversalException.showMessageDialog((Component)((Object)DpExpWizOSSTransfer.this));
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = new TraversalException(DpWizardArb.getString("IMP_TASK_CANCELLED_CANCEL_WIZARD"), DpWizardArb.getString("IMP_TASK_CANCELLED"));
                        traversalException.showMessageDialog((Component)((Object)DpExpWizOSSTransfer.this));
                    }
                });
            }
        };
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
    }

    public void buildUI() {
        this.initDataChooser();
        this._ADWCConnCombo = new OracleConnectionComboBox();
        this._connCombo = this._ADWCConnCombo.getJComboBox();
        this.setLayout(new GridBagLayout());
        this.log.setLayout(new GridBagLayout());
        this.log.add((Component)this._warnNeedCred, LayoutControl.GBC.gbc((int)0, (int)0, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        this.log.add((Component)this._ADWCConn, LayoutControl.GBC.gbc((int)0, (int)1, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        this.addLabelandText(this.log, 2, this._ADWCConn, this._connCombo);
        this.addLabelandText(this.log, 9, this._ADWCCred, this._ADWCCredCombo);
        this.addLabelandText(this.log, 12, this._URLBucket, (JComponent)this._dataChooser);
        this.log.add((Component)this._dumpExists, LayoutControl.GBC.gbc((int)0, (int)13, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        this.log.add((Component)this._cbDoImport, LayoutControl.GBC.gbc((int)0, (int)14, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        this.addLabelandText(this.log, 15, this._jobName, this._jobNameTF);
        this._cbDoImport.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DpExpWizOSSTransfer.this._jobName.setEnabled(true);
                    DpExpWizOSSTransfer.this._jobNameTF.setEnabled(true);
                } else {
                    DpExpWizOSSTransfer.this._jobName.setEnabled(false);
                    DpExpWizOSSTransfer.this._jobNameTF.setEnabled(false);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.log, LayoutControl.GBC.gbc((int)0, (int)0, (int)6, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)2, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START));
        this.add(Box.createVerticalGlue(), LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        this._connCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DpExpWizOSSTransfer.this.connectionChanged(actionEvent);
            }
        });
        if (this._isShowGoToSummary) {
            ResourceUtils.resButton((AbstractButton)this._cbGoToSummary, (String)StringUtils.stripMnemonic((String)UiResources.getString((String)"GOTO_SUMMARY")));
            this.add(this._cbGoToSummary, LayoutControl.GBC.gbc((int)0, (int)4, (int)4, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_END_FULL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.LINE_START));
            this._cbGoToSummary.setSelected(true);
            this._cbGoToSummary.setEnabled(false);
        }
    }

    private void switchdependancies(JComponent[] jComponentArray, boolean bl) {
        for (JComponent jComponent : jComponentArray) {
            if (jComponent instanceof JLabel) {
                ((JLabel)jComponent).setEnabled(bl);
                continue;
            }
            if (jComponent instanceof JTextField) {
                ((JTextField)jComponent).setEnabled(bl);
                continue;
            }
            if (jComponent instanceof JCheckBox) {
                ((JCheckBox)jComponent).setEnabled(bl);
                continue;
            }
            if (jComponent instanceof JComboBox) {
                ((JComboBox)jComponent).setEnabled(bl);
                continue;
            }
            new Exception().printStackTrace();
        }
    }

    private void addLabelandText(JPanel jPanel, int n, JLabel jLabel, JComponent jComponent) {
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        jPanel.add((Component)jComponent, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_CONTROL2BUTTON_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
    }

    public void onEntry(TraversableContext traversableContext) {
        boolean bl;
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        if (((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "SKIP_TO_OSS", Boolean.FALSE)).booleanValue()) {
            this._listModel.setProperty("EXP_OUT_8", (Object)Boolean.TRUE);
        }
        this._listModel.setProperty("SKIP_TO_OSS", (Object)Boolean.FALSE);
        String string = (String)DpWizCommon.getOrInitializeList(this._listModel, "EXP_OUT_1", "");
        this._ADWCConnCombo.setCurrentConnection(string);
        boolean bl2 = bl = this._dumpExists.getParent() != null && this._dumpExists.getParent().equals(this.log);
        if (DpWizCommon.getOrInitializeList(this._listModel, "EXP_LAST_EXCEPTION", null) != null) {
            if (!bl) {
                this.log.add((Component)this._dumpExists, LayoutControl.GBC.gbc((int)0, (int)15, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_SUB, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
            }
        } else {
            if (bl) {
                this.log.remove(this._dumpExists);
            }
            this._listModel.setProperty("EXP_OUT_8", (Object)Boolean.FALSE);
        }
        this._dumpExists.setSelected((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_OUT_8", Boolean.FALSE));
        String string2 = (String)DpWizCommon.getOrInitializeList(this._listModel, "EXP_OUT_10", "");
        if (string2 != null && !string2.equals("")) {
            if (this._ADWCCredCombo.getItemCount() == 0) {
                this._ADWCCredCombo.addItem(string2);
            }
            this._ADWCCredCombo.setSelectedItem(string2);
        }
        URL uRL = null;
        try {
            uRL = new URL("https://localhost");
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).severe(malformedURLException.getMessage());
        }
        this.setDataChooserURL((URL)DpWizCommon.getOrInitializeList(this._listModel, "EXP_OUT_11", uRL));
        Boolean bl3 = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_CHECK_DO_IMPORT", Boolean.TRUE);
        this._cbDoImport.setSelected(bl3);
        this._jobNameTF.setEnabled(bl3);
        this._jobNameTF.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "EXP_FULL_JOB_NAME", ""));
        this._jobName.setEnabled(bl3);
        if (string != null && !string.equals("")) {
            this.getCredentialsOnTask(string);
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ExtractListModel extractListModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        URL uRL = this.getDataChooserURL();
        if (traversableContext.getDirection() == 1 && (this._ADWCCredCombo.getSelectedItem() == null || this._ADWCCredCombo.getSelectedItem().equals("") || uRL == null || uRL.getHost() == null || uRL.getHost().equals("localhost"))) {
            throw new TraversalException(DpWizardArb.getString("EXP_OSS_FILE_TRANSFER"));
        }
        this.testDirExists(this._optDirPathTF.getText(), extractListModel);
        extractListModel.setProperty("EXP_OUT_1", (Object)this._ADWCConnCombo.getCurrentConnectionName());
        extractListModel.setProperty("EXP_OUT_8", (Object)this._dumpExists.isSelected());
        extractListModel.setProperty("EXP_OUT_10", this._ADWCCredCombo.getSelectedItem());
        extractListModel.setProperty("EXP_OUT_11", (Object)uRL);
        extractListModel.setProperty("EXP_CHECK_3", (Object)Boolean.FALSE);
        extractListModel.setProperty("EXP_CHECK_DO_IMPORT", (Object)this._cbDoImport.isSelected());
        extractListModel.setProperty("EXP_FULL_JOB_NAME", (Object)this._jobNameTF.getText());
    }

    public void testDirExists(String string, ExtractListModel extractListModel) throws TraversalException {
        this.getFileNames(string, extractListModel);
    }

    public static String stripDir(String string, boolean bl) {
        if (!bl) {
            return string;
        }
        if (string.equals("NULL") || string.equals("CREDENTIAL:NULL")) {
            return string;
        }
        return string.substring(string.indexOf(":") + 1).replaceAll("\"", "");
    }

    public ArrayList<String> tofilepath(String string, String string2, String string3) throws TraversalException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            File file = null;
            file = string3 != null && !string3.equals("") ? FileSystems.getDefault().getPath(string3, new String[0]).toFile() : FileSystems.getDefault().getPath(string, new String[0]).toFile();
            if (!file.isDirectory()) {
                throw new TraversalException(DpWizardArb.getString("EXP_TRANSFER_DIRECTORY"));
            }
        }
        catch (Exception exception) {
            throw new TraversalException(DpWizardArb.getString("EXP_TRANSFER_DIRECTORY") + exception.getMessage());
        }
        return arrayList;
    }

    public ArrayList<String> getFullPath(String[] stringArray, ArrayList<String[]> arrayList, String string) throws TraversalException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = stringArray[0];
        if (string2.startsWith("DIRECTORY:")) {
            string2 = string2.substring(string2.indexOf(":") + 1);
        }
        for (String[] stringArray2 : arrayList) {
            if (!stringArray2[1].equals(string2)) continue;
            for (String string3 : this.tofilepath(stringArray2[2], stringArray[2], string)) {
            }
        }
        return arrayList2;
    }

    public void getFileNames(String string, ExtractListModel extractListModel) throws TraversalException {
        ArrayList arrayList = (ArrayList)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_DIRECTORIES_PATH", new ArrayList());
        ArrayList arrayList2 = (ArrayList)DpWizCommon.getOrInitializeList(extractListModel, "IMP_OUTPUTDIRFILESIZE", new ArrayList());
        for (String[] stringArray : arrayList2) {
            for (String string2 : this.getFullPath(stringArray, arrayList, string)) {
            }
        }
    }

    public String getExitTransition() {
        return "Fin";
    }
}

