/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.CopyFilesPane;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizMain;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.OutputDirectoriesUI;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class DpExpWizOutputFiles
extends DefaultTraversablePanel {
    private String[] _gotDirectories = null;
    private static final long serialVersionUID = 1L;
    private OutputDirectoriesUI _oUI = new OutputDirectoriesUI();
    private ExtractListModel _listModel = null;
    protected final JCheckBox _cbGoToSummary = new JCheckBox();
    private JCheckBox _reuse = null;
    private JCheckBox _appendSysdate = null;
    private JCheckBox _ossTransfer = null;
    private JCheckBox _compressionAll = new JCheckBox(DpWizardArb.getString("COMPRESSION_ALL"));
    private boolean _isShowGoToSummary = true;
    private JCheckBox _toEnable = new JCheckBox(DpWizardArb.getString("EXP_OSS_TRANSFER_OPTIONS"));
    private CopyFilesPane _cfp = new CopyFilesPane(this._oUI);

    public DpExpWizOutputFiles() {
        this.setLayout(new GridBagLayout());
        this.add(this._oUI, new GridBagConstraints(0, 0, 3, 3, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._ossTransfer = new JCheckBox(DpWizardArb.getString("EXP_OSS_TRANSFER_OPTIONS"));
        this._ossTransfer.setSelected(false);
        this._reuse = new JCheckBox();
        this._reuse.setSelected(false);
        this._appendSysdate = new JCheckBox();
        this._appendSysdate.setSelected(false);
        this._reuse.setText(DpWizardArb.getString("EXP_OVERWRITE_EXISTING_FILE"));
        this.add(this._reuse, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._appendSysdate.setText(DpWizardArb.getString("EXP_APPEND_SYSDATE_LABEL"));
        this.add(this._appendSysdate, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._compressionAll, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._compressionAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DpExpWizOutputFiles.this._compressionAll.isSelected()) {
                    DpExpWizOutputFiles.this._compressionAll.setSelected(LicenseUtils.requiresLicense((String)"AdvancedCompression", (String)((String)DpExpWizOutputFiles.this._listModel.getPropertyValue("KEY_CNAME")), (boolean)false));
                }
            }
        });
        this.add(this._toEnable, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._cfp, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 10.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 9, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._isShowGoToSummary) {
            ResourceUtils.resButton((AbstractButton)this._cbGoToSummary, (String)StringUtils.stripMnemonic((String)UiResources.getString((String)"GOTO_SUMMARY")));
            this.add(this._cbGoToSummary, new GridBagConstraints(0, 10, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this._toEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DpExpWizOutputFiles.this._cfp.setLocalEnabled(true);
                } else {
                    DpExpWizOutputFiles.this._cfp.setLocalEnabled(false);
                }
            }
        });
        this.validate();
    }

    public String[] getDirectories(TraversableContext traversableContext) {
        this._gotDirectories = (String[])DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_DIRECTORIES", new String[0]);
        return this._gotDirectories;
    }

    public void onEntry(TraversableContext traversableContext) {
        ExtractListModel extractListModel = (ExtractListModel)DpExpWizMain.getOrInitializeContext(traversableContext, "KEY_EXPORT_OBJECTS", new ExtractListModel());
        if (traversableContext.getDirection() == 1 && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "SKIP_TO_OSS", Boolean.FALSE)).booleanValue()) {
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        super.onEntry(traversableContext);
        this._gotDirectories = null;
        this._oUI.setDirectories(this.getDirectories(traversableContext));
        this._oUI.onEntry(traversableContext);
        this._cfp.onEntry(traversableContext);
        if (((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE)).equals(Boolean.TRUE)) {
            this._toEnable.setSelected(true);
            this._cfp.setLocalEnabled(true);
        } else {
            this._toEnable.setSelected(false);
            this._cfp.setLocalEnabled(false);
        }
        Boolean bl = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_COMPRESSION_ALL", null);
        if (bl == null) {
            bl = LicenseUtils.requiresLicense((String)"AdvancedCompression", (String)((String)this._listModel.getPropertyValue("KEY_CNAME")), (boolean)false);
            this._listModel.setProperty("EXP_COMPRESSION_ALL", (Object)bl);
        }
        this._compressionAll.setSelected(bl);
        this._reuse.setSelected(((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_REUSEDUMP_FILE", Boolean.FALSE)).equals(Boolean.TRUE));
        this._appendSysdate.setSelected(((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_APPENDSYSDATEDUMPFILE", Boolean.TRUE)).equals(Boolean.TRUE));
        this._cbGoToSummary.setSelected(false);
        Version version = (Version)this._listModel.getPropertyValue("EXP_VERSION");
        this._reuse.setEnabled(true);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        if (this._appendSysdate.isSelected()) {
            this._listModel.setProperty("DP_APPENDSYSDATEDUMPFILE", (Object)Boolean.TRUE);
        } else {
            this._listModel.setProperty("DP_APPENDSYSDATEDUMPFILE", (Object)Boolean.FALSE);
        }
        this._cfp.onExit(traversableContext);
        this._oUI.onExit(traversableContext);
        Boolean bl = Boolean.FALSE;
        if (this._toEnable.isSelected()) {
            bl = Boolean.TRUE;
        }
        this._listModel.setProperty("EXP_EXP_OSSTRANSFER_ENABLED", (Object)bl);
        if (this._reuse.isSelected()) {
            this._listModel.setProperty("DP_REUSEDUMP_FILE", (Object)Boolean.TRUE);
        } else {
            this._listModel.setProperty("DP_REUSEDUMP_FILE", (Object)Boolean.FALSE);
        }
        this._listModel.setProperty("EXP_COMPRESSION_ALL", (Object)this._compressionAll.isSelected());
    }

    private boolean isCopyScreen() {
        return this._toEnable.isSelected();
    }

    public Object getExitTransition() {
        if (this.isCopyScreen()) {
            return "TRANSOSSTransfer";
        }
        if (this._cbGoToSummary.isSelected()) {
            return "Fin";
        }
        return "TRANSScheduleOptions";
    }
}

