/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryXMLDataNode;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.model.Element;

public final class GalleryAddinUtil {
    private GalleryAddinUtil() {
    }

    public static void usage() {
        System.out.println("GalleryAddinUtil loader version 9i");
        System.out.println("Usage:  GalleryAddinUtil <gallery.xml> <gallery entry properties file>");
        System.out.println("");
        System.exit(0);
    }

    public static void legacyLoadGalleryItems(URL xmlURL, URL propURL) {
        GalleryAddinUtil.loadGalleryItems(xmlURL, propURL, "NumItems", "Item");
    }

    public static void loadGalleryItems(URL xmlURL, URL propURL) {
        GalleryAddinUtil.loadGalleryItems(xmlURL, propURL, "NumItems.Add", "Add.Item");
    }

    private static void loadGalleryItems(URL xmlURL, URL propURL, String countProp, String itemPropPrefix) {
        try {
            Properties props = new Properties();
            props.load(propURL.openStream());
            GalleryXMLDataNode gxn = new GalleryXMLDataNode(xmlURL);
            RootGalleryFolder rf = (RootGalleryFolder)gxn.getData();
            String o = props.getProperty(countProp);
            if (o == null) {
                return;
            }
            int numItems = Integer.parseInt(o.toString().trim());
            for (int i = 0; i < numItems; ++i) {
                String categoryName = props.getProperty(itemPropPrefix + i + ".category");
                String folderName = props.getProperty(itemPropPrefix + i + ".folder");
                String clazz = props.getProperty(itemPropPrefix + i + ".class");
                String name = props.getProperty(itemPropPrefix + i + ".name");
                String descrip = props.getProperty(itemPropPrefix + i + ".description");
                String resclass = props.getProperty(itemPropPrefix + i + ".resclass");
                String unsortedS = props.getProperty(itemPropPrefix + i + ".unsorted");
                String iconFile = props.getProperty(itemPropPrefix + i + ".iconFile");
                boolean unsorted = unsortedS != null ? Boolean.valueOf(unsortedS) : false;
                String[] params = GalleryAddinUtil.getPropertyArray(props, itemPropPrefix + i, ".numParams", ".param");
                String[] technologyKeys = GalleryAddinUtil.getPropertyArray(props, itemPropPrefix + i, ".numTechnologyKeys", ".technologyKey");
                if (folderName == null || folderName.trim().length() == 0) {
                    System.out.println("WARNING: property " + itemPropPrefix + i + ".folder not specified");
                    continue;
                }
                ElementInfo info = new ElementInfo(categoryName, folderName, clazz, params, name, descrip, iconFile, unsorted);
                if (resclass != null && resclass.length() != 0) {
                    info.setResClass(resclass);
                }
                info.setTechnologyKeys(technologyKeys);
                GalleryFolder f = rf.createFolder(info.getPath());
                GalleryElement ele = info.createElement();
                f.add(ele);
            }
            gxn.markDirty(true);
            gxn.save();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public static void removeGalleryItems(URL xmlURL, URL propURL) {
        try {
            Properties props = new Properties();
            props.load(propURL.openStream());
            GalleryXMLDataNode gxn = new GalleryXMLDataNode(xmlURL);
            RootGalleryFolder rf = (RootGalleryFolder)gxn.getData();
            String o = props.getProperty("NumItems.Remove");
            if (o == null) {
                return;
            }
            int numItems = Integer.parseInt(o.toString().trim());
            for (int i = 0; i < numItems; ++i) {
                String categoryName = props.getProperty("Remove.Item" + i + ".category");
                String folderName = props.getProperty("Remove.Item" + i + ".folder");
                if (folderName == null) continue;
                String name = props.getProperty("Remove.Item" + i + ".name");
                String clazz = props.getProperty("Remove.Item" + i + ".class");
                ElementInfo info = new ElementInfo();
                info.setPath(categoryName, folderName);
                info.setWizardClass(clazz);
                info.setName(name);
                GalleryFolder f = rf.getFolder(info.getPath());
                if (name == null && clazz == null) {
                    if (f.size() <= 0) {
                        rf.remove((Element)f);
                        continue;
                    }
                    System.out.println("WARNING: NOT removing folder [" + folderName + "] since it is not empty.");
                    continue;
                }
                if (f == null) {
                    System.out.println("WARNING: Could not find folder named: " + folderName);
                    continue;
                }
                GalleryElement ele = f.getGalleryElement(name);
                if (ele == null) {
                    System.out.println("WARNING: Could not find element: " + name);
                    continue;
                }
                if (clazz != null && !ele.getWizardClass().equals(clazz)) continue;
                f.remove(ele);
            }
            gxn.markDirty(true);
            gxn.save();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            System.exit(1);
        }
    }

    private static String[] getPropertyArray(Properties props, String prefix, String numProperty, String itemProperty) {
        String numProp = props.getProperty(prefix + numProperty, "0");
        int n = Integer.parseInt(numProp);
        if (n == 0) {
            return null;
        }
        String[] array = new String[n];
        for (int i = 0; i < n; ++i) {
            array[i] = props.getProperty(prefix + itemProperty + i);
        }
        return array;
    }

    private static URL getFileURL(String filePath) {
        URL url = null;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                url = file.toURL();
            }
            catch (MalformedURLException muEx) {
                System.err.println("ERROR: URL [" + url.toString() + "] is not valid");
            }
        } else {
            System.err.println("ERROR: File [" + filePath + "] does not exist");
        }
        return url;
    }

    private static void abort(String errorText) {
        System.err.println("ERROR: " + errorText);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            GalleryAddinUtil.usage();
        }
        System.out.println("Deprecated: Gallery definitions need to be defined in extension manifest");
        URL xmlURL = GalleryAddinUtil.getFileURL(args[0]);
        URL propURL = GalleryAddinUtil.getFileURL(args[1]);
        if (xmlURL == null || propURL == null) {
            GalleryAddinUtil.abort("Invalid Command Line Arguments Given");
            GalleryAddinUtil.usage();
        }
        GalleryAddinUtil.loadGalleryItems(xmlURL, propURL);
        GalleryAddinUtil.legacyLoadGalleryItems(xmlURL, propURL);
        GalleryAddinUtil.removeGalleryItems(xmlURL, propURL);
        System.exit(0);
    }
}

