/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NbResourceHelper {
    private static final String ENCODING_PATTERN = "(?ms).*\\s*<meta\\s+http-equiv=['\"]content-type['\"]\\s+content=['\"]\\s*text/html;\\s+charset=(.*)['\"]\\s*/?>\\s*.*";
    private static final Pattern encodingPattern = Pattern.compile("(?ms).*\\s*<meta\\s+http-equiv=['\"]content-type['\"]\\s+content=['\"]\\s*text/html;\\s+charset=(.*)['\"]\\s*/?>\\s*.*");
    private static final int BUFFER_LENGTH = 4096;
    private static final Logger LOGGER = Logger.getLogger(NbResourceHelper.class.getName());

    private NbResourceHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResource(String url) {
        InputStream is = null;
        String text = "";
        try {
            is = new URL(url).openStream();
            byte[] arr = new byte[4096];
            int len = is.read(arr);
            Charset encoding = NbResourceHelper.getEncoding(arr);
            StringBuilder sb = new StringBuilder();
            while (len > 0) {
                sb.append(new String(arr, 0, len, encoding));
                len = is.read(arr);
            }
            text = sb.toString().replaceAll("<[^>]*?>", "").trim();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return text;
    }

    private static Charset getEncoding(byte[] arr) throws IOException {
        Charset encoding = NbResourceHelper.analyzeBOM(arr);
        if (encoding == null) {
            String foundEncoding;
            String part = new String(arr);
            Matcher m = encodingPattern.matcher(part);
            if (m.matches() && Charset.isSupported(foundEncoding = m.group(1))) {
                encoding = Charset.forName(foundEncoding);
            }
            if (encoding == null) {
                encoding = Charset.defaultCharset();
            }
        }
        return encoding != null ? encoding : Charset.defaultCharset();
    }

    private static Charset analyzeBOM(byte[] arr) throws IOException {
        if (arr.length < 4) {
            return null;
        }
        Charset encoding = null;
        if (arr[0] == -17 && arr[1] == -69 && arr[2] == -65) {
            encoding = Charset.forName("UTF-8");
        } else if (arr[0] == -2 && arr[1] == -1) {
            encoding = Charset.forName("UTF-16BE");
        } else if (arr[0] == -1 && arr[1] == -2) {
            encoding = Charset.forName("UTF-16LE");
        } else if (arr[0] == 0 && arr[1] == 0 && arr[2] == -2 && arr[3] == -1) {
            encoding = Charset.forName("UTF-32BE");
        } else if (arr[0] == -1 && arr[1] == -2 && arr[2] == 0 && arr[3] == 0) {
            encoding = Charset.forName("UTF-32LE");
        } else {
            int found = 0;
            for (int i = 0; i < 4; ++i) {
                if (arr[i] != 0) continue;
                ++found;
            }
            if (found >= 2) {
                encoding = arr[0] == 0 ? Charset.forName("UTF-16BE") : Charset.forName("UTF-16LE");
            }
        }
        return encoding;
    }
}

