/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ideimpl.gallery.GalleryElementReference;
import oracle.javatools.data.HashStructure;

final class NewMenuHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "new-menu-hook");
    private static final String ADD_TO_MENU_ELEMENT_KEY = "add-to-new-menu";
    private static HashStructureHook _hashStructureHook;
    private static final Map<String, List<GalleryElementReference>> _newMenuItems;

    NewMenuHook() {
    }

    public static List<GalleryElementReference> getGalleryItems(String extensionId) {
        NewMenuHook.initializeHook();
        if (_newMenuItems.containsKey(extensionId)) {
            return Collections.unmodifiableList(_newMenuItems.get(extensionId));
        }
        return Collections.emptyList();
    }

    private static void initializeHook() {
        if (_hashStructureHook == null) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            _hashStructureHook = (HashStructureHook)extensionRegistry.getHook(NAME);
            if (_hashStructureHook == null) {
                return;
            }
            _hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    Logger.getLogger(NewMenuHook.class.getName()).log(Level.SEVERE, "The new-menu-hook can only be used as a trigger hook, so this is unexpected!");
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    NewMenuHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    public static void getItemsFromHook(HashStructure hashStructure) {
        List galleryItems = hashStructure.getAsList("gallery-item");
        if (galleryItems == null) {
            return;
        }
        for (HashStructure itemHash : galleryItems) {
            GalleryElementReference elementReference = GalleryElementReference.getInstance(itemHash);
            if (!elementReference.getBoolean(ADD_TO_MENU_ELEMENT_KEY, false)) continue;
            String extId = itemHash.getString("#__extension-id");
            if (!_newMenuItems.containsKey(extId)) {
                _newMenuItems.put(extId, new ArrayList());
            }
            List<GalleryElementReference> list = _newMenuItems.get(extId);
            list.add(elementReference);
        }
    }

    static {
        _newMenuItems = new HashMap<String, List<GalleryElementReference>>();
    }
}

