/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.specification.ExportDomains;
import oracle.javatools.exports.specification.FileExportSpecification;
import oracle.javatools.exports.specification.FileExportSpecificationReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.SAXException;

public class CreateExportsFromUsesTask
extends Task {
    private String owner;
    private String source;
    private Path domainFile;
    private Path inputFile;
    private Format inputFormat;
    private boolean failOnUnexpectedInput = true;
    private Path exportsFile;
    private Path listFile;

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDomainFile(File domainFile) {
        this.domainFile = domainFile.toPath();
    }

    public void setMessagesFile(File file) {
        if (this.inputFormat != null) {
            throw new BuildException("only one of messagesfile or tablefile allowed");
        }
        this.inputFormat = Format.MESSAGE;
        this.inputFile = file.toPath();
    }

    public void setTableFile(File file) {
        if (this.inputFormat != null) {
            throw new BuildException("only one of messagesfile or tablefile allowed");
        }
        this.inputFormat = Format.TABLE;
        this.inputFile = file.toPath();
    }

    public void setFailOnUnexpectedInput(boolean failOnUnexpectedInput) {
        this.failOnUnexpectedInput = failOnUnexpectedInput;
    }

    public void setExportsFile(File file) {
        this.exportsFile = file.toPath();
    }

    public void setListFile(File file) {
        this.listFile = file.toPath();
    }

    /*
     * Unable to fully structure code
     */
    public void execute() {
        if (Paths.isUpToDate(this.exportsFile, FileUtils.getFileUtils().getFileTimestampGranularity(), new Path[]{this.domainFile, this.inputFile}) && Paths.isUpToDate(this.listFile, FileUtils.getFileUtils().getFileTimestampGranularity(), new Path[]{this.domainFile, this.inputFile})) {
            return;
        }
        if (this.domainFile != null) {
            this.log(String.format("parsing domain file %s", new Object[]{this.domainFile}));
            try {
                reader = new FileExportSpecificationReader();
                reader.setSchemaValidating(true);
                issues = new ArrayList<String>();
                domains = ((FileExportSpecification)reader.read(this.domainFile, issues)).getDomains();
                this.log(String.format("export file domains: %s", new Object[]{domains}), 2);
                if (this.failOnUnexpectedInput) {
                    var4_5 = issues.iterator();
                    if (!var4_5.hasNext()) ** GOTO lbl23
                    issue = (String)var4_5.next();
                    throw new IOException(issue);
                }
                for (String issue : issues) {
                    this.log(issue, 1);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new BuildException("exception reading " + this.domainFile + ": " + e, (Throwable)e);
            }
        } else {
            domains = new ExportDomains(new String[0]);
        }
lbl23:
        // 3 sources

        this.log(String.format("parsing %s %s", new Object[]{this.inputFormat.toString().toLowerCase(), this.inputFile}));
        reportedUnusedDomains = new HashSet<String>();
        reportedAdjustedTypes = new HashSet<String>();
        elements = new LinkedHashMap<Element, Element>();
        lineCount = 0;
        try {
            reader = Files.newBufferedReader(this.inputFile);
            var7_11 = null;
            try {
                MEMBER_LABELS = Arrays.asList(new String[]{"constructor", "method", "field"});
                line = reader.readLine();
                while (line != null) {
                    block51: {
                        ++lineCount;
                        if (line.isEmpty() || line.startsWith("#")) break block51;
                        fields = line.split("\\s+");
                        switch (1.$SwitchMap$oracle$javatools$exports$ant$CreateExportsFromUsesTask$Format[this.inputFormat.ordinal()]) {
                            case 1: {
                                if (fields.length >= 3) ** GOTO lbl46
                                message = String.format("unmatched message at line %d: %s", new Object[]{lineCount, line});
                                if (this.failOnUnexpectedInput) {
                                    throw new IOException(message);
                                }
                                this.log(message, 1);
                                break block51;
lbl46:
                                // 1 sources

                                label = fields[1].toLowerCase();
                                qualifiedType = fields[0];
                                packag = this.getPackage(qualifiedType, reportedAdjustedTypes);
                                type = qualifiedType.substring(packag.length() + 1);
                                typeKind = "class";
                                if ("type".equals(label)) {
                                    member = "";
                                    break;
                                }
                                member = fields[2];
                                break;
                            }
                            case 2: {
                                if (fields.length >= 2) ** GOTO lbl63
                                message = String.format("unmatched message at line %d: %s", new Object[]{lineCount, line});
                                if (this.failOnUnexpectedInput) {
                                    throw new IOException(message);
                                }
                                this.log(message, 1);
                                break block51;
lbl63:
                                // 1 sources

                                label = fields[0].toLowerCase();
                                name = fields[1];
                                if (!"class".equals(label) && !"interface".equals(label)) ** GOTO lbl77
                                if ("in".equals(fields[2])) ** GOTO lbl72
                                message = String.format("unmatched message at line %d: %s", new Object[]{lineCount, line});
                                if (this.failOnUnexpectedInput) {
                                    throw new IOException(message);
                                }
                                this.log(message, 1);
                                break block51;
lbl72:
                                // 1 sources

                                packag = fields[3];
                                type = name;
                                typeKind = label;
                                member = "";
                                break;
lbl77:
                                // 1 sources

                                if ("type".equals(label)) {
                                    label = "class";
                                    type = name;
                                    member = "";
                                    packag = this.getPackage(type, reportedAdjustedTypes);
                                    type = type.substring(packag.length() + 1);
                                    typeKind = "class";
                                    break;
                                }
                                if (MEMBER_LABELS.contains(label)) ** GOTO lbl91
                                message = String.format("unexpected element type %s at line %d: %s", new Object[]{label, lineCount, line});
                                if (this.failOnUnexpectedInput) {
                                    throw new IOException(message);
                                }
                                this.log(message, 1);
                                break block51;
lbl91:
                                // 1 sources

                                if (fields.length >= 3 && "of".equals(fields[2])) ** GOTO lbl97
                                message = String.format("unmatched message at line %d: %s", new Object[]{lineCount, line});
                                if (this.failOnUnexpectedInput) {
                                    throw new IOException(message);
                                }
                                this.log(message, 1);
                                break block51;
lbl97:
                                // 1 sources

                                if (fields.length >= 7 && "in".equals(fields[5])) {
                                    packag = fields[6];
                                    type = fields[4];
                                    typeKind = fields[3];
                                } else if (fields.length >= 6 && "in".equals(fields[4])) {
                                    packag = fields[5];
                                    type = fields[3];
                                    typeKind = "class";
                                } else {
                                    qualifiedType = fields[3];
                                    packag = this.getPackage(qualifiedType, reportedAdjustedTypes);
                                    type = qualifiedType.substring(packag.length() + 1);
                                    typeKind = "class";
                                }
                                member = name;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("unexpected format " + (Object)this.inputFormat);
                            }
                        }
                        if (!domains.controls(packag)) {
                            if (reportedUnusedDomains.add(packag)) {
                                this.log(String.format("package %s outside domains: ignoring", new Object[]{packag}), 1);
                            }
                        } else {
                            packageElement = new Element("package", packag, "", "", lineCount);
                            if (elements.containsKey(packageElement)) {
                                packageElement = (Element)elements.get(packageElement);
                                packag = packageElement.getPackage();
                            } else {
                                elements.put(packageElement, packageElement);
                            }
                            type = this.erase(type);
                            typeElement = new Element(typeKind.intern(), packag, type, "", lineCount);
                            if (elements.containsKey(typeElement)) {
                                typeElement = (Element)elements.get(typeElement);
                                type = typeElement.getType();
                                if ("interface".equals(typeKind)) {
                                    typeElement.setLabel(typeKind);
                                }
                            } else {
                                elements.put(typeElement, typeElement);
                            }
                            if (!member.isEmpty()) {
                                typeElement.setMembers(true);
                                if (!"field".equals(label)) {
                                    member = this.erase(member);
                                }
                                if (elements.containsKey(memberElement = new Element(label.intern(), packag, type, member, lineCount))) {
                                    this.log(String.format("duplicate %s at lines %d and %d: %s", new Object[]{label, ((Element)elements.get(memberElement)).getLine(), lineCount, line}), 1);
                                } else {
                                    elements.put(memberElement, memberElement);
                                }
                            }
                        }
                    }
                    line = reader.readLine();
                }
                lineCount = 0;
            }
            catch (Throwable var8_14) {
                var7_11 = var8_14;
                throw var8_14;
            }
            finally {
                if (reader != null) {
                    if (var7_11 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var8_13) {
                            var7_11.addSuppressed(var8_13);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BuildException("exception reading uses from " + this.inputFile + (lineCount == 0 ? "" : ":" + lineCount) + ": " + e, (Throwable)e);
        }
        this.writeExportsFile(domains, elements.values());
        if (this.exportsFile != null) {
            this.log(String.format("created %s", new Object[]{this.exportsFile}));
        }
    }

    private String getPackage(String type, Set<String> reportedAdjustedTypes) {
        int dot = type.lastIndexOf(46);
        String packag = dot > 0 ? type.substring(0, dot) : "";
        dot = packag.lastIndexOf(46);
        if (dot > 0 && dot + 1 < packag.length() && Character.isUpperCase(packag.charAt(dot + 1))) {
            packag = packag.substring(0, dot);
            if (reportedAdjustedTypes.add(type)) {
                this.log(String.format("adjusting package for %s to %s", type, packag), 2);
            }
        }
        return packag;
    }

    private String erase(String signature) {
        int i = signature.indexOf(60);
        if (i < 0) {
            return signature;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(signature, 0, i);
        int depth = 1;
        ++i;
        while (i < signature.length()) {
            char c = signature.charAt(i);
            switch (c) {
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    if (--depth >= 0) break;
                    return signature;
                }
                default: {
                    if (depth != 0) break;
                    builder.append(c);
                }
            }
            ++i;
        }
        return depth == 0 ? builder.toString() : signature;
    }

    private void writeExportsFile(ExportDomains domains, Collection<Element> elements) {
        ArrayList<Element> sortedElements;
        Throwable throwable;
        BufferedWriter writer;
        if (this.exportsFile != null) {
            try {
                writer = Files.newBufferedWriter(this.exportsFile, new OpenOption[0]);
                throwable = null;
                try {
                    writer.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>");
                    writer.newLine();
                    writer.write("<lib-exports");
                    if (this.owner != null) {
                        writer.write(" owner=\"");
                        writer.write(this.owner);
                        writer.write(34);
                    }
                    if (this.source != null) {
                        writer.write(" source=\"");
                        writer.write(this.source);
                        writer.write(34);
                    }
                    writer.write(" xmlns=\"http://xmlns.oracle.com/ide/export\">");
                    writer.newLine();
                    if (!domains.controlsAll()) {
                        for (ExportDomains.Domain domain : domains) {
                            CreateExportsFromUsesTask.writeIndent(1, writer);
                            writer.write("<domain name=\"");
                            String name = domain.getName();
                            writer.write(name, 0, name.length() - 1);
                            List<String> exceptions = domain.getExceptions();
                            if (!exceptions.isEmpty()) {
                                writer.write("\">");
                                writer.newLine();
                                for (String exception : exceptions) {
                                    CreateExportsFromUsesTask.writeIndent(2, writer);
                                    writer.write("<except name=\"");
                                    writer.write(exception);
                                    writer.write("\"/>");
                                    writer.newLine();
                                }
                                CreateExportsFromUsesTask.writeIndent(1, writer);
                                writer.write("</domain>");
                            } else {
                                writer.write("\"/>");
                            }
                            writer.newLine();
                        }
                    }
                    sortedElements = new ArrayList<Element>(elements);
                    Collections.sort(sortedElements);
                    sortedElements.add(new Element("", "", "", "", elements.size() + 1));
                    ArrayDeque<Element> stack = new ArrayDeque<Element>();
                    for (Element element : sortedElements) {
                        Element lastElement;
                        if (element.isPackage() || element.isSentinel()) {
                            switch (stack.size()) {
                                case 2: {
                                    lastElement = (Element)stack.pop();
                                    assert (lastElement.isType());
                                    CreateExportsFromUsesTask.writeIndent(2, writer);
                                    writer.write("</");
                                    writer.write(lastElement.getLabel());
                                    writer.write(">");
                                    writer.newLine();
                                }
                                case 1: {
                                    lastElement = (Element)stack.pop();
                                    assert (lastElement.isPackage());
                                    CreateExportsFromUsesTask.writeIndent(1, writer);
                                    writer.write("</package>");
                                    writer.newLine();
                                }
                            }
                            if (!element.isPackage()) continue;
                            CreateExportsFromUsesTask.writeIndent(1, writer);
                            writer.write("<package name=\"");
                            writer.write(element.getPackage());
                            writer.write("\">");
                            writer.newLine();
                            stack.push(element);
                            continue;
                        }
                        if (element.isType()) {
                            switch (stack.size()) {
                                case 2: {
                                    lastElement = (Element)stack.pop();
                                    assert (lastElement.isType());
                                    assert (lastElement.getPackage().equals(element.getPackage()));
                                    CreateExportsFromUsesTask.writeIndent(2, writer);
                                    writer.write("</");
                                    writer.write(lastElement.getLabel());
                                    writer.write(">");
                                    writer.newLine();
                                }
                            }
                            assert (!element.getLabel().equals("type"));
                            CreateExportsFromUsesTask.writeIndent(2, writer);
                            writer.write(60);
                            writer.write(element.getLabel());
                            writer.write(" name=\"");
                            writer.write(element.getType());
                            writer.write(34);
                            if (element.isMembers()) {
                                stack.push(element);
                            } else {
                                writer.write(" members=\"concealed\"/");
                            }
                            writer.write(62);
                            writer.newLine();
                            continue;
                        }
                        if (element.isMember()) {
                            lastElement = (Element)stack.peek();
                            assert (element.getPackage().equals(lastElement.getPackage()));
                            assert (element.getType().equals(lastElement.getType()));
                            assert (!lastElement.isPackage());
                            assert (!element.getLabel().equals("type"));
                            CreateExportsFromUsesTask.writeIndent(3, writer);
                            writer.write("<");
                            writer.write(element.getLabel());
                            writer.write(" name=\"");
                            writer.write(element.getMember());
                            writer.write("\"/>");
                            writer.newLine();
                            continue;
                        }
                        throw new IllegalStateException("unexpected element " + element);
                    }
                    writer.write("</lib-exports>");
                    writer.newLine();
                }
                catch (Throwable sortedElements2) {
                    throwable = sortedElements2;
                    throw sortedElements2;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable sortedElements2) {
                                throwable.addSuppressed(sortedElements2);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException("exception creating export file " + this.exportsFile + ": " + e, (Throwable)e);
            }
        }
        if (this.listFile != null) {
            try {
                writer = Files.newBufferedWriter(this.listFile, new OpenOption[0]);
                throwable = null;
                try {
                    sortedElements = new ArrayList<Element>(elements);
                    Collections.sort(sortedElements);
                    Element lastElement = new Element("", "", "", "", elements.size() + 1);
                    for (Element element : sortedElements) {
                        if (element.isType()) {
                            assert (element.getPackage().equals(lastElement.getPackage()));
                            assert (!element.getLabel().equals("type"));
                            writer.write(element.getPackage());
                            if (!element.getPackage().isEmpty()) {
                                writer.write(46);
                            }
                            writer.write(element.getType());
                            writer.newLine();
                        } else if (element.isMember()) {
                            assert (element.getPackage().equals(lastElement.getPackage()));
                            assert (element.getType().equals(lastElement.getType()));
                            assert (!lastElement.isPackage());
                            assert (!element.getLabel().equals("type"));
                            writer.write(element.getPackage());
                            if (!element.getPackage().isEmpty()) {
                                writer.write(46);
                            }
                            writer.write(element.getType());
                            String member = element.getMember();
                            if ("constructor".equals(element.getLabel())) {
                                int paren = member.indexOf(40);
                                if (paren > 0) {
                                    member = member.substring(paren);
                                }
                            } else {
                                writer.write(46);
                            }
                            writer.write(member);
                            writer.newLine();
                        }
                        lastElement = element;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException("exception creating list file " + this.listFile + ": " + e, (Throwable)e);
            }
        }
    }

    private static void writeIndent(int depth, BufferedWriter writer) throws IOException {
        for (int i = 0; i < depth; ++i) {
            writer.write("  ");
        }
    }

    private static <E extends Comparable> Collection<E> sorted(Collection<E> collection) {
        ArrayList<E> list = new ArrayList<E>(collection);
        Collections.sort(list);
        return list;
    }

    private static class Type
    implements Comparable<Type> {
        private String name;
        private Boolean isInterface;

        Type(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setInterface(boolean isInterface) {
            this.isInterface = isInterface;
        }

        String getKind() {
            return this.isInterface == Boolean.TRUE ? "interface" : "class";
        }

        @Override
        public int compareTo(Type that) {
            return this.name.compareTo(that.name);
        }
    }

    private static class Package
    implements Comparable<Package> {
        private String name;
        private Map<String, Type> types = new LinkedHashMap<String, Type>();

        Package(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        Collection<Type> getTypes() {
            return this.types.values();
        }

        Type addType(String name) {
            Type type = this.types.get(name);
            if (type == null) {
                type = new Type(name);
                this.types.put(name, type);
            }
            return type;
        }

        @Override
        public int compareTo(Package that) {
            return this.name.compareTo(that.name);
        }
    }

    private static class Model {
        private Map<String, Package> packages = new LinkedHashMap<String, Package>();

        private Model() {
        }

        Collection<Package> getPackages() {
            return this.packages.values();
        }

        Package addPackage(String name) {
            Package packag = this.packages.get(name);
            if (packag == null) {
                packag = new Package(name);
                this.packages.put(name, packag);
            }
            return packag;
        }
    }

    private class Element
    implements Comparable<Element> {
        private String label;
        private final String labelComparison;
        private final String packag;
        private final String type;
        private final String member;
        private final int line;
        private boolean members;

        private Element(String label, String packag, String type, String member, int line) {
            this.label = label;
            this.labelComparison = "class".equals(label) || "interface".equals(label) ? "type" : label;
            this.packag = packag;
            this.type = type;
            this.member = member;
            this.line = line;
        }

        public String getPackage() {
            return this.packag;
        }

        public String getType() {
            return this.type;
        }

        public String getMember() {
            return this.member;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isSentinel() {
            return this.packag.isEmpty();
        }

        public boolean isPackage() {
            return !this.packag.isEmpty() && this.type.isEmpty();
        }

        public boolean isType() {
            return !this.type.isEmpty() && this.member.isEmpty();
        }

        public boolean isMember() {
            return !this.member.isEmpty();
        }

        public boolean isMembers() {
            return this.members;
        }

        public void setMembers(boolean members) {
            this.members = members;
        }

        public void setLabel(String label) {
            assert (this.labelComparison.equals("type"));
            assert (label.equals("class") || label.equals("interface"));
            this.label = label;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Element)) {
                return false;
            }
            Element that = (Element)other;
            return this.labelComparison.equals(that.labelComparison) && this.packag.equals(that.packag) && this.type.equals(that.type) && this.member.equals(that.member);
        }

        public int hashCode() {
            int result = this.labelComparison.hashCode();
            result = 31 * result + this.packag.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.member.hashCode();
            return result;
        }

        @Override
        public int compareTo(Element that) {
            int comparison = this.packag.compareTo(that.packag);
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.type.compareTo(that.type);
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.member.compareTo(that.member);
            if (comparison != 0) {
                return comparison;
            }
            return this.ordinal(this.member) - this.ordinal(that.member);
        }

        private int ordinal(String label) {
            if (label.isEmpty()) {
                return 0;
            }
            switch (label.charAt(0)) {
                case 'p': {
                    return 1;
                }
                case 't': {
                    return 2;
                }
            }
            return 3;
        }

        public String toString() {
            return (this.isSentinel() ? "<sentinel>" : this.label + " " + (this.isPackage() ? this.packag : (this.isType() ? this.type : this.type + "#" + this.member))) + ":" + this.line;
        }
    }

    private static enum Format {
        TABLE,
        MESSAGE;

    }
}

