/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import oracle.javatools.exports.command.ClassesSource;
import oracle.javatools.exports.command.Command;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandInterface;
import oracle.javatools.util.CommandModel;
import oracle.javatools.util.CommandParser;

public class Exports
implements CommandInterface {
    private CommandInterface.Operation operation;
    private Path middlewareHome;
    private boolean validating = true;
    private String owner;
    private List<String> consumers = new ArrayList<String>();
    private Path domainFile;
    private final List<Path> classPath = new ArrayList<Path>();
    private final List<ClassesSource> libraries = new ArrayList<ClassesSource>();
    private boolean failOnClassPathError = true;
    private final List<Path> baselines = new ArrayList<Path>();
    private final List<ClassesSource> dependencies = new ArrayList<ClassesSource>();
    private final List<Path> bootClassPath = new ArrayList<Path>();
    private String libraryName;
    private String libraryId;
    private String libraryDescription;
    private Path outputDirectory;
    private Path addedFile;
    private Path baselineFile;
    private Path commentsFile;
    private Path concealedFile;
    private Path exportedFile;
    private Path exportsFile;
    private Path issuesFile;
    private Path librariesFile;
    private Path libraryFile;
    private Path problemsFile;
    private Path removedFile;
    private Path unusedExportedFile;
    private Path usedCommentedFile;
    private Path usedConcealedFile;
    private Path usedUncommentedFile;

    @Override
    public CommandInterface.Operation getOperation() {
        return this.operation;
    }

    @Override
    public Path getMiddlewareHome() {
        return this.middlewareHome;
    }

    @Override
    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public List<String> getConsumers() {
        return this.consumers;
    }

    @Override
    public Path getDomainFile() {
        return this.domainFile;
    }

    @Override
    public List<Path> getClassPath() {
        return this.classPath;
    }

    @Override
    public boolean isFailOnClassPathError() {
        return this.failOnClassPathError;
    }

    @Override
    public List<ClassesSource> getLibraries() {
        return this.libraries;
    }

    @Override
    public Path getBaseline0() {
        return this.baselines.size() > 0 ? this.baselines.get(0) : null;
    }

    @Override
    public Path getBaseline1() {
        return this.baselines.size() > 1 ? this.baselines.get(1) : null;
    }

    @Override
    public List<ClassesSource> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Path> getBootClassPath() {
        return this.bootClassPath;
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public String getLibraryId() {
        return this.libraryId;
    }

    @Override
    public String getLibraryDescription() {
        return this.libraryDescription;
    }

    @Override
    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public Path getAddedFile() {
        return this.addedFile;
    }

    @Override
    public Path getBaselineFile() {
        return this.baselineFile;
    }

    @Override
    public Path getCommentsFile() {
        return this.commentsFile;
    }

    @Override
    public Path getConcealedFile() {
        return this.concealedFile;
    }

    @Override
    public Path getExportedFile() {
        return this.exportedFile;
    }

    @Override
    public Path getExportsFile() {
        return this.exportsFile;
    }

    @Override
    public Path getIssuesFile() {
        return this.issuesFile;
    }

    @Override
    public Path getLibrariesFile() {
        return this.librariesFile;
    }

    @Override
    public Path getLibraryFile() {
        return this.libraryFile;
    }

    @Override
    public Path getProblemsFile() {
        return this.problemsFile;
    }

    @Override
    public Path getRemovedFile() {
        return this.removedFile;
    }

    @Override
    public Path getUnusedExportedFile() {
        return this.unusedExportedFile;
    }

    @Override
    public Path getUsedCommentedFile() {
        return this.usedCommentedFile;
    }

    @Override
    public Path getUsedConcealedFile() {
        return this.usedConcealedFile;
    }

    @Override
    public Path getUsedUncommentedFile() {
        return this.usedUncommentedFile;
    }

    @Override
    public void error(String message, Object ... arguments) {
        message = message.startsWith("error:") ? message : "error:   " + message;
        System.err.println(String.format(message, arguments));
    }

    public void fatal(String message, Object ... arguments) {
        message = message.startsWith("error:") ? message : "error:   " + message;
        System.err.println(String.format(message, arguments));
        System.exit(1);
    }

    @Override
    public void warning(String message, Object ... arguments) {
        message = message.startsWith("warning:") ? message : "warning: " + message;
        System.err.println(String.format(message, arguments));
    }

    @Override
    public void note(String message, Object ... arguments) {
        message = message.startsWith("note:") ? message : "note:    " + message;
        System.out.println(String.format(message, arguments));
    }

    @Override
    public void coarse(String message, Object ... arguments) {
        message = message.startsWith("note:") ? message : "note:    " + message;
        System.out.println(String.format(message, arguments));
    }

    @Override
    public void fine(String message, Object ... arguments) {
        message = message.startsWith("note:") ? message : "note:    " + message;
        System.out.println(String.format(message, arguments));
    }

    @Override
    public String parameter(String name) {
        return name + " parameter";
    }

    @Override
    public String option(String name) {
        return "-" + name + " option";
    }

    @Override
    public String output(CommandInterface.Output output) {
        return "-output " + output.getTypeName() + ", or -" + output.getTypeName() + "file";
    }

    @Override
    public String libraryOrExtension(String libraryId, String extensionId) {
        return "[library:" + libraryId + "] or [extension:" + extensionId + "]";
    }

    public static void main(String[] arguments) {
        new Exports().execute(arguments);
    }

    private void execute(String[] arguments) {
        int argumentCount = arguments.length;
        if (argumentCount < 2) {
            Exports.printUsage();
            System.exit(1);
        }
        CommandParser parser = new CommandParser();
        parser.setArgumentFilesEnabled(true);
        parser.setCommaListsEnabled(true);
        switch (arguments[0]) {
            case "generate": {
                this.operation = CommandInterface.Operation.GENERATE;
                parser.defineParameter("classpath", Path[].class);
                parser.defineRequirement(new String[]{"classpath"});
                parser.defineOption("failonclasspatherror");
                break;
            }
            case "analyze": 
            case "analyse": {
                this.operation = CommandInterface.Operation.ANALYZE;
                parser.defineParameter("libraries", String[].class);
                parser.defineRequirement(new String[]{"libraries"});
                break;
            }
            case "merge": {
                this.operation = CommandInterface.Operation.MERGE;
                parser.defineParameter("libraries", String[].class);
                parser.defineRequirement(new String[]{"libraries"});
                break;
            }
            case "capture": {
                this.operation = CommandInterface.Operation.CAPTURE;
                parser.defineParameter("libraries", String[].class);
                parser.defineRequirement(new String[]{"libraries"});
                break;
            }
            case "compare": {
                this.operation = CommandInterface.Operation.COMPARE;
                parser.defineParameter("baselines", Path[].class);
                parser.defineRequirement(new String[]{"baselines"});
                break;
            }
            default: {
                this.fatal("Unexpected command \"%s\", expected one of generate, analyze, merge, capture, or compare", arguments[0]);
            }
        }
        parser.defineOption("bootclasspath", Path[].class);
        parser.defineOption("output", CommandInterface.Output[].class);
        parser.defineOption("nooutput", CommandInterface.Output[].class);
        parser.defineOption("directory", Path.class);
        parser.defineSynonym("directory", "outputdir");
        parser.defineSynonym("directory", "d");
        parser.defineOption("libraryname", String.class);
        parser.defineOption("libraryid", String.class);
        parser.defineOption("librarydescription", String.class);
        for (CommandInterface.Output output : (CommandInterface.Output[])CommandInterface.Output.class.getEnumConstants()) {
            parser.defineOption(output.getTypeName() + "file", Path.class);
        }
        parser.defineOption("help");
        parser.defineOption("consumers", String[].class);
        parser.defineOption("dependencies", String[].class);
        parser.defineOption("domainfile", Path.class);
        parser.defineOption("middlewarehome", Path.class);
        parser.defineSynonym("middlewarehome", "mwh");
        parser.defineOption("owner", String.class);
        parser.defineOption("validate");
        parser.defineOption("novalidate");
        parser.defineSuperseding(new String[]{"validate", "novalidate"});
        parser.defineOption("trace");
        parser.defineOption("uses");
        CommandModel model = null;
        try {
            Path maybePath;
            Path path;
            String id;
            ClassesSource.Type type;
            String[] stringArray = arguments;
            arguments = new String[argumentCount - 1];
            System.arraycopy(stringArray, 1, arguments, 0, argumentCount - 1);
            model = parser.parse(arguments);
            if (model.isPresent("help")) {
                Exports.printUsage();
                System.exit(0);
            }
            this.validating = !model.isPresent("novalidate");
            this.middlewareHome = (Path)model.getValue("middlewarehome");
            EnumSet<CommandInterface.Output> defaultOutput = this.operation.getDefaults();
            if (model.isPresent("uses")) {
                if (this.operation.getAllowed().contains((Object)CommandInterface.Output.USED_CONCEALED)) {
                    defaultOutput.addAll(EnumSet.of(CommandInterface.Output.UNUSED_EXPORTED, CommandInterface.Output.USED_CONCEALED, CommandInterface.Output.USED_COMMENTED, CommandInterface.Output.USED_UNCOMMENTED));
                } else {
                    this.fatal(this.operation.toString().toLowerCase() + " operation prohibits the -uses option", new Object[0]);
                }
            }
            this.consumers.addAll(Arrays.asList((Object[])model.getValue("consumers", (Object)new String[0])));
            switch (this.operation) {
                case GENERATE: {
                    Path path2;
                    int n;
                    Path[] pathArray = (Path[])model.getValue("classpath");
                    int output = pathArray.length;
                    for (n = 0; n < output; ++n) {
                        path2 = pathArray[n];
                        this.classPath.add(path2);
                    }
                    this.failOnClassPathError = model.isPresent("failonclasspatherror");
                    break;
                }
                case MERGE: 
                case ANALYZE: 
                case CAPTURE: {
                    int n;
                    String[] stringArray2 = (String[])model.getValue("libraries", (Object)new String[0]);
                    int output = stringArray2.length;
                    for (n = 0; n < output; ++n) {
                        String parameter = stringArray2[n];
                        if (parameter.equals("installation") || parameter.equals("[installation]")) {
                            if (this.middlewareHome == null) {
                                this.fatal("-middlewarehome required for [%s]", parameter);
                            }
                            type = ClassesSource.Type.INSTALLATION;
                            id = null;
                            path = null;
                        } else {
                            if (parameter.charAt(0) == '[' && parameter.charAt(parameter.length() - 1) == ']') {
                                if (this.middlewareHome == null) {
                                    this.fatal("-middlewarehome required for id references like [%s]", parameter);
                                }
                                if ((parameter = parameter.substring(1, parameter.length() - 1)).startsWith("library:")) {
                                    type = ClassesSource.Type.LIBRARY;
                                    parameter = parameter.substring("library:".length());
                                } else if (parameter.startsWith("extension:")) {
                                    type = ClassesSource.Type.EXTENSION;
                                    parameter = parameter.substring("extension:".length());
                                } else {
                                    type = ClassesSource.Type.UNKNOWN;
                                }
                            } else {
                                type = ClassesSource.Type.UNKNOWN;
                            }
                            maybePath = null;
                            try {
                                maybePath = (Path)parser.getConverter(Path.class).convert(parameter, Path.class);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (maybePath != null && Files.exists(maybePath, new LinkOption[0])) {
                                id = null;
                                path = maybePath;
                            } else {
                                if (this.middlewareHome == null) {
                                    this.fatal("-middlewarehome required for id references like [%s]", parameter);
                                }
                                id = parameter;
                                path = null;
                            }
                        }
                        this.libraries.add(new ClassesSource(path, id, type));
                    }
                    break;
                }
                case COMPARE: {
                    Path path2;
                    int n;
                    Path[] pathArray = (Path[])model.getValue("baselines", (Object)new Path[0]);
                    int output = pathArray.length;
                    for (n = 0; n < output; ++n) {
                        path2 = pathArray[n];
                        this.baselines.add(path2);
                    }
                    if (this.baselines.size() == 2) break;
                    this.fatal("compare operation requires exactly 2 baseline files to compare", new Object[0]);
                }
            }
            for (String parameter : (String[])model.getValue("dependencies", (Object)new String[0])) {
                if (parameter.equals("installation") || parameter.equals("[installation]")) {
                    if (this.middlewareHome == null) {
                        this.fatal("-middlewarehome required for [%s]", parameter);
                    }
                    type = ClassesSource.Type.INSTALLATION;
                    id = null;
                    path = null;
                } else {
                    if (parameter.charAt(0) == '[' && parameter.charAt(parameter.length() - 1) == ']') {
                        if (this.middlewareHome == null) {
                            this.fatal("-middlewarehome required for id references like [%s]", parameter);
                        }
                        if ((parameter = parameter.substring(1, parameter.length() - 1)).startsWith("library:")) {
                            type = ClassesSource.Type.LIBRARY;
                            parameter = parameter.substring("library:".length());
                        } else if (parameter.startsWith("extension:")) {
                            type = ClassesSource.Type.EXTENSION;
                            parameter = parameter.substring("extension:".length());
                        } else {
                            type = ClassesSource.Type.UNKNOWN;
                        }
                    } else {
                        type = ClassesSource.Type.UNKNOWN;
                    }
                    maybePath = null;
                    try {
                        maybePath = (Path)parser.getConverter(Path.class).convert(parameter, Path.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (maybePath != null && Files.exists(maybePath, new LinkOption[0])) {
                        id = null;
                        path = maybePath;
                    } else {
                        if (this.middlewareHome == null) {
                            this.fatal("-middlewarehome required for id references like [%s]", parameter);
                        }
                        id = parameter;
                        path = null;
                    }
                }
                this.dependencies.add(new ClassesSource(path, id, type));
            }
            this.libraryName = (String)model.getValue("libraryname");
            this.libraryId = (String)model.getValue("libraryid");
            this.libraryDescription = (String)model.getValue("librarydescription");
            EnumSet<CommandInterface.Output> output = model.isPresent("output") ? EnumSet.copyOf(Arrays.asList((CommandInterface.Output[])model.getValue("output"))) : null;
            EnumSet<CommandInterface.Output> noOutput = model.isPresent("nooutput") ? EnumSet.copyOf(Arrays.asList((CommandInterface.Output[])model.getValue("nooutput"))) : null;
            for (CommandInterface.Output type2 : (CommandInterface.Output[])CommandInterface.Output.class.getEnumConstants()) {
                try {
                    Field field = this.getClass().getDeclaredField(type2.getPropertyName());
                    field.setAccessible(true);
                    String optionName = type2.getTypeName().toLowerCase() + "file";
                    Object value = model.getValue(optionName);
                    if (value != null && noOutput != null && noOutput.contains((Object)type2)) {
                        this.fatal("Option -nooutput" + type2.getTypeName() + " conflicts with -" + optionName + " option", new Object[0]);
                    }
                    if (value != null || !(output != null ? output.contains((Object)type2) : defaultOutput.contains((Object)type2)) || noOutput != null && noOutput.contains((Object)type2)) continue;
                    this.outputDirectory = (Path)model.getValue("directory");
                    if (this.outputDirectory == null) {
                        this.fatal("-directory option required to create default path for " + type2.getFileName(), new Object[0]);
                    }
                    field.set(this, this.outputDirectory.resolve(type2.getFileName()));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    this.fatal("Field " + type2.getPropertyName() + " for output type \"" + type2.getTypeName() + "\" not introspected: " + e, e);
                }
            }
            int exitCode = Command.execute(this);
            System.exit(exitCode);
        }
        catch (oracle.javatools.util.CommandException e) {
            this.fatal(e.getMessage(), new Object[0]);
        }
        catch (CommandException e) {
            if (model.isPresent("trace")) {
                e.printStackTrace();
            }
            this.fatal(e.getMessage(), new Object[0]);
        }
    }

    private static void printUsage() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Exports.class.getResourceAsStream("usage.txt")));){
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

