/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.aurora.compiler.ClassFinder;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.FinderFactory;
import oracle.aurora.compiler.MemoizedFinder;

public class MemoizedFinderFactory
implements FinderFactory {
    FinderFactory farFactory;
    Hashtable finderCache = new Hashtable(51);
    Hashtable memoizedCache = new Hashtable(51);
    ClassFinder nullFinder;

    public MemoizedFinderFactory(FinderFactory farFactory) {
        this.farFactory = farFactory;
    }

    public ClassFinder finder(ExternalEntity source) {
        ClassFinder f;
        if (source == null) {
            if (this.nullFinder == null) {
                this.nullFinder = this.farFactory.finder(null);
            }
            f = this.nullFinder;
        } else {
            f = (ClassFinder)this.finderCache.get(source);
            if (f == null) {
                f = this.farFactory.finder(source);
                this.finderCache.put(source, f);
            }
        }
        MemoizedFinder m = (MemoizedFinder)this.memoizedCache.get(f);
        if (m == null) {
            m = new MemoizedFinder(f);
            this.memoizedCache.put(f, m);
        }
        return m;
    }

    public void close() {
        Enumeration finders = this.finderCache.elements();
        while (finders.hasMoreElements()) {
            ClassFinder f = (ClassFinder)finders.nextElement();
            f.close();
        }
        this.farFactory.close();
    }
}

