/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public final class VCSHashURL {
    private final URL _url;
    private final String _externalForm;

    public VCSHashURL(URL url) {
        this._url = url;
        this._externalForm = url.toExternalForm();
    }

    public final URL getURL() {
        return this._url;
    }

    public final String getExternalForm() {
        return this._externalForm;
    }

    public final boolean equals(Object o) {
        return o instanceof VCSHashURL && this._externalForm.equals(((VCSHashURL)o)._externalForm);
    }

    public final int hashCode() {
        return this._externalForm.hashCode();
    }

    public final String toString() {
        return this._externalForm;
    }

    public static final Collection<URL> convertToURLs(Collection<VCSHashURL> urls) {
        ArrayList<URL> urls2 = new ArrayList<URL>(urls.size());
        for (VCSHashURL url : urls) {
            urls2.add(url.getURL());
        }
        return urls2;
    }

    public static final Collection<VCSHashURL> convertFromURLs(Collection<URL> urls) {
        ArrayList<VCSHashURL> urls2 = new ArrayList<VCSHashURL>(urls.size());
        for (URL url : urls) {
            urls2.add(new VCSHashURL(url));
        }
        return urls2;
    }
}

