/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.tracking;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.jdeveloper.vcs.tracking.VCSBugTracking;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingHook;

class VCSBugTrackingRegistry {
    private static final VCSBugTrackingRegistry _instance = new VCSBugTrackingRegistry();
    private final Map<String, VCSBugTracking> _registry = Collections.synchronizedMap(new HashMap());

    VCSBugTrackingRegistry() {
    }

    static final synchronized VCSBugTrackingRegistry getInstance() {
        return _instance;
    }

    VCSBugTracking lookup(String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this._registry.containsKey(type)) {
            return this._registry.get(type);
        }
        VCSBugTrackingHook hook = (VCSBugTrackingHook)ExtensionRegistry.getExtensionRegistry().getHook(VCSBugTrackingHook.HOOK);
        VCSBugTracking bugtrack = hook.getObject(type);
        if (bugtrack != null) {
            this._registry.put(type, bugtrack);
        }
        return bugtrack;
    }
}

