/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.vcs.util.DialogCallback;

public class DialogCloseListener
implements VetoableChangeListener {
    private final JEWTDialog m_dialog;
    private final DialogCallback m_callback;

    public DialogCloseListener(JEWTDialog dialog, DialogCallback callback) {
        this.m_dialog = dialog;
        this.m_callback = callback;
    }

    @Override
    public final void vetoableChange(PropertyChangeEvent vce) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)vce) && this.m_callback != null) {
            try {
                this.m_callback.run(this.m_dialog);
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Window)this.m_dialog, (Exception)re);
                throw new PropertyVetoException("", vce);
            }
            catch (KeepOpenException koe) {
                throw new PropertyVetoException("", vce);
            }
            catch (Exception e) {
                this.handleException((Component)this.m_dialog, e);
                throw new PropertyVetoException("", vce);
            }
        }
    }

    protected void handleException(Component parent, Exception e) {
        MessageDialog.error((Component)parent, (Object)e.getMessage(), (String)"", null);
    }

    static class KeepOpenException
    extends Exception {
        KeepOpenException() {
        }
    }
}

