/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.MetricDefinition;
import oracle.jdeveloper.audit.extension.ParameterDefinition;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.extension.TransformBinding;
import oracle.jdeveloper.audit.extension.TransformDefinition;
import oracle.jdeveloper.audit.extension.Value;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.report.XmlReportType;
import oracle.jdevimpl.audit.report.XmlReporter;

public class ProfileXmlReporter
extends XmlReporter<Profile> {
    private List<BeanDefinition> beans;
    private static final String DOCUMENT_ROOT = "profile-report";
    private static final String SCHEMA_URI = "http://xmlns.oracle.com/jdeveloper/1013/audit";
    private static final Comparator<BeanDefinition> ID_COMPARATOR = new Comparator<BeanDefinition>(){

        @Override
        public int compare(BeanDefinition left, BeanDefinition right) {
            return left.getId().compareTo(right.getId());
        }
    };

    @Override
    public XmlReportType getType() {
        return XmlReportType.PROFILE;
    }

    @Override
    protected void writeModel(Profile profile) {
        this.beans = new ArrayList<BeanDefinition>(profile.getDefinitions());
        Collections.sort(this.beans, ID_COMPARATOR);
        this.writeBeginTag(DOCUMENT_ROOT, new String[]{"xmlns", SCHEMA_URI}, false, true);
        this.writeTextElement("title", this.getTitle());
        this.writeProfile(profile);
        this.writeRules(profile, true, "rules", "rule");
        this.writeRules(profile, false, "assists", "assist");
        this.writeMetrics(profile);
        this.writeEndTag(DOCUMENT_ROOT);
    }

    private void writeProfile(Profile profile) {
        this.writeBeginTag("profile");
        this.writeTextElement("name", profile.getName());
        this.writeTextElement("key", profile.getId());
        this.writeTextElement("url", profile.getURL());
        this.writeEndTag("profile");
    }

    public void writeRules(Profile profile, boolean assists, String tags, String tag) {
        this.writeBeginTag(tags);
        for (BeanDefinition bean : this.beans) {
            RuleDefinition rule;
            if (!(bean instanceof RuleDefinition) || (rule = (RuleDefinition)bean).isAssist() != assists || !profile.isEnabled(rule.getId())) continue;
            this.writeBeginTag(tag, new String[]{"id", rule.getId(), "enabled", "true"}, false, true);
            this.writeBaseExtensionBean(rule);
            this.writeEndTag(tag);
        }
        this.writeEndTag(tags);
    }

    public void writeBaseExtensionBean(RuleDefinition rule) {
        this.writeExtensionBean(rule);
        this.writeTextElement("severity", rule.getSeverity());
        this.writeTextElement("style", this.value(rule.getValues(), "style", rule.getSeverity().toString()));
        Collection<TransformBinding> bindings = rule.getTransformBindings();
        if (bindings != null) {
            for (TransformBinding binding : bindings) {
                if (!binding.isDefault()) continue;
                this.writeBeginTag("defaultTransform");
                this.writeTransform(binding);
                this.writeEndTag("defaultTransform");
            }
        }
        this.writeParameters(rule.getParameters());
        this.writeCategory(rule.getCategory());
        this.writeTransforms(rule.getTransformBindings());
    }

    public void writeParameters(Collection<ParameterDefinition> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        this.writeBeginTag("rule-params");
        for (ParameterDefinition parameter : parameters) {
            this.writeBeginTag("rule-param");
            this.writeTextElement("param-name", parameter.getName());
            this.writeTextElement("param-type", parameter.getParameterType().getTypeName());
            this.writeTextElement("param-required", parameter.isRequired());
            this.writeEndTag("rule-param");
        }
        this.writeEndTag("rule-params");
    }

    public void writeCategory(CategoryDefinition c) {
        this.writeTextElement("category", c.label());
    }

    public void writeTransforms(Collection<TransformBinding> transforms) {
        if (transforms == null || transforms.isEmpty()) {
            return;
        }
        this.writeBeginTag("transforms");
        for (TransformBinding transform : transforms) {
            this.writeTransform(transform);
        }
        this.writeEndTag("transforms");
    }

    public void writeExtensionBean(BeanDefinition bean) {
        this.writeTextElement("name", bean.label());
        this.writeTextElement("description", bean.description());
    }

    public void writeMetric(MetricDefinition metric) {
        this.writeBeginTag("metric");
        this.writeExtensionBean(metric);
        this.writeTextElement("threshhold", this.value(metric.getValues(), "threshold", null));
        this.writeTextElement("type", metric.getValueType());
        this.writeCategory(metric.getCategory());
        this.writeEndTag("metric");
    }

    private String value(Collection<Value> values, String name, String defaultValue) {
        if (values != null) {
            for (Value value : values) {
                if (!name.equals(value.getName())) continue;
                return value.getText();
            }
        }
        return defaultValue;
    }

    private void writeMetrics(Profile profile) {
        this.writeBeginTag("metrics");
        for (BeanDefinition bean : this.beans) {
            MetricDefinition metric;
            if (!(bean instanceof MetricDefinition) || !profile.isEnabled((metric = (MetricDefinition)bean).getId())) continue;
            this.writeMetric(metric);
        }
        this.writeEndTag("metrics");
    }

    private void writeTransform(TransformBinding binding) {
        TransformDefinition t = binding.getTransform();
        this.writeBeginTag("transform", new String[]{"id", t.getId(), "enabled", String.valueOf(true)}, false, true);
        this.writeTextElement("name", t.label());
        this.writeTextElement("description", t.description());
        if (binding.getCondition() != null) {
            this.writeTextElement("condition", binding.getCondition().getText());
        }
        this.writeEndTag("transform");
    }
}

