/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import oracle.dss.dataView.datacache.Layer;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.util.DataAccess;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;

public class PageLayer
extends Layer {
    private Member m_member;

    public PageLayer() {
        this.putMember(new Member());
    }

    public PageLayer(ContainerNode layerNode, Map metadataMap, Map layerMap) {
        super((BaseObjectNode)layerNode, layerMap);
        Enumeration members = layerNode.getContainedObject("Member");
        if (members.hasMoreElements()) {
            ObjectNode memberNode = (ObjectNode)members.nextElement();
            this.putMember(new Member(memberNode, metadataMap));
        } else {
            this.putMember(new Member());
        }
    }

    public PageLayer(DataAccess da, int edge, int layer, int slice, Map metadataMap, Map layerMap) {
        super(da, edge, layer, layerMap);
        this.putMember(new Member(da, edge, layer, slice, metadataMap));
    }

    public ContainerNode addLayerToXML(Map metadataMap, Map layerMap) {
        ContainerNode layerNode = super.addLayerToXML(layerMap);
        ObjectNode memberNode = this.getMember().addMemberToXML(metadataMap);
        layerNode.addContainedObject((BaseNode)memberNode);
        return layerNode;
    }

    public Member getMember() {
        return this.m_member;
    }

    public void putMember(Member member) {
        this.m_member = member;
    }
}

