/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.util.ArrayList;
import java.util.Vector;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.share.collection.Range;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.gridView.GridView;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.RowComponentInfo;

public class GridViewUtils
extends DataviewUtils {
    public static String leftTrim(String s) {
        int st;
        int len = s.length();
        char[] val = s.toCharArray();
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        return st > 0 ? s.substring(st, len) : s;
    }

    protected static boolean oneCellOnly(CellRange[] range) {
        if (range == null) {
            return true;
        }
        if (range.length > 1) {
            return false;
        }
        return range[0].getLowerLimit().equals((Object)range[0].getUpperLimit());
    }

    protected static DataComponentInfo[] convertRangesToCells(CellRange[] range) {
        int r;
        Vector<DataComponentInfo> tempdci = new Vector<DataComponentInfo>();
        for (r = 0; r < range.length; ++r) {
            Cell ll = range[r].getLowerLimit();
            Cell ul = range[r].getUpperLimit();
            for (int row = ll.row; row <= ul.row; ++row) {
                for (int col = ll.column; col <= ul.column; ++col) {
                    tempdci.addElement(new DataComponentInfo(row, col));
                }
            }
        }
        DataComponentInfo[] dci = new DataComponentInfo[tempdci.size()];
        for (r = 0; r < dci.length; ++r) {
            dci[r] = (DataComponentInfo)tempdci.elementAt(r);
        }
        return dci;
    }

    protected static CellRange[] convertCellsToRanges(DataComponentInfo[] cells) {
        boolean bIncluded;
        CellRange range2;
        ArrayList<CellRange> singleCols = new ArrayList<CellRange>();
        ArrayList<CellRange> singleRows = new ArrayList<CellRange>();
        int minCol = -1;
        int maxCol = -1;
        int minRow = -1;
        int maxRow = -1;
        for (int cell = 0; cell < cells.length; ++cell) {
            int newCol = cells[cell].getColumn();
            int newRow = cells[cell].getRow();
            if (minCol < 0) {
                minCol = newCol;
                maxCol = newCol;
                minRow = newRow;
                maxRow = newRow;
                continue;
            }
            if (minCol == maxCol && newCol == maxCol && (newRow == minRow - 1 || newRow == maxRow + 1)) {
                if (newRow == minRow - 1) {
                    minRow = newRow;
                    continue;
                }
                if (newRow != maxRow + 1) continue;
                maxRow = newRow;
                continue;
            }
            if (minRow == maxRow && newRow == maxRow && (newCol == minCol - 1 || newCol == maxCol + 1)) {
                if (newCol == minCol - 1) {
                    minCol = newCol;
                    continue;
                }
                if (newCol != maxCol + 1) continue;
                maxCol = newCol;
                continue;
            }
            CellRange range = new CellRange(minCol, minRow, maxCol, maxRow);
            if (minCol == maxCol) {
                singleCols.add(range);
            } else {
                singleRows.add(range);
            }
            minCol = newCol;
            maxCol = newCol;
            minRow = newRow;
            maxRow = newRow;
        }
        CellRange lastCellRange = new CellRange(minCol, minRow, maxCol, maxRow);
        if (minCol == maxCol) {
            singleCols.add(lastCellRange);
        } else {
            singleRows.add(lastCellRange);
        }
        ArrayList<CellRange> cellRanges = new ArrayList<CellRange>();
        if (singleCols.size() > 1) {
            CellRange range = (CellRange)singleCols.get(0);
            for (int c = 1; c < singleCols.size(); ++c) {
                range2 = (CellRange)singleCols.get(c);
                bIncluded = false;
                if (range2.getLowerLimit().column == range.getLowerLimit().column - 1) {
                    if (range2.getLowerLimit().row == range.getLowerLimit().row && range2.getUpperLimit().row == range.getUpperLimit().row) {
                        range = new CellRange(range.getLowerLimit().column - 1, range.getLowerLimit().row, range.getUpperLimit().column, range.getUpperLimit().row);
                        bIncluded = true;
                    }
                } else if (range2.getUpperLimit().column == range.getUpperLimit().column + 1 && range2.getLowerLimit().row == range.getLowerLimit().row && range2.getUpperLimit().row == range.getUpperLimit().row) {
                    range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row, range.getUpperLimit().column + 1, range.getUpperLimit().row);
                    bIncluded = true;
                }
                if (bIncluded) continue;
                cellRanges.add(range);
                range = range2;
            }
            cellRanges.add(range);
        } else if (singleCols.size() == 1) {
            cellRanges.add((CellRange)singleCols.get(0));
        }
        if (singleRows.size() > 1) {
            CellRange range = (CellRange)singleRows.get(0);
            for (int r = 1; r < singleRows.size(); ++r) {
                range2 = (CellRange)singleRows.get(r);
                bIncluded = false;
                if (range2.getLowerLimit().row == range.getLowerLimit().row - 1) {
                    if (range2.getLowerLimit().column == range.getLowerLimit().column && range2.getUpperLimit().column == range.getUpperLimit().column) {
                        range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row - 1, range.getUpperLimit().column, range.getUpperLimit().row);
                        bIncluded = true;
                    }
                } else if (range2.getUpperLimit().row == range.getUpperLimit().row + 1 && range2.getLowerLimit().column == range.getLowerLimit().column && range2.getUpperLimit().column == range.getUpperLimit().column) {
                    range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row, range.getUpperLimit().column, range.getUpperLimit().row + 1);
                    bIncluded = true;
                }
                if (bIncluded) continue;
                cellRanges.add(range);
                range = range2;
            }
            cellRanges.add(range);
        } else if (singleRows.size() == 1) {
            cellRanges.add((CellRange)singleRows.get(0));
        }
        CellRange[] rangesArray = new CellRange[cellRanges.size()];
        rangesArray = cellRanges.toArray(rangesArray);
        return rangesArray;
    }

    protected static ComponentHandle createDataComponent(GridView gv, int type, String name, Object source, int row, int column, CellRange[] cellList, boolean useSel) {
        if (type == 12 && !GridViewUtils.oneCellOnly(cellList) && useSel) {
            return new DataRangeComponentHandle(16, gv.getNameFromID(16), source, GridViewUtils.convertRangesToCells(cellList));
        }
        if (useSel && cellList != null && cellList.length == 1) {
            return new DataComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(cellList[0].getLowerLimit().row), gv.getGridViewModel().getDataFromTableCol(cellList[0].getLowerLimit().column));
        }
        return new DataComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(row), gv.getGridViewModel().getDataFromTableCol(column));
    }

    protected static ColumnComponentInfo[] convertDataColRangesToCells(Range[] range) {
        int r;
        Vector<ColumnComponentInfo> tempcci = new Vector<ColumnComponentInfo>();
        for (r = 0; r < range.length; ++r) {
            int ll = range[r].getLowerLimit();
            int ul = range[r].getUpperLimit();
            for (int col = ll; col <= ul; ++col) {
                tempcci.addElement(new ColumnComponentInfo(col));
            }
        }
        ColumnComponentInfo[] cci = new ColumnComponentInfo[tempcci.size()];
        for (r = 0; r < cci.length; ++r) {
            cci[r] = (ColumnComponentInfo)tempcci.elementAt(r);
        }
        return cci;
    }

    protected static RowComponentInfo[] convertDataRowRangesToCells(Range[] range) {
        int r;
        Vector<RowComponentInfo> temprci = new Vector<RowComponentInfo>();
        for (r = 0; r < range.length; ++r) {
            int ll = range[r].getLowerLimit();
            int ul = range[r].getUpperLimit();
            for (int row = ll; row <= ul; ++row) {
                temprci.addElement(new RowComponentInfo(row));
            }
        }
        RowComponentInfo[] rci = new RowComponentInfo[temprci.size()];
        for (r = 0; r < rci.length; ++r) {
            rci[r] = (RowComponentInfo)temprci.elementAt(r);
        }
        return rci;
    }

    protected static boolean oneCellOnly(Range[] range) {
        if (range == null) {
            return true;
        }
        if (range.length > 1) {
            return false;
        }
        return range[0].getLowerLimit() == range[0].getUpperLimit();
    }

    public static boolean equalsHPos(int[] a, int[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

