/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewAttributes;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class GridViewXML
extends DataviewXML {
    public static final String no_column_sizing = "NO_COLUMN_SIZING";
    public static final String absolute_column_sizing = "ABSOLUTE_COLUMN_SIZING";
    public static final String relative_column_sizing = "RELATIVE_COLUMN_SIZING";
    public static final String no_banding = "NO_BANDING";
    public static final String row_banding = "ROW_BANDING";
    public static final String column_banding = "COLUMN_BANDING";
    public static final String a_autoFitRowCount = "autoFitRowCount";
    public static final String a_autoFitColumnCount = "autoFitColumnCount";
    public static final String a_autoFitScope = "autoFitScope";
    public static final String a_backgroundImagePath = "backgroundImagePath";
    public static final String a_hGridVisible = "hGridVisible";
    public static final String a_vGridVisible = "vGridVisible";
    public static final String a_zoomFactor = "zoomFactor";
    public static final String a_cornerComponentColor = "cornerComponentColor";
    public static final String a_cellEditingAllowed = "cellEditingAllowed";
    public static final String a_visible = "visible";
    public static final String a_gridColor = "gridColor";
    public static final String a_hGridColor = "hGridColor";
    public static final String a_vGridColor = "vGridColor";
    public static final String a_grid3D = "grid3D";
    public static final String a_cellMaxHeight = "cellMaxHeight";
    public static final String a_cellMinHeight = "cellMinHeight";
    public static final String a_cellMaxWidth = "cellMaxWidth";
    public static final String a_cellMinWidth = "cellMinWidth";
    public static final String a_enabled = "enabled";
    public static final String a_startRow = "startRow";
    public static final String a_startColumn = "startColumn";
    public static final String a_truncatedNumericDataFormat = "truncatedNumericDataFormat";
    public static final String a_manualRowSizingEnabled = "manualRowSizingEnabled";
    public static final String a_manualColumnSizingEnabled = "manualColumnSizingEnabled";
    public static final String a_columnHeaderVisible = "columnHeaderVisible";
    public static final String a_rowHeaderVisible = "rowHeaderVisible";
    public static final String a_swapAllowed = "swapAllowed";
    public static final String a_index = "index";
    public static final String a_path = "path";
    public static final String a_badColor = "badColor";
    public static final String a_warningColor = "warningColor";
    public static final String a_goodColor = "goodColor";
    public static final String a_hideData = "hideData";
    public static final String a_banding = "banding";
    public static final String a_htmlColumnSizing = "htmlColumnSizing";
    public static final String a_htmlRowBlockSize = "htmlRowBlockSize";
    public static final String a_htmlColumnBlockSize = "htmlColumnBlockSize";
    public static final String a_htmlTableCellPadding = "htmlTableCellPadding";
    public static final String a_htmlTableWidth = "htmlTableWidth";
    public static final String a_htmlTextInputSize = "htmlTextInputSize";
    public static final String a_toolbarFormatCount = "toolbarFormatCount";
    public static final String a_formatCount = "formatCount";
    public static final String a_UIFormats = "UIFormats";
    public static final String a_annotationImagePath = "annotationImagePath";
    public static final String a_annotationIconVisible = "annotationIconVisible";
    public static final String a_annotationIconPrinted = "annotationIconPrinted";
    protected boolean d_manualRowSizingEnabled;
    protected boolean d_manualColumnSizingEnabled;
    protected int d_autoFitRowCount;
    protected int d_autoFitColumnCount;
    protected int d_autoFitScope;
    protected String d_backgroundImagePath;
    protected String d_annotationImagePath;
    protected boolean d_annotationIconVisible;
    protected boolean d_annotationIconPrinted;
    protected int d_startRow;
    protected int d_startColumn;
    protected boolean d_hGridVisible;
    protected boolean d_vGridVisible;
    protected int d_zoomFactor;
    protected int d_cornerComponentColor;
    protected boolean d_cellEditingAllowed;
    protected boolean d_visible;
    protected int d_gridColor;
    protected boolean d_grid3D;
    protected int d_cellMaxHeight;
    protected int d_cellMinHeight;
    protected int d_cellMaxWidth;
    protected int d_cellMinWidth;
    protected boolean d_enabled;
    protected int d_truncatedNumericDataFormat;
    protected boolean d_columnHeaderVisible;
    protected boolean d_rowHeaderVisible;
    protected boolean d_swapAllowed;
    protected String d_badColor;
    protected String d_warningColor;
    protected String d_goodColor;
    protected boolean d_hideData;
    protected int d_banding;
    protected int d_htmlColumnSizing;
    protected int d_htmlRowBlockSize;
    protected int d_htmlColumnBlockSize;
    protected Integer d_htmlTableCellPadding;
    protected String d_htmlTableWidth;
    protected int d_htmlTextInputSize;
    protected int d_toolbarFormatCount;
    protected int d_formatCount;
    private GridViewAttributes _gridview;

    public GridViewXML(GridViewAttributes gridView) {
        super((DataviewAttributes)gridView);
        this._gridview = gridView;
    }

    protected void initDefaults(GridViewDefaultValues gdv) {
        super.initDefaults((DataviewDefaultValues)gdv);
        this.d_manualRowSizingEnabled = gdv.isManualRowSizingEnabled();
        this.d_manualColumnSizingEnabled = gdv.isManualColumnSizingEnabled();
        this.d_drillingEnabled = gdv.isDrillingEnabled();
        this.d_autoFitRowCount = gdv.getAutoFitRowCount();
        this.d_autoFitColumnCount = gdv.getAutoFitColumnCount();
        this.d_autoFitScope = gdv.getAutoFitScope();
        this.d_backgroundImagePath = gdv.getBackgroundImagePath();
        this.d_annotationImagePath = gdv.getAnnotationImagePath();
        this.d_annotationIconVisible = gdv.isAnnotationIconVisible();
        this.d_annotationIconPrinted = gdv.isAnnotationIconPrinted();
        this.d_startRow = gdv.getStartRow();
        this.d_startColumn = gdv.getStartColumn();
        this.d_hGridVisible = gdv.isHGridVisible();
        this.d_vGridVisible = gdv.isVGridVisible();
        this.d_zoomFactor = gdv.getZoomFactor();
        this.d_cornerComponentColor = gdv.getCornerComponentColor();
        this.d_cellEditingAllowed = gdv.isCellEditingAllowed();
        this.d_visible = gdv.isVisible();
        this.d_gridColor = gdv.getGridColor();
        this.d_grid3D = gdv.isGrid3D();
        this.d_cellMaxHeight = gdv.getCellMaxHeight();
        this.d_cellMinHeight = gdv.getCellMinHeight();
        this.d_cellMaxWidth = gdv.getCellMaxWidth();
        this.d_cellMinWidth = gdv.getCellMinWidth();
        this.d_enabled = gdv.isEnabled();
        this.d_truncatedNumericDataFormat = gdv.getTruncatedNumericDataFormat();
        this.d_columnHeaderVisible = gdv.isColumnHeaderVisible();
        this.d_rowHeaderVisible = gdv.isRowHeaderVisible();
        this.d_swapAllowed = gdv.isSwapAllowed();
        this.d_banding = gdv.getBanding();
        this.d_htmlColumnSizing = gdv.getHTMLColumnSizing();
        this.d_htmlRowBlockSize = gdv.getHTMLRowBlockSize();
        this.d_htmlColumnBlockSize = gdv.getHTMLColumnBlockSize();
        this.d_htmlTableCellPadding = gdv.getHTMLTableCellPadding();
        this.d_htmlTableWidth = gdv.getHTMLTableWidth();
        this.d_htmlTextInputSize = gdv.getHTMLTextInputSize();
        this.d_formatCount = gdv.getUIFormatCount();
        this.d_toolbarFormatCount = gdv.getToolbarUIFormatCount();
        this.d_badColor = gdv.getBadColor();
        this.d_warningColor = gdv.getWarningColor();
        this.d_goodColor = gdv.getGoodColor();
        this.d_hideData = gdv.isHideData();
    }

    public void setXML(ObjectNode node) {
        String tmp;
        super.setXML(node);
        PropertyNode pNode = node.getProperty(a_startRow);
        if (pNode != null) {
            this._gridview.setStartRow(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_startColumn)) != null) {
            this._gridview.setStartColumn(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_autoFitColumnCount)) != null) {
            this._gridview.setAutoFitColumnCount(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_autoFitRowCount)) != null) {
            this._gridview.setAutoFitRowCount(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_autoFitScope)) != null) {
            this._gridview.setAutoFitScope(GridView.convertAutoFitScopeToInt(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_backgroundImagePath)) != null) {
            this._gridview.setBackgroundImagePath(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_annotationImagePath)) != null) {
            this._gridview.setAnnotationImagePath(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_annotationIconVisible)) != null) {
            this._gridview.setAnnotationIconVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_annotationIconPrinted)) != null) {
            this._gridview.setAnnotationIconPrinted(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_hGridVisible)) != null) {
            this._gridview.setHGridVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_vGridVisible)) != null) {
            this._gridview.setVGridVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_cornerComponentColor)) != null) {
            this._gridview.setCornerComponentColor(new Color(GridView.hexStringToInt(pNode.getValueAsString())));
        }
        if ((pNode = node.getProperty(a_cellEditingAllowed)) != null) {
            this._gridview.setCellEditingAllowed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_swapAllowed)) != null) {
            this._gridview.setSwapAllowed(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_visible)) != null) {
            this._gridview.setVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_grid3D)) != null) {
            this._gridview.setGrid3D(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_cellMaxHeight)) != null) {
            this._gridview.setCellMaxHeight(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_cellMinHeight)) != null) {
            this._gridview.setCellMinHeight(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_cellMaxWidth)) != null) {
            this._gridview.setCellMaxWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_cellMinWidth)) != null) {
            this._gridview.setCellMinWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_manualRowSizingEnabled)) != null) {
            this._gridview.setManualRowSizingEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_manualColumnSizingEnabled)) != null) {
            this._gridview.setManualColumnSizingEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_truncatedNumericDataFormat)) != null) {
            tmp = pNode.getValueAsString();
            if (tmp.equals("FILL_WITH_HASHMARKS")) {
                this._gridview.setTruncatedNumericDataFormat(0);
            } else if (tmp.equals("TRUNCATE_WITHOUT_ELLIPSIS")) {
                this._gridview.setTruncatedNumericDataFormat(1);
            } else if (tmp.equals("TRUNCATE_WITH_ELLIPSIS")) {
                this._gridview.setTruncatedNumericDataFormat(2);
            }
        }
        if ((pNode = node.getProperty(a_enabled)) != null) {
            this._gridview.setEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_gridColor)) != null) {
            this._gridview.setGridColor(new Color(GridView.hexStringToInt(pNode.getValueAsString())));
        }
        if ((pNode = node.getProperty(a_hGridColor)) != null) {
            this._gridview.setHGridColor(new Color(GridView.hexStringToInt(pNode.getValueAsString())));
        }
        if ((pNode = node.getProperty(a_vGridColor)) != null) {
            this._gridview.setVGridColor(new Color(GridView.hexStringToInt(pNode.getValueAsString())));
        }
        if ((pNode = node.getProperty(a_columnHeaderVisible)) != null) {
            this._gridview.setColumnHeaderVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_rowHeaderVisible)) != null) {
            this._gridview.setRowHeaderVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_banding)) != null) {
            tmp = pNode.getValueAsString();
            int banding = 0;
            if (tmp.equals(no_banding)) {
                banding = 0;
            } else if (tmp.equals(row_banding)) {
                banding = 1;
            } else if (tmp.equals(column_banding)) {
                banding = 2;
            }
            this._gridview.setBanding(banding);
        }
        if ((pNode = node.getProperty(a_htmlColumnSizing)) != null) {
            tmp = pNode.getValueAsString();
            int sizing = 0;
            if (tmp.equals(no_column_sizing)) {
                sizing = 0;
            } else if (tmp.equals(absolute_column_sizing)) {
                sizing = 1;
            } else if (tmp.equals(relative_column_sizing)) {
                sizing = 2;
            }
            this._gridview.setHTMLColumnSizing(sizing);
        }
        if ((pNode = node.getProperty(a_htmlColumnBlockSize)) != null) {
            this._gridview.setHTMLColumnBlockSize(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_htmlRowBlockSize)) != null) {
            this._gridview.setHTMLRowBlockSize(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_htmlTableCellPadding)) != null) {
            tmp = pNode.getValueAsString();
            if (tmp == null || tmp.length() == 0) {
                this._gridview.setHTMLTableCellPadding(null);
            } else {
                this._gridview.setHTMLTableCellPadding(new Integer(pNode.getValueAsInteger()));
            }
        }
        if ((pNode = node.getProperty(a_htmlTableWidth)) != null) {
            tmp = pNode.getValueAsString();
            if (tmp == null || tmp.length() == 0) {
                this._gridview.setHTMLTableWidth(null);
            } else {
                this._gridview.setHTMLTableWidth(tmp);
            }
        }
        if ((pNode = node.getProperty(a_htmlTextInputSize)) != null) {
            this._gridview.setHTMLTextInputSize(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_badColor)) != null) {
            this._gridview.setBadColor(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_warningColor)) != null) {
            this._gridview.setWarningColor(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_goodColor)) != null) {
            this._gridview.setGoodColor(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_hideData)) != null) {
            this._gridview.setHideData(pNode.getValueAsBoolean());
        }
    }

    public ObjectNode getObjectNode(ObjectNode node, boolean allProperties) {
        super.getObjectNode(node, allProperties);
        if (allProperties || this._gridview.getStartRow() != this.d_startRow) {
            node.addProperty(a_startRow, this._gridview.getStartRow());
        }
        if (allProperties || this._gridview.getStartColumn() != this.d_startColumn) {
            node.addProperty(a_startColumn, this._gridview.getStartColumn());
        }
        if (allProperties || this._gridview.getAutoFitColumnCount() != this.d_autoFitColumnCount) {
            node.addProperty(a_autoFitColumnCount, this._gridview.getAutoFitColumnCount());
        }
        if (allProperties || this._gridview.getAutoFitRowCount() != this.d_autoFitRowCount) {
            node.addProperty(a_autoFitRowCount, this._gridview.getAutoFitRowCount());
        }
        if (allProperties || this._gridview.getAutoFitScope() != this.d_autoFitScope) {
            node.addProperty(a_autoFitScope, GridView.convertAutoFitScopeToString(this._gridview.getAutoFitScope()));
        }
        if (allProperties || this._gridview.getBackgroundImagePath() != this.d_backgroundImagePath) {
            node.addProperty(a_backgroundImagePath, this._gridview.getBackgroundImagePath());
        }
        if (allProperties || this._gridview.getAnnotationImagePath() != this.d_annotationImagePath) {
            node.addProperty(a_annotationImagePath, this._gridview.getAnnotationImagePath());
        }
        if (allProperties || this._gridview.isAnnotationIconVisible() != this.d_annotationIconVisible) {
            node.addProperty(a_annotationIconVisible, this._gridview.isAnnotationIconVisible());
        }
        if (allProperties || this._gridview.isAnnotationIconPrinted() != this.d_annotationIconPrinted) {
            node.addProperty(a_annotationIconPrinted, this._gridview.isAnnotationIconPrinted());
        }
        if (allProperties || this._gridview.isHGridVisible() != this.d_hGridVisible) {
            node.addProperty(a_hGridVisible, this._gridview.isHGridVisible());
        }
        if (allProperties || this._gridview.isVGridVisible() != this.d_vGridVisible) {
            node.addProperty(a_vGridVisible, this._gridview.isVGridVisible());
        }
        if (this._gridview.getCornerComponentColor() != null && (allProperties || this._gridview.isCornerComponentColorUsed())) {
            node.addProperty(a_cornerComponentColor, GridView.toHexString(this._gridview.getCornerComponentColor().getRGB()));
        }
        if (allProperties || this._gridview.isCellEditingAllowed() != this.d_cellEditingAllowed) {
            node.addProperty(a_cellEditingAllowed, this._gridview.isCellEditingAllowed());
        }
        if (allProperties || this._gridview.isSwapAllowed() != this.d_swapAllowed) {
            node.addProperty(a_swapAllowed, this._gridview.isSwapAllowed());
        }
        if (allProperties || this._gridview.isVisible() != this.d_visible) {
            node.addProperty(a_visible, this._gridview.isVisible());
        }
        if (allProperties || this._gridview.getHGridColor() != null && this._gridview.getHGridColor().getRGB() != this.d_gridColor) {
            node.addProperty(a_hGridColor, GridView.toHexString(this._gridview.getHGridColor().getRGB()));
        }
        if (allProperties || this._gridview.getVGridColor() != null && this._gridview.getVGridColor().getRGB() != this.d_gridColor) {
            node.addProperty(a_vGridColor, GridView.toHexString(this._gridview.getVGridColor().getRGB()));
        }
        if (allProperties || this._gridview.isGrid3D() != this.d_grid3D) {
            node.addProperty(a_grid3D, this._gridview.isGrid3D());
        }
        if (allProperties || this._gridview.getCellMaxHeight() != this.d_cellMaxHeight) {
            node.addProperty(a_cellMaxHeight, this._gridview.getCellMaxHeight());
        }
        if (allProperties || this._gridview.getCellMinHeight() != this.d_cellMinHeight) {
            node.addProperty(a_cellMinHeight, this._gridview.getCellMinHeight());
        }
        if (allProperties || this._gridview.getCellMaxWidth() != this.d_cellMaxWidth) {
            node.addProperty(a_cellMaxWidth, this._gridview.getCellMaxWidth());
        }
        if (allProperties || this._gridview.getCellMinWidth() != this.d_cellMinWidth) {
            node.addProperty(a_cellMinWidth, this._gridview.getCellMinWidth());
        }
        if (allProperties || this._gridview.isManualRowSizingEnabled() != this.d_manualRowSizingEnabled) {
            node.addProperty(a_manualRowSizingEnabled, this._gridview.isManualRowSizingEnabled());
        }
        if (allProperties || this._gridview.isManualColumnSizingEnabled() != this.d_manualColumnSizingEnabled) {
            node.addProperty(a_manualColumnSizingEnabled, this._gridview.isManualColumnSizingEnabled());
        }
        if (allProperties || this._gridview.isEnabled() != this.d_enabled) {
            node.addProperty(a_enabled, this._gridview.isEnabled());
        }
        if (allProperties || this._gridview.getTruncatedNumericDataFormat() != this.d_truncatedNumericDataFormat) {
            int tmp = this._gridview.getTruncatedNumericDataFormat();
            if (tmp == 0) {
                node.addProperty(a_truncatedNumericDataFormat, "FILL_WITH_HASHMARKS");
            } else if (tmp == 1) {
                node.addProperty(a_truncatedNumericDataFormat, "TRUNCATE_WITHOUT_ELLIPSIS");
            } else if (tmp == 2) {
                node.addProperty(a_truncatedNumericDataFormat, "TRUNCATE_WITH_ELLIPSIS");
            }
        }
        if (allProperties || this._gridview.isColumnHeaderVisible() != this.d_columnHeaderVisible) {
            node.addProperty(a_columnHeaderVisible, this._gridview.isColumnHeaderVisible());
        }
        if (allProperties || this._gridview.isRowHeaderVisible() != this.d_rowHeaderVisible) {
            node.addProperty(a_rowHeaderVisible, this._gridview.isRowHeaderVisible());
        }
        if (allProperties || this._gridview.getBanding() != this.d_banding) {
            String tmp = no_banding;
            switch (this._gridview.getBanding()) {
                case 0: {
                    tmp = no_banding;
                    break;
                }
                case 1: {
                    tmp = row_banding;
                    break;
                }
                case 2: {
                    tmp = column_banding;
                }
            }
            node.addProperty(a_banding, tmp);
        }
        if (allProperties || this._gridview.getHTMLColumnSizing() != this.d_htmlColumnSizing) {
            String tmp = no_column_sizing;
            switch (this._gridview.getHTMLColumnSizing()) {
                case 0: {
                    tmp = no_column_sizing;
                    break;
                }
                case 1: {
                    tmp = absolute_column_sizing;
                    break;
                }
                case 2: {
                    tmp = relative_column_sizing;
                }
            }
            node.addProperty(a_htmlColumnSizing, tmp);
        }
        if (allProperties || this._gridview.getHTMLColumnBlockSize() != this.d_htmlColumnBlockSize) {
            node.addProperty(a_htmlColumnBlockSize, this._gridview.getHTMLColumnBlockSize());
        }
        if (allProperties || this._gridview.getHTMLRowBlockSize() != this.d_htmlRowBlockSize) {
            node.addProperty(a_htmlRowBlockSize, this._gridview.getHTMLRowBlockSize());
        }
        if (allProperties || this._gridview.getHTMLTableCellPadding() != null && this.d_htmlTableCellPadding == null || this._gridview.getHTMLTableCellPadding() == null && this.d_htmlTableCellPadding != null || this._gridview.getHTMLTableCellPadding() != null && this.d_htmlTableCellPadding != null && this._gridview.getHTMLTableCellPadding().intValue() != this.d_htmlTableCellPadding.intValue()) {
            if (this._gridview.getHTMLTableCellPadding() == null) {
                node.addProperty(a_htmlTableCellPadding, "");
            } else {
                node.addProperty(a_htmlTableCellPadding, this._gridview.getHTMLTableCellPadding().intValue());
            }
        }
        if (allProperties || this._gridview.getHTMLTableWidth() != null && this.d_htmlTableWidth == null || this._gridview.getHTMLTableWidth() == null && this.d_htmlTableWidth != null || this._gridview.getHTMLTableWidth() != null && this.d_htmlTableWidth != null && !this._gridview.getHTMLTableWidth().equals(this.d_htmlTableWidth)) {
            if (this._gridview.getHTMLTableWidth() == null) {
                node.addProperty(a_htmlTableWidth, "");
            } else {
                node.addProperty(a_htmlTableWidth, this._gridview.getHTMLTableWidth());
            }
        }
        if (allProperties || this._gridview.getHTMLTextInputSize() != this.d_htmlTextInputSize) {
            node.addProperty(a_htmlTextInputSize, this._gridview.getHTMLTextInputSize());
        }
        String color = this._gridview.getBadColor();
        if (allProperties || color != null && !color.equals(this.d_badColor)) {
            node.addProperty(a_badColor, this._gridview.getBadColor());
        }
        color = this._gridview.getWarningColor();
        if (allProperties || color != null && !color.equals(this.d_warningColor)) {
            node.addProperty(a_warningColor, this._gridview.getWarningColor());
        }
        color = this._gridview.getGoodColor();
        if (allProperties || color != null && !color.equals(this.d_goodColor)) {
            node.addProperty(a_goodColor, this._gridview.getGoodColor());
        }
        if (allProperties || this._gridview.isHideData() != this.d_hideData) {
            node.addProperty(a_hideData, this._gridview.isHideData());
        }
        return node;
    }

    public void resetGridViewXML() {
        this._gridview.setAutoFitRowCount(this.d_autoFitRowCount);
        this._gridview.setAutoFitColumnCount(this.d_autoFitColumnCount);
        this._gridview.setAutoFitScope(this.d_autoFitScope);
        this._gridview.setBackgroundImagePath(this.d_backgroundImagePath);
        this._gridview.setAnnotationImagePath(this.d_annotationImagePath);
        this._gridview.setAnnotationIconVisible(this.d_annotationIconVisible);
        this._gridview.setAnnotationIconPrinted(this.d_annotationIconPrinted);
        this._gridview.setHGridVisible(this.d_hGridVisible);
        this._gridview.setVGridVisible(this.d_vGridVisible);
        this._gridview.setCellEditingAllowed(this.d_cellEditingAllowed);
        this._gridview.setVisible(this.d_visible);
        this._gridview.setGridColor(new Color(this.d_gridColor));
        this._gridview.setGrid3D(this.d_grid3D);
        this._gridview.setCellMaxHeight(this.d_cellMaxHeight);
        this._gridview.setCellMinHeight(this.d_cellMinHeight);
        this._gridview.setCellMaxWidth(this.d_cellMaxWidth);
        this._gridview.setCellMinWidth(this.d_cellMinWidth);
        this._gridview.setManualRowSizingEnabled(this.d_manualRowSizingEnabled);
        this._gridview.setManualColumnSizingEnabled(this.d_manualColumnSizingEnabled);
        this._gridview.setEnabled(this.d_enabled);
        this._gridview.setTruncatedNumericDataFormat(this.d_truncatedNumericDataFormat);
        this._gridview.setStartRow(this.d_startRow);
        this._gridview.setStartColumn(this.d_startColumn);
        this._gridview.setCornerComponentColor(new Color(this.d_cornerComponentColor));
        this._gridview.setCornerComponentColorUsed(false);
        this._gridview.setSwapAllowed(this.d_swapAllowed);
        this._gridview.setColumnHeaderVisible(this.d_columnHeaderVisible);
        this._gridview.setRowHeaderVisible(this.d_rowHeaderVisible);
        this._gridview.setBanding(this.d_banding);
        this._gridview.setHTMLColumnSizing(this.d_htmlColumnSizing);
        this._gridview.setHTMLColumnBlockSize(this.d_htmlColumnBlockSize);
        this._gridview.setHTMLRowBlockSize(this.d_htmlRowBlockSize);
        this._gridview.setHTMLTableCellPadding(this.d_htmlTableCellPadding);
        this._gridview.setHTMLTableWidth(this.d_htmlTableWidth);
        this._gridview.setHTMLTextInputSize(this.d_htmlTextInputSize);
        this._gridview.setUIFormatCount(this.d_formatCount);
        this._gridview.setToolbarUIFormatCount(this.d_toolbarFormatCount);
        this._gridview.setBadColor(this.d_badColor);
        this._gridview.setWarningColor(this.d_warningColor);
        this._gridview.setGoodColor(this.d_goodColor);
        this._gridview.setHideData(this.d_hideData);
    }

    public void setDefaultCornerComponentColor(Color c) {
        this.d_cornerComponentColor = c.getRGB();
    }
}

