/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.jpubgen.GenRawSequence;
import oracle.express.idl.jpubgen.GenWstringSequence;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.express.idl.util.SegmentedByteArrayOutputStream;
import oracle.express.idl.util.SegmentedStringWriter;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.RAW;

public class VarrayStream
implements OlapiStreamable {
    private boolean _valid;
    private SegmentedByteArrayOutputStream _baos;
    private SegmentedStringWriter _writer;
    private byte[][] _bytesArray;
    private int _bytesElemIndex;
    private byte[] _currentBytes;
    private int _bytesOffset;
    private String[] _wstringArray;
    private int _wstringElemIndex;
    private String _currentWstring;
    private int _wstringOffset;

    public VarrayStream() {
        OlapiTracer.enter("VarrayStream.constructor");
        try {
            this._baos = new SegmentedByteArrayOutputStream();
            this._writer = new SegmentedStringWriter(false);
            this._bytesArray = null;
            this._bytesElemIndex = 0;
            this._currentBytes = null;
            this._bytesOffset = 0;
            this._wstringArray = null;
            this._wstringElemIndex = 0;
            this._currentWstring = null;
            this._wstringOffset = 0;
            this._valid = true;
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.constructor");
    }

    public VarrayStream(OracleCallableStatement oracleCallableStatement) {
        OlapiTracer.enter("VarrayStream.constructor");
        try {
            int n;
            StringBuffer stringBuffer;
            this._baos = null;
            this._writer = null;
            this._bytesArray = (byte[][])((ARRAY)oracleCallableStatement.getObject(1)).getArray();
            if (OlapiTracer.isTracingEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("bytesArray: " + this._bytesArray.length);
                for (n = 0; n < this._bytesArray.length; ++n) {
                    stringBuffer.append(", " + this._bytesArray[n].length);
                }
                OlapiTracer.log(stringBuffer);
            }
            if (0 == this._bytesArray.length) {
                this._bytesElemIndex = 0;
                this._currentBytes = null;
            } else {
                this._bytesElemIndex = 1;
                this._currentBytes = this._bytesArray[0];
            }
            this._bytesOffset = 0;
            this._wstringArray = (String[])((ARRAY)oracleCallableStatement.getObject(2)).getArray();
            if (OlapiTracer.isTracingEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("wstringArray: " + this._wstringArray.length);
                for (n = 0; n < this._wstringArray.length; ++n) {
                    stringBuffer.append(", " + this._wstringArray[n].length());
                }
                OlapiTracer.log(stringBuffer);
            }
            if (0 == this._wstringArray.length) {
                this._wstringElemIndex = 0;
                this._currentWstring = null;
            } else {
                this._wstringElemIndex = 1;
                this._currentWstring = this._wstringArray[0];
            }
            this._wstringOffset = 0;
            this._valid = true;
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.constructor");
    }

    public VarrayStream(GenRawSequence genRawSequence, GenWstringSequence genWstringSequence) {
        OlapiTracer.enter("VarrayStream.constructor");
        try {
            int n;
            StringBuffer stringBuffer;
            this._baos = null;
            this._writer = null;
            this._bytesArray = (byte[][])((ARRAY)genRawSequence.toDatum(null)).getArray();
            if (OlapiTracer.isTracingEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("bytesArray: " + this._bytesArray.length);
                for (n = 0; n < this._bytesArray.length; ++n) {
                    stringBuffer.append(", " + this._bytesArray[n].length);
                }
                OlapiTracer.log(stringBuffer);
            }
            if (0 == this._bytesArray.length) {
                this._bytesElemIndex = 0;
                this._currentBytes = null;
            } else {
                this._bytesElemIndex = 1;
                this._currentBytes = this._bytesArray[0];
            }
            this._bytesOffset = 0;
            this._wstringArray = genWstringSequence.getArray();
            if (OlapiTracer.isTracingEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("wstringArray: " + this._wstringArray.length);
                for (n = 0; n < this._wstringArray.length; ++n) {
                    stringBuffer.append(", " + this._wstringArray[n].length());
                }
                OlapiTracer.log(stringBuffer);
            }
            if (0 == this._wstringArray.length) {
                this._wstringElemIndex = 0;
                this._currentWstring = null;
            } else {
                this._wstringElemIndex = 1;
                this._currentWstring = this._wstringArray[0];
            }
            this._wstringOffset = 0;
            this._valid = true;
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.constructor");
    }

    public VarrayStream(byte[][] byArray, String[] stringArray) {
        OlapiTracer.enter("VarrayStream.constructor");
        try {
            int n;
            StringBuffer stringBuffer;
            this._baos = null;
            this._writer = null;
            this._bytesArray = byArray;
            if (OlapiTracer.isTracingEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("bytesArray: " + this._bytesArray.length);
                for (n = 0; n < this._bytesArray.length; ++n) {
                    stringBuffer.append(", " + this._bytesArray[n].length);
                }
                OlapiTracer.log(stringBuffer);
            }
            if (0 == this._bytesArray.length) {
                this._bytesElemIndex = 0;
                this._currentBytes = null;
            } else {
                this._bytesElemIndex = 1;
                this._currentBytes = this._bytesArray[0];
            }
            this._bytesOffset = 0;
            this._wstringArray = stringArray;
            if (OlapiTracer.isTracingEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("wstringArray: " + this._wstringArray.length);
                for (n = 0; n < this._wstringArray.length; ++n) {
                    stringBuffer.append(", " + this._wstringArray[n].length());
                }
                OlapiTracer.log(stringBuffer);
            }
            if (0 == this._wstringArray.length) {
                this._wstringElemIndex = 0;
                this._currentWstring = null;
            } else {
                this._wstringElemIndex = 1;
                this._currentWstring = this._wstringArray[0];
            }
            this._wstringOffset = 0;
            this._valid = true;
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.constructor");
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setParams(OracleCallableStatement oracleCallableStatement) {
        OlapiTracer.enter("VarrayStream.setParams");
        try {
            byte[][] byArray = this._baos.getBuffers();
            RAW[] rAWArray = new RAW[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                rAWArray[i] = new RAW(byArray[i]);
            }
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("bytesArray: " + byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(", " + byArray[i].length);
                }
                OlapiTracer.log(stringBuffer);
            }
            GenRawSequence genRawSequence = new GenRawSequence(rAWArray);
            StringBuffer[] stringBufferArray = this._writer.getBuffers();
            String[] stringArray = new String[stringBufferArray.length];
            for (int i = 0; i < stringBufferArray.length; ++i) {
                stringArray[i] = stringBufferArray[i].toString();
            }
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("wstringArray: " + stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(", " + stringArray[i].length());
                }
                OlapiTracer.log(stringBuffer);
            }
            GenWstringSequence genWstringSequence = new GenWstringSequence(stringArray);
            oracleCallableStatement.setObject(1, (Object)genRawSequence);
            oracleCallableStatement.setObject(2, (Object)genWstringSequence);
            oracleCallableStatement.registerOutParameter(1, 2003, "SYS.GENRAWSEQUENCE");
            oracleCallableStatement.registerOutParameter(2, 2003, "SYS.GENWSTRINGSEQUENCE");
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.setParams");
    }

    public void setParams(GenRawSequence[] genRawSequenceArray, GenWstringSequence[] genWstringSequenceArray) {
        OlapiTracer.enter("VarrayStream.setParams");
        try {
            byte[][] byArray = this._baos.getBuffers();
            RAW[] rAWArray = new RAW[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                rAWArray[i] = new RAW(byArray[i]);
            }
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("bytesArray: " + byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(", " + byArray[i].length);
                }
                OlapiTracer.log(stringBuffer);
            }
            genRawSequenceArray[0] = new GenRawSequence(rAWArray);
            StringBuffer[] stringBufferArray = this._writer.getBuffers();
            String[] stringArray = new String[stringBufferArray.length];
            for (int i = 0; i < stringBufferArray.length; ++i) {
                stringArray[i] = stringBufferArray[i].toString();
            }
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("wstringArray: " + stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(", " + stringArray[i].length());
                }
                OlapiTracer.log(stringBuffer);
            }
            genWstringSequenceArray[0] = new GenWstringSequence(stringArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.setParams");
    }

    public int read() {
        OlapiTracer.enter("VarrayStream.read");
        byte by = 0;
        try {
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("reading at <" + (this._bytesElemIndex - 1) + ", " + this._bytesOffset + ">");
            }
            by = this._currentBytes[this._bytesOffset++];
            if (this._bytesOffset == this._currentBytes.length && this._bytesElemIndex < this._bytesArray.length) {
                this._currentBytes = this._bytesArray[this._bytesElemIndex++];
                this._bytesOffset = 0;
            }
            OlapiTracer.log("byte read: " + by);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.read");
        return by;
    }

    public void read(byte[] byArray) {
        OlapiTracer.enter("VarrayStream.read");
        if (OlapiTracer.isTracingEnabled() && null != byArray) {
            OlapiTracer.log("expect to read " + byArray.length + " bytes");
        }
        try {
            int n;
            if (byArray.length + this._bytesOffset <= this._currentBytes.length) {
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("reading from <" + (this._bytesElemIndex - 1) + ", " + this._bytesOffset + "> to <" + (this._bytesElemIndex - 1) + ", " + (this._bytesOffset + byArray.length - 1) + ">");
                }
                System.arraycopy(this._currentBytes, this._bytesOffset, byArray, 0, byArray.length);
                this._bytesOffset += byArray.length;
            } else {
                int n2 = this._currentBytes.length - this._bytesOffset;
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("reading from <" + (this._bytesElemIndex - 1) + ", " + this._bytesOffset + "> to <" + (this._bytesElemIndex - 1) + ", " + (this._bytesOffset + n2 - 1) + ">");
                }
                System.arraycopy(this._currentBytes, this._bytesOffset, byArray, 0, n2);
                n = n2;
                for (int i = byArray.length - n2; 0 < i; i -= n2) {
                    this._currentBytes = this._bytesArray[this._bytesElemIndex++];
                    n2 = Math.min(i, this._currentBytes.length);
                    if (OlapiTracer.isTracingEnabled()) {
                        OlapiTracer.log("reading from <" + (this._bytesElemIndex - 1) + ", 0> to <" + (this._bytesElemIndex - 1) + ", " + (this._bytesOffset + n2 - 1) + ">");
                    }
                    System.arraycopy(this._currentBytes, 0, byArray, n, n2);
                    n += n2;
                    this._bytesOffset = n2;
                }
            }
            if (this._bytesOffset == this._currentBytes.length && this._bytesElemIndex < this._bytesArray.length) {
                this._currentBytes = this._bytesArray[this._bytesElemIndex++];
                this._bytesOffset = 0;
            }
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < byArray.length; ++n) {
                    stringBuffer.append(" " + byArray[n]);
                }
                OlapiTracer.log("bytes(" + byArray.length + ") read: " + stringBuffer);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.read");
    }

    public void read(char[] cArray) {
        OlapiTracer.enter("VarrayStream.read");
        if (OlapiTracer.isTracingEnabled() && null != cArray) {
            OlapiTracer.log("expect to read " + cArray.length + " chars");
        }
        try {
            if (cArray.length + this._wstringOffset <= this._currentWstring.length()) {
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("reading from <" + (this._wstringElemIndex - 1) + ", " + this._wstringOffset + "> to <" + (this._wstringElemIndex - 1) + ", " + (this._wstringOffset + cArray.length - 1) + ">");
                }
                this._currentWstring.getChars(this._wstringOffset, this._wstringOffset + cArray.length, cArray, 0);
                this._wstringOffset += cArray.length;
            } else {
                int n = this._currentWstring.length() - this._wstringOffset;
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("reading from <" + (this._wstringElemIndex - 1) + ", " + this._wstringOffset + "> to <" + (this._wstringElemIndex - 1) + ", " + (this._wstringOffset + n - 1) + ">");
                }
                this._currentWstring.getChars(this._wstringOffset, this._wstringOffset + n, cArray, 0);
                int n2 = n;
                for (int i = cArray.length - n; 0 < i; i -= n) {
                    this._currentWstring = this._wstringArray[this._wstringElemIndex++];
                    n = Math.min(i, this._currentWstring.length());
                    if (OlapiTracer.isTracingEnabled()) {
                        OlapiTracer.log("reading from <" + (this._wstringElemIndex - 1) + ", 0> to <" + (this._wstringElemIndex - 1) + ", " + (this._wstringOffset + n - 1) + ">");
                    }
                    this._currentWstring.getChars(0, n, cArray, n2);
                    n2 += n;
                    this._wstringOffset = n;
                }
            }
            if (this._wstringOffset == this._currentWstring.length() && this._wstringElemIndex < this._wstringArray.length) {
                this._currentWstring = this._wstringArray[this._wstringElemIndex++];
                this._wstringOffset = 0;
            }
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("chars(" + cArray.length + ") read: " + cArray);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.read");
    }

    public void write(int n) {
        OlapiTracer.enter("VarrayStream.write");
        try {
            this._baos.write(n);
            OlapiTracer.log("byte written: " + n);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.write");
    }

    public void write(byte[] byArray) {
        OlapiTracer.enter("VarrayStream.write");
        try {
            this._baos.write(byArray);
            if (OlapiTracer.isTracingEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(" " + byArray[i]);
                }
                OlapiTracer.log("bytes(" + byArray.length + ") written: " + stringBuffer);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.write");
    }

    public void write(String string) {
        OlapiTracer.enter("VarrayStream.write");
        try {
            this._writer.write(string);
            if (OlapiTracer.isTracingEnabled()) {
                OlapiTracer.log("string(" + string.length() + ") written: " + string);
            }
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("VarrayStream.write");
    }

    public void write(byte[][] byArray) {
        this._baos.append(byArray);
    }

    public void write(StringBuffer[] stringBufferArray) {
        this._writer.append(stringBufferArray);
    }

    public void flush() {
    }

    public void close() {
        try {
            if (null != this._baos) {
                this._baos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._baos = null;
        try {
            if (null != this._writer) {
                this._writer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._writer = null;
        this._valid = false;
    }
}

