/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.HashSet;
import java.util.Set;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.CursorLock;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DistinctDefinition;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.RecursiveJoinDefinition;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.ValueDefinition;

final class CursorLockReleaser
extends DataDescriptorDefinitionVisitor {
    private Set m_VisitedDefinitions = new HashSet();
    private CursorLock m_CursorLock;

    private CursorLockReleaser(CursorLock cursorLock) {
        this.setCursorLock(cursorLock);
    }

    private CursorLock getCursorLock() {
        return this.m_CursorLock;
    }

    private Set getVisitedDefinitions() {
        return this.m_VisitedDefinitions;
    }

    public static final void releaseCursorLock(SourceDefinition sourceDefinition, CursorLock cursorLock) {
        CursorLockReleaser cursorLockReleaser = new CursorLockReleaser(cursorLock);
        cursorLockReleaser.visitDefinition(sourceDefinition, null);
    }

    private void setCursorLock(CursorLock cursorLock) {
        this.m_CursorLock = cursorLock;
    }

    public Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
        this.visitDefinition(aliasDefinition.getBase(), object);
        return null;
    }

    public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
        boolean bl = true;
        for (Object e : constantListDefinition.getElements()) {
            if (bl) {
                bl = false;
                if (!(e instanceof SourceDefinition)) break;
            }
            this.visitDefinition((SourceDefinition)e, object);
        }
        return null;
    }

    public final void visitDefinition(SourceDefinition sourceDefinition, Object object) {
        if (this.getVisitedDefinitions().contains(sourceDefinition)) {
            return;
        }
        this.getVisitedDefinitions().add(sourceDefinition);
        sourceDefinition.acceptVisitor(this, object);
    }

    public Object visitDistinctDefinition(DistinctDefinition distinctDefinition, Object object) {
        this.visitDefinition(distinctDefinition.getBase(), object);
        return null;
    }

    public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
        dynamicDefinition.getTemplate().removeCursorLock(this.getCursorLock());
        this.visitDefinition(dynamicDefinition.getCurrent(), object);
        return null;
    }

    public Object visitExtractDefinition(ExtractDefinition extractDefinition, Object object) {
        this.visitDefinition(extractDefinition.getBase(), object);
        return null;
    }

    public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
        return null;
    }

    public Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
        this.visitDefinition(joinDefinition.getBase(), object);
        this.visitDefinition(joinDefinition.getJoined(), object);
        this.visitDefinition(joinDefinition.getComparison(), object);
        return null;
    }

    public Object visitPositionDefinition(PositionDefinition positionDefinition, Object object) {
        this.visitDefinition(positionDefinition.getBase(), object);
        return null;
    }

    public Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
        this.visitDefinition(rangeDefinition.getBottom(), object);
        this.visitDefinition(rangeDefinition.getTop(), object);
        return null;
    }

    public Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
        this.visitDefinition(valueDefinition.getBase(), object);
        this.visitDefinition(valueDefinition.getInput(), object);
        return null;
    }

    public Object visitRecursiveJoinDefinition(RecursiveJoinDefinition recursiveJoinDefinition, Object object) {
        this.visitDefinition(recursiveJoinDefinition.getBase(), object);
        this.visitDefinition(recursiveJoinDefinition.getJoined(), object);
        this.visitDefinition(recursiveJoinDefinition.getComparison(), object);
        this.visitDefinition(recursiveJoinDefinition.getParent(), object);
        return null;
    }
}

