/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.DynamicDefinitionState;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourceGenerator;
import oracle.olapi.data.source.Template;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;
import oracle.olapi.transaction.metadataStateManager.MetadataStateOwner;

public final class DynamicDefinition
extends SourceDefinition
implements MetadataStateOwner {
    private Template m_Template;
    private SourceGenerator m_SourceGenerator;
    private MetadataStateManager m_StateManager;

    DynamicDefinition(Template template, SourceGenerator sourceGenerator, DataProvider dataProvider) {
        this(template, sourceGenerator, dataProvider, dataProvider.getBaseTransactionProvider().getIncrementalTransaction());
    }

    DynamicDefinition(Template template, SourceGenerator sourceGenerator, DataProvider dataProvider, Transaction transaction) {
        super(dataProvider._getSourceIDProvider().createDynamicID(), dataProvider);
        this.setTemplate(template);
        this.setSourceGenerator(sourceGenerator);
        this.setStateManager(new MetadataStateManager(new DynamicDefinitionState(), transaction, this));
        template._registerDynamicDefinition(this);
    }

    public Object acceptVisitor(DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, Object object) {
        return dataDescriptorDefinitionVisitor.visitDynamicDefinition(this, object);
    }

    final void accumulateInputs(Set set, Transaction transaction, boolean bl, boolean bl2) {
        this.getCurrent(transaction).accumulateInputs(set, transaction, bl, bl2);
    }

    final void accumulateOutputs(List list, Transaction transaction) {
        this.getCurrent(transaction).accumulateOutputs(list, transaction);
    }

    final void checkValidity(Transaction transaction) throws TransactionalObjectInvalidException {
        if (!this.getStateManager().hasCurrentState(transaction)) {
            throw new TransactionalObjectInvalidException();
        }
    }

    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        return this.getCurrent().findOrCreateExtractModel(source, transaction);
    }

    public final SourceDefinition getCurrent() {
        return this.getCurrent(this.getCurrentSystemTransaction());
    }

    public final SourceDefinition getCurrent(Transaction transaction) {
        DynamicDefinitionState dynamicDefinitionState = (DynamicDefinitionState)this.getStateManager().getCurrentStateForRead(transaction);
        SourceDefinition sourceDefinition = dynamicDefinitionState.getCurrentDefinition();
        if (sourceDefinition == null) {
            sourceDefinition = this.getSourceGenerator().generateSource(this.getTemplate().getCurrentState()).getDefinition();
            DynamicDefinitionState dynamicDefinitionState2 = new DynamicDefinitionState(sourceDefinition, dynamicDefinitionState.isMaterializationRecommended());
            this.getStateManager().setCurrentState(dynamicDefinitionState2, transaction);
        }
        return sourceDefinition;
    }

    public final void forceCurrentGenerationForRead(Transaction transaction) {
        DynamicDefinitionState dynamicDefinitionState = (DynamicDefinitionState)this.getStateManager().getCurrentStateForRead(transaction);
        SourceDefinition sourceDefinition = dynamicDefinitionState.getCurrentDefinition();
        if (sourceDefinition == null) {
            sourceDefinition = this.getSourceGenerator().generateSource(this.getTemplate().getCurrentStateForRead()).getDefinition();
            dynamicDefinitionState.setCurrentDefinition(sourceDefinition);
        }
    }

    public final SourceGenerator getSourceGenerator() {
        return this.m_SourceGenerator;
    }

    private final MetadataStateManager getStateManager() {
        return this.m_StateManager;
    }

    public final Template getTemplate() {
        return this.m_Template;
    }

    final SourceDefinition getType(Transaction transaction) {
        return this.getCurrent(transaction);
    }

    final SourceDefinition getElementType(Transaction transaction) {
        return this.getCurrent(transaction).getElementType(transaction);
    }

    public final void update(Transaction transaction) {
        this.getCurrent(transaction);
    }

    private void setSourceGenerator(SourceGenerator sourceGenerator) {
        this.m_SourceGenerator = sourceGenerator;
    }

    private void setStateManager(MetadataStateManager metadataStateManager) {
        this.m_StateManager = metadataStateManager;
    }

    private void setTemplate(Template template) {
        this.m_Template = template;
    }

    final void templateStateChanged(Transaction transaction) {
        DynamicDefinitionState dynamicDefinitionState = (DynamicDefinitionState)this.getStateManager().getCurrentStateForWrite(transaction);
        dynamicDefinitionState.templateStateChanged();
        this.getStateManager().setCurrentState(dynamicDefinitionState, transaction);
    }

    public final boolean isModified(Transaction transaction) {
        return this.getStateManager().isModified(transaction);
    }

    public final Transaction getActiveTransaction() {
        return this.getStateManager().getActiveTransaction();
    }

    public final boolean isMaterializationRecommended() {
        BaseTransaction baseTransaction = this.getDataProvider().getBaseTransactionProvider().getCurrentSystemTransaction();
        DynamicDefinitionState dynamicDefinitionState = (DynamicDefinitionState)this.getStateManager().getCurrentStateForRead(baseTransaction);
        return dynamicDefinitionState.isMaterializationRecommended();
    }

    public final void setMaterializationRecommended(boolean bl) {
        boolean bl2 = this.isMaterializationRecommended();
        if (bl == bl2) {
            return;
        }
        BaseTransaction baseTransaction = this.getDataProvider().getBaseTransactionProvider().getIncrementalTransaction();
        DynamicDefinitionState dynamicDefinitionState = (DynamicDefinitionState)this.getStateManager().findOrCreateCurrentStateForWrite(baseTransaction);
        dynamicDefinitionState.setMaterializationRecommended(bl);
    }

    public Object getTransactionalState(Transaction transaction) {
        return this.getStateManager().getCurrentStateForRead(transaction);
    }

    public final void rollbackPersistentState() {
    }
}

